/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.model.index;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BitMap<K, V>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<V, Integer> valueIndex;
    private final List<V> valueList;
    private final int capacity;
    private final Map<K, BitSet> bitSetMap;
    private int currentIndex;

    public BitMap() {
        this(16);
    }

    public BitMap(int capacity) {
        this.capacity = capacity;
        this.valueIndex = new HashMap<V, Integer>(capacity);
        this.bitSetMap = new HashMap<K, BitSet>(16);
        this.valueList = new ArrayList<V>(capacity);
        this.currentIndex = 0;
    }

    public void addValue(K k, V v) {
        if (EmptyUtil.isEmpty(v)) {
            return;
        }
        if (EmptyUtil.isEmpty(k)) {
            return;
        }
        Integer index = this.valueIndex.get(v);
        if (Objects.isNull(index)) {
            index = this.currentIndex;
            ++this.currentIndex;
            this.valueIndex.put((Integer)v, index);
            this.valueList.add(v);
        }
        BitSet bitSet = this.bitSetMap.computeIfAbsent(k, key -> new BitSet(this.capacity));
        bitSet.set(index);
    }

    public void addValue(Set<K> keys, V v) {
        for (K k : keys) {
            this.addValue(k, v);
        }
    }

    public Set<K> getKeys(V v) {
        Integer integer = this.valueIndex.get(v);
        if (Objects.isNull(integer)) {
            return new HashSet(8);
        }
        if (integer < 0) {
            throw new KDBizException("value: " + v + " is not exists");
        }
        HashSet<K> keys = new HashSet<K>(16);
        for (Map.Entry<K, BitSet> entry : this.bitSetMap.entrySet()) {
            BitSet bitSet = entry.getValue();
            if (!bitSet.get(integer)) continue;
            keys.add(entry.getKey());
        }
        return keys;
    }

    public boolean removeAll(Set<K> keys, V v) {
        boolean result = false;
        for (K k : keys) {
            boolean remove = this.remove(k, v);
            result = result || remove;
        }
        return result;
    }

    public boolean remove(K k, V v) {
        if (EmptyUtil.isEmpty(v)) {
            return false;
        }
        if (EmptyUtil.isEmpty(k)) {
            return false;
        }
        Integer integer = this.valueIndex.get(v);
        if (Objects.isNull(integer)) {
            return false;
        }
        BitSet bitSet = this.bitSetMap.get(k);
        if (Objects.isNull(bitSet)) {
            return false;
        }
        bitSet.set((int)integer, false);
        return true;
    }

    public V findOne(K key) {
        return this.findOne(Collections.singleton(key));
    }

    public V findOne(Set<K> keys) {
        BitSet bitSet = this.getBitSet(keys);
        if (bitSet == null) {
            return null;
        }
        int idx = bitSet.nextSetBit(0);
        if (idx != -1) {
            return this.valueList.get(idx);
        }
        return null;
    }

    public List<V> findList(Set<K> keys) {
        BitSet bitSet = this.getBitSet(keys);
        int idx = 0;
        LinkedList<V> resultList = new LinkedList<V>();
        if (bitSet == null) {
            return resultList;
        }
        int i = bitSet.nextSetBit(idx);
        while (i >= 0) {
            V data = this.valueList.get(i);
            resultList.add(data);
            i = bitSet.nextSetBit(i + 1);
        }
        return resultList;
    }

    public Set<V> findSet(Set<K> keys) {
        BitSet bitSet = this.getBitSet(keys);
        int idx = 0;
        HashSet<V> results = new HashSet<V>(16);
        if (bitSet == null) {
            return results;
        }
        int i = bitSet.nextSetBit(idx);
        while (i >= 0) {
            V data = this.valueList.get(i);
            results.add(data);
            i = bitSet.nextSetBit(i + 1);
        }
        return results;
    }

    public Set<V> values() {
        return new HashSet<V>(this.valueList);
    }

    public boolean isEmpty() {
        return EmptyUtil.isEmpty(this.valueList);
    }

    private BitSet getBitSet(Set<K> keys) {
        BitSet bitSet = new BitSet(this.capacity);
        BitSet currentBitSet = null;
        boolean first = false;
        for (K k : keys) {
            if (EmptyUtil.isEmpty(k)) continue;
            if (currentBitSet == null) {
                first = true;
            }
            if ((currentBitSet = this.bitSetMap.get(k)) == null) {
                return null;
            }
            if (first) {
                bitSet.or(currentBitSet);
                first = false;
                continue;
            }
            bitSet.and(currentBitSet);
        }
        return bitSet;
    }

    public void clear() {
        this.valueIndex.clear();
        this.bitSetMap.clear();
        this.valueList.clear();
        this.currentIndex = 0;
    }
}

