/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.model.index;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.index.node.TreeNode;
import kd.tmc.fpm.common.bean.DimensionInfoBean;

public class DimensionIndexTree
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log logger = LogFactory.getLog(DimensionIndexTree.class);
    private TreeNode root;
    private TreeNode leafHead;
    private TreeNode leafTail;
    private List<TreeNode> leafList;
    private List<TreeNode> topVirtualNodes;
    private List<Long> dimIdSort;

    public DimensionIndexTree() {
        this(new TreeNode());
    }

    public DimensionIndexTree(TreeNode root) {
        this.root = root;
        this.topVirtualNodes = new ArrayList<TreeNode>(8);
        this.dimIdSort = new ArrayList<Long>(8);
        this.leafList = new ArrayList<TreeNode>(8);
    }

    public TreeNode find(DimensionInfoBean dimensionInfo) {
        List<Long> memIdList = dimensionInfo.getMemberIdList().stream().filter(o -> o instanceof Long).map(o -> (Long)o).collect(Collectors.toList());
        return this.find(dimensionInfo.getDimensionIdList(), memIdList);
    }

    public void clearTreeNodeData() {
        if (EmptyUtil.isEmpty(this.leafList)) {
            return;
        }
        this.leafList.stream().filter(node -> EmptyUtil.isNoEmpty(node.getDataList())).forEach(node -> node.getDataList().clear());
    }

    public void clearTreeNodeData(DimensionInfoBean dimensionInfoBean) {
        this.clearTreeNodeData(Collections.singleton(dimensionInfoBean));
    }

    public void clearTreeNodeData(Set<DimensionInfoBean> dimensionInfoBeans) {
        dimensionInfoBeans.stream().map(this::find).filter(Objects::nonNull).filter(node -> EmptyUtil.isNoEmpty(node.getDataList())).forEach(node -> node.getDataList().clear());
    }

    private TreeNode find(List<Long> dimIdList, List<Long> dimMemIdList) {
        List<Long> sortedMemIdList = this.sortDimMemIdList(dimIdList, dimMemIdList);
        TreeNode node = this.root;
        for (Long memId : sortedMemIdList) {
            Map<Long, TreeNode> children = node.getNextDimMemMap();
            if ((node = children.get(memId)) != null) continue;
            break;
        }
        return node == this.root ? null : node;
    }

    private List<Long> sortDimMemIdList(List<Long> dimIdList, List<Long> dimMemIdList) {
        ArrayList<Long> sortedList = new ArrayList<Long>(dimMemIdList.size());
        Map<Long, Integer> dimIdToIdxMap = this.getDimIdToSortedIdxMap(dimIdList);
        for (Long dimId : this.dimIdSort) {
            Integer idx = dimIdToIdxMap.get(dimId);
            if (Objects.isNull(idx)) {
                logger.info("\u627e\u4e0d\u5230\u7684\u7ef4\u5ea6\u3010{}\u3011", (Object)dimId);
            }
            sortedList.add(dimMemIdList.get(idx));
        }
        return sortedList;
    }

    private Map<Long, Integer> getDimIdToSortedIdxMap(List<Long> dimIdList) {
        HashMap<Long, Integer> dimIdToIdxMap = new HashMap<Long, Integer>(dimIdList.size());
        for (int i = 0; i < dimIdList.size(); ++i) {
            dimIdToIdxMap.put(dimIdList.get(i), i);
        }
        return dimIdToIdxMap;
    }

    public TreeNode getRoot() {
        return this.root;
    }

    public void setRoot(TreeNode root) {
        this.root = root;
    }

    public List<TreeNode> getTopVirtualNodes() {
        return this.topVirtualNodes;
    }

    public void setTopVirtualNodes(List<TreeNode> topVirtualNodes) {
        this.topVirtualNodes = topVirtualNodes;
    }

    public List<TreeNode> getLeafList() {
        return this.leafList;
    }

    public void setLeafList(List<TreeNode> leafList) {
        this.leafList = leafList;
    }

    public TreeNode getLeafHead() {
        return this.leafHead;
    }

    public void setLeafHead(TreeNode leafHead) {
        this.leafHead = leafHead;
    }

    public TreeNode getLeafTail() {
        return this.leafTail;
    }

    public void setLeafTail(TreeNode leafTail) {
        this.leafTail = leafTail;
    }

    public List<Long> getDimIdSort() {
        return this.dimIdSort;
    }

    public void setDimIdSort(List<Long> dimIdSort) {
        this.dimIdSort = dimIdSort;
    }
}

