/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.model.index.generate;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.index.DimensionIndexTree;
import kd.tmc.fpm.business.domain.model.index.generate.bean.DimensionInfo;
import kd.tmc.fpm.business.domain.model.index.generate.bean.MemberInfo;
import kd.tmc.fpm.business.domain.model.index.generate.strategy.IndexTreeGenerateStrategy;
import kd.tmc.fpm.business.domain.model.index.node.TreeNode;

public class DimensionIndexTreeGenerator {
    private IndexTreeGenerateStrategy strategy;
    private List<List<DimensionInfo>> dimGrpList;
    private DimensionIndexTree tree;
    private List<TreeNode> currLeafList;
    private Long currDimId;
    private boolean buildLeaf;
    private Map<TreeNode, BuildTempInfo> tempBuildInfoMap;

    public DimensionIndexTreeGenerator(IndexTreeGenerateStrategy strategy) {
        this.strategy = strategy;
    }

    public DimensionIndexTree build() {
        this.tree = new DimensionIndexTree();
        this.currLeafList = new LinkedList<TreeNode>();
        this.dimGrpList = this.strategy.getDimensionGroupList();
        this.checkArguments();
        this.currLeafList.add(this.tree.getRoot());
        this.initDimLeaf(this.tree.getRoot());
        this.tempBuildInfoMap = new HashMap<TreeNode, BuildTempInfo>(8);
        for (int i = 0; i < this.dimGrpList.size(); ++i) {
            List<DimensionInfo> dimGrp = this.dimGrpList.get(i);
            boolean lastDim = i == this.dimGrpList.size() - 1;
            this.buildDim(dimGrp, lastDim);
        }
        if (this.currLeafList.size() > 0) {
            this.tree.setLeafHead(this.currLeafList.get(0));
            this.tree.setLeafTail(this.currLeafList.get(this.currLeafList.size() - 1));
        }
        if (this.strategy.buildSummaryReference()) {
            this.doBuildSumReference();
        }
        return this.tree;
    }

    private void checkArguments() {
        for (List<DimensionInfo> dimensions : this.dimGrpList) {
            for (DimensionInfo dimension : dimensions) {
                if (dimension.getDimType() != DimensionType.DETAILDIM) continue;
                throw new IllegalArgumentException("Only main dimension can build index tree.");
            }
        }
    }

    private BuildTempInfo getBuildInfo(TreeNode treeNode) {
        return this.tempBuildInfoMap.computeIfAbsent(treeNode, o -> new BuildTempInfo());
    }

    private void buildDim(List<DimensionInfo> dimList, boolean lastDimLocation) {
        for (int i = 0; i < dimList.size(); ++i) {
            DimensionInfo dimension = dimList.get(i);
            this.currDimId = dimension.getDimensionId();
            this.tree.getDimIdSort().add(dimension.getDimensionId());
            List<MemberInfo> memberList = this.strategy.getDimMemberList(dimension);
            boolean currDirectionLastDim = i == dimList.size() - 1;
            this.buildLeaf = currDirectionLastDim && lastDimLocation;
            this.doBuildDim(memberList);
        }
    }

    private void doBuildSumReference() {
        for (TreeNode topVirtualNode : this.tree.getTopVirtualNodes()) {
            int curLeafCnt = -1;
            for (TreeNode virtualBrother = topVirtualNode.getBrother(); virtualBrother != null; virtualBrother = virtualBrother.getBrother()) {
                int curCnt = 0;
                TreeNode virtualLeaf = topVirtualNode.getLeafHead();
                TreeNode brotherLeaf = virtualBrother.getLeafHead();
                boolean last = false;
                while (virtualLeaf != null && brotherLeaf != null) {
                    virtualLeaf.addRefNodes(brotherLeaf);
                    if (topVirtualNode == virtualLeaf) break;
                    virtualLeaf = virtualLeaf.getNext();
                    brotherLeaf = brotherLeaf.getNext();
                    ++curCnt;
                    if (last) break;
                    if (virtualLeaf != topVirtualNode.getLeafTail() && brotherLeaf != virtualBrother.getLeafTail()) continue;
                    last = true;
                }
                if (curLeafCnt != -1) continue;
                curLeafCnt = curCnt;
            }
        }
    }

    private void doBuildDim(List<MemberInfo> memberList) {
        List<TreeNode> leafList = this.fetchCurrLeafList();
        for (TreeNode pNode : leafList) {
            if (EmptyUtil.isEmpty(memberList)) continue;
            BuildTempInfo buildInfo = this.getBuildInfo(pNode);
            buildInfo.prevDimLeaf = pNode;
            for (MemberInfo member : memberList) {
                TreeNode treeNode = this.buildMemberTree(pNode, member, false);
                if (treeNode == null) continue;
                pNode.addChild(treeNode);
            }
        }
    }

    private List<TreeNode> fetchCurrLeafList() {
        LinkedList<TreeNode> leafList = new LinkedList<TreeNode>(this.currLeafList);
        this.currLeafList.clear();
        return leafList;
    }

    private TreeNode buildMemberTree(TreeNode pNode, MemberInfo member, boolean isVirtualBrother) {
        TreeNode treeNode;
        boolean curContainsTopVNode = false;
        List<MemberInfo> children = member.getChildren();
        if (children.size() > 0) {
            treeNode = this.createNormalNode(pNode, member);
            BuildTempInfo buildInfo = this.getBuildInfo(treeNode);
            if (isVirtualBrother) {
                buildInfo.topBrotherNode = treeNode;
            }
            TreeNode vNode = this.createVirtualNode(treeNode, member);
            BuildTempInfo vNodeBuildInfo = this.getBuildInfo(vNode);
            if (buildInfo.topVNode == null && this.strategy.buildSummaryReference() && this.strategy.isSummaryNode(member)) {
                curContainsTopVNode = true;
                vNodeBuildInfo.topVNode = vNode;
                this.tree.getTopVirtualNodes().add(vNode);
            }
            if (this.buildLeaf) {
                vNode.setLeaf(true);
                this.tree.getLeafList().add(vNode);
                vNode.setSummary(vNodeBuildInfo.topVNode != null);
            } else {
                this.initDimLeaf(vNode);
            }
            this.addLeafNode(vNode);
            treeNode.addChild(vNode);
            for (MemberInfo child : children) {
                TreeNode childNode = this.buildMemberTree(treeNode, child, curContainsTopVNode);
                treeNode.addChild(childNode);
            }
            if (curContainsTopVNode) {
                this.buildNodeBrotherPtr(treeNode.getChildren().values());
            }
        } else {
            if (this.buildLeaf) {
                treeNode = this.createLeafNode(pNode, member);
                treeNode.setSummary(this.getBuildInfo((TreeNode)treeNode).topVNode != null);
            } else {
                treeNode = this.createNormalNode(pNode, member);
                this.initDimLeaf(treeNode);
            }
            if (isVirtualBrother) {
                this.getBuildInfo((TreeNode)treeNode).topBrotherNode = treeNode;
            }
            this.addLeafNode(treeNode);
        }
        return treeNode;
    }

    private void addLeafNode(TreeNode node) {
        if (this.buildLeaf && this.currLeafList.size() > 0) {
            this.currLeafList.get(this.currLeafList.size() - 1).setNext(node);
        }
        if (this.buildLeaf) {
            BuildTempInfo buildInfo = this.getBuildInfo(node);
            TreeNode topVirtualNode = buildInfo.topVNode;
            TreeNode topVirtualBrother = buildInfo.topBrotherNode;
            if (topVirtualNode != null) {
                if (topVirtualNode.getLeafHead() == null) {
                    topVirtualNode.setLeafHead(node);
                }
                topVirtualNode.setLeafTail(node);
            }
            if (topVirtualBrother != null) {
                if (topVirtualBrother.getLeafHead() == null) {
                    topVirtualBrother.setLeafHead(node);
                }
                topVirtualBrother.setLeafTail(node);
            }
        }
        this.currLeafList.add(node);
    }

    private void buildNodeBrotherPtr(Iterable<TreeNode> nodeList) {
        TreeNode prevNode = null;
        for (TreeNode node : nodeList) {
            if (prevNode != null) {
                prevNode.setBrother(node);
            }
            prevNode = node;
        }
    }

    private TreeNode createLeafNode(TreeNode pNode, MemberInfo member) {
        TreeNode leafNode = new TreeNode();
        leafNode.setLeaf(true);
        this.tree.getLeafList().add(leafNode);
        this.fillBaseInfo(leafNode, pNode, member);
        return leafNode;
    }

    private TreeNode createNormalNode(TreeNode pNode, MemberInfo member) {
        TreeNode treeNode = new TreeNode();
        this.fillBaseInfo(treeNode, pNode, member);
        return treeNode;
    }

    private TreeNode createVirtualNode(TreeNode pNode, MemberInfo member) {
        TreeNode virtualNode = new TreeNode();
        virtualNode.setVirtual(true);
        virtualNode.setVirtualRef(pNode);
        this.fillBaseInfo(virtualNode, pNode, member);
        return virtualNode;
    }

    private void fillBaseInfo(TreeNode node, TreeNode pNode, MemberInfo member) {
        node.setParent(pNode);
        node.setDimId(this.currDimId);
        node.setMemId(member.getMemberId());
        node.setName(member.getName());
        BuildTempInfo buildInfo = this.getBuildInfo(node);
        BuildTempInfo pNodeBuildInfo = this.getBuildInfo(pNode);
        buildInfo.prevDimLeaf = pNodeBuildInfo.prevDimLeaf;
        buildInfo.topVNode = pNodeBuildInfo.topVNode;
        buildInfo.topBrotherNode = pNodeBuildInfo.topBrotherNode;
        buildInfo.prevDimLeaf.getNextDimMemMap().put(node.getMemId(), node);
    }

    private void initDimLeaf(TreeNode node) {
        node.setNextDimMemMap(new HashMap<Long, TreeNode>(8));
        node.setDimLeaf(true);
    }

    private static class BuildTempInfo {
        TreeNode topVNode;
        TreeNode topBrotherNode;
        TreeNode prevDimLeaf;

        private BuildTempInfo() {
        }
    }
}

