/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.model.index.generate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.db.DB;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.index.ReportDataIndexQueryMap;
import kd.tmc.fpm.business.domain.model.index.generate.bean.QueryIndexInfo;
import kd.tmc.fpm.business.domain.model.index.generate.bean.WarpBean;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.utils.DimensionInfoHelper;
import kd.tmc.fpm.common.bean.DimensionInfoBean;

public class QueryIndexInfoMapGenerator {
    public static <V> QueryIndexInfo<V, ReportData> buildReportDataIndex(List<ReportData> reportDataList, FundPlanSystem system) {
        List warpBeanList = QueryIndexInfoMapGenerator.getWarpBeans(reportDataList);
        return QueryIndexInfoMapGenerator.build(warpBeanList, system, rd -> !rd.isAuxiliaryInfo());
    }

    public static <V> QueryIndexInfo<V, ReportData> buildReportDataIndex(List<ReportData> reportDataList, FundPlanSystem system, Predicate<ReportData> predicate) {
        List warpBeanList = QueryIndexInfoMapGenerator.getWarpBeans(reportDataList);
        return QueryIndexInfoMapGenerator.build(warpBeanList, system, predicate);
    }

    public static <V> QueryIndexInfo<V, ReportData> buildReportDataIndexByPredicate(List<ReportData> reportDataList, Predicate<ReportData> reportDataFilter, Predicate<Long> dimIdFilter) {
        List warpBeanList = QueryIndexInfoMapGenerator.getWarpBeans(reportDataList);
        return QueryIndexInfoMapGenerator.buildIndex(warpBeanList, reportDataFilter, dimIdFilter);
    }

    private static <V> List<WarpBean<V, ReportData>> getWarpBeans(List<ReportData> reportDataList) {
        ArrayList<WarpBean<V, ReportData>> warpBeanList = new ArrayList<WarpBean<V, ReportData>>(reportDataList.size());
        int count = reportDataList.size();
        LinkedList<Long> idQueue = new LinkedList<Long>();
        if (count > 0) {
            long[] idArr;
            for (long id : idArr = DB.genGlobalLongIds((int)count)) {
                idQueue.offer(id);
            }
        }
        for (ReportData reportData : reportDataList) {
            if (EmptyUtil.isEmpty((Long)reportData.getId())) {
                reportData.setId((Long)idQueue.poll());
            }
            DimensionInfoBean dimensionInfoBean = DimensionInfoHelper.getDimensionInfoBean(reportData);
            WarpBean<Long, ReportData> warpBean = new WarpBean<Long, ReportData>(reportData.getId(), dimensionInfoBean, reportData);
            warpBeanList.add(warpBean);
        }
        return warpBeanList;
    }

    public static <V, T> QueryIndexInfo<V, T> build(List<WarpBean<V, T>> warpBeanList, FundPlanSystem system, Predicate<T> warpBeanFilter) {
        Set detailDimIds = system.getDimList().stream().filter(item -> item.getDimType() == DimensionType.DETAILDIM).map(Dimension::getId).collect(Collectors.toSet());
        return QueryIndexInfoMapGenerator.buildIndex(warpBeanList, warpBeanFilter, detailDimIds::contains);
    }

    private static <V, T> QueryIndexInfo<V, T> buildIndex(List<WarpBean<V, T>> warpBeanList, Predicate<T> warpBeanFilter, Predicate<Long> dimensionIdFilter) {
        ReportDataIndexQueryMap<V> map = new ReportDataIndexQueryMap<V>(warpBeanList.size());
        HashMap<V, T> dataMap = new HashMap<V, T>(warpBeanList.size());
        for (WarpBean<V, T> warpBean : warpBeanList) {
            if (!warpBeanFilter.test(warpBean.getBean())) continue;
            DimensionInfoBean dimensionInfoBean = warpBean.getDimensionInfoBean();
            List dimensionIdList = dimensionInfoBean.getDimensionIdList();
            List memberIdList = dimensionInfoBean.getMemberIdList();
            for (int i = 0; i < dimensionIdList.size(); ++i) {
                Long dimensionId = (Long)dimensionIdList.get(i);
                if (dimensionIdFilter.test(dimensionId)) continue;
                Long memberId = (Long)memberIdList.get(i);
                map.addData(dimensionId, memberId, warpBean.getId());
                dataMap.put(warpBean.getId(), warpBean.getBean());
            }
        }
        return new QueryIndexInfo(map, dataMap);
    }
}

