/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.model.index.generate.bean;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.index.ReportDataIndexQueryMap;
import kd.tmc.fpm.business.domain.model.index.generate.bean.WarpBean;
import kd.tmc.fpm.common.bean.DimensionInfoBean;

public class QueryIndexInfo<V, T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ReportDataIndexQueryMap<V> indexQueryMap;
    private Map<V, T> dataMap;

    public QueryIndexInfo(ReportDataIndexQueryMap<V> indexQueryMap, Map<V, T> dataMap) {
        this.indexQueryMap = indexQueryMap;
        this.dataMap = dataMap;
    }

    public ReportDataIndexQueryMap<V> getIndexQueryMap() {
        return this.indexQueryMap;
    }

    public void setIndexQueryMap(ReportDataIndexQueryMap<V> indexQueryMap) {
        this.indexQueryMap = indexQueryMap;
    }

    public Map<V, T> getDataMap() {
        return this.dataMap;
    }

    public void setDataMap(Map<V, T> dataMap) {
        this.dataMap = dataMap;
    }

    public List<Long> listDimensionId() {
        return this.getIndexQueryMap().listDimensionId();
    }

    public void updateIndex(WarpBean<V, T> warpBean) {
        DimensionInfoBean dimensionInfoBean = warpBean.getDimensionInfoBean();
        List dimensionIdList = dimensionInfoBean.getDimensionIdList();
        List memberIdList = dimensionInfoBean.getMemberIdList();
        for (int i = 0; i < dimensionIdList.size(); ++i) {
            Long dimensionId = (Long)dimensionIdList.get(i);
            Long memberId = (Long)memberIdList.get(i);
            this.indexQueryMap.addData(dimensionId, memberId, warpBean.getId());
            this.dataMap.put(warpBean.getId(), warpBean.getBean());
        }
    }

    public static <V, T> QueryIndexInfo<V, T> buildEmptyIndexInfo(int size) {
        ReportDataIndexQueryMap map = new ReportDataIndexQueryMap(size);
        HashMap dataMap = new HashMap(size);
        return new QueryIndexInfo(map, dataMap);
    }

    public List<T> findList(DimensionInfoBean dimensionInfoBean) {
        List<V> list = this.indexQueryMap.findList(dimensionInfoBean);
        if (EmptyUtil.isEmpty(list)) {
            return Collections.emptyList();
        }
        return list.stream().map(this.dataMap::get).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public T findOne(DimensionInfoBean dimensionInfoBean) {
        V v = this.indexQueryMap.find(dimensionInfoBean);
        if (EmptyUtil.isEmpty(v)) {
            return null;
        }
        return this.dataMap.get(v);
    }
}

