/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.model.index.generate.strategy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.index.generate.bean.DimensionInfo;
import kd.tmc.fpm.business.domain.model.index.generate.bean.MemberInfo;
import kd.tmc.fpm.business.domain.model.index.generate.strategy.IndexTreeGenerateStrategy;
import kd.tmc.fpm.business.domain.model.report.AnalysisReport;
import kd.tmc.fpm.business.domain.model.report.ReportDataSource;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;

public class AnalysisIndexTreeStrategy
implements IndexTreeGenerateStrategy {
    private AnalysisReport analysisReport;
    private Map<Long, Dimension> dimensionMap;

    public AnalysisIndexTreeStrategy(ReportDataSource report, FundPlanSystem fundPlanSystem) {
        this.analysisReport = (AnalysisReport)report;
        this.dimensionMap = fundPlanSystem.getMainDimList().stream().collect(Collectors.toMap(Dimension::getId, Function.identity(), (a, b) -> a));
    }

    @Override
    public List<List<DimensionInfo>> getDimensionGroupList() {
        List<TemplateDim> pageDimensionList;
        ReportTemplate template = this.analysisReport.getTemplate();
        ArrayList<DimensionInfo> dimensionList = new ArrayList<DimensionInfo>(2);
        List<Long> sumDimensionIds = this.analysisReport.getSumDimensionIds();
        if (this.analysisReport.needClean() && EmptyUtil.isNoEmpty(pageDimensionList = this.analysisReport.getTemplate().getPageDimList().stream().filter(templateDim -> sumDimensionIds.contains(templateDim.getDimensionId())).collect(Collectors.toList()))) {
            this.fillDimensionInfo(dimensionList, pageDimensionList);
        }
        this.fillDimensionInfo(dimensionList, this.analysisReport.getTemplate().getRowDimList());
        this.fillDimensionInfo(dimensionList, this.analysisReport.getTemplate().getColDimList());
        if (dimensionList.size() == 0) {
            throw new IllegalArgumentException("Main dimension not found in report, templateId = " + template.getId());
        }
        return Collections.singletonList(dimensionList);
    }

    private void fillDimensionInfo(List<DimensionInfo> dimensionList, List<TemplateDim> templateDimList) {
        for (TemplateDim templateDim : templateDimList) {
            Dimension dimension = this.dimensionMap.get(templateDim.getDimensionId());
            if (Objects.isNull(dimension)) continue;
            if (!templateDim.getDimType().isPeriodDim()) {
                dimensionList.add(new DimensionInfo(dimension));
                continue;
            }
            dimensionList.add(new DimensionInfo(dimension));
            if (this.analysisReport.isContainDetailReportType()) continue;
            DimensionInfo dimensionInfo = new DimensionInfo();
            dimensionInfo.setDimensionId(dimension.getId());
            dimensionInfo.setDimType(dimension.getDimType());
            dimensionInfo.setMemberList(new ArrayList<MemberInfo>());
            Map periodMemberMap = dimension.getAllDimMemberList().stream().map(PeriodMember.class::cast).collect(Collectors.toMap(DimMember::getId, Function.identity(), (a, b) -> a));
            List<Long> memberScope = templateDim.getMemberScope();
            for (Long periodMemberId : memberScope) {
                PeriodMember periodMember = (PeriodMember)periodMemberMap.get(periodMemberId);
                if (Objects.isNull(periodMember)) continue;
                MemberInfo memberInfo = new MemberInfo();
                memberInfo.setMemberId(periodMemberId);
                memberInfo.setDimensionId(dimension.getId());
                memberInfo.setChildren(Collections.emptyList());
                memberInfo.setName(periodMember.getName());
                memberInfo.setPeriodType(periodMember.getPeriodType());
                memberInfo.setPeriodTypeId(periodMember.getPeriodTypeId());
                dimensionInfo.getMemberList().add(memberInfo);
            }
        }
    }

    @Override
    public List<MemberInfo> getDimMemberList(DimensionInfo dimension) {
        ReportTemplate template = this.analysisReport.getTemplate();
        Optional<TemplateDim> findOptional = template.getAllTemplateDim().stream().filter(td -> Objects.equals(td.getDimensionId(), dimension.getDimensionId())).findFirst();
        if (!findOptional.isPresent()) {
            return new ArrayList<MemberInfo>(0);
        }
        TemplateDim templateDim = findOptional.get();
        HashSet<Long> memberScope = new HashSet<Long>(templateDim.getMemberScope());
        return dimension.getAllDimMemberList().stream().filter(memberInfo -> memberScope.contains(memberInfo.getMemberId())).map(MemberInfo::copy).collect(Collectors.toList());
    }

    @Override
    public boolean buildSummaryReference() {
        return false;
    }

    @Override
    public boolean isSummaryNode(MemberInfo memberInfo) {
        return false;
    }
}

