/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.model.index.generate.strategy;

import com.google.common.base.Functions;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.index.generate.bean.DimensionInfo;
import kd.tmc.fpm.business.domain.model.index.generate.bean.MemberInfo;
import kd.tmc.fpm.business.domain.model.index.generate.strategy.IndexTreeGenerateStrategy;
import kd.tmc.fpm.business.domain.model.report.ReportDataSource;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.helper.TemplateInfoHelper;

public class CompleteSubjectIndexTreeStrategy
implements IndexTreeGenerateStrategy {
    private ReportDataSource report;
    private Map<Long, Dimension> dimensionMap;
    private Map<Long, TemplateDim> templateDimMap;
    private Set<Long> memberScopeWithParent;

    public CompleteSubjectIndexTreeStrategy(ReportDataSource report, FundPlanSystem system) {
        this.report = report;
        this.dimensionMap = system.getDimList().stream().collect(Collectors.toMap(Dimension::getId, Function.identity()));
        this.templateDimMap = report.getTemplate().getAllTemplateDim().stream().collect(Collectors.toMap(TemplateDim::getDimensionId, Functions.identity()));
    }

    @Override
    public List<List<DimensionInfo>> getDimensionGroupList() {
        LinkedList groupList = new LinkedList();
        ReportTemplate template = this.report.getTemplate();
        List<List> dimensionGroupList = Arrays.asList(template.getPageDimList(), template.getRowDimList(), template.getColDimList());
        for (List dimensions : dimensionGroupList) {
            List filteredDimList = dimensions.stream().filter(o -> o.getDimType() != DimensionType.DETAILDIM).filter(o -> TemplateInfoHelper.nonSubjectFlowVirtualDim(template, o.getDimType())).map(o -> this.dimensionMap.get(o.getDimensionId())).collect(Collectors.toList());
            if (filteredDimList.size() <= 0) continue;
            groupList.add(filteredDimList);
        }
        if (groupList.size() == 0) {
            throw new IllegalArgumentException("Main dimension not found in report, templateId = " + template.getId());
        }
        return groupList.stream().map(o -> o.stream().filter(Objects::nonNull).map(DimensionInfo::new).collect(Collectors.toList())).collect(Collectors.toList());
    }

    @Override
    public List<MemberInfo> getDimMemberList(DimensionInfo dimension) {
        TemplateDim templateDim = this.templateDimMap.get(dimension.getDimensionId());
        if (templateDim == null) {
            throw new IllegalArgumentException("TemplateDim not found: dimensionId = " + dimension.getDimensionId());
        }
        if (templateDim.getDimType().isSubjectDim()) {
            return dimension.getMemberList();
        }
        this.memberScopeWithParent = new HashSet<Long>(templateDim.getMemberScope().size());
        Map memMap = dimension.getAllDimMemberList().stream().collect(Collectors.toMap(MemberInfo::getMemberId, Functions.identity()));
        for (Long memberId : templateDim.getMemberScope()) {
            for (MemberInfo dimMember = (MemberInfo)memMap.get(memberId); dimMember != null; dimMember = dimMember.getParent()) {
                this.memberScopeWithParent.add(dimMember.getMemberId());
            }
        }
        LinkedList<MemberInfo> waitRemoveInfo = new LinkedList<MemberInfo>();
        for (MemberInfo member : dimension.getMemberList()) {
            if (!this.memberScopeWithParent.contains(member.getMemberId())) {
                waitRemoveInfo.add(member);
                continue;
            }
            this.removeChildMemberByMemberScope(member);
        }
        dimension.getMemberList().removeAll(waitRemoveInfo);
        return dimension.getMemberList();
    }

    @Override
    public boolean buildSummaryReference() {
        return false;
    }

    @Override
    public boolean isSummaryNode(MemberInfo memberInfo) {
        return false;
    }

    private void removeChildMemberByMemberScope(MemberInfo member) {
        List<MemberInfo> childMemList = member.getChildren();
        if (childMemList != null) {
            childMemList.removeIf(o -> !this.memberScopeWithParent.contains(o.getMemberId()));
            if (childMemList.size() > 0) {
                for (MemberInfo childMem : childMemList) {
                    this.removeChildMemberByMemberScope(childMem);
                }
            }
        }
    }
}

