/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.model.index.generate.strategy;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.PeriodType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.ReportPeriodType;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.index.generate.bean.DimensionInfo;
import kd.tmc.fpm.business.domain.model.index.generate.bean.MemberInfo;
import kd.tmc.fpm.business.domain.model.index.generate.strategy.AbstractTreeStrategy;
import kd.tmc.fpm.business.domain.model.index.generate.strategy.IndexTreeGenerateStrategy;
import kd.tmc.fpm.business.domain.model.report.ReportDataSource;
import org.apache.commons.collections.CollectionUtils;

public class DetailPeriodStrategy
extends AbstractTreeStrategy {
    private FundPlanSystem system;
    private ReportPeriodType periodType;
    private PeriodType detailPeriodType;

    public DetailPeriodStrategy(ReportDataSource reportDataSource, FundPlanSystem system, IndexTreeGenerateStrategy strategy) {
        super(strategy);
        this.system = system;
        this.periodType = reportDataSource.getReportPeriodType();
        this.detailPeriodType = this.periodType.getDetailPeriodType();
    }

    @Override
    public List<List<DimensionInfo>> getDimensionGroupList() {
        return this.strategy.getDimensionGroupList();
    }

    @Override
    public List<MemberInfo> getDimMemberList(DimensionInfo dimension) {
        List<MemberInfo> memberList = this.strategy.getDimMemberList(dimension);
        if (dimension.getDimType() == DimensionType.PERIOD) {
            Dimension periodDim = this.system.getMainDimensionByDimType(DimensionType.PERIOD);
            Map periodMemberMap = periodDim.getAllDimMemberList().stream().map(o -> (PeriodMember)o).collect(Collectors.toMap(DimMember::getId, Function.identity()));
            LinkedList<Object> leafMemList = new LinkedList<Object>();
            for (MemberInfo memberInfo : memberList) {
                List curLeafMemList = memberInfo.getAllChildMember().stream().filter(o -> CollectionUtils.isEmpty(o.getChildren())).collect(Collectors.toList());
                if (curLeafMemList.size() > 0) {
                    leafMemList.addAll(curLeafMemList);
                    continue;
                }
                leafMemList.add(memberInfo);
            }
            for (MemberInfo memberInfo : leafMemList) {
                if (memberInfo.getPeriodType() == this.detailPeriodType && this.periodType.getReportPeriodId().equals(memberInfo.getPeriodTypeId())) continue;
                PeriodMember dimMember = (PeriodMember)periodMemberMap.get(memberInfo.getMemberId());
                List<DimMember> periodChildren = dimMember.getChildren();
                List<MemberInfo> childInfoList = periodChildren.stream().map(o -> MemberInfo.buildMember(o, leafMember)).collect(Collectors.toList());
                LinkedList<MemberInfo> waitRemoveList = new LinkedList<MemberInfo>();
                for (MemberInfo child : childInfoList) {
                    if (this.clip(child)) {
                        waitRemoveList.add(child);
                        continue;
                    }
                    child.setParent(memberInfo);
                }
                childInfoList.removeAll(waitRemoveList);
                memberInfo.setChildren(childInfoList);
            }
        }
        return memberList;
    }

    @Override
    public boolean buildSummaryReference() {
        return true;
    }

    @Override
    public boolean isSummaryNode(MemberInfo memberInfo) {
        if (this.periodType.getPeriodType() == PeriodType.MONTH_WEEK) {
            return memberInfo.getPeriodType() == PeriodType.MONTH_WEEK || memberInfo.getPeriodType() == PeriodType.YEAR_WEEK;
        }
        return memberInfo.getPeriodType() == this.periodType.getPeriodType();
    }

    private boolean clip(MemberInfo memberInfo) {
        if (memberInfo.getPeriodType() == this.detailPeriodType && this.periodType.getReportPeriodId().equals(memberInfo.getPeriodTypeId())) {
            for (MemberInfo child : memberInfo.getChildren()) {
                child.setParent(null);
            }
            memberInfo.getChildren().clear();
            return false;
        }
        LinkedList<MemberInfo> waitRemoveList = new LinkedList<MemberInfo>();
        boolean clipFlag = true;
        for (MemberInfo child : memberInfo.getChildren()) {
            if (this.clip(child)) {
                waitRemoveList.add(child);
                continue;
            }
            clipFlag = false;
        }
        memberInfo.getChildren().removeAll(waitRemoveList);
        return clipFlag;
    }
}

