/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.model.index.generate.strategy;

import com.google.common.base.Functions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.index.generate.bean.DimensionInfo;
import kd.tmc.fpm.business.domain.model.index.generate.bean.MemberInfo;
import kd.tmc.fpm.business.domain.model.index.generate.strategy.IndexTreeGenerateStrategy;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;

public class DimensionMemberScopeIndexTreeStrategy
implements IndexTreeGenerateStrategy {
    private Map<Long, Dimension> dimensionMap;
    private Map<Long, TemplateDim> templateDimMap;
    private Set<Long> memberScopeWithParent;

    public DimensionMemberScopeIndexTreeStrategy(List<TemplateDim> templateDimList, FundPlanSystem system) {
        this.dimensionMap = system.getDimList().stream().collect(Collectors.toMap(Dimension::getId, Function.identity()));
        this.templateDimMap = templateDimList.stream().collect(Collectors.toMap(TemplateDim::getDimensionId, Functions.identity()));
    }

    @Override
    public List<List<DimensionInfo>> getDimensionGroupList() {
        LinkedList<ArrayList> groupList = new LinkedList<ArrayList>();
        for (Map.Entry<Long, TemplateDim> dimensions : this.templateDimMap.entrySet()) {
            Dimension dimension;
            TemplateDim templateDim = dimensions.getValue();
            if (templateDim.getDimType() == DimensionType.DETAILDIM || Objects.isNull(dimension = this.dimensionMap.get(templateDim.getDimensionId()))) continue;
            groupList.add(Lists.newArrayList((Object[])new Dimension[]{dimension}));
        }
        if (groupList.size() == 0) {
            throw new IllegalArgumentException("Main dimension not found in report");
        }
        return groupList.stream().map(o -> o.stream().map(DimensionInfo::new).collect(Collectors.toList())).collect(Collectors.toList());
    }

    @Override
    public List<MemberInfo> getDimMemberList(DimensionInfo dimension) {
        TemplateDim templateDim = this.templateDimMap.get(dimension.getDimensionId());
        if (templateDim == null) {
            throw new IllegalArgumentException("TemplateDim not found: dimensionId = " + dimension.getDimensionId());
        }
        this.memberScopeWithParent = new HashSet<Long>(templateDim.getMemberScope().size());
        Map memMap = dimension.getAllDimMemberList().stream().collect(Collectors.toMap(MemberInfo::getMemberId, Functions.identity()));
        for (Long memberId : templateDim.getMemberScope()) {
            for (MemberInfo dimMember = (MemberInfo)memMap.get(memberId); dimMember != null; dimMember = dimMember.getParent()) {
                this.memberScopeWithParent.add(dimMember.getMemberId());
            }
        }
        LinkedList<MemberInfo> waitRemoveInfo = new LinkedList<MemberInfo>();
        for (MemberInfo member : dimension.getMemberList()) {
            if (!this.memberScopeWithParent.contains(member.getMemberId())) {
                waitRemoveInfo.add(member);
                continue;
            }
            this.removeChildMemberByMemberScope(member);
        }
        dimension.getMemberList().removeAll(waitRemoveInfo);
        return dimension.getMemberList();
    }

    @Override
    public boolean buildSummaryReference() {
        return false;
    }

    @Override
    public boolean isSummaryNode(MemberInfo memberInfo) {
        return false;
    }

    private void removeChildMemberByMemberScope(MemberInfo member) {
        List<MemberInfo> childMemList = member.getChildren();
        if (childMemList != null) {
            childMemList.removeIf(o -> !this.memberScopeWithParent.contains(o.getMemberId()));
            if (childMemList.size() > 0) {
                for (MemberInfo childMem : childMemList) {
                    this.removeChildMemberByMemberScope(childMem);
                }
            }
        }
    }
}

