/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.model.index.generate.strategy;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.index.generate.bean.DimensionInfo;
import kd.tmc.fpm.business.domain.model.index.generate.bean.MemberInfo;
import kd.tmc.fpm.business.domain.model.index.generate.strategy.AbstractTreeStrategy;
import kd.tmc.fpm.business.domain.model.index.generate.strategy.IndexTreeGenerateStrategy;
import kd.tmc.fpm.business.domain.model.report.AnalysisReport;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;

public class MultiAnalysisOrgScopeStrategy
extends AbstractTreeStrategy {
    private AnalysisReport analysisReport;

    public MultiAnalysisOrgScopeStrategy(IndexTreeGenerateStrategy strategy, AnalysisReport analysisReport) {
        super(strategy);
        this.analysisReport = analysisReport;
    }

    @Override
    public List<List<DimensionInfo>> getDimensionGroupList() {
        return this.strategy.getDimensionGroupList();
    }

    @Override
    public List<MemberInfo> getDimMemberList(DimensionInfo dimension) {
        if (!dimension.getDimType().isOrgDim()) {
            return this.strategy.getDimMemberList(dimension);
        }
        List<MemberInfo> memberList = dimension.getMemberList();
        ReportTemplate template = this.analysisReport.getTemplate();
        TemplateDim orgDim = template.getAllTemplateDim().stream().filter(templateDim -> templateDim.getDimType().isOrgDim()).findFirst().get();
        List<Long> memberScope = orgDim.getMemberScope();
        if (EmptyUtil.isEmpty(memberScope)) {
            return this.strategy.getDimMemberList(dimension);
        }
        List memberInfoList = memberList.stream().filter(memberInfo -> memberScope.contains(memberInfo.getMemberId())).collect(Collectors.toList());
        memberInfoList.addAll(memberInfoList.stream().map(MemberInfo::getAllChildMember).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList()));
        return memberInfoList.stream().map(MemberInfo::copy).distinct().collect(Collectors.toList());
    }

    @Override
    public boolean buildSummaryReference() {
        return this.strategy.buildSummaryReference();
    }

    @Override
    public boolean isSummaryNode(MemberInfo memberInfo) {
        return this.strategy.isSummaryNode(memberInfo);
    }
}

