/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.model.index.node;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.tmc.fpm.common.bean.DimensionInfoBean;

public class TreeNode
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long id;
    private String name;
    private Long dimId;
    private Long memId;
    private boolean root;
    private TreeNode parent;
    private LinkedHashMap<Long, TreeNode> children;
    private TreeNode next;
    private TreeNode brother;
    private boolean summary;
    private boolean leaf;
    private Set<TreeNode> refNodes;
    private String formula;
    private transient List<Object> dataList;
    private boolean dimLeaf;
    private Map<Long, TreeNode> nextDimMemMap;
    private boolean virtual;
    private TreeNode leafHead;
    private TreeNode leafTail;
    private TreeNode virtualRef;

    public TreeNode addChild(TreeNode node) {
        if (this.children == null) {
            this.children = new LinkedHashMap(8);
        }
        this.children.put(node.getMemId(), node);
        return this;
    }

    public TreeNode addRefNodes(TreeNode node) {
        if (this.refNodes == null) {
            this.refNodes = new HashSet<TreeNode>(8);
        }
        this.refNodes.add(node);
        return this;
    }

    public TreeNode addData(Object data) {
        if (this.dataList == null) {
            this.dataList = new LinkedList<Object>();
        }
        this.dataList.add(data);
        return this;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public boolean isRoot() {
        return this.root;
    }

    public void setRoot(boolean root) {
        this.root = root;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getDimId() {
        return this.dimId;
    }

    public void setDimId(Long dimId) {
        this.dimId = dimId;
    }

    public Long getMemId() {
        return this.memId;
    }

    public void setMemId(Long memId) {
        this.memId = memId;
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public void setParent(TreeNode parent) {
        this.parent = parent;
    }

    public LinkedHashMap<Long, TreeNode> getChildren() {
        return this.children;
    }

    public void setChildren(LinkedHashMap<Long, TreeNode> children) {
        this.children = children;
    }

    public TreeNode getNext() {
        return this.next;
    }

    public void setNext(TreeNode next) {
        this.next = next;
    }

    public boolean isLeaf() {
        return this.leaf;
    }

    public void setLeaf(boolean leaf) {
        this.leaf = leaf;
    }

    public Set<TreeNode> getRefNodes() {
        return this.refNodes;
    }

    public void setRefNodes(Set<TreeNode> refNodes) {
        this.refNodes = refNodes;
    }

    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public List<Object> getDataList() {
        return this.dataList;
    }

    public void setDataList(List<Object> dataList) {
        this.dataList = dataList;
    }

    public boolean isSummary() {
        return this.summary;
    }

    public void setSummary(boolean summary) {
        this.summary = summary;
    }

    public TreeNode getLeafHead() {
        return this.leafHead;
    }

    public void setLeafHead(TreeNode leafHead) {
        this.leafHead = leafHead;
    }

    public TreeNode getLeafTail() {
        return this.leafTail;
    }

    public void setLeafTail(TreeNode leafTail) {
        this.leafTail = leafTail;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public void setVirtual(boolean virtual) {
        this.virtual = virtual;
    }

    public TreeNode getVirtualRef() {
        return this.virtualRef;
    }

    public void setVirtualRef(TreeNode virtualRef) {
        this.virtualRef = virtualRef;
    }

    public boolean isDimLeaf() {
        return this.dimLeaf;
    }

    public void setDimLeaf(boolean dimLeaf) {
        this.dimLeaf = dimLeaf;
    }

    public Map<Long, TreeNode> getNextDimMemMap() {
        return this.nextDimMemMap;
    }

    public void setNextDimMemMap(Map<Long, TreeNode> nextDimMemMap) {
        this.nextDimMemMap = nextDimMemMap;
    }

    public TreeNode getBrother() {
        return this.brother;
    }

    public void setBrother(TreeNode brother) {
        this.brother = brother;
    }

    public String toString() {
        return this.name;
    }

    public DimensionInfoBean getDimInfoBean() {
        DimensionInfoBean dimensionInfoBean = new DimensionInfoBean();
        ArrayList<Long> dimIdList = new ArrayList<Long>(6);
        ArrayList<Long> dimMemberIdList = new ArrayList<Long>(6);
        dimensionInfoBean.setDimensionIdList(dimIdList);
        dimensionInfoBean.setMemberIdList(dimMemberIdList);
        List<TreeNode> allParentNode = this.getAllParentNode();
        allParentNode.add(0, this);
        for (TreeNode treeNode : allParentNode) {
            if (treeNode.isVirtual() || treeNode.getDimId() == null || dimIdList.contains(treeNode.getDimId())) continue;
            dimIdList.add(treeNode.getDimId());
            dimMemberIdList.add(treeNode.getMemId());
        }
        return dimensionInfoBean;
    }

    public List<TreeNode> getAllParentNode() {
        ArrayList<TreeNode> result = new ArrayList<TreeNode>(16);
        this.getParentNode(this, result);
        return result;
    }

    private void getParentNode(TreeNode treeNode, List<TreeNode> outMemberList) {
        TreeNode parent = treeNode.getParent();
        if (parent == null) {
            return;
        }
        outMemberList.add(parent);
        this.getParentNode(parent, outMemberList);
    }
}

