/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.model.inspection;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.inspection.DateRange;
import kd.tmc.fpm.business.domain.model.inspection.header.BaseHeader;
import kd.tmc.fpm.common.helper.StringHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class InspectDateRange {
    private List<DateRange> dateRangeList = new ArrayList<DateRange>(8);
    private Map<Long, PeriodMember> periodMemberMap = new HashMap<Long, PeriodMember>(64);

    private InspectDateRange() {
    }

    public static InspectDateRange getInstance(BaseHeader header, FundPlanSystem system) {
        Date startDate = header.getStartDate();
        Date endDate = header.getEndDate();
        InspectDateRange inspectDateRange = new InspectDateRange();
        if (Objects.nonNull(startDate) && Objects.nonNull(endDate)) {
            inspectDateRange.dateRangeList.add(new DateRange(startDate, endDate));
        }
        if (CollectionUtils.isEmpty(header.getPeriodScope())) {
            return inspectDateRange;
        }
        HashSet<Long> periodScope = new HashSet<Long>(header.getPeriodScope());
        Dimension periodDim = system.getMainDimensionByDimType(DimensionType.PERIOD);
        periodDim.getAllDimMemberList().stream().filter(p -> periodScope.contains(p.getId())).map(PeriodMember.class::cast).forEach(p -> {
            inspectDateRange.dateRangeList.add(new DateRange(p.getStartDate(), p.getEndDate()));
            inspectDateRange.periodMemberMap.putIfAbsent(p.getId(), (PeriodMember)p);
        });
        return inspectDateRange;
    }

    public boolean isInRange(String dateStr) {
        if (EmptyUtil.isEmpty((String)dateStr)) {
            return false;
        }
        Date date = DateUtils.stringToDate((String)dateStr, (String)"yyyy-MM-dd");
        if (Objects.isNull(date)) {
            return false;
        }
        return this.isInRange(date);
    }

    public boolean isInRange(Date date) {
        for (DateRange dateRange : this.dateRangeList) {
            if (!dateRange.isInRange(date)) continue;
            return true;
        }
        return false;
    }

    public boolean isInRange(Object val) {
        if (EmptyUtil.isEmpty((Object)val)) {
            return false;
        }
        if (val instanceof Date) {
            Date date = (Date)val;
            return this.isInRange(date);
        }
        if (val instanceof Long) {
            Long periodMemId = (Long)val;
            return this.isInRange(periodMemId);
        }
        String value = StringHelper.getStringValue((Object)val);
        return this.isInRange(value);
    }

    public boolean isInRange(Long periodMemId) {
        return this.periodMemberMap.containsKey(periodMemId);
    }

    public Set<Long> getAllPeriodMemberIdList() {
        return new HashSet<Long>(this.periodMemberMap.keySet());
    }

    public List<PeriodMember> getAllPeriodMemberList() {
        if (this.periodMemberMap.size() > 0) {
            return new ArrayList<PeriodMember>(this.periodMemberMap.values());
        }
        return new ArrayList<PeriodMember>(0);
    }

    public DateRange getDateRange() {
        if (MapUtils.isNotEmpty(this.periodMemberMap)) {
            return null;
        }
        if (EmptyUtil.isEmpty(this.dateRangeList)) {
            return null;
        }
        return this.dateRangeList.get(0);
    }

    public Date getMinStartDate() {
        return this.dateRangeList.stream().sorted(Comparator.comparing(DateRange::getStartDate)).map(DateRange::getStartDate).findFirst().get();
    }

    public Date getMaxEndDate() {
        return this.dateRangeList.stream().sorted(Comparator.comparing(DateRange::getEndDate).reversed()).map(DateRange::getEndDate).findFirst().get();
    }
}

