/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.model.match;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.index.BitMap;
import kd.tmc.fpm.business.domain.model.index.generate.QueryIndexInfoMapGenerator;
import kd.tmc.fpm.business.domain.model.index.generate.bean.QueryIndexInfo;
import kd.tmc.fpm.business.domain.model.match.MatchValue;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.mvc.exception.match.MatchException;
import kd.tmc.fpm.common.bean.DimensionInfoBean;

public class GroupReportData {
    private DimensionInfoBean dimensionInfoBean;
    private List<ReportData> reportDataList;
    private List<ReportData> optionalReportDataList;
    private ReportData reportData;
    private Long reportPeriodId;
    private Long reportPeriodMemId;
    private Long reportOrgId;
    private Long sumReportOrgId;
    private MatchException matchException;
    private boolean accurateMatched;
    private BitMap<Long, Long> detailDimBitMap;
    private QueryIndexInfo<Long, ReportData> queryIndexInfo;
    private boolean hasDetailPeriod;

    public GroupReportData(DimensionInfoBean dimensionInfoBean, List<ReportData> reportDataList) {
        this(0L, 0L, dimensionInfoBean, reportDataList);
    }

    public GroupReportData(Long reportOrgId, Long reportPeriodMemId, DimensionInfoBean dimensionInfoBean, List<ReportData> reportDataList) {
        this(reportOrgId, reportPeriodMemId, dimensionInfoBean, reportDataList, null);
    }

    public GroupReportData(DimensionInfoBean dimensionInfoBean, List<ReportData> reportDataList, MatchException matchException) {
        this(0L, 0L, dimensionInfoBean, reportDataList, matchException);
    }

    public GroupReportData(Long reportOrgId, Long reportPeriodMemId, DimensionInfoBean dimensionInfoBean, List<ReportData> reportDataList, MatchException matchException) {
        this.dimensionInfoBean = dimensionInfoBean;
        this.reportDataList = reportDataList;
        if (EmptyUtil.isNoEmpty(reportDataList)) {
            this.reportPeriodId = reportDataList.get(0).getReportPeriodId();
        }
        this.reportPeriodMemId = reportPeriodMemId;
        this.reportOrgId = reportOrgId;
        this.matchException = matchException;
        this.accurateMatched = true;
        this.detailDimBitMap = new BitMap(32);
        this.optionalReportDataList = new ArrayList<ReportData>(64);
    }

    public void setDimensionInfoBean(DimensionInfoBean dimensionInfoBean) {
        this.dimensionInfoBean = dimensionInfoBean;
    }

    public List<ReportData> getReportDataList() {
        return this.reportDataList;
    }

    public void setReportDataList(List<ReportData> reportDataList) {
        this.reportDataList = reportDataList;
        if (EmptyUtil.isNoEmpty(reportDataList) && EmptyUtil.isEmpty((Long)this.reportPeriodId)) {
            this.reportPeriodId = reportDataList.get(0).getReportPeriodId();
        }
    }

    public DimensionInfoBean getDimensionInfoBean() {
        return this.dimensionInfoBean;
    }

    public QueryIndexInfo<Long, ReportData> getQueryIndexInfo(FundPlanSystem system) {
        if (Objects.nonNull(this.queryIndexInfo)) {
            return this.queryIndexInfo;
        }
        this.queryIndexInfo = QueryIndexInfoMapGenerator.buildReportDataIndex(this.reportDataList, system);
        return this.queryIndexInfo;
    }

    public MatchException getMatchException() {
        return this.matchException;
    }

    public void setMatchException(MatchException matchException) {
        this.matchException = matchException;
    }

    public boolean hasException() {
        return Objects.nonNull((Object)this.matchException);
    }

    public Long getReportPeriodId() {
        return this.reportPeriodId;
    }

    public void setReportPeriodId(Long reportPeriodId) {
        this.reportPeriodId = reportPeriodId;
    }

    public ReportData getReportData() {
        if (Objects.nonNull(this.reportData)) {
            return this.reportData;
        }
        if (EmptyUtil.isEmpty(this.reportDataList)) {
            return null;
        }
        return this.reportDataList.get(0);
    }

    public void setReportData(ReportData reportData) {
        this.reportData = reportData;
    }

    public boolean isAccurateMatched() {
        return this.accurateMatched;
    }

    public void setAccurateMatched(boolean accurateMatched) {
        this.accurateMatched = accurateMatched;
    }

    public Long getReportOrgId() {
        return this.reportOrgId;
    }

    public void setReportOrgId(Long reportOrgId) {
        this.reportOrgId = reportOrgId;
    }

    public BitMap<Long, Long> getDetailDimBitMap() {
        return this.detailDimBitMap;
    }

    public void setDetailDimBitMap(BitMap<Long, Long> detailDimBitMap) {
        this.detailDimBitMap = detailDimBitMap;
    }

    public Long getReportPeriodMemId() {
        return this.reportPeriodMemId;
    }

    public void setReportPeriodMemId(Long reportPeriodMemId) {
        this.reportPeriodMemId = reportPeriodMemId;
    }

    public boolean isDetailPeriodData() {
        return !this.hasDetailPeriod || !Objects.equals(this.reportPeriodMemId, this.reportPeriodId);
    }

    public Long getSumReportOrgId() {
        return this.sumReportOrgId;
    }

    public void setSumReportOrgId(Long sumReportOrgId) {
        this.sumReportOrgId = sumReportOrgId;
    }

    public boolean isSumData() {
        return EmptyUtil.isNoEmpty((Long)this.sumReportOrgId);
    }

    public boolean isMatchedDetail() {
        return Objects.nonNull(this.detailDimBitMap) && !this.detailDimBitMap.isEmpty();
    }

    public List<ReportData> getOptionalReportDataList() {
        return this.optionalReportDataList;
    }

    public void setOptionalReportDataList(List<ReportData> optionalReportDataList) {
        this.optionalReportDataList = optionalReportDataList;
    }

    public boolean isHasDetailPeriod() {
        return this.hasDetailPeriod;
    }

    public void setHasDetailPeriod(boolean hasDetailPeriod) {
        this.hasDetailPeriod = hasDetailPeriod;
    }

    public void addReportData(ReportData reportData) {
        this.reportDataList.add(reportData);
    }

    public void addOptionalReportData(ReportData reportData) {
        this.optionalReportDataList.add(reportData);
    }

    public void addDetailMatchValue(MatchValue matchValue, ReportData reportData) {
        if (Objects.isNull(this.detailDimBitMap)) {
            this.detailDimBitMap = new BitMap(this.reportDataList.size());
        }
        this.detailDimBitMap.addValue(matchValue.getDimension().getId(), reportData.getId());
    }

    public boolean isAbort() {
        return Objects.nonNull((Object)this.matchException) && this.matchException.isAbort();
    }

    public GroupReportData copy() {
        GroupReportData groupReportData = new GroupReportData(this.dimensionInfoBean.copy(), new ArrayList<ReportData>(16), this.matchException);
        groupReportData.accurateMatched = this.accurateMatched;
        groupReportData.reportOrgId = this.reportOrgId;
        groupReportData.reportPeriodMemId = this.reportPeriodMemId;
        groupReportData.reportPeriodId = this.reportPeriodId;
        groupReportData.sumReportOrgId = this.sumReportOrgId;
        groupReportData.optionalReportDataList = new ArrayList<ReportData>(this.optionalReportDataList);
        groupReportData.hasDetailPeriod = this.hasDetailPeriod;
        return groupReportData;
    }
}

