/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.model.query;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.BasedataEntityType;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DetailDimType;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.MemberType;
import kd.tmc.fpm.business.domain.enums.PeriodControlStrategyType;
import kd.tmc.fpm.business.domain.model.control.ControlStrategyDetail;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.report.ReportData;

public class BalanceResultInfo {
    private Long reportDataId;
    private Long reportId;
    private BigDecimal planAmt;
    private BigDecimal lockAmt;
    private BigDecimal factAmt;
    private Map<String, Object> dimensionValueMap = new HashMap<String, Object>(16);
    private Map<String, Object> dimensionNameMap = new HashMap<String, Object>(16);
    public static final String SEPARATOR = ";";

    public Map<String, Object> getDimensionNameMap() {
        return this.dimensionNameMap;
    }

    public void setDimensionNameMap(Map<String, Object> dimensionNameMap) {
        this.dimensionNameMap = dimensionNameMap;
    }

    public Long getReportDataId() {
        return this.reportDataId;
    }

    public void setReportDataId(Long reportDataId) {
        this.reportDataId = reportDataId;
    }

    public BigDecimal getPlanAmt() {
        return this.planAmt;
    }

    public void setPlanAmt(BigDecimal planAmt) {
        this.planAmt = planAmt;
    }

    public BigDecimal getLockAmt() {
        return this.lockAmt;
    }

    public void setLockAmt(BigDecimal lockAmt) {
        this.lockAmt = lockAmt;
    }

    public BigDecimal getFactAmt() {
        return this.factAmt;
    }

    public void setFactAmt(BigDecimal factAmt) {
        this.factAmt = factAmt;
    }

    public Long getReportId() {
        return this.reportId;
    }

    public void setReportId(Long reportId) {
        this.reportId = reportId;
    }

    public Map<String, Object> getDimensionValueMap() {
        return this.dimensionValueMap;
    }

    public void setDimensionValueMap(Map<String, Object> dimensionValueMap) {
        this.dimensionValueMap = dimensionValueMap;
    }

    public String toString() {
        return "BalanceResultInfo{reportDataId=" + this.reportDataId + ", reportId=" + this.reportId + ", planAmt=" + this.planAmt + ", lockAmt=" + this.lockAmt + ", factAmt=" + this.factAmt + ", dimensionValueMap=" + this.dimensionValueMap + '}';
    }

    public static BalanceResultInfoBuilder builder() {
        return new BalanceResultInfoBuilder();
    }

    public BalanceResultInfo build(BalanceResultInfoBuilder balanceResultInfoBuilder) {
        if (Objects.nonNull(balanceResultInfoBuilder.dimensionConfig) && Objects.nonNull(balanceResultInfoBuilder.reportData)) {
            for (Map.Entry<String, DimensionAndDetailType> entry : balanceResultInfoBuilder.dimensionConfig.entrySet()) {
                Object dimVal;
                String fieldName = entry.getKey();
                DimensionAndDetailType dimensionAndDetailType = entry.getValue();
                DimensionType dimensionType = dimensionAndDetailType.getDimensionType();
                if (dimensionType.isCustomDim()) {
                    dimVal = this.getCusDimValue(balanceResultInfoBuilder, fieldName);
                    if (dimVal == null) {
                        continue;
                    }
                } else {
                    dimVal = balanceResultInfoBuilder.reportData.getDimValByDimType(dimensionType, dimensionAndDetailType.getDetailDimType());
                }
                Dimension dimension = balanceResultInfoBuilder.fundPlanSystem.getDetailDimensionByDetailType(dimensionAndDetailType.getDetailDimType());
                if (fieldName.startsWith("detail_detailext") && dimension.getMemberType() == MemberType.BASE_DATA) {
                    if (EmptyUtil.isEmpty((Object)dimVal)) continue;
                    String baseDataType = dimension.getBaseDataType();
                    BasedataEntityType basedataEntityType = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)baseDataType);
                    String nameProperty = basedataEntityType.getNameProperty();
                    DynamicObject dynamicObject = TmcDataServiceHelper.loadSingle((Object)dimVal, (String)baseDataType, (String)nameProperty);
                    dimVal = dynamicObject.getString(nameProperty);
                }
                if (Objects.isNull(dimVal)) continue;
                this.dimensionValueMap.put(fieldName, dimVal);
                this.dimensionNameMap.put(fieldName, dimension.getName());
            }
        }
        if (Objects.nonNull(balanceResultInfoBuilder.reportData)) {
            this.reportDataId = balanceResultInfoBuilder.reportData.getId();
            this.reportId = balanceResultInfoBuilder.reportData.getReportId();
            this.planAmt = balanceResultInfoBuilder.reportData.getPlanAmt();
            this.lockAmt = balanceResultInfoBuilder.reportData.getLockAmt();
            this.factAmt = balanceResultInfoBuilder.reportData.getActAmt();
        }
        return this;
    }

    private Object getCusDimValue(BalanceResultInfoBuilder balanceResultInfoBuilder, String fieldName) {
        Object dimVal;
        try {
            int seq = Integer.parseInt(fieldName.substring(fieldName.length() - 1));
            Long customDimId = balanceResultInfoBuilder.seqCustomDimMap.get(seq);
            if (EmptyUtil.isEmpty((Long)customDimId)) {
                return null;
            }
            dimVal = balanceResultInfoBuilder.reportData.getDimValByDimensionId(customDimId);
            if (EmptyUtil.isEmpty((Object)dimVal)) {
                return null;
            }
            Optional<Dimension> first = balanceResultInfoBuilder.fundPlanSystem.getDimList().stream().filter(td -> Objects.equals(td.getId(), customDimId)).findFirst();
            if (first.isPresent()) {
                dimVal = new DimValue(first.get().getName(), dimVal);
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
        return dimVal;
    }

    public static class DimValue {
        private String name;
        private Object value;

        public DimValue(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }
    }

    public static class DimensionAndDetailType {
        DimensionType dimensionType;
        DetailDimType detailDimType;

        public DimensionAndDetailType(DimensionType dimensionType) {
            this(dimensionType, null);
        }

        public DimensionAndDetailType(DetailDimType detailDimType) {
            this(DimensionType.DETAILDIM, detailDimType);
        }

        public DimensionAndDetailType(DimensionType dimensionType, DetailDimType detailDimType) {
            this.dimensionType = dimensionType;
            this.detailDimType = detailDimType;
        }

        public DimensionType getDimensionType() {
            return this.dimensionType;
        }

        public DetailDimType getDetailDimType() {
            return this.detailDimType;
        }

        public String toString() {
            return "DimensionAndDetailType{dimensionType=" + (Object)((Object)this.dimensionType) + ", detailDimType=" + (Object)((Object)this.detailDimType) + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DimensionAndDetailType that = (DimensionAndDetailType)o;
            return this.dimensionType == that.dimensionType && this.detailDimType == that.detailDimType;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.dimensionType, this.detailDimType});
        }
    }

    public static class BalanceResultInfoBuilder {
        protected ReportData reportData;
        protected PeriodControlStrategyType periodControlStrategy;
        protected ControlStrategyDetail controlStrategyDetail;
        protected FundPlanSystem fundPlanSystem;
        protected Map<String, DimensionAndDetailType> dimensionConfig;
        protected Map<Integer, Long> seqCustomDimMap;

        public BalanceResultInfoBuilder reportData(ReportData reportData) {
            this.reportData = reportData;
            return this;
        }

        public BalanceResultInfoBuilder periodControlStrategy(PeriodControlStrategyType periodControlStrategy) {
            this.periodControlStrategy = periodControlStrategy;
            return this;
        }

        public BalanceResultInfoBuilder fundPlanSystem(FundPlanSystem fundPlanSystem) {
            this.fundPlanSystem = fundPlanSystem;
            return this;
        }

        public BalanceResultInfoBuilder controlStrategyDetail(ControlStrategyDetail controlStrategyDetail) {
            this.controlStrategyDetail = controlStrategyDetail;
            return this;
        }

        public BalanceResultInfoBuilder dimensionConfig(Map<String, DimensionAndDetailType> dimensionConfig) {
            this.dimensionConfig = dimensionConfig;
            return this;
        }

        public BalanceResultInfoBuilder seqCustomDimMap(Map<Integer, Long> seqCustomDimMap) {
            this.seqCustomDimMap = seqCustomDimMap;
            return this;
        }

        public BalanceResultInfo build() {
            return new BalanceResultInfo().build(this);
        }

        public BalanceResultInfo build(BalanceResultInfo balanceResultInfo) {
            return balanceResultInfo.build(this);
        }
    }
}

