/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.model.query;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import kd.tmc.fpm.business.domain.enums.ControlIntensityType;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.control.ControlStrategyDetail;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.query.BalanceResultInfo;
import kd.tmc.fpm.common.enums.ControlIntensityEnum;
import kd.tmc.fpm.common.enums.PeriodControlStrategyEnum;

public class BalanceResultMainInfo
extends BalanceResultInfo {
    private Long systemId;
    private String periodControlStrategy;
    private String controlIntensity;
    private BigDecimal controlCoefficient;
    private String detailControlBasis;
    private String amtUnit;

    public Long getSystemId() {
        return this.systemId;
    }

    public void setSystemId(Long systemId) {
        this.systemId = systemId;
    }

    public String getPeriodControlStrategy() {
        return this.periodControlStrategy;
    }

    public void setPeriodControlStrategy(String periodControlStrategy) {
        this.periodControlStrategy = periodControlStrategy;
    }

    public String getControlIntensity() {
        return this.controlIntensity;
    }

    public void setControlIntensity(String controlIntensity) {
        this.controlIntensity = controlIntensity;
    }

    public BigDecimal getControlCoefficient() {
        return this.controlCoefficient;
    }

    public void setControlCoefficient(BigDecimal controlCoefficient) {
        this.controlCoefficient = controlCoefficient;
    }

    public String getDetailControlBasis() {
        return this.detailControlBasis;
    }

    public void setDetailControlBasis(String detailControlBasis) {
        this.detailControlBasis = detailControlBasis;
    }

    public String getAmtUnit() {
        return this.amtUnit;
    }

    public void setAmtUnit(String amtUnit) {
        this.amtUnit = amtUnit;
    }

    @Override
    public BalanceResultInfo build(BalanceResultInfo.BalanceResultInfoBuilder balanceResultInfoBuilder) {
        super.build(balanceResultInfoBuilder);
        if (Objects.nonNull(balanceResultInfoBuilder.fundPlanSystem)) {
            this.systemId = balanceResultInfoBuilder.fundPlanSystem.getId();
        }
        if (Objects.nonNull(balanceResultInfoBuilder.reportData)) {
            this.amtUnit = balanceResultInfoBuilder.reportData.getAmountUnit().getName();
        }
        if (Objects.nonNull(balanceResultInfoBuilder.periodControlStrategy)) {
            this.periodControlStrategy = PeriodControlStrategyEnum.valueOf((String)balanceResultInfoBuilder.periodControlStrategy.toString()).getName();
        }
        if (Objects.nonNull(balanceResultInfoBuilder.controlStrategyDetail)) {
            this.controlCoefficient = balanceResultInfoBuilder.controlStrategyDetail.getControlCoefficient();
            ControlIntensityType controlIntensity = balanceResultInfoBuilder.controlStrategyDetail.getControlIntensity();
            if (Objects.nonNull(controlIntensity)) {
                this.controlIntensity = ControlIntensityEnum.valueOf((String)controlIntensity.toString()).getName().loadKDString();
            }
            List<ControlStrategyDetail.DetailControlBasis> detailControlBasisList = balanceResultInfoBuilder.controlStrategyDetail.getDetailControlBasisList();
            List<ControlStrategyDetail.DetailControlBasis> list = detailControlBasisList = balanceResultInfoBuilder.controlStrategyDetail.getDetailControl() != false ? detailControlBasisList : Collections.emptyList();
            if (Objects.nonNull(balanceResultInfoBuilder.fundPlanSystem)) {
                List<Dimension> detailDimList = balanceResultInfoBuilder.fundPlanSystem.getDetailDimList();
                StringBuilder sb = new StringBuilder();
                for (ControlStrategyDetail.DetailControlBasis controlBasis : detailControlBasisList) {
                    DimensionType dimensionType = controlBasis.getDimensionType();
                    if (dimensionType == DimensionType.DETAILDIM) {
                        Dimension detailField = detailDimList.stream().filter(dimension -> Objects.equals(dimension.getId(), controlBasis.getDimensionId())).findFirst().orElse(null);
                        if (!Objects.nonNull(detailField)) continue;
                        if (sb.length() == 0) {
                            sb.append(detailField.getName());
                            continue;
                        }
                        sb.append(";").append(detailField.getName());
                        continue;
                    }
                    Dimension mainDimensionByDimType = balanceResultInfoBuilder.fundPlanSystem.getMainDimensionByDimensionId(controlBasis.getDimensionId());
                    if (sb.length() == 0) {
                        sb.append(mainDimensionByDimType.getName());
                        continue;
                    }
                    sb.append(";").append(mainDimensionByDimType.getName());
                }
                this.detailControlBasis = sb.toString();
            }
        }
        return this;
    }

    @Override
    public String toString() {
        return "BalanceResultMainInfo{systemId=" + this.systemId + ", periodControlStrategy='" + this.periodControlStrategy + '\'' + ", controlIntensity='" + this.controlIntensity + '\'' + ", controlCoefficient=" + this.controlCoefficient + ", detailControlBasis='" + this.detailControlBasis + '\'' + ", amtUnit='" + this.amtUnit + '\'' + '}' + super.toString();
    }
}

