/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.model.report;

import java.math.BigDecimal;
import java.util.Objects;
import kd.tmc.fpm.business.domain.enums.AmountUnit;

public class AdjustAmtInfo {
    private CombinationKey combinationKey;
    private AmountUnit amountUnit;
    private BigDecimal adjustSumAmtIn = BigDecimal.ZERO;
    private BigDecimal adjustSumAmtOut = BigDecimal.ZERO;
    private BigDecimal adjustSumAmtBal = BigDecimal.ZERO;

    public AdjustAmtInfo() {
    }

    public AdjustAmtInfo(CombinationKey combinationKey, AmountUnit amountUnit) {
        this();
        this.combinationKey = combinationKey;
        this.amountUnit = amountUnit;
    }

    public AmountUnit getAmountUnit() {
        return this.amountUnit;
    }

    public void setAmountUnit(AmountUnit amountUnit) {
        this.amountUnit = amountUnit;
    }

    public BigDecimal getAdjustSumAmtIn() {
        return this.adjustSumAmtIn;
    }

    public void setAdjustSumAmtIn(BigDecimal adjustSumAmtIn) {
        this.adjustSumAmtIn = adjustSumAmtIn;
    }

    public BigDecimal getAdjustSumAmtOut() {
        return this.adjustSumAmtOut;
    }

    public void setAdjustSumAmtOut(BigDecimal adjustSumAmtOut) {
        this.adjustSumAmtOut = adjustSumAmtOut;
    }

    public BigDecimal getAdjustSumAmtBal() {
        return this.adjustSumAmtBal;
    }

    public void setAdjustSumAmtBal(BigDecimal adjustSumAmtBal) {
        this.adjustSumAmtBal = adjustSumAmtBal;
    }

    public void addAdjustSumAmtIn(BigDecimal bigDecimal) {
        this.adjustSumAmtIn = this.adjustSumAmtIn.add(bigDecimal);
    }

    public void addAdjustSumAmtOut(BigDecimal bigDecimal) {
        this.adjustSumAmtOut = this.adjustSumAmtOut.add(bigDecimal);
    }

    public void addAdjustSumAmtBal(BigDecimal bigDecimal) {
        this.adjustSumAmtBal = this.adjustSumAmtBal.add(bigDecimal);
    }

    public void addAdjustAmtInfo(AdjustAmtInfo adjustAmtInfo) {
        this.addAdjustSumAmtIn(adjustAmtInfo.getAdjustSumAmtIn());
        this.addAdjustSumAmtOut(adjustAmtInfo.getAdjustSumAmtOut());
        this.addAdjustSumAmtBal(adjustAmtInfo.getAdjustSumAmtBal());
    }

    public CombinationKey getCombinationKey() {
        return this.combinationKey;
    }

    public void setCombinationKey(CombinationKey combinationKey) {
        this.combinationKey = combinationKey;
    }

    public static class CombinationKey {
        private Long currencyId;
        private Long customPageDimensionMember1;
        private Long customPageDimensionMember2;

        public CombinationKey(Long currencyId) {
            this(currencyId, 0L);
        }

        public CombinationKey(Long currencyId, Long customPageDimensionMember1) {
            this(currencyId, customPageDimensionMember1, 0L);
        }

        public CombinationKey(Long currencyId, Long customPageDimensionMember1, Long customPageDimensionMember2) {
            this.currencyId = currencyId;
            this.customPageDimensionMember1 = customPageDimensionMember1;
            this.customPageDimensionMember2 = customPageDimensionMember2;
        }

        public Long getCurrencyId() {
            return this.currencyId;
        }

        public void setCurrencyId(Long currencyId) {
            this.currencyId = currencyId;
        }

        public Long getCustomPageDimensionMember1() {
            return this.customPageDimensionMember1;
        }

        public void setCustomPageDimensionMember1(Long customPageDimensionMember1) {
            this.customPageDimensionMember1 = customPageDimensionMember1;
        }

        public Long getCustomPageDimensionMember2() {
            return this.customPageDimensionMember2;
        }

        public void setCustomPageDimensionMember2(Long customPageDimensionMember2) {
            this.customPageDimensionMember2 = customPageDimensionMember2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CombinationKey that = (CombinationKey)o;
            return Objects.equals(this.currencyId, that.currencyId) && Objects.equals(this.customPageDimensionMember1, that.customPageDimensionMember1) && Objects.equals(this.customPageDimensionMember2, that.customPageDimensionMember2);
        }

        public int hashCode() {
            return Objects.hash(this.currencyId, this.customPageDimensionMember1, this.customPageDimensionMember2);
        }
    }
}

