/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.model.report;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.PeriodDirection;
import kd.tmc.fpm.business.domain.enums.PeriodType;
import kd.tmc.fpm.business.domain.enums.ReportInputType;
import kd.tmc.fpm.business.domain.enums.ReportPlanChangeStatus;
import kd.tmc.fpm.business.domain.enums.ReportPlanType;
import kd.tmc.fpm.business.domain.enums.ReportProcessStatus;
import kd.tmc.fpm.business.domain.enums.ReportStatus;
import kd.tmc.fpm.business.domain.enums.TemplateMetricType;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.formula.ReportTreeNodeFormulaManager;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.ReportPeriodType;
import kd.tmc.fpm.business.domain.model.dimension.member.AccountMember;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.MetricMember;
import kd.tmc.fpm.business.domain.model.dimension.member.OrgMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.index.BitMap;
import kd.tmc.fpm.business.domain.model.index.DimensionIndexTree;
import kd.tmc.fpm.business.domain.model.index.generate.DimensionIndexTreeGenerator;
import kd.tmc.fpm.business.domain.model.index.generate.QueryIndexInfoMapGenerator;
import kd.tmc.fpm.business.domain.model.index.generate.bean.QueryIndexInfo;
import kd.tmc.fpm.business.domain.model.index.generate.strategy.IndexTreeGenerateStrategy;
import kd.tmc.fpm.business.domain.model.index.generate.strategy.IndexTreeGenerateStrategyFactory;
import kd.tmc.fpm.business.domain.model.index.node.TreeNode;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.report.ReportDataSource;
import kd.tmc.fpm.business.domain.model.report.SumPlanReport;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateAccountSetting;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.domain.model.template.TemplateReportType;
import kd.tmc.fpm.business.spread.formula.Formula;
import kd.tmc.fpm.business.spread.formula.FormulaOperationVal;
import kd.tmc.fpm.business.spread.formula.FormulaOperationValUp;
import kd.tmc.fpm.business.spread.formula.IFormulaOperator;
import kd.tmc.fpm.business.utils.DimensionInfoHelper;
import kd.tmc.fpm.common.bean.DimensionInfoBean;
import kd.tmc.fpm.common.trace.IFpmTraceSpan;
import kd.tmc.fpm.common.trace.IFpmTracer;
import kd.tmc.fpm.common.utils.CollectionBuildUtil;
import kd.tmc.fpm.common.utils.FpmAssertUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

public class Report
implements ReportDataSource {
    private static final long serialVersionUID = 1L;
    protected List<ReportData> reportDataList = new ArrayList<ReportData>(16);
    private Long id;
    private Long systemId;
    private String name;
    private String number;
    private Date startDate;
    private Date closeDate;
    private Long exchangeRateTableId;
    private Date exchangeRateDate;
    private Map<Object, BigDecimal> exchangeRateMap = new HashMap<Object, BigDecimal>(16);
    private Boolean initFlag;
    private ReportProcessStatus processStatus;
    private ReportStatus reportStatus;
    private Long attachId;
    private ReportPlanType reportPlanType;
    private Long sumParamConfigSnapshotId;
    private Long parentTemplateId;
    private List<OrgMember> companyMemberList;
    private List<PeriodMember> periodMemberList;
    protected ReportTemplate template;
    protected ReportPeriodType reportPeriodType;
    protected ReportPeriodType referencePeriodType;
    private PeriodMember referencePeriodMember;
    private ReportPlanChangeStatus changeStatus;
    private Long auditErId;
    private Long informantErId;
    private String informanStr;
    protected transient DimensionIndexTree indexTree;
    private boolean zeroReport;
    protected transient QueryIndexInfo<Object, ReportData> queryIndexInfo;
    private ReportTreeNodeFormulaManager reportTreeNodeFormulaManager;

    public DimensionIndexTree getIndexTree() {
        return this.indexTree;
    }

    public void buildIndexTree(FundPlanSystem system) {
        this.getIndexTree(system);
    }

    @Override
    public DimensionIndexTree getIndexTree(FundPlanSystem system) {
        return this.getIndexTree(system, null);
    }

    @Override
    public DimensionIndexTree getIndexTree(FundPlanSystem system, Long summaryDimId) {
        if (this.indexTree == null) {
            IndexTreeGenerateStrategy strategy = IndexTreeGenerateStrategyFactory.createReportDataStrategy(this, system);
            DimensionIndexTreeGenerator generator = new DimensionIndexTreeGenerator(strategy);
            this.indexTree = generator.build();
            List<ReportData> mountReportDataList = this.getReportDataList().stream().filter(o -> !o.isAuxiliaryInfo()).collect(Collectors.toList());
            this.mountReportData(mountReportDataList);
        }
        return this.indexTree;
    }

    public void clearIndexTree() {
        this.indexTree = null;
    }

    public void clearTreeNodeData(ReportData reportData) {
        this.clearTreeNodeData(Collections.singletonList(reportData));
    }

    public void clearTreeNodeData(List<ReportData> reportDataList) {
        FpmAssertUtil.isNotNull((Object)this.indexTree, (String)"indexTree is not initialized");
        this.indexTree.clearTreeNodeData(reportDataList.stream().map(rd -> DimensionInfoHelper.getDimensionInfoBean(rd, this.getTemplate())).collect(Collectors.toSet()));
    }

    public DimensionIndexTree rebuildTree(FundPlanSystem system) {
        this.clearIndexTree();
        return this.getIndexTree(system);
    }

    public void mountReportData(List<ReportData> mountReportDataList) {
        for (ReportData reportData : mountReportDataList) {
            ArrayList<Long> dimIdList = new ArrayList<Long>(reportData.getDimList().size());
            ArrayList<Object> dimMemIdList = new ArrayList<Object>(reportData.getDimList().size());
            List<Object> prepareDatas = reportData.getDimValList();
            for (int inx = 0; inx < reportData.getDimList().size(); ++inx) {
                TemplateDim templateDim = reportData.getDimList().get(inx);
                if (templateDim.getDimType() == DimensionType.DETAILDIM) continue;
                dimIdList.add(templateDim.getDimensionId());
                dimMemIdList.add(prepareDatas.get(inx));
            }
            DimensionInfoBean dimensionInfoBean = new DimensionInfoBean();
            dimensionInfoBean.setDimensionIdList(dimIdList);
            dimensionInfoBean.setMemberIdList(dimMemIdList);
            TreeNode node = this.indexTree.find(dimensionInfoBean);
            if (node == null) continue;
            node.addData(reportData);
        }
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public Long getSystemId() {
        return this.systemId;
    }

    public void setSystemId(Long systemId) {
        this.systemId = systemId;
    }

    @Override
    public ReportTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(ReportTemplate template) {
        this.template = template;
    }

    public Date getCloseDate() {
        return this.closeDate;
    }

    public void setCloseDate(Date closeDate) {
        this.closeDate = closeDate;
    }

    public Long getExchangeRateTableId() {
        return this.exchangeRateTableId;
    }

    public void setExchangeRateTableId(Long exchangeRateTableId) {
        this.exchangeRateTableId = exchangeRateTableId;
    }

    public Date getExchangeRateDate() {
        return this.exchangeRateDate;
    }

    public void setExchangeRateDate(Date exchangeRateDate) {
        this.exchangeRateDate = exchangeRateDate;
    }

    public Map<Object, BigDecimal> getExchangeRateMap() {
        return this.exchangeRateMap;
    }

    public void setExchangeRateMap(Map<Object, BigDecimal> exchangeRateMap) {
        this.exchangeRateMap = exchangeRateMap;
    }

    @Override
    public List<ReportData> getReportDataList() {
        return this.reportDataList;
    }

    public void setReportDataList(List<ReportData> reportDataList) {
        this.reportDataList = reportDataList;
    }

    @Override
    public ReportPeriodType getReportPeriodType() {
        return this.reportPeriodType;
    }

    public void setReportPeriodType(ReportPeriodType reportPeriodType) {
        this.reportPeriodType = reportPeriodType;
    }

    public List<OrgMember> getCompanyMemberList() {
        return this.companyMemberList;
    }

    public void setCompanyMemberList(List<OrgMember> companyMemberList) {
        this.companyMemberList = companyMemberList;
    }

    @Override
    public List<PeriodMember> getPeriodMemberList() {
        return this.periodMemberList;
    }

    public void setPeriodMemberList(List<PeriodMember> periodMemberList) {
        this.periodMemberList = periodMemberList;
    }

    public Boolean getInitFlag() {
        return this.initFlag;
    }

    public void setInitFlag(Boolean initFlag) {
        this.initFlag = initFlag;
    }

    public Long getParentTemplateId() {
        return this.parentTemplateId;
    }

    public void setParentTemplateId(Long parentTemplateId) {
        this.parentTemplateId = parentTemplateId;
    }

    public ReportProcessStatus getProcessStatus() {
        return this.processStatus;
    }

    public void setProcessStatus(ReportProcessStatus processStatus) {
        this.processStatus = processStatus;
    }

    public ReportStatus getReportStatus() {
        return this.reportStatus;
    }

    public void setReportStatus(ReportStatus reportStatus) {
        this.reportStatus = reportStatus;
    }

    public Long getAttachId() {
        return this.attachId;
    }

    public void setAttachId(Long attachId) {
        this.attachId = attachId;
    }

    public Long getAuditErId() {
        return this.auditErId;
    }

    public void setAuditErId(Long auditErId) {
        this.auditErId = auditErId;
    }

    public Long getInformantErId() {
        return this.informantErId;
    }

    public void setInformantErId(Long informantErId) {
        this.informantErId = informantErId;
    }

    public ReportPlanChangeStatus getChangeStatus() {
        return this.changeStatus;
    }

    public void setChangeStatus(ReportPlanChangeStatus changeStatus) {
        this.changeStatus = changeStatus;
    }

    public String getInformanStr() {
        return this.informanStr;
    }

    public void setInformanStr(String informanStr) {
        this.informanStr = informanStr;
    }

    public ReportPeriodType getReferencePeriodType() {
        return this.referencePeriodType;
    }

    public void setReferencePeriodType(ReportPeriodType referencePeriodType) {
        this.referencePeriodType = referencePeriodType;
    }

    public PeriodMember getReferencePeriodMember() {
        return this.referencePeriodMember;
    }

    public void setReferencePeriodMember(PeriodMember referencePeriodMember) {
        this.referencePeriodMember = referencePeriodMember;
    }

    public ReportPlanType getReportPlanType() {
        return this.reportPlanType;
    }

    public void setReportPlanType(ReportPlanType reportPlanType) {
        this.reportPlanType = reportPlanType;
    }

    public Long getSumParamConfigSnapshotId() {
        return this.sumParamConfigSnapshotId;
    }

    public void setSumParamConfigSnapshotId(Long sumParamConfigSnapshotId) {
        this.sumParamConfigSnapshotId = sumParamConfigSnapshotId;
    }

    public Report copySimpleReport() {
        Report report = new Report();
        report.setId(this.id);
        report.setName(this.name);
        report.setInitFlag(this.initFlag);
        report.setProcessStatus(this.processStatus);
        report.setReportStatus(this.reportStatus);
        report.setAttachId(this.attachId);
        return report;
    }

    public Report copyReportData() {
        boolean isSumPlanReport = this instanceof SumPlanReport;
        Report report = isSumPlanReport ? new SumPlanReport() : new Report();
        report.setId(this.id);
        report.setName(this.name);
        report.setNumber(this.number);
        report.setSystemId(this.systemId);
        report.setTemplate(this.template);
        report.setExchangeRateTableId(this.exchangeRateTableId);
        report.setExchangeRateDate(this.exchangeRateDate);
        report.setAttachId(this.attachId);
        report.setInformantErId(this.informantErId);
        report.setInformanStr(this.informanStr);
        report.setReportPlanType(this.reportPlanType);
        report.setZeroReport(this.zeroReport);
        if (isSumPlanReport) {
            ((SumPlanReport)report).setSunReportSumRecordList(((SumPlanReport)this).getSunReportSumRecordList());
        }
        report.setReportPeriodType(this.reportPeriodType);
        report.setStartDate(this.startDate);
        report.setCloseDate(this.closeDate);
        report.setInitFlag(this.initFlag);
        report.setReportStatus(this.reportStatus);
        report.setProcessStatus(this.processStatus);
        report.setSumParamConfigSnapshotId(this.sumParamConfigSnapshotId);
        report.setCompanyMemberList(this.companyMemberList);
        report.setPeriodMemberList(this.periodMemberList);
        report.setReferencePeriodMember(this.referencePeriodMember);
        report.setReferencePeriodType(this.referencePeriodType);
        report.setExchangeRateMap(this.exchangeRateMap);
        if (EmptyUtil.isNoEmpty(this.reportDataList)) {
            ArrayList<ReportData> reportDataCopyList = new ArrayList<ReportData>(this.reportDataList.size());
            this.reportDataList.forEach(item -> {
                ReportData copy = new ReportData((ReportData)item);
                copy.setId(item.getId());
                reportDataCopyList.add(copy);
            });
            report.setReportDataList(reportDataCopyList);
        }
        return report;
    }

    public ReportTreeNodeFormulaManager getFormulaManager(FundPlanSystem system) {
        return this.getFormulaManager(system, false);
    }

    public ReportTreeNodeFormulaManager getFormulaManager(FundPlanSystem system, boolean rebuild) {
        if (!rebuild && Objects.nonNull(this.reportTreeNodeFormulaManager)) {
            return this.reportTreeNodeFormulaManager;
        }
        DimensionIndexTree indexTree = this.getIndexTree(system);
        this.reportTreeNodeFormulaManager = this.getFormulaManager(system, indexTree);
        return this.reportTreeNodeFormulaManager;
    }

    public ReportTreeNodeFormulaManager getFormulaManager(FundPlanSystem system, DimensionIndexTree indexTree) {
        if (this.template.getTemplateType() == TemplateType.DETAIL) {
            return null;
        }
        Dimension periodDim = system.getMainDimensionByDimType(DimensionType.PERIOD);
        List<DimMember> periodMemberList = periodDim.getAllDimMemberList();
        List<TemplateDim> allTemplateDimOutSubject = this.template.getAllTemplateDim().stream().filter(item -> item.getDimType() != DimensionType.SUBJECTS).collect(Collectors.toList());
        Optional<TemplateDim> subjectOptional = this.template.getAllTemplateDim().stream().filter(item -> item.getDimType() == DimensionType.SUBJECTS).findFirst();
        if (!subjectOptional.isPresent()) {
            return null;
        }
        TemplateDim subjectTplDim = subjectOptional.get();
        List tplDimScopeListS = allTemplateDimOutSubject.stream().map(item -> {
            if (item.getDimType() == DimensionType.PERIOD) {
                return this.getDetailPeriodMemberScope();
            }
            return item.getMemberScope();
        }).collect(Collectors.toList());
        List descartes = Lists.cartesianProduct(tplDimScopeListS);
        List dimIdList = allTemplateDimOutSubject.stream().map(TemplateDim::getDimensionId).collect(Collectors.toList());
        dimIdList.add(subjectTplDim.getDimensionId());
        List<TemplateAccountSetting> accountSettings = this.template.getAccountSettings();
        List targetAcctSettings = accountSettings.stream().filter(Objects::nonNull).filter(item -> ReportInputType.SUMMARY == item.getInputType() || ReportInputType.FORMULA == item.getInputType()).collect(Collectors.toList());
        ArrayList<Formula> formulaList = new ArrayList<Formula>(16);
        for (TemplateAccountSetting targetAcctSetting : targetAcctSettings) {
            Formula formulaInfo = targetAcctSetting.buildFormulaInfo();
            if (formulaInfo == null) continue;
            Deque<IFormulaOperator> operator = formulaInfo.getOperator();
            for (List dimMemberS : descartes) {
                ArrayList<Long> targetMemberS = new ArrayList<Long>(dimMemberS);
                targetMemberS.add(targetAcctSetting.getAccountMemId());
                LinkedList<IFormulaOperator> finalOperator = new LinkedList<IFormulaOperator>();
                TreeNode leftTreeNode = indexTree.find(new DimensionInfoBean(dimIdList, targetMemberS));
                if (Objects.isNull(leftTreeNode)) continue;
                Formula finalFormula = new Formula();
                formulaList.add(finalFormula);
                FormulaOperationValUp<TreeNode> leftVal = new FormulaOperationValUp<TreeNode>();
                leftVal.setName(leftTreeNode);
                finalFormula.setLeftValUp(leftVal);
                for (IFormulaOperator currOperator : operator) {
                    if (currOperator instanceof FormulaOperationVal) {
                        FormulaOperationVal operationVal = (FormulaOperationVal)currOperator;
                        Long childAcctMemId = Long.valueOf(operationVal.getName());
                        targetMemberS.remove(targetMemberS.size() - 1);
                        targetMemberS.add(childAcctMemId);
                        TreeNode childrenTreeNode = indexTree.find(new DimensionInfoBean(dimIdList, targetMemberS));
                        if (Objects.isNull(childrenTreeNode)) continue;
                        FormulaOperationValUp<TreeNode> val = new FormulaOperationValUp<TreeNode>();
                        val.setName(childrenTreeNode);
                        finalOperator.add(val);
                    } else {
                        finalOperator.add(currOperator);
                    }
                    finalFormula.setOperator(finalOperator);
                }
            }
        }
        allTemplateDimOutSubject.add(subjectTplDim);
        this.findBeginOfTermFormula(allTemplateDimOutSubject, formulaList, descartes, accountSettings, system, indexTree);
        return new ReportTreeNodeFormulaManager(formulaList);
    }

    private void findBeginOfTermFormula(List<TemplateDim> dimList, List<Formula> formulaList, List<List<Long>> descartes, List<TemplateAccountSetting> accountSettings, FundPlanSystem system, DimensionIndexTree indexTree) {
        Dimension subjectDim = system.getMainDimensionByDimType(DimensionType.SUBJECTS);
        List<DimMember> memberList = subjectDim.getAllDimMemberList();
        Map<Long, Long> beginEndPeriodMap = memberList.stream().map(AccountMember.class::cast).filter(accountMember -> Objects.nonNull(accountMember.getPeriodDirection()) && Objects.nonNull(accountMember.getAssociateAccount())).collect(Collectors.toMap(accountMember -> accountMember.getAssociateAccount().getId(), DimMember::getId, (k1, k2) -> k1));
        if (beginEndPeriodMap.isEmpty()) {
            return;
        }
        List sortedPeriodList = this.getCurrentAllPeriodMembers().stream().sorted(Comparator.comparing(PeriodMember::getStartDate)).collect(Collectors.toList());
        Map<Long, Long> previousPeriodMap = IntStream.range(0, sortedPeriodList.size()).boxed().collect(Collectors.toMap(i -> ((PeriodMember)sortedPeriodList.get((int)i)).getId(), i -> i > 0 ? ((PeriodMember)sortedPeriodList.get(i - 1)).getId() : 0L));
        List beginTermSettings = accountSettings.stream().filter(Objects::nonNull).filter(item -> beginEndPeriodMap.containsKey(item.getAccountMemId())).collect(Collectors.toList());
        List dimIdList = dimList.stream().map(TemplateDim::getDimensionId).collect(Collectors.toList());
        for (TemplateAccountSetting accountSetting : beginTermSettings) {
            if (accountSetting.getInputType() != ReportInputType.MANUAL_INPUT) continue;
            for (List<Long> dimMemberS : descartes) {
                ArrayList<Long> beginMemberIds = new ArrayList<Long>(dimMemberS);
                beginMemberIds.add(accountSetting.getAccountMemId());
                TreeNode leftTreeNode = indexTree.find(new DimensionInfoBean(dimIdList, beginMemberIds));
                if (Objects.isNull(leftTreeNode)) continue;
                ArrayList<Long> endMemberIds = new ArrayList<Long>(dimMemberS);
                endMemberIds.add(beginEndPeriodMap.get(accountSetting.getAccountMemId()));
                int periodIndex = dimList.indexOf(dimList.stream().filter(item -> item.getDimType() == DimensionType.PERIOD).findFirst().get());
                Long removePeriodId = (Long)endMemberIds.remove(periodIndex);
                if (!previousPeriodMap.containsKey(removePeriodId) || !EmptyUtil.isNoEmpty((Long)previousPeriodMap.get(removePeriodId))) continue;
                endMemberIds.add(periodIndex, previousPeriodMap.get(removePeriodId));
                TreeNode rightTreeNode = indexTree.find(new DimensionInfoBean(dimIdList, endMemberIds));
                if (Objects.isNull(rightTreeNode)) continue;
                Formula finalFormula = new Formula();
                formulaList.add(finalFormula);
                FormulaOperationValUp<TreeNode> leftVal = new FormulaOperationValUp<TreeNode>();
                leftVal.setName(leftTreeNode);
                finalFormula.setLeftValUp(leftVal);
                LinkedList<IFormulaOperator> finalOperator = new LinkedList<IFormulaOperator>();
                FormulaOperationValUp<TreeNode> rightVal = new FormulaOperationValUp<TreeNode>();
                rightVal.setName(rightTreeNode);
                finalOperator.add(rightVal);
                finalFormula.setOperator(finalOperator);
            }
        }
    }

    public List<Long> getDetailPeriodMemberScope() {
        return this.getDetailPeriodMemberScope(true);
    }

    private List<Long> getDetailPeriodMemberScope(boolean needCurrentReportPeriod) {
        List<PeriodMember> periodMemberList = this.getPeriodMemberList();
        List<PeriodMember> needAllChildPeriod = this.isRollContainsDetail() ? periodMemberList : Collections.singletonList(periodMemberList.get(0));
        List<Long> allChildMemberIds = needAllChildPeriod.stream().map(DimMember::getAllChildMember).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(DimMember::getId).collect(Collectors.toList());
        if (needCurrentReportPeriod) {
            allChildMemberIds.addAll(periodMemberList.stream().map(DimMember::getId).collect(Collectors.toList()));
        }
        return allChildMemberIds;
    }

    public void sumToParentPeriod(FundPlanSystem system, boolean finalState) {
        this.periodAgg(this.periodMemberList, system, finalState);
    }

    public void sumToParentPeriodByScope(List<PeriodMember> periodMemberList, FundPlanSystem system, boolean finalState) {
        this.periodAgg(periodMemberList, system, finalState);
    }

    private void periodAgg(List<PeriodMember> periodMemberList, FundPlanSystem system, boolean finalState) {
        try (IFpmTraceSpan span = IFpmTracer.getInstance().createSpan(String.format("%s-%s", Report.class.getSimpleName(), "sumToParentPeriod"));){
            span.addTag("Time consuming to build dimension tree");
            Dimension periodDim = system.getMainDimensionByDimType(DimensionType.PERIOD);
            Map<Long, DimMember> periodMemberMap = periodDim.getAllDimMemberList().stream().collect(Collectors.toMap(DimMember::getId, Function.identity()));
            DimensionIndexTree indexTree = this.getIndexTree(system, periodDim.getId());
            BitMap<Long, Long> subReportIndex = new BitMap<Long, Long>();
            PeriodType detailPeriodType = this.getReportPeriodType().getDetailPeriodType();
            boolean hasDetailPeriod = detailPeriodType != null;
            Dimension subjectDim = system.getMainDimensionByDimType(DimensionType.SUBJECTS);
            List<DimMember> memberList = subjectDim.getAllDimMemberList();
            Dimension metricDim = system.getMainDimensionByDimType(DimensionType.METRIC);
            MetricMember metricMember = metricDim.getAllDimMemberList().stream().map(item -> (MetricMember)item).filter(item -> TemplateMetricType.PLANAMT == item.getTemplateMetricType()).findFirst().get();
            Set<Long> periodBeginningSet = memberList.stream().map(AccountMember.class::cast).filter(accountMember -> Objects.nonNull(accountMember.getPeriodDirection()) && accountMember.getPeriodDirection() == PeriodDirection.BEGINNING).map(DimMember::getId).collect(Collectors.toSet());
            Set<Long> periodEndingSet = memberList.stream().map(AccountMember.class::cast).filter(accountMember -> Objects.nonNull(accountMember.getPeriodDirection()) && accountMember.getPeriodDirection() == PeriodDirection.ENDING).map(DimMember::getId).collect(Collectors.toSet());
            if (hasDetailPeriod) {
                List<PeriodMember> detailPeriodMemberScope;
                ArrayList<ReportData> newRDList = new ArrayList<ReportData>();
                List<PeriodMember> list = detailPeriodMemberScope = this.isRollContainsDetail() ? periodMemberList : Collections.singletonList(periodMemberList.get(0));
                if (this.template.getTemplateType() == TemplateType.FIXED) {
                    List<TemplateDim> templateDimLst = this.getTemplate().getAllTemplateDim().stream().filter(o -> !o.isDetailDim()).collect(Collectors.toList());
                    ArrayList<Long> dimIds = new ArrayList<Long>(templateDimLst.size());
                    ArrayList<List<Long>> dimMemberIds = new ArrayList<List<Long>>(templateDimLst.size());
                    this.fillIntoDimensionId(metricMember, detailPeriodMemberScope, templateDimLst, dimIds, dimMemberIds);
                    List descartesMemberIdGroups = CollectionBuildUtil.descartes(dimMemberIds);
                    span.addTag("Period data aggregation time");
                    for (List descartesMemberIdGroup : descartesMemberIdGroups) {
                        ReportData summaryReportData;
                        ArrayList<Object> members = new ArrayList<Object>(descartesMemberIdGroup);
                        DimensionInfoBean findBean = new DimensionInfoBean();
                        findBean.setDimensionIdList(dimIds);
                        findBean.setMemberIdList(members);
                        TreeNode treeNode = indexTree.find(findBean);
                        List<Object> dataList = treeNode.getDataList();
                        if (this.isMoreThanOne(dataList)) {
                            List reportDataList = treeNode.getDataList().stream().filter(Objects::nonNull).filter(o -> o instanceof ReportData).map(o -> {
                                ReportData o1 = (ReportData)o;
                                Set memberIdSet = o1.getDimValList().stream().filter(Objects::nonNull).filter(i -> i instanceof Long).map(i -> (Long)i).collect(Collectors.toSet());
                                Object periodMemberId = o1.getDimValByDimType(DimensionType.PERIOD);
                                memberIdSet.remove((Long)periodMemberId);
                                subReportIndex.addValue(memberIdSet, o1.getId());
                                return o1;
                            }).collect(Collectors.toList());
                            for (ReportData reportData : reportDataList) {
                                this.listRefNodeAndSum(subReportIndex, periodMemberMap, periodBeginningSet, periodEndingSet, treeNode, reportData);
                            }
                            subReportIndex.clear();
                            continue;
                        }
                        if (!CollectionUtils.isEmpty(dataList)) {
                            Optional<ReportData> summaryOp = treeNode.getDataList().stream().filter(Objects::nonNull).filter(o -> o instanceof ReportData).map(o -> (ReportData)o).findFirst();
                            summaryReportData = summaryOp.get();
                        } else {
                            summaryReportData = this.buildSumPeriodRD(templateDimLst, members);
                            this.initReportDataAmt(summaryReportData);
                            treeNode.addData(summaryReportData);
                            this.reportDataList.add(summaryReportData);
                            newRDList.add(summaryReportData);
                        }
                        this.listRefNodeAndSum(subReportIndex, periodMemberMap, periodBeginningSet, periodEndingSet, treeNode, summaryReportData);
                    }
                } else {
                    HashSet<ReportData> handledRDSet = new HashSet<ReportData>();
                    List<Long> parentPeriodIdList = this.isRollContainsDetail() ? periodMemberList.stream().map(DimMember::getId).collect(Collectors.toList()) : Collections.singletonList(periodMemberList.get(0).getId());
                    Map<Long, List> beginToEndPeriodMap = periodMemberList.stream().collect(Collectors.toMap(DimMember::getId, obj -> obj.getChildren().stream().map(PeriodMember.class::cast).sorted(Comparator.comparing(PeriodMember::getStartDate)).collect(Collectors.toList()), (k1, k2) -> k1));
                    List<ReportData> reportDataList = this.getReportDataList();
                    if (!finalState) {
                        reportDataList.removeIf(rd -> parentPeriodIdList.contains(rd.getDimValByDimType(DimensionType.PERIOD, null)));
                    } else {
                        reportDataList.stream().filter(rd -> parentPeriodIdList.contains(rd.getDimValByDimType(DimensionType.PERIOD, null))).forEach(rd -> {
                            rd.setPlanAmt(BigDecimal.ZERO);
                            rd.setReportPlanAmt(BigDecimal.ZERO);
                            rd.setOriginalPlanAmt(BigDecimal.ZERO);
                            rd.setPlanReferenceAmt(BigDecimal.ZERO);
                            rd.setActAmt(BigDecimal.ZERO);
                            rd.setLockAmt(BigDecimal.ZERO);
                            rd.setValue(BigDecimal.ZERO);
                            rd.setOffsetAmt(BigDecimal.ZERO);
                        });
                    }
                    Set parentPeriodIdSet = periodMemberList.stream().map(DimMember::getId).collect(Collectors.toSet());
                    this.clearIndexTree();
                    indexTree = this.getIndexTree(system);
                    block11: for (ReportData reportData : reportDataList) {
                        Object parent;
                        DimensionInfoBean infoBean = new DimensionInfoBean();
                        ArrayList<Long> mainDimIdList = new ArrayList<Long>(6);
                        ArrayList<Object> mainDimMemberIdList = new ArrayList<Object>(6);
                        infoBean.setDimensionIdList(mainDimIdList);
                        infoBean.setMemberIdList(mainDimMemberIdList);
                        List<TemplateDim> dimList = reportData.getDimList();
                        Map tplDimMap = dimList.stream().collect(Collectors.toMap(TemplateDim::getDimensionId, Function.identity()));
                        List<Object> dimValList = reportData.getDimValList();
                        for (int i = 0; i < dimList.size(); ++i) {
                            TemplateDim templateDim = dimList.get(i);
                            if (templateDim.getDimType() == DimensionType.DETAILDIM || templateDim.getDimType() == DimensionType.METRIC) continue;
                            mainDimIdList.add(templateDim.getDimensionId());
                            if (templateDim.getDimType() == DimensionType.PERIOD) {
                                DimMember dimMember;
                                Long periodMemIdLong;
                                Object periodMemId = dimValList.get(i);
                                if (EmptyUtil.isEmpty((Object)periodMemId) || parentPeriodIdSet.contains(periodMemIdLong = (Long)periodMemId) || Objects.isNull(dimMember = periodMemberMap.get(periodMemIdLong)) || Objects.isNull(parent = dimMember.getParent())) continue block11;
                                mainDimMemberIdList.add(((DimMember)parent).getId());
                                continue;
                            }
                            mainDimMemberIdList.add(dimValList.get(i));
                        }
                        TreeNode treeNode = indexTree.find(infoBean);
                        if (treeNode == null) continue;
                        List<ReportData> dataList = CollectionUtils.isEmpty(treeNode.getDataList()) ? Collections.emptyList() : treeNode.getDataList().stream().map(o -> (ReportData)o).collect(Collectors.toList());
                        List<ReportData> targetRDList = this.getReportDataByDimInfo(mainDimIdList, mainDimMemberIdList, dataList);
                        ReportData targetRD = null;
                        if (CollectionUtils.isEmpty(targetRDList)) {
                            ArrayList<TemplateDim> currDimList = new ArrayList<TemplateDim>(dimList.size());
                            parent = mainDimIdList.iterator();
                            while (parent.hasNext()) {
                                Long mainDimId = (Long)parent.next();
                                currDimList.add((TemplateDim)tplDimMap.get(mainDimId));
                            }
                            targetRD = this.buildSumPeriodRD(currDimList, mainDimMemberIdList);
                            newRDList.add(targetRD);
                            treeNode.addData(targetRD);
                        } else {
                            targetRD = targetRDList.get(0);
                            targetRD.setDirty(Boolean.TRUE);
                        }
                        if (handledRDSet.add(targetRD)) {
                            this.initReportDataAmt(targetRD);
                        }
                        Long dimVal = (Long)targetRD.getDimValByDimType(DimensionType.SUBJECTS, null);
                        Long parentPeriod = (Long)targetRD.getDimValByDimType(DimensionType.PERIOD, null);
                        Long detailPeriod = (Long)reportData.getDimValByDimType(DimensionType.PERIOD, null);
                        List periodMembers = beginToEndPeriodMap.get(parentPeriod);
                        if (periodBeginningSet.contains(dimVal)) {
                            if (!CollectionUtils.isNotEmpty((Collection)periodMembers) || !Objects.equals(((PeriodMember)periodMembers.get(0)).getId(), detailPeriod)) continue;
                            this.calcAmt(targetRD, reportData);
                            continue;
                        }
                        if (periodEndingSet.contains(dimVal)) {
                            if (!CollectionUtils.isNotEmpty((Collection)periodMembers) || !Objects.equals(((PeriodMember)periodMembers.get(periodMembers.size() - 1)).getId(), detailPeriod)) continue;
                            this.calcAmt(targetRD, reportData);
                            continue;
                        }
                        this.calcAmt(targetRD, reportData);
                    }
                    reportDataList.addAll(newRDList);
                }
                this.mountReportData(newRDList);
            }
        }
    }

    private void listRefNodeAndSum(BitMap<Long, Long> subReportIndex, Map<Long, DimMember> periodMemberMap, Set<Long> periodBeginningSet, Set<Long> periodEndingSet, TreeNode treeNode, ReportData summaryReportData) {
        Long dimVal = (Long)summaryReportData.getDimValByDimType(DimensionType.SUBJECTS, null);
        if (periodBeginningSet.contains(dimVal)) {
            this.balanceSubjectHandle(subReportIndex, treeNode, summaryReportData, periodMemberMap, PeriodDirection.BEGINNING);
        } else if (periodEndingSet.contains(dimVal)) {
            this.balanceSubjectHandle(subReportIndex, treeNode, summaryReportData, periodMemberMap, PeriodDirection.ENDING);
        } else {
            this.detailAggregation(subReportIndex, treeNode, summaryReportData);
        }
        summaryReportData.setDirty(Boolean.TRUE);
    }

    private boolean isMoreThanOne(List<Object> dataList) {
        return !CollectionUtils.isEmpty(dataList) && dataList.size() > 1;
    }

    private void fillIntoDimensionId(MetricMember metricMember, List<PeriodMember> periodMemberList, List<TemplateDim> templateDimLst, List<Long> dimIds, List<List<Long>> dimMemberIds) {
        templateDimLst.stream().filter(Objects::nonNull).forEach(o -> {
            dimIds.add(o.getDimensionId());
            if (o.getDimType() == DimensionType.PERIOD) {
                List periodMemberIds = periodMemberList.stream().filter(Objects::nonNull).map(DimMember::getId).collect(Collectors.toList());
                dimMemberIds.add(periodMemberIds);
            } else if (o.getDimType() == DimensionType.METRIC) {
                dimMemberIds.add(Lists.newArrayList((Object[])new Long[]{metricMember.getId()}));
            } else {
                dimMemberIds.add(o.getMemberScope());
            }
        });
    }

    private void initReportDataAmt(ReportData reportData) {
        if (reportData.getPlanAmt() == null) {
            reportData.setPlanAmt(BigDecimal.ZERO);
        }
        if (reportData.getReportPlanAmt() == null) {
            reportData.setReportPlanAmt(BigDecimal.ZERO);
        }
        if (reportData.getOriginalPlanAmt() == null) {
            reportData.setOriginalPlanAmt(BigDecimal.ZERO);
        }
        if (reportData.getPlanReferenceAmt() == null) {
            reportData.setPlanReferenceAmt(BigDecimal.ZERO);
        }
        if (reportData.getActAmt() == null) {
            reportData.setActAmt(BigDecimal.ZERO);
        }
        if (reportData.getLockAmt() == null) {
            reportData.setLockAmt(BigDecimal.ZERO);
        }
        if (reportData.getValue() == null) {
            reportData.setValue(BigDecimal.ZERO);
        }
        if (reportData.getOffsetAmt() == null) {
            reportData.setOffsetAmt(BigDecimal.ZERO);
        }
    }

    private void calcAmt(ReportData targetRD, ReportData reportData) {
        targetRD.setPlanAmt(targetRD.getPlanAmt().add(this.dealAmtData(reportData.getPlanAmt())));
        targetRD.setReportPlanAmt(targetRD.getReportPlanAmt().add(this.dealAmtData(reportData.getReportPlanAmt())));
        targetRD.setOriginalPlanAmt(targetRD.getOriginalPlanAmt().add(this.dealAmtData(reportData.getOriginalPlanAmt())));
        targetRD.setPlanReferenceAmt(targetRD.getPlanReferenceAmt().add(this.dealAmtData(reportData.getPlanReferenceAmt())));
        targetRD.setActAmt(targetRD.getActAmt().add(this.dealAmtData(reportData.getActAmt())));
        targetRD.setLockAmt(targetRD.getLockAmt().add(this.dealAmtData(reportData.getLockAmt())));
        targetRD.setBigDecimalValueOrDefault(targetRD.getBigDecimalValue().add(reportData.getBigDecimalValue()));
    }

    private void balanceSubjectHandle(BitMap<Long, Long> subReportIndex, TreeNode treeNode, ReportData summaryReportData, Map<Long, DimMember> periodMemberMap, PeriodDirection periodDirection) {
        Set<TreeNode> refNodes = treeNode.getRefNodes();
        if (CollectionUtils.isEmpty(refNodes)) {
            return;
        }
        PeriodMember currPeriodMember = null;
        for (TreeNode node : refNodes) {
            ReportData refNodeReportData;
            Optional<List<Object>> dataList;
            if (node.isVirtual() || !(dataList = Optional.ofNullable(node.getDataList())).isPresent() || Objects.isNull(refNodeReportData = this.getReportDataByBitMap(summaryReportData, subReportIndex, dataList.get()))) continue;
            Long dimVal = (Long)refNodeReportData.getDimValByDimType(DimensionType.PERIOD, null);
            PeriodMember dimMember = (PeriodMember)periodMemberMap.get(dimVal);
            if (currPeriodMember != null && !this.balanceDateCompare(dimMember, currPeriodMember, periodDirection)) continue;
            summaryReportData.setPlanAmt(refNodeReportData.getPlanAmt());
            summaryReportData.setActAmt(refNodeReportData.getActAmt());
            summaryReportData.setReportPlanAmt(refNodeReportData.getReportPlanAmt());
            summaryReportData.setOriginalPlanAmt(refNodeReportData.getOriginalPlanAmt());
            summaryReportData.setPlanReferenceAmt(refNodeReportData.getPlanReferenceAmt());
            summaryReportData.setBigDecimalValueOrDefault(refNodeReportData.getBigDecimalValue());
            currPeriodMember = dimMember;
        }
    }

    private ReportData getReportDataByBitMap(ReportData summaryReportData, BitMap<Long, Long> subReportIndex, List<Object> dataList) {
        ReportData refNodeReportData = null;
        List refList = dataList.stream().filter(Objects::nonNull).filter(o -> o instanceof ReportData).map(o -> (ReportData)o).collect(Collectors.toList());
        for (ReportData reportData : refList) {
            if (subReportIndex.isEmpty()) {
                refNodeReportData = reportData;
                break;
            }
            DimensionInfoBean mainDimensionInfoBean = DimensionInfoHelper.getMainDimensionInfoBean(reportData);
            List memberIdList = mainDimensionInfoBean.getMemberIdList();
            Object periodMemberId = reportData.getDimValByDimType(DimensionType.PERIOD);
            memberIdList.remove(periodMemberId);
            Set memberSets = memberIdList.stream().map(i -> Long.parseLong(i.toString())).collect(Collectors.toSet());
            Long reportDataId = subReportIndex.findOne(memberSets);
            if (!Objects.nonNull(reportDataId) || !Objects.equals(summaryReportData.getId(), reportDataId)) continue;
            refNodeReportData = reportData;
            break;
        }
        return refNodeReportData;
    }

    private boolean balanceDateCompare(PeriodMember dimMember, PeriodMember currPeriodMember, PeriodDirection periodDirection) {
        if (periodDirection == PeriodDirection.BEGINNING) {
            return dimMember.getStartDate().compareTo(currPeriodMember.getStartDate()) < 0;
        }
        return dimMember.getStartDate().compareTo(currPeriodMember.getStartDate()) > 0;
    }

    private void detailAggregation(BitMap<Long, Long> subReportIndex, TreeNode treeNode, ReportData summaryReportData) {
        Set<TreeNode> refNodes = treeNode.getRefNodes();
        if (CollectionUtils.isEmpty(refNodes)) {
            return;
        }
        ReportData calcData = null;
        for (TreeNode node : refNodes) {
            ReportData refData;
            Optional<List<Object>> dataList;
            if (node.isVirtual() || !(dataList = Optional.ofNullable(node.getDataList())).isPresent() || !Objects.nonNull(refData = this.getReportDataByBitMap(summaryReportData, subReportIndex, dataList.get()))) continue;
            if (Objects.isNull(calcData)) {
                calcData = new ReportData();
                this.initReportDataAmt(calcData);
            }
            this.calcAmt(calcData, refData);
        }
        if (calcData != null) {
            this.updateAmt(summaryReportData, calcData);
        }
    }

    private void updateAmt(ReportData summaryReportData, ReportData calcData) {
        summaryReportData.setPlanAmt(calcData.getPlanAmt());
        summaryReportData.setReportPlanAmt(calcData.getReportPlanAmt());
        summaryReportData.setOriginalPlanAmt(calcData.getOriginalPlanAmt());
        summaryReportData.setLockAmt(calcData.getLockAmt());
        summaryReportData.setActAmt(calcData.getActAmt());
        summaryReportData.setPlanReferenceAmt(calcData.getPlanReferenceAmt());
        summaryReportData.setBigDecimalValueOrDefault(calcData.getBigDecimalValue());
    }

    private ReportData buildSumPeriodRD(List<TemplateDim> templateDimLst, List<Object> members) {
        ReportData summaryReportData = new ReportData();
        summaryReportData.setId(null);
        summaryReportData.setReportId(this.getId());
        summaryReportData.setDimList(templateDimLst);
        summaryReportData.setDimValList(members);
        summaryReportData.setEffectFlag(false);
        summaryReportData.setSystemId(this.getSystemId());
        summaryReportData.setMainTable(this.getTemplate().isMainTable());
        summaryReportData.setAmountUnit(this.getTemplate().getAmountUnit());
        summaryReportData.setRow(0);
        summaryReportData.setCol(0);
        summaryReportData.setAuxiliaryInfo(false);
        summaryReportData.setEditable(false);
        summaryReportData.setReportPeriodId(this.getPeriodMemberList().get(0).getId());
        return summaryReportData;
    }

    public BigDecimal dealAmtData(BigDecimal amt) {
        return Optional.ofNullable(amt).map(o -> o).orElseGet(() -> BigDecimal.ZERO);
    }

    public boolean isRollContainsDetail() {
        if (this.periodMemberList.size() <= 1 && !this.reportPeriodType.isRoll()) {
            return false;
        }
        if (EmptyUtil.isEmpty((Object)((Object)this.reportPeriodType.getDetailPeriodType()))) {
            return false;
        }
        if (Objects.isNull(this.template)) {
            return false;
        }
        List<TemplateReportType> reportTypeList = this.template.getReportTypeList();
        if (EmptyUtil.isEmpty(reportTypeList)) {
            return true;
        }
        Optional<TemplateReportType> first = reportTypeList.stream().filter(rt -> Objects.equals(this.reportPeriodType.getReportPeriodId(), rt.getReportTypeId())).findFirst();
        if (!first.isPresent()) {
            return false;
        }
        TemplateReportType templateReportType = first.get();
        return templateReportType.isRollContainsDetail();
    }

    @Override
    public Pair<List<Long>, List<List<Long>>> getTplDimAndValInfo(FundPlanSystem system) {
        if (this.isRollContainsDetail()) {
            return ReportDataSource.super.getTplDimAndValInfo(system);
        }
        PeriodType detailPeriodType = this.getReportPeriodType().getDetailPeriodType();
        if (Objects.isNull((Object)detailPeriodType)) {
            return ReportDataSource.super.getTplDimAndValInfo(system);
        }
        if (this.getPeriodMemberList().size() == 1) {
            return ReportDataSource.super.getTplDimAndValInfo(system);
        }
        ReportTemplate template = this.getTemplate();
        List templateDimList = template.getAllTemplateDim().stream().filter(item -> item.getDimType() != DimensionType.DETAILDIM).collect(Collectors.toList());
        ArrayList<Long> subDimIdList = new ArrayList<Long>(template.getAllTemplateDim().size());
        ArrayList<List<Long>> subDimValList = new ArrayList<List<Long>>(template.getAllTemplateDim().size());
        List<PeriodMember> currentPeriodMemberList = Collections.singletonList(this.periodMemberList.get(0));
        List rollPeriodIdList = this.periodMemberList.subList(1, this.periodMemberList.size()).stream().map(DimMember::getId).collect(Collectors.toList());
        for (TemplateDim templateDim : templateDimList) {
            subDimIdList.add(templateDim.getDimensionId());
            if (templateDim.getDimType() != DimensionType.PERIOD) {
                subDimValList.add(new ArrayList<Long>(templateDim.getMemberScope()));
                continue;
            }
            List detailPeriodMembers = currentPeriodMemberList.stream().filter(Objects::nonNull).filter(b -> templateDim.getMemberScope().contains(b.getId())).map(DimMember::getChildren).flatMap(Collection::stream).map(DimMember::getId).collect(Collectors.toList());
            detailPeriodMembers.addAll(rollPeriodIdList);
            subDimValList.add(detailPeriodMembers);
        }
        return Pair.of(subDimIdList, subDimValList);
    }

    public boolean needSplit() {
        if (Objects.isNull(this.template)) {
            return false;
        }
        return this.template.getTemplateType() == TemplateType.FIXED;
    }

    public PeriodMember getCurrentReportPeriod() {
        return this.getPeriodMemberList().get(0);
    }

    public List<PeriodMember> getCurrentReportPeriodDetail() {
        ReportPeriodType periodType = this.getReportPeriodType();
        if (periodType == null || periodType.getDetailPeriodType() == null) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        return this.getPeriodMemberList().get(0).getAllChildMember().stream().map(item -> (PeriodMember)item).collect(Collectors.toList());
    }

    public List<PeriodMember> getCurrentReportPeriodDetailIfHasDetail() {
        List<PeriodMember> currentReportPeriodDetail = this.getCurrentReportPeriodDetail();
        return EmptyUtil.isEmpty(currentReportPeriodDetail) ? Collections.singletonList(this.getCurrentReportPeriod()) : currentReportPeriodDetail;
    }

    @Override
    public List<PeriodMember> getCurrentAllPeriodMembers() {
        if (Objects.isNull((Object)this.reportPeriodType.getDetailPeriodType())) {
            return this.periodMemberList;
        }
        if (!this.isRollContainsDetail()) {
            PeriodMember currPeriodMember = this.periodMemberList.get(0);
            List<PeriodMember> result = currPeriodMember.getAllChildMember().stream().map(PeriodMember.class::cast).collect(Collectors.toList());
            result.addAll(this.periodMemberList.subList(1, this.periodMemberList.size()));
            return result;
        }
        return this.periodMemberList.stream().map(DimMember::getAllChildMember).flatMap(Collection::stream).map(PeriodMember.class::cast).collect(Collectors.toList());
    }

    public Set<Long> getAllPeriodMemberIds() {
        return this.getAllPeriodMemberIds(false);
    }

    public Set<Long> getAllPeriodMemberIds(boolean needReference) {
        Set<Long> periodMemberIds = this.periodMemberList.stream().map(DimMember::getId).collect(Collectors.toSet());
        if (needReference && Objects.nonNull(this.referencePeriodMember)) {
            periodMemberIds.add(this.referencePeriodMember.getId());
        }
        if (this.periodMemberList.size() == 1) {
            periodMemberIds.addAll(this.getCurrentReportPeriodDetail().stream().map(DimMember::getId).collect(Collectors.toSet()));
            return periodMemberIds;
        }
        if (Objects.isNull((Object)this.reportPeriodType.getDetailPeriodType())) {
            return periodMemberIds;
        }
        if (this.isRollContainsDetail()) {
            periodMemberIds.addAll(this.periodMemberList.stream().map(DimMember::getAllChildMember).flatMap(Collection::stream).map(DimMember::getId).collect(Collectors.toSet()));
            return periodMemberIds;
        }
        periodMemberIds.addAll(this.getCurrentReportPeriodDetail().stream().map(DimMember::getId).collect(Collectors.toSet()));
        return periodMemberIds;
    }

    public List<TreeNode> getTreeNodeList() {
        return this.getTreeNodeList(this.reportDataList);
    }

    public List<TreeNode> getTreeNodeList(List<ReportData> reportDataList) {
        FpmAssertUtil.isNotNull((Object)this.indexTree, (String)"indexTree is not initialized");
        return reportDataList.stream().map(rd -> DimensionInfoHelper.getDimensionInfoBean(rd, this.template)).distinct().map(this.indexTree::find).collect(Collectors.toList());
    }

    public List<TreeNode> getTreeNodeList(FundPlanSystem system, List<ReportData> reportDataList) {
        if (Objects.isNull(this.indexTree)) {
            this.getIndexTree(system);
        }
        return reportDataList.stream().map(rd -> DimensionInfoHelper.getDimensionInfoBean(rd, this.template)).distinct().map(this.indexTree::find).collect(Collectors.toList());
    }

    public List<TreeNode> getTreeNodeListByDimensionBeanList(FundPlanSystem system, Collection<DimensionInfoBean> dimensionInfoBeans) {
        if (Objects.isNull(this.indexTree)) {
            this.getIndexTree(system);
        }
        return dimensionInfoBeans.stream().distinct().map(this.indexTree::find).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<ReportData> getTreeNodeDataList(List<ReportData> newReportDataList) {
        List<TreeNode> treeNodeList = this.getTreeNodeList(newReportDataList);
        return treeNodeList.stream().map(TreeNode::getDataList).filter(Objects::nonNull).flatMap(Collection::stream).map(ReportData.class::cast).collect(Collectors.toList());
    }

    public void addExchangeRate(Object currencyId, BigDecimal rate) {
        if (Objects.isNull(this.exchangeRateMap)) {
            this.exchangeRateMap = new HashMap<Object, BigDecimal>(16);
        }
        if (Objects.isNull(rate)) {
            rate = BigDecimal.ONE;
        }
        this.exchangeRateMap.putIfAbsent(currencyId, rate);
    }

    public BigDecimal getExchangeRate(Object currencyId) {
        if (Objects.isNull(this.exchangeRateMap)) {
            return BigDecimal.ONE;
        }
        return this.exchangeRateMap.getOrDefault(currencyId, BigDecimal.ONE);
    }

    public QueryIndexInfo<Object, ReportData> getQueryIndexInfo(FundPlanSystem system) {
        return this.getQueryIndexInfo(system, false);
    }

    public QueryIndexInfo<Object, ReportData> getQueryIndexInfo(FundPlanSystem system, boolean rebuild) {
        if (rebuild) {
            this.queryIndexInfo = null;
        }
        if (this.queryIndexInfo != null) {
            return this.queryIndexInfo;
        }
        if (this.queryIndexInfo == null) {
            this.queryIndexInfo = QueryIndexInfoMapGenerator.buildReportDataIndex(this.getReportDataList(), system, rd -> !rd.isAuxiliaryInfo());
        }
        return this.queryIndexInfo;
    }

    public void setQueryIndexInfo(QueryIndexInfo<Object, ReportData> queryIndexInfo) {
        this.queryIndexInfo = queryIndexInfo;
    }

    public boolean isZeroReport() {
        return this.zeroReport;
    }

    public void setZeroReport(boolean zeroReport) {
        this.zeroReport = zeroReport;
    }
}

