/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.model.report;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.tmc.fpm.business.domain.model.index.DimensionIndexTree;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportCalcTree;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportCalcValTreeNode;
import kd.tmc.fpm.common.bean.DimensionInfoBean;
import org.apache.commons.collections.MapUtils;

public class ReportCalcModel
implements Serializable {
    private List<ReportCalcVal> pageDimValList = new ArrayList<ReportCalcVal>(4);
    private List<ReportCalcVal> colDimValList = new ArrayList<ReportCalcVal>(4);
    private List<ReportCalcVal> rowDimValList = new ArrayList<ReportCalcVal>(4);
    private List<ReportCalcVal> dataValList = new ArrayList<ReportCalcVal>(512);
    private List<ReportCalcVal> extValList = new ArrayList<ReportCalcVal>(4);
    private transient DimensionIndexTree indexTree;
    private ReportCalcTree rowTree;
    private ReportCalcTree colTree;
    private int colOffset;
    private int rowOffset;
    private Map<Integer, List<ReportCalcVal>> detailReportCalcValGroupByRow;

    @Deprecated
    public DimensionInfoBean getFixedTemplateDimensionInfo(int col, int row) {
        DimensionInfoBean pageDimInfoBean = new DimensionInfoBean();
        for (ReportCalcVal reportCalcVal : this.pageDimValList) {
            pageDimInfoBean.getDimensionIdList().add(reportCalcVal.getDimensionId());
            pageDimInfoBean.getMemberIdList().add(reportCalcVal.getValue());
        }
        DimensionInfoBean colDimList = null;
        DimensionInfoBean rowDimList = null;
        if (this.colTree == null || this.rowTree == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u901a\u8fc7\u884c\u5217\u53f7\u83b7\u53d6\u7ef4\u5ea6\u4fe1\u606f\u5931\u8d25\uff0c\u5bf9\u5e94\u7684\u884c\u6216\u5217\u6811\u4e3a\u7a7a\u3002[row=%1$s, col=%2$s]", (String)"ReportCalcModel_0", (String)"tmc-fpm-business", (Object[])new Object[0]), row, col));
        }
        colDimList = this.colTree.getDimInfoByLocation(col, this.colOffset);
        rowDimList = this.rowTree.getDimInfoByLocation(row, this.rowOffset);
        DimensionInfoBean dimensionInfoBean = DimensionInfoBean.concat((DimensionInfoBean[])new DimensionInfoBean[]{colDimList, rowDimList, pageDimInfoBean});
        return dimensionInfoBean;
    }

    public DimensionInfoBean getDimensionInfo(int col, int row) {
        return this.getDimensionInfoBean(col, row, true);
    }

    public DimensionInfoBean getDimensionInfoWithVirtual(int col, int row) {
        return this.getDimensionInfoBean(col, row, false);
    }

    private DimensionInfoBean getDimensionInfoBean(int col, int row, boolean needFilterVirtual) {
        DimensionInfoBean colDimList;
        DimensionInfoBean dimensionInfoBean = null;
        DimensionInfoBean pageDimInfoBean = new DimensionInfoBean();
        for (ReportCalcVal reportCalcVal : this.pageDimValList) {
            pageDimInfoBean.getDimensionIdList().add(reportCalcVal.getDimensionId());
            pageDimInfoBean.getMemberIdList().add(reportCalcVal.getValue());
        }
        if (this.colTree != null && this.rowTree != null) {
            colDimList = this.colTree.getDimInfoByLocation(col, this.colOffset);
            DimensionInfoBean rowDimList = this.rowTree.getDimInfoByLocation(row, this.rowOffset);
            dimensionInfoBean = DimensionInfoBean.concat((DimensionInfoBean[])new DimensionInfoBean[]{colDimList, rowDimList, pageDimInfoBean});
        } else if (this.colTree != null) {
            colDimList = new DimensionInfoBean();
            List<ReportCalcValTreeNode> leafList = this.colTree.getLeafList();
            List<ReportCalcVal> reportCalcValByRow = this.getReportCalcValByRow(row);
            Map rowDataByColMap = reportCalcValByRow.stream().collect(Collectors.toMap(ReportCalcVal::getCol, Function.identity()));
            for (ReportCalcValTreeNode node : leafList) {
                ReportCalcVal currLeafCalcVal = node.getCalcVal();
                if (node.getParent() != null && node.getParent() != this.colTree.getRoot() && (currLeafCalcVal.getCol() > col || currLeafCalcVal.getEndCol() < col)) continue;
                while (node != null && node != this.colTree.getRoot()) {
                    if (node.isSkipVal() || node.isRemark()) {
                        node = node.getParent();
                        continue;
                    }
                    ReportCalcVal calcVal = node.getCalcVal();
                    Long dimensionId = calcVal.getDimensionId();
                    ReportCalcVal cell = (ReportCalcVal)rowDataByColMap.get(calcVal.getCol());
                    if (Objects.isNull(cell)) {
                        node = node.getParent();
                        continue;
                    }
                    Object value = cell.getValue();
                    boolean isDim = true;
                    if (!dimensionId.equals(calcVal.getValue())) {
                        if (calcVal.getCol() <= col && calcVal.getEndCol() >= col) {
                            value = calcVal.getValue();
                        } else {
                            isDim = false;
                        }
                    }
                    if (needFilterVirtual) {
                        boolean bl = isDim = !calcVal.isVirtualCell() && isDim;
                    }
                    if (isDim) {
                        colDimList.getDimensionIdList().add(dimensionId);
                        colDimList.getMemberIdList().add(value);
                    }
                    node = node.getParent();
                }
            }
            dimensionInfoBean = DimensionInfoBean.concat((DimensionInfoBean[])new DimensionInfoBean[]{colDimList, pageDimInfoBean});
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u884c\u5217\u7ef4\u4fe1\u606f\u5f02\u5e38", (String)"ReportCalcModel_1", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        return dimensionInfoBean;
    }

    public ReportCalcVal getReportCalcVal(int col, int row) {
        ReportCalcVal calcVal = null;
        int maxRow = 0;
        maxRow = this.rowTree != null ? this.rowOffset + this.rowTree.getLeafList().size() - 1 : this.dataValList.stream().max(Comparator.comparingInt(ReportCalcVal::getRow)).get().getRow();
        int maxCol = 0;
        maxCol = this.colTree != null ? this.colOffset + this.colTree.getLeafList().size() - 1 : this.dataValList.stream().max(Comparator.comparingInt(ReportCalcVal::getCol)).get().getCol();
        if (0 <= col && col < this.colOffset && row > this.rowOffset) {
            calcVal = this.colDimValList.stream().filter(o -> o.getCol() == col && o.getRow() == row).findFirst().orElse(null);
        } else if (0 <= row && row < this.rowOffset) {
            calcVal = this.rowDimValList.stream().filter(o -> o.getCol() == col && o.getRow() == row).findFirst().orElse(null);
        } else if (row >= this.rowOffset && row <= maxRow && col >= this.colOffset && col <= maxCol) {
            if (this.colTree != null && this.rowTree != null) {
                int rowIdx = row - this.rowOffset;
                int colIdx = col - this.colOffset;
                int colLen = this.colTree.getLeafList().size();
                calcVal = this.dataValList.get(rowIdx * colLen + colIdx);
            } else {
                calcVal = this.dataValList.stream().filter(o -> o.getCol() == col && o.getRow() == row).findFirst().orElse(null);
            }
        } else {
            calcVal = this.extValList.stream().filter(o -> o.getCol() == col && o.getRow() == row).findFirst().orElse(null);
        }
        return calcVal;
    }

    public List<ReportCalcVal> getReportCalcValByRow(int row) {
        if (MapUtils.isEmpty(this.detailReportCalcValGroupByRow)) {
            this.detailReportCalcValGroupByRow = this.dataValList.stream().collect(Collectors.groupingBy(ReportCalcVal::getRow));
        }
        return this.detailReportCalcValGroupByRow.getOrDefault(row, Collections.emptyList());
    }

    public void initDetailReportCalcValGroupMap() {
        if (MapUtils.isEmpty(this.detailReportCalcValGroupByRow)) {
            this.detailReportCalcValGroupByRow = this.dataValList.stream().collect(Collectors.groupingBy(ReportCalcVal::getRow));
        }
    }

    public List<ReportCalcVal> getPageDimValList() {
        return this.pageDimValList;
    }

    public void setPageDimValList(List<ReportCalcVal> pageDimValList) {
        this.pageDimValList = pageDimValList;
    }

    public List<ReportCalcVal> getColDimValList() {
        return this.colDimValList;
    }

    public void setColDimValList(List<ReportCalcVal> colDimValList) {
        this.colDimValList = colDimValList;
    }

    public List<ReportCalcVal> getRowDimValList() {
        return this.rowDimValList;
    }

    public void setRowDimValList(List<ReportCalcVal> rowDimValList) {
        this.rowDimValList = rowDimValList;
    }

    public List<ReportCalcVal> getDataValList() {
        return this.dataValList;
    }

    public void setDataValList(List<ReportCalcVal> dataValList) {
        this.dataValList = dataValList;
    }

    public List<ReportCalcVal> getExtValList() {
        return this.extValList;
    }

    public void setExtValList(List<ReportCalcVal> extValList) {
        this.extValList = extValList;
    }

    public DimensionIndexTree getIndexTree() {
        return this.indexTree;
    }

    public void setIndexTree(DimensionIndexTree indexTree) {
        this.indexTree = indexTree;
    }

    public int getColOffset() {
        return this.colOffset;
    }

    public void setColOffset(int colOffset) {
        this.colOffset = colOffset;
    }

    public int getRowOffset() {
        return this.rowOffset;
    }

    public void setRowOffset(int rowOffset) {
        this.rowOffset = rowOffset;
    }

    public ReportCalcTree getRowTree() {
        return this.rowTree;
    }

    public void setRowTree(ReportCalcTree rowTree) {
        this.rowTree = rowTree;
    }

    public ReportCalcTree getColTree() {
        return this.colTree;
    }

    public void setColTree(ReportCalcTree colTree) {
        this.colTree = colTree;
    }

    public Map<Integer, List<ReportCalcVal>> getDetailReportCalcValGroupByRow() {
        return this.detailReportCalcValGroupByRow;
    }

    public void setDetailReportCalcValGroupByRow(Map<Integer, List<ReportCalcVal>> detailReportCalcValGroupByRow) {
        this.detailReportCalcValGroupByRow = detailReportCalcValGroupByRow;
    }
}

