/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.model.report;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.AmountUnit;
import kd.tmc.fpm.business.domain.enums.DetailDimType;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.ReportDataType;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.utils.CommonUtils;
import kd.tmc.fpm.common.enums.AmountUnitEnum;
import kd.tmc.fpm.common.utils.AmountUtil;

public class ReportData
implements Serializable {
    private Long id;
    private Long reportId;
    private List<TemplateDim> dimList;
    private List<Object> dimValList;
    private Object value;
    private BigDecimal planAmt;
    private BigDecimal reportPlanAmt;
    private BigDecimal originalPlanAmt;
    private BigDecimal planReferenceAmt;
    private BigDecimal offsetAmt;
    private BigDecimal actAmt;
    private BigDecimal holdActAmt;
    private BigDecimal lockAmt;
    private BigDecimal holdLockAmt;
    private String remark;
    private boolean effectFlag;
    private Long reportPeriodId;
    private boolean mainTable;
    private AmountUnit amountUnit;
    private Integer version;
    private Long linkedReportId;
    private ReportDataType dataType;
    private boolean editable;
    private List<Long> sourceIdList;
    private boolean smartGelFlag;
    private boolean isAuxiliaryInfo;
    private Boolean dirty;
    private int col;
    private int row;
    private Map<Long, String> auxiliaryValMap;
    private Map<Long, Object> metricValMap;
    private Long systemId;
    private BigDecimal concurrentAmt;

    public String getAuxiliaryVal(Long auxiliaryId) {
        if (this.auxiliaryValMap == null) {
            return null;
        }
        return this.auxiliaryValMap.get(auxiliaryId);
    }

    public void putAuxiliaryVal(Long auxiliaryId, String val) {
        if (auxiliaryId == null) {
            return;
        }
        if (this.auxiliaryValMap == null) {
            this.auxiliaryValMap = new HashMap<Long, String>(16);
        }
        if (!this.auxiliaryValMap.containsKey(auxiliaryId) || !val.equals(this.auxiliaryValMap.get(auxiliaryId))) {
            this.auxiliaryValMap.put(auxiliaryId, val);
            this.dirty = true;
        }
    }

    public Map<Long, String> getAuxiliaryValMap() {
        return this.auxiliaryValMap;
    }

    public void setAuxiliaryValMap(Map<Long, String> auxiliaryValMap) {
        this.auxiliaryValMap = auxiliaryValMap;
    }

    public void putAllMetricVal(Map<Long, Object> metricValMap) {
        if (!CollectionUtils.isEmpty(metricValMap)) {
            this.initMetricValMapIfNeed();
            this.metricValMap.putAll(metricValMap);
        }
    }

    public void putMetricVal(Long metricId, Object val) {
        this.initMetricValMapIfNeed();
        this.metricValMap.put(metricId, val);
    }

    public BigDecimal getBigDecimalValueByMetric(Long metricId) {
        this.initMetricValMapIfNeed();
        Object o = this.metricValMap.get(metricId);
        if (EmptyUtil.isEmpty((Object)o)) {
            return BigDecimal.ZERO;
        }
        if (o instanceof BigDecimal) {
            return (BigDecimal)o;
        }
        if (o instanceof Double) {
            return BigDecimal.valueOf((Double)o);
        }
        if (o instanceof Integer) {
            return BigDecimal.valueOf(((Integer)o).intValue());
        }
        if (o instanceof Long) {
            return BigDecimal.valueOf((Long)o);
        }
        return BigDecimal.ZERO;
    }

    private void initMetricValMapIfNeed() {
        if (this.metricValMap == null) {
            this.metricValMap = new HashMap<Long, Object>(8);
        }
    }

    public ReportData(ReportData reportData) {
        this.reportId = reportData.reportId;
        this.systemId = reportData.systemId;
        this.dimList = new ArrayList<TemplateDim>(reportData.dimList);
        this.dimValList = new ArrayList<Object>(reportData.dimValList);
        this.planAmt = CommonUtils.getValueIfNull(reportData.planAmt);
        this.actAmt = CommonUtils.getValueIfNull(reportData.actAmt);
        this.lockAmt = CommonUtils.getValueIfNull(reportData.lockAmt);
        this.offsetAmt = CommonUtils.getValueIfNull(reportData.offsetAmt);
        this.originalPlanAmt = CommonUtils.getValueIfNull(reportData.originalPlanAmt);
        this.planReferenceAmt = CommonUtils.getValueIfNull(reportData.planReferenceAmt);
        this.concurrentAmt = CommonUtils.getValueIfNull(reportData.concurrentAmt);
        this.remark = reportData.remark;
        this.effectFlag = reportData.effectFlag;
        this.reportPeriodId = reportData.reportPeriodId;
        this.mainTable = reportData.mainTable;
        this.amountUnit = reportData.amountUnit;
        this.version = reportData.version;
        this.linkedReportId = reportData.linkedReportId;
        this.dataType = reportData.dataType;
        this.editable = reportData.editable;
        this.col = reportData.col;
        this.row = reportData.row;
        this.auxiliaryValMap = new HashMap<Long, String>(CommonUtils.getOrDefault(reportData.auxiliaryValMap, Collections.emptyMap()));
        this.reportPlanAmt = CommonUtils.getValueIfNull(reportData.reportPlanAmt);
        this.metricValMap = new HashMap<Long, Object>(CommonUtils.getOrDefault(reportData.metricValMap, Collections.emptyMap()));
        this.isAuxiliaryInfo = reportData.isAuxiliaryInfo;
        this.value = reportData.value;
        this.smartGelFlag = reportData.getSmartGelFlag();
    }

    public ReportData() {
        this.clearAmt();
        this.dirty = false;
    }

    public boolean isEffectFlag() {
        return this.effectFlag;
    }

    public void setEffectFlag(boolean effectFlag) {
        this.effectFlag = effectFlag;
    }

    public Long getReportPeriodId() {
        return this.reportPeriodId;
    }

    public void setReportPeriodId(Long reportPeriodId) {
        this.reportPeriodId = reportPeriodId;
    }

    public Object getDimValByDimType(DimensionType dimensionType) {
        return this.getDimValByDimType(dimensionType, null);
    }

    public Object getDimValByDimType(DimensionType dimensionType, DetailDimType detailDimType) {
        List<TemplateDim> dimList = this.getDimList();
        List<Object> dimValList = this.getDimValList();
        Optional<TemplateDim> first = dimList.stream().filter(item -> item.getDimType() == dimensionType && (detailDimType == null || item.getDetailDimType() == detailDimType)).findFirst();
        if (!first.isPresent()) {
            return null;
        }
        TemplateDim templateDim = first.get();
        int index = dimList.indexOf(templateDim);
        return dimValList.get(index);
    }

    public Object getDimValByDimensionId(Long dimensionId) {
        List<TemplateDim> dimList = this.getDimList();
        List<Object> dimValList = this.getDimValList();
        for (int i = 0; i < dimList.size(); ++i) {
            Long dimId = dimList.get(i).getDimensionId();
            if (!Objects.equals(dimId, dimensionId)) continue;
            return dimValList.get(i);
        }
        return null;
    }

    public BigDecimal getPlanReferenceAmt() {
        return CommonUtils.getValueIfNull(this.planReferenceAmt);
    }

    public void setPlanReferenceAmt(BigDecimal planReferenceAmt) {
        this.planReferenceAmt = planReferenceAmt;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public List<TemplateDim> getDimList() {
        return this.dimList;
    }

    public void setDimList(List<TemplateDim> dimList) {
        this.dimList = dimList;
    }

    public List<Object> getDimValList() {
        return this.dimValList;
    }

    public void setDimValList(List<Object> dimValList) {
        this.dimValList = dimValList;
    }

    public BigDecimal getPlanAmt() {
        return CommonUtils.getValueIfNull(this.planAmt);
    }

    public void setPlanAmt(BigDecimal planAmt) {
        this.planAmt = planAmt;
    }

    public BigDecimal getActAmt() {
        return CommonUtils.getValueIfNull(this.actAmt);
    }

    public void setActAmt(BigDecimal actAmt) {
        this.actAmt = actAmt;
    }

    public BigDecimal getLockAmt() {
        return CommonUtils.getValueIfNull(this.lockAmt);
    }

    public void setLockAmt(BigDecimal lockAmt) {
        this.lockAmt = lockAmt;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public Long getLinkedReportId() {
        return this.linkedReportId;
    }

    public void setLinkedReportId(Long linkedReportId) {
        this.linkedReportId = linkedReportId;
    }

    public ReportDataType getDataType() {
        return this.dataType;
    }

    public void setDataType(ReportDataType dataType) {
        this.dataType = dataType;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public int getCol() {
        return this.col;
    }

    public void setCol(int col) {
        this.col = col;
    }

    public int getRow() {
        return this.row;
    }

    public void setRow(int row) {
        this.row = row;
    }

    public boolean isMainTable() {
        return this.mainTable;
    }

    public void setMainTable(boolean mainTable) {
        this.mainTable = mainTable;
    }

    public AmountUnit getAmountUnit() {
        return this.amountUnit;
    }

    public void setAmountUnit(AmountUnit amountUnit) {
        this.amountUnit = amountUnit;
    }

    public Long getReportId() {
        return this.reportId;
    }

    public void setReportId(Long reportId) {
        this.reportId = reportId;
    }

    public BigDecimal getOriginalPlanAmt() {
        if (this.originalPlanAmt == null) {
            return BigDecimal.ZERO;
        }
        return this.originalPlanAmt;
    }

    public void setOriginalPlanAmt(BigDecimal originalPlanAmt) {
        this.originalPlanAmt = originalPlanAmt;
    }

    public BigDecimal getReportPlanAmt() {
        if (this.reportPlanAmt == null) {
            return BigDecimal.ZERO;
        }
        return this.reportPlanAmt;
    }

    public void setReportPlanAmt(BigDecimal reportPlanAmt) {
        this.reportPlanAmt = reportPlanAmt;
    }

    public List<Long> getSourceIdList() {
        if (Objects.isNull(this.sourceIdList)) {
            this.sourceIdList = new ArrayList<Long>(4);
        }
        return this.sourceIdList;
    }

    public void setSourceIdList(List<Long> sourceIdList) {
        this.sourceIdList = sourceIdList;
    }

    public BigDecimal getOffsetAmt() {
        if (this.offsetAmt == null) {
            return BigDecimal.ZERO;
        }
        return this.offsetAmt;
    }

    public void setOffsetAmt(BigDecimal offsetAmt) {
        this.offsetAmt = offsetAmt;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public BigDecimal getBigDecimalValue() {
        if (Objects.isNull(this.value)) {
            return BigDecimal.ZERO;
        }
        if (this.value instanceof BigDecimal) {
            return (BigDecimal)this.value;
        }
        if (this.value instanceof Double) {
            return BigDecimal.valueOf((Double)this.value);
        }
        if (this.value instanceof Integer) {
            return BigDecimal.valueOf(((Integer)this.value).intValue());
        }
        if (this.value instanceof Long) {
            return BigDecimal.valueOf((Long)this.value);
        }
        return BigDecimal.ZERO;
    }

    public void setBigDecimalValueOrDefault(Object value) {
        this.value = Optional.ofNullable(value).orElse(BigDecimal.ZERO);
    }

    public boolean isAuxiliaryInfo() {
        return this.isAuxiliaryInfo;
    }

    public void setAuxiliaryInfo(boolean auxiliaryInfo) {
        this.isAuxiliaryInfo = auxiliaryInfo;
    }

    public Boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(Boolean dirty) {
        this.dirty = dirty;
    }

    public BigDecimal getHoldActAmt() {
        return CommonUtils.getValueIfNull(this.holdActAmt);
    }

    public void setHoldActAmt(BigDecimal holdActAmt) {
        this.holdActAmt = holdActAmt;
    }

    public BigDecimal getHoldLockAmt() {
        return CommonUtils.getValueIfNull(this.holdLockAmt);
    }

    public void setHoldLockAmt(BigDecimal holdLockAmt) {
        this.holdLockAmt = holdLockAmt;
    }

    public Long getSystemId() {
        return this.systemId;
    }

    public void setSystemId(Long systemId) {
        this.systemId = systemId;
    }

    public BigDecimal getConcurrentAmt() {
        return CommonUtils.getValueIfNull(this.concurrentAmt);
    }

    public void setConcurrentAmt(BigDecimal concurrentAmt) {
        this.concurrentAmt = concurrentAmt;
    }

    public void addPlanAmt(BigDecimal planAmt) {
        if (Objects.isNull(this.planAmt)) {
            this.planAmt = BigDecimal.ZERO;
        }
        this.planAmt = this.planAmt.add(CommonUtils.getValueIfNull(planAmt));
    }

    public void addLockAmt(BigDecimal lockAmt) {
        if (Objects.isNull(this.lockAmt)) {
            this.lockAmt = BigDecimal.ZERO;
        }
        this.lockAmt = this.lockAmt.add(CommonUtils.getValueIfNull(lockAmt));
    }

    public void addActAmt(BigDecimal actAmt) {
        if (Objects.isNull(this.actAmt)) {
            this.actAmt = BigDecimal.ZERO;
        }
        this.actAmt = this.actAmt.add(CommonUtils.getValueIfNull(actAmt));
    }

    public void addHoldActAmt(BigDecimal holdActAmt) {
        if (Objects.isNull(this.holdActAmt)) {
            this.holdActAmt = BigDecimal.ZERO;
        }
        this.holdActAmt = this.holdActAmt.add(CommonUtils.getValueIfNull(holdActAmt));
    }

    public void addHoldLockAmt(BigDecimal holdLockAmt) {
        if (Objects.isNull(this.holdLockAmt)) {
            this.holdLockAmt = BigDecimal.ZERO;
        }
        this.holdLockAmt = this.holdLockAmt.add(CommonUtils.getValueIfNull(holdLockAmt));
    }

    public void addReportPlanAmt(BigDecimal reportPlanAmt) {
        if (Objects.isNull(this.reportPlanAmt)) {
            this.reportPlanAmt = BigDecimal.ZERO;
        }
        this.reportPlanAmt = this.reportPlanAmt.add(CommonUtils.getValueIfNull(reportPlanAmt));
    }

    public void addOriginalPlanAmt(BigDecimal originalPlanAmt) {
        if (Objects.isNull(this.originalPlanAmt)) {
            this.originalPlanAmt = BigDecimal.ZERO;
        }
        this.originalPlanAmt = this.originalPlanAmt.add(CommonUtils.getValueIfNull(originalPlanAmt));
    }

    public void addPlanReferenceAmt(BigDecimal planReferenceAmt) {
        this.planReferenceAmt = CommonUtils.getValueIfNull(this.planReferenceAmt).add(CommonUtils.getValueIfNull(planReferenceAmt));
    }

    public void addConcurrentAmt(BigDecimal concurrentAmt) {
        this.concurrentAmt = this.concurrentAmt.add(CommonUtils.getValueIfNull(concurrentAmt));
    }

    public final void clearAmt() {
        this.value = BigDecimal.ZERO;
        this.planAmt = BigDecimal.ZERO;
        this.reportPlanAmt = BigDecimal.ZERO;
        this.originalPlanAmt = BigDecimal.ZERO;
        this.planReferenceAmt = BigDecimal.ZERO;
        this.lockAmt = BigDecimal.ZERO;
        this.actAmt = BigDecimal.ZERO;
        this.holdLockAmt = BigDecimal.ZERO;
        this.holdActAmt = BigDecimal.ZERO;
        this.offsetAmt = BigDecimal.ZERO;
        this.concurrentAmt = BigDecimal.ZERO;
        this.dirty = true;
        if (Objects.isNull(this.metricValMap)) {
            return;
        }
        this.metricValMap = this.metricValMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, o -> BigDecimal.ZERO));
    }

    public void add(ReportData reportData) {
        this.add(reportData, false);
    }

    public void subtract(ReportData reportData) {
        this.add(reportData, true);
    }

    public void add(ReportData reportData, boolean negative) {
        this.addActAmt(CommonUtils.getNegativeValueIfNeed(reportData.getActAmt(), negative));
        this.addLockAmt(CommonUtils.getNegativeValueIfNeed(reportData.getLockAmt(), negative));
        this.addHoldLockAmt(CommonUtils.getNegativeValueIfNeed(reportData.getHoldLockAmt(), negative));
        this.addHoldActAmt(CommonUtils.getNegativeValueIfNeed(reportData.getHoldActAmt(), negative));
        this.addPlanAmt(CommonUtils.getNegativeValueIfNeed(reportData.getPlanAmt(), negative));
        this.addReportPlanAmt(CommonUtils.getNegativeValueIfNeed(reportData.getReportPlanAmt(), negative));
        this.addPlanReferenceAmt(CommonUtils.getNegativeValueIfNeed(reportData.getPlanReferenceAmt(), negative));
        this.addOriginalPlanAmt(CommonUtils.getNegativeValueIfNeed(reportData.getOriginalPlanAmt(), negative));
    }

    public String toString() {
        return "ReportData{id=" + this.id + ", reportId=" + this.reportId + ", planAmt=" + this.planAmt + ", actAmt=" + this.actAmt + ", holdActAmt=" + this.holdActAmt + ", lockAmt=" + this.lockAmt + ", holdLockAmt=" + this.holdLockAmt + ", concurrentAmt=" + this.concurrentAmt + ", mainTable=" + this.mainTable + ", amountUnit=" + (Object)((Object)this.amountUnit) + '}';
    }

    public BigDecimal getReportActAmount(BigDecimal waitReleaseAmt) {
        BigDecimal realAmount = AmountUtil.convert((AmountUnitEnum)AmountUnitEnum.ONE, (AmountUnitEnum)((AmountUnitEnum)AmountUnitEnum.valueOf(AmountUnitEnum.class, (String)this.amountUnit.name())), (BigDecimal)waitReleaseAmt);
        return realAmount;
    }

    public boolean getSmartGelFlag() {
        return this.smartGelFlag;
    }

    public void setSmartGelFlag(boolean smartGelFlag) {
        this.smartGelFlag = smartGelFlag;
    }

    public BigDecimal getAvailableAmt() {
        return this.getPlanAmt().subtract(this.getLockAmt()).subtract(this.getActAmt()).subtract(this.getHoldActAmt()).subtract(this.getHoldLockAmt());
    }
}

