/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.model.report;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.PeriodType;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.ReportPeriodType;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.index.DimensionIndexTree;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import org.apache.commons.lang3.tuple.Pair;

public interface ReportDataSource
extends Serializable {
    public ReportTemplate getTemplate();

    default public DimensionIndexTree getIndexTree(FundPlanSystem system, Long summaryDimId) {
        return null;
    }

    default public DimensionIndexTree getIndexTree(FundPlanSystem system) {
        return null;
    }

    public ReportPeriodType getReportPeriodType();

    public List<ReportData> getReportDataList();

    public List<PeriodMember> getPeriodMemberList();

    public List<PeriodMember> getCurrentAllPeriodMembers();

    @Deprecated
    default public List<ReportData> getReportDataByDimInfo(List<Long> targetDimIdList, List<Object> targetDimValList) {
        return this.getReportDataByDimInfo(targetDimIdList, targetDimValList, this.getReportDataList());
    }

    @Deprecated
    default public List<ReportData> getReportDataByDimInfo(List<Long> targetDimIdList, List<Object> targetDimValList, List<ReportData> reportDataList) {
        ArrayList<ReportData> matchedDataList = new ArrayList<ReportData>();
        HashSet<Long> targetDimIdSet = new HashSet<Long>(targetDimIdList);
        for (ReportData reportData : reportDataList) {
            List dimIdList = reportData.getDimList().stream().filter(c -> EmptyUtil.isNoEmpty((Object)c)).map(TemplateDim::getDimensionId).collect(Collectors.toList());
            HashSet dimIdSet = new HashSet(dimIdList);
            boolean dimensionMatch = dimIdSet.containsAll(targetDimIdSet);
            if (!dimensionMatch) continue;
            List<Object> dimValList = reportData.getDimValList();
            boolean dimValMatch = true;
            for (int i = 0; i < targetDimIdList.size(); ++i) {
                Object targetVal;
                Long targetDimId = targetDimIdList.get(i);
                int dimIndex = dimIdList.indexOf(targetDimId);
                Object dimVal = dimValList.get(dimIndex);
                if (Objects.equals(dimVal, targetVal = targetDimValList.get(i))) continue;
                dimValMatch = false;
                break;
            }
            if (!dimValMatch) continue;
            matchedDataList.add(reportData);
        }
        return matchedDataList;
    }

    default public Pair<List<Long>, List<List<Long>>> getTplDimAndValInfo(FundPlanSystem system) {
        ReportTemplate template = this.getTemplate();
        ArrayList subDimIdList = new ArrayList(template.getAllTemplateDim().size());
        ArrayList subDimValList = new ArrayList(template.getAllTemplateDim().size());
        PeriodType detailPeriodType = this.getReportPeriodType().getDetailPeriodType();
        boolean hasDetailPeriod = detailPeriodType != null;
        template.getAllTemplateDim().stream().filter(item -> item.getDimType() != DimensionType.DETAILDIM).forEach(item -> {
            subDimIdList.add(item.getDimensionId());
            if (item.getDimType() == DimensionType.PERIOD) {
                if (hasDetailPeriod) {
                    List<DimMember> allDimMemberList = system.getMainDimensionByDimType(DimensionType.PERIOD).getAllDimMemberList();
                    List detailPeriodMembers = allDimMemberList.stream().filter(Objects::nonNull).filter(b -> item.getMemberScope().contains(b.getId())).map(DimMember::getChildren).flatMap(Collection::stream).map(DimMember::getId).collect(Collectors.toList());
                    subDimValList.add(detailPeriodMembers);
                } else {
                    subDimValList.add(new ArrayList<Long>(item.getMemberScope()));
                }
            } else {
                subDimValList.add(new ArrayList<Long>(item.getMemberScope()));
            }
        });
        return Pair.of(subDimIdList, subDimValList);
    }
}

