/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.model.sumplan;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.StringUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.sumplan.EvalDimensionVal;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;

public class EvalDimensionCombination
implements Serializable {
    private List<EvalDimensionVal> evalDimensionValList = new ArrayList<EvalDimensionVal>(8);
    private Long systemId;
    private boolean freeze;

    public EvalDimensionCombination(Long systemId) {
        this.systemId = systemId;
    }

    public EvalDimensionCombination(Long systemId, List<EvalDimensionVal> evalDimensionValList) {
        this(systemId);
        if (EmptyUtil.isNoEmpty(evalDimensionValList)) {
            this.evalDimensionValList.addAll(evalDimensionValList);
        }
    }

    public List<EvalDimensionVal> getEvalDimensionValList() {
        return this.evalDimensionValList;
    }

    public EvalDimensionCombination addEvalDimensionVal(EvalDimensionVal evalDimensionVal) {
        if (this.freeze) {
            return this;
        }
        this.evalDimensionValList.add(evalDimensionVal);
        return this;
    }

    public EvalDimensionCombination freeze() {
        if (this.freeze) {
            return this;
        }
        this.freeze = true;
        this.evalDimensionValList = this.evalDimensionValList.stream().sorted(Comparator.comparing(EvalDimensionVal::getDimensionId)).collect(Collectors.toList());
        return this;
    }

    public EvalDimensionCombination unFreeze() {
        this.freeze = false;
        return this;
    }

    public Long getSystemId() {
        return this.systemId;
    }

    public void setSystemId(Long systemId) {
        this.systemId = systemId;
    }

    public Object getValueByDimType(DimensionType dimensionType) {
        Optional<EvalDimensionVal> first = this.evalDimensionValList.stream().filter(val -> val.getDimensionType() == dimensionType).findFirst();
        if (first.isPresent()) {
            return first.get().getValue();
        }
        return 0L;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EvalDimensionCombination that = (EvalDimensionCombination)o;
        this.freeze();
        that.freeze();
        if (EmptyUtil.isEmpty(this.evalDimensionValList) && EmptyUtil.isEmpty(that.evalDimensionValList)) {
            return true;
        }
        if (EmptyUtil.isEmpty(this.evalDimensionValList) || EmptyUtil.isEmpty(that.evalDimensionValList)) {
            return false;
        }
        if (this.evalDimensionValList.size() != that.evalDimensionValList.size()) {
            return false;
        }
        for (int i = 0; i < this.evalDimensionValList.size(); ++i) {
            if (Objects.equals(this.evalDimensionValList.get(i), that.evalDimensionValList.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        this.freeze();
        return Objects.hash(this.evalDimensionValList.toArray());
    }

    public String toString() {
        this.freeze();
        return this.evalDimensionValList.toString();
    }

    public EvalDimensionCombination copy(Consumer<EvalDimensionVal> consumer) {
        EvalDimensionCombination combination = new EvalDimensionCombination(this.systemId);
        List<EvalDimensionVal> evalDimensionValList = this.getEvalDimensionValList();
        if (Objects.isNull(consumer)) {
            consumer = t -> {};
        }
        for (EvalDimensionVal evalDimensionVal : evalDimensionValList) {
            EvalDimensionVal copy = evalDimensionVal.copy();
            consumer.accept(copy);
            combination.addEvalDimensionVal(copy);
        }
        return combination;
    }

    public static EvalDimensionCombination getEvalDimensionCombinationByReportData(ReportData reportData) {
        return EvalDimensionCombination.getEvalDimensionCombinationByReportData(reportData, (TemplateDim td) -> true);
    }

    public static EvalDimensionCombination getEvalDimensionCombinationByReportData(ReportData reportData, ReportTemplate template) {
        Predicate<TemplateDim> predicate = td -> {
            if (EmptyUtil.isEmpty((Object)template)) {
                return true;
            }
            List<TemplateDim> allTemplateDim = template.getAllTemplateDim();
            Set collect = allTemplateDim.stream().map(TemplateDim::getDimensionId).collect(Collectors.toSet());
            return collect.contains(td.getDimensionId());
        };
        return EvalDimensionCombination.getEvalDimensionCombinationByReportData(reportData, predicate);
    }

    public static EvalDimensionCombination getEvalDimensionCombinationByReportData(ReportData reportData, Predicate<TemplateDim> predicate) {
        List<TemplateDim> dimList = reportData.getDimList();
        List<Object> dimValList = reportData.getDimValList();
        if (EmptyUtil.isEmpty(predicate)) {
            predicate = id -> true;
        }
        EvalDimensionCombination evalDimensionCombination = new EvalDimensionCombination(reportData.getSystemId());
        for (int i = 0; i < dimList.size(); ++i) {
            Object value;
            TemplateDim templateDim = dimList.get(i);
            if (templateDim.isDetailDim() || !predicate.test(templateDim) || EmptyUtil.isEmpty((Object)(value = dimValList.get(i)))) continue;
            evalDimensionCombination.addEvalDimensionVal(new EvalDimensionVal(templateDim.getDimensionId(), templateDim.getDimType(), value));
        }
        evalDimensionCombination.freeze();
        return evalDimensionCombination;
    }

    public static EvalDimensionCombination getEvalDimensionCombinationWithDetailDim(ReportData reportData, Predicate<TemplateDim> predicate) {
        List<TemplateDim> dimList = reportData.getDimList();
        List<Object> dimValList = reportData.getDimValList();
        if (EmptyUtil.isEmpty(predicate)) {
            predicate = id -> true;
        }
        EvalDimensionCombination evalDimensionCombination = new EvalDimensionCombination(reportData.getSystemId());
        for (int i = 0; i < dimList.size(); ++i) {
            Object value;
            TemplateDim templateDim = dimList.get(i);
            if (!predicate.test(templateDim) || EmptyUtil.isEmpty((Object)(value = dimValList.get(i)))) continue;
            evalDimensionCombination.addEvalDimensionVal(new EvalDimensionVal(templateDim.getDimensionId(), templateDim.getDimType(), value));
        }
        evalDimensionCombination.freeze();
        return evalDimensionCombination;
    }

    public static Set<EvalDimensionCombination> getEvalDimensionCombinationSetByReportDataSet(List<ReportData> reportDataList) {
        return EvalDimensionCombination.getEvalDimensionCombinationSetByReportDataSet(reportDataList, null);
    }

    public static Set<EvalDimensionCombination> getEvalDimensionCombinationSetByReportDataSet(List<ReportData> reportDataList, ReportTemplate template) {
        if (EmptyUtil.isEmpty(reportDataList)) {
            return Collections.emptySet();
        }
        HashSet<EvalDimensionCombination> evalDimensionCombinationSet = new HashSet<EvalDimensionCombination>(reportDataList.size());
        for (ReportData reportData : reportDataList) {
            evalDimensionCombinationSet.add(EvalDimensionCombination.getEvalDimensionCombinationByReportData(reportData, template));
        }
        return evalDimensionCombinationSet;
    }

    public String getUniqueKey() {
        this.freeze();
        return this.evalDimensionValList.stream().map(EvalDimensionVal::getValue).map(Object::toString).filter(StringUtils::isNotEmpty).collect(Collectors.joining("_"));
    }

    public boolean contains(EvalDimensionCombination evalDimensionCombination) {
        List<EvalDimensionVal> evalDimensionValList = evalDimensionCombination.getEvalDimensionValList();
        return this.evalDimensionValList.containsAll(evalDimensionValList);
    }
}

