/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.model.sumplan;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.report.Report;

public class MainSubReport
implements Serializable {
    private Report mainReport;
    private List<Report> childReports;

    public MainSubReport() {
    }

    public MainSubReport(Report mainReport) {
        this(mainReport, new ArrayList<Report>(6));
    }

    public MainSubReport(Report mainReport, List<Report> childReports) {
        this.mainReport = mainReport;
        this.childReports = childReports;
    }

    public Report getMainReport() {
        return this.mainReport;
    }

    public void setMainReport(Report mainReport) {
        this.mainReport = mainReport;
    }

    public List<Report> getChildReports() {
        return this.childReports;
    }

    public void setChildReports(List<Report> childReports) {
        this.childReports = childReports;
    }

    public void addChildReport(Report childReport) {
        this.addChildReport(Collections.singletonList(childReport));
    }

    public void addChildReport(List<Report> childReportList) {
        if (EmptyUtil.isEmpty(childReportList)) {
            return;
        }
        if (Objects.isNull(this.childReports)) {
            this.childReports = new ArrayList<Report>(8);
        }
        this.childReports.addAll(childReportList);
    }

    public Set<Long> getReportIds() {
        HashSet<Long> reportIds = new HashSet<Long>(16);
        reportIds.add(this.mainReport.getId());
        if (EmptyUtil.isEmpty(this.childReports)) {
            return reportIds;
        }
        reportIds.addAll(this.childReports.stream().map(Report::getId).collect(Collectors.toSet()));
        return reportIds;
    }
}

