/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.model.sumplan;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.index.generate.QueryIndexInfoMapGenerator;
import kd.tmc.fpm.business.domain.model.index.generate.bean.QueryIndexInfo;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.report.SumPlanHeader;
import kd.tmc.fpm.business.domain.model.sumplan.ApprovedAmountRecord;
import kd.tmc.fpm.business.domain.model.sumplan.InnerCancelRecord;

public class SumPlanInfo {
    private DimMember sumOrgMember;
    private Report report;
    private QueryIndexInfo<Long, ReportData> queryIndexInfo;
    private FundPlanSystem system;
    private ApprovedAmountRecord approvedAmountRecord;
    private List<InnerCancelRecord> innerCancelRecordList;
    private SumPlanHeader sumPlanHeader;
    private List<ReportData> relationDataList;
    private Map<Long, Map<Long, BigDecimal>> currencyRateMap;

    public SumPlanInfo() {
    }

    public SumPlanInfo(DimMember sumOrgMember, Report report, FundPlanSystem system, ApprovedAmountRecord approvedAmountRecord, List<InnerCancelRecord> innerCancelRecordList, SumPlanHeader sumPlanHeader, List<ReportData> relationDataList, Map<Long, Map<Long, BigDecimal>> currencyRateMap) {
        this.sumOrgMember = sumOrgMember;
        this.report = report;
        this.system = system;
        this.approvedAmountRecord = approvedAmountRecord;
        this.innerCancelRecordList = innerCancelRecordList;
        this.sumPlanHeader = sumPlanHeader;
        this.relationDataList = relationDataList;
        this.currencyRateMap = currencyRateMap;
    }

    public DimMember getSumOrgMember() {
        return this.sumOrgMember;
    }

    public void setSumOrgMember(DimMember sumOrgMember) {
        this.sumOrgMember = sumOrgMember;
    }

    public QueryIndexInfo<Long, ReportData> getQueryIndexInfo() {
        if (Objects.isNull(this.queryIndexInfo)) {
            this.queryIndexInfo = QueryIndexInfoMapGenerator.buildReportDataIndex(this.report.getReportDataList(), this.system, rd -> !rd.isAuxiliaryInfo());
        }
        return this.queryIndexInfo;
    }

    public void setQueryIndexInfo(QueryIndexInfo<Long, ReportData> queryIndexInfo) {
        this.queryIndexInfo = queryIndexInfo;
    }

    public FundPlanSystem getSystem() {
        return this.system;
    }

    public void setSystem(FundPlanSystem system) {
        this.system = system;
    }

    public ApprovedAmountRecord getApprovedAmountRecord() {
        return this.approvedAmountRecord;
    }

    public void setApprovedAmountRecord(ApprovedAmountRecord approvedAmountRecord) {
        this.approvedAmountRecord = approvedAmountRecord;
    }

    public List<InnerCancelRecord> getInnerCancelRecordList() {
        return this.innerCancelRecordList;
    }

    public void setInnerCancelRecordList(List<InnerCancelRecord> innerCancelRecordList) {
        this.innerCancelRecordList = innerCancelRecordList;
    }

    public SumPlanHeader getSumPlanHeader() {
        return this.sumPlanHeader;
    }

    public void setSumPlanHeader(SumPlanHeader sumPlanHeader) {
        this.sumPlanHeader = sumPlanHeader;
    }

    public Report getReport() {
        return this.report;
    }

    public void setReport(Report report) {
        this.report = report;
    }

    public List<ReportData> getRelationDataList() {
        return this.relationDataList;
    }

    public void setRelationDataList(List<ReportData> relationDataList) {
        this.relationDataList = relationDataList;
    }

    public Map<Long, Map<Long, BigDecimal>> getCurrencyRateMap() {
        if (Objects.isNull(this.currencyRateMap)) {
            this.currencyRateMap = new HashMap<Long, Map<Long, BigDecimal>>(2);
        }
        return this.currencyRateMap;
    }

    public void setCurrencyRateMap(Map<Long, Map<Long, BigDecimal>> currencyRateMap) {
        this.currencyRateMap = currencyRateMap;
    }

    public void rebuildIndex() {
        this.queryIndexInfo = QueryIndexInfoMapGenerator.buildReportDataIndex(this.report.getReportDataList(), this.system, rd -> !rd.isAuxiliaryInfo());
    }

    public static SumPlanInfoBuilder builder() {
        return new SumPlanInfoBuilder();
    }

    public static class SumPlanInfoBuilder {
        private DimMember sumOrgMember;
        private Report report;
        private FundPlanSystem system;
        private ApprovedAmountRecord approvedAmountRecord;
        private List<InnerCancelRecord> innerCancelRecordList;
        private SumPlanHeader sumPlanHeader;
        private List<ReportData> relationDataList;
        private Map<Long, Map<Long, BigDecimal>> currencyRateMap;

        public SumPlanInfoBuilder sumOrgMember(DimMember sumOrgMember) {
            this.sumOrgMember = sumOrgMember;
            return this;
        }

        public SumPlanInfoBuilder report(Report report) {
            this.report = report;
            return this;
        }

        public SumPlanInfoBuilder system(FundPlanSystem system) {
            this.system = system;
            return this;
        }

        public SumPlanInfoBuilder approvedAmountRecord(ApprovedAmountRecord approvedAmountRecord) {
            this.approvedAmountRecord = approvedAmountRecord;
            return this;
        }

        public SumPlanInfoBuilder innerCancelRecordList(List<InnerCancelRecord> innerCancelRecordList) {
            this.innerCancelRecordList = innerCancelRecordList;
            return this;
        }

        public SumPlanInfoBuilder sumPlanHeader(SumPlanHeader sumPlanHeader) {
            this.sumPlanHeader = sumPlanHeader;
            return this;
        }

        public SumPlanInfoBuilder relationDataList(List<ReportData> relationDataList) {
            this.relationDataList = relationDataList;
            return this;
        }

        public SumPlanInfoBuilder currencyRateMap(Map<Long, Map<Long, BigDecimal>> currencyRateMap) {
            this.currencyRateMap = currencyRateMap;
            return this;
        }

        public SumPlanInfo build() {
            return new SumPlanInfo(this.sumOrgMember, this.report, this.system, this.approvedAmountRecord, this.innerCancelRecordList, this.sumPlanHeader, this.relationDataList, this.currencyRateMap);
        }
    }
}

