/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.model.task;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.TaskStatus;

public class TaskRecord
implements Serializable {
    private Long id;
    private String name;
    private Integer taskNum;
    private String taskType;
    private String status;
    private String taskInfo;
    private String errorMsg;
    private String groupId;
    private Date createTime;
    private Long objectId;
    private String objectEntityNumber;
    private String actExecuteTraceId;
    private Long executeTaskId;
    private int retry;
    private boolean ignore;

    public TaskRecord() {
    }

    public TaskRecord(Long id, String name, Integer taskNum, String taskType, String status, String taskInfo, String errorMsg, String groupId, Date createTime, Long objectId, String objectEntityNumber) {
        this.id = id;
        this.name = name;
        this.taskNum = taskNum;
        this.taskType = taskType;
        this.status = status;
        this.taskInfo = taskInfo;
        this.errorMsg = errorMsg;
        this.groupId = groupId;
        this.createTime = createTime;
        this.objectId = objectId;
        this.objectEntityNumber = objectEntityNumber;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getTaskNum() {
        return this.taskNum;
    }

    public void setTaskNum(Integer taskNum) {
        this.taskNum = taskNum;
    }

    public String getTaskType() {
        return this.taskType;
    }

    public void setTaskType(String taskType) {
        this.taskType = taskType;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getTaskInfo() {
        return this.taskInfo;
    }

    public void setTaskInfo(String taskInfo) {
        this.taskInfo = taskInfo;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public Long getObjectId() {
        return this.objectId;
    }

    public void setObjectId(Long objectId) {
        this.objectId = objectId;
    }

    public String getObjectEntityNumber() {
        return this.objectEntityNumber;
    }

    public void setObjectEntityNumber(String objectEntityNumber) {
        this.objectEntityNumber = objectEntityNumber;
    }

    public String getActExecuteTraceId() {
        return this.actExecuteTraceId;
    }

    public void setActExecuteTraceId(String actExecuteTraceId) {
        this.actExecuteTraceId = actExecuteTraceId;
    }

    public Long getExecuteTaskId() {
        return this.executeTaskId;
    }

    public void setExecuteTaskId(Long executeTaskId) {
        this.executeTaskId = executeTaskId;
    }

    public int getRetry() {
        return this.retry;
    }

    public void setRetry(int retry) {
        this.retry = retry;
    }

    public void addRetry() {
        if (Objects.equals(this.status, TaskStatus.RETRYING.name())) {
            ++this.retry;
        }
    }

    public boolean isIgnore() {
        return this.ignore;
    }

    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    public Map<String, Object> getTaskParams() {
        if (EmptyUtil.isEmpty((String)this.taskInfo)) {
            return Collections.emptyMap();
        }
        return (Map)SerializationUtils.fromJsonString((String)this.taskInfo, HashMap.class);
    }

    public String toString() {
        return "TaskRecordDTO{id=" + this.id + ", name='" + this.name + '\'' + ", taskNum=" + this.taskNum + ", taskType='" + this.taskType + '\'' + ", status='" + this.status + '\'' + ", taskInfo='" + this.taskInfo + '\'' + ", objectId='" + this.objectId + '\'' + ", objectEntityNumber='" + this.objectEntityNumber + '\'' + '}';
    }

    public static TaskRecordBuilder builder() {
        return new TaskRecordBuilder();
    }

    public static class TaskRecordBuilder {
        private Long id;
        private String name;
        private int taskNum;
        private String taskType;
        private String status;
        private String taskInfo;
        private String errorMsg;
        private String groupId;
        private Date createTime;
        private Long objectId;
        private String objectEntityNumber;

        public TaskRecordBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public TaskRecordBuilder name(String name) {
            this.name = name;
            return this;
        }

        public TaskRecordBuilder taskNum(int taskNum) {
            this.taskNum = taskNum;
            return this;
        }

        public TaskRecordBuilder taskType(String taskType) {
            this.taskType = taskType;
            return this;
        }

        public TaskRecordBuilder status(String status) {
            this.status = status;
            return this;
        }

        public TaskRecordBuilder taskInfo(String taskInfo) {
            this.taskInfo = taskInfo;
            return this;
        }

        public TaskRecordBuilder errorMsg(String errorMsg) {
            this.errorMsg = errorMsg;
            return this;
        }

        public TaskRecordBuilder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public TaskRecordBuilder createTime(Date createTime) {
            this.createTime = createTime;
            return this;
        }

        public TaskRecordBuilder objectId(Long objectId) {
            this.objectId = objectId;
            return this;
        }

        public TaskRecordBuilder objectEntityNumber(String objectEntityNumber) {
            this.objectEntityNumber = objectEntityNumber;
            return this;
        }

        public TaskRecord build() {
            return new TaskRecord(this.id, this.name, this.taskNum, this.taskType, this.status, this.taskInfo, this.errorMsg, this.groupId, this.createTime, this.objectId, this.objectEntityNumber);
        }
    }
}

