/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.model.trace;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Set;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.FlowType;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;
import kd.tmc.fpm.business.utils.CommonUtils;

public class ControlTraceBroke {
    private Long billId;
    private String entityType;
    private Set<Long> reportOrgIds;
    private Set<FlowType> flowTypes;
    private boolean existRecord;
    private Long controlTraceId;
    private BigDecimal totalAmt = BigDecimal.ZERO;

    public ControlTraceBroke(BillBizInfo billBizInfo) {
        this.billId = billBizInfo.getBillId();
        this.entityType = billBizInfo.getEntityType();
        this.flowTypes = new HashSet<FlowType>(8);
        this.reportOrgIds = new HashSet<Long>(16);
    }

    public Long getBillId() {
        return this.billId;
    }

    public void setBillId(Long billId) {
        this.billId = billId;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    public Set<Long> getReportOrgIds() {
        return this.reportOrgIds;
    }

    public void setReportOrgIds(Set<Long> reportOrgIds) {
        this.reportOrgIds = reportOrgIds;
    }

    public Set<FlowType> getFlowTypes() {
        return this.flowTypes;
    }

    public void setFlowTypes(Set<FlowType> flowTypes) {
        this.flowTypes = flowTypes;
    }

    public boolean isExistRecord() {
        return this.existRecord;
    }

    public void setExistRecord(boolean existRecord) {
        this.existRecord = existRecord;
    }

    public Long getControlTraceId() {
        return this.controlTraceId;
    }

    public void setControlTraceId(Long controlTraceId) {
        this.controlTraceId = controlTraceId;
    }

    public void addReportOrgId(Long reportOrgId) {
        if (EmptyUtil.isEmpty((Long)reportOrgId)) {
            return;
        }
        this.reportOrgIds.add(reportOrgId);
    }

    public void addFlowType(FlowType flowType) {
        this.flowTypes.add(flowType);
    }

    public BigDecimal getTotalAmt() {
        return this.totalAmt;
    }

    public void setTotalAmt(BigDecimal totalAmt) {
        this.totalAmt = totalAmt;
    }

    public void addAmount(BigDecimal amount) {
        this.totalAmt = this.totalAmt.add(CommonUtils.getValueIfNull(amount));
    }
}

