/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.service;

import java.util.Objects;
import kd.tmc.fpm.business.domain.enums.AnalysisReportType;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.report.AnalyseReportQueryParam;
import kd.tmc.fpm.business.domain.model.report.AnalysisHeader;
import kd.tmc.fpm.business.domain.service.AnalysisReportDataBuildService;
import kd.tmc.fpm.business.domain.service.impl.AbstractAnalysisReportDataBuildService;
import kd.tmc.fpm.business.domain.service.impl.AnalysisReportDataDimensionCleanService;
import kd.tmc.fpm.business.domain.service.impl.AnalysisReportDataDimensionSumService;
import kd.tmc.fpm.business.domain.service.impl.AnalysisReportDataRebuildService;
import kd.tmc.fpm.business.domain.service.impl.LinkSearchAnalyseReportDataBuildServiceImpl;
import kd.tmc.fpm.business.domain.service.impl.MetricValueMapFillReportDataBuildService;
import kd.tmc.fpm.business.domain.service.impl.MultiAnalysisReportDataBuildServiceImpl;
import kd.tmc.fpm.business.domain.service.impl.PlanExecAnalysisReportDataBuildServiceImpl;
import kd.tmc.fpm.business.domain.service.impl.PositionAnalysisReportDataBuildServiceImpl;
import kd.tmc.fpm.business.domain.service.impl.SynthesisReportDataBuildServiceImpl;
import kd.tmc.fpm.business.spread.generator.actions.impl.MultiAnalysisNetInFlowReportDataService;
import kd.tmc.fpm.common.utils.FpmAssertUtil;

public class AnalysisReportDataBuildFactory {
    public static AnalysisReportDataBuildService getService(AnalysisReportType type, FundPlanSystem system, AnalysisHeader header) {
        if (Objects.isNull((Object)header.getAnalysisReportType())) {
            header.setAnalysisReportType(type);
        }
        return AnalysisReportDataBuildFactory.getService(system, header);
    }

    public static AnalysisReportDataBuildService getService(FundPlanSystem system, AnalysisHeader header) {
        AbstractAnalysisReportDataBuildService service = null;
        switch (header.getAnalysisReportType()) {
            case MULTI: {
                service = new MultiAnalysisReportDataBuildServiceImpl(header, system).wrapperCast(AnalysisReportDataDimensionCleanService.class).addSumDimension(system.getMainDimensionByDimType(DimensionType.SUBJECTS).getId()).wrapper(AnalysisReportDataRebuildService.class).wrapperCast(AnalysisReportDataDimensionSumService.class).addSumDimension(system.getMainDimensionByDimType(DimensionType.ORG).getId()).wrapper(MultiAnalysisNetInFlowReportDataService.class);
                break;
            }
            case POSITION: {
                service = new PositionAnalysisReportDataBuildServiceImpl(header, system).wrapperCast(AnalysisReportDataDimensionCleanService.class).addSumDimension(system.getMainDimensionByDimType(DimensionType.ORG).getId()).wrapper(AnalysisReportDataRebuildService.class).wrapperCast(AnalysisReportDataDimensionSumService.class).addSumDimension(system.getMainDimensionByDimType(DimensionType.SUBJECTS).getId());
                break;
            }
            case PLANEXECANALYS: {
                service = new PlanExecAnalysisReportDataBuildServiceImpl(header, system).wrapper(AnalysisReportDataRebuildService.class).wrapperCast(AnalysisReportDataDimensionSumService.class).addSumDimension(system.getMainDimensionByDimType(DimensionType.ORG).getId()).wrapper(MetricValueMapFillReportDataBuildService.class);
                break;
            }
            case SYNTHESIS: {
                service = new SynthesisReportDataBuildServiceImpl(header, system).wrapper(AnalysisReportDataRebuildService.class).wrapperCast(AnalysisReportDataDimensionSumService.class).addSumDimension(system.getMainDimensionByDimType(DimensionType.ORG).getId()).wrapperCast(AnalysisReportDataDimensionCleanService.class).addSumDimension(system.getMainDimensionByDimType(DimensionType.CURRENCY).getId()).addSumDimension(system.getMainDimensionByDimType(DimensionType.ORG).getId()).addSumDimension(system.getMainDimensionByDimType(DimensionType.PERIOD).getId()).wrapper(MetricValueMapFillReportDataBuildService.class);
                break;
            }
            case LINK_SEARCH_ANALYSE: {
                AnalyseReportQueryParam queryParam = new AnalyseReportQueryParam();
                queryParam.setSystem(system);
                queryParam.setAnalysisHeader(header);
                service = new LinkSearchAnalyseReportDataBuildServiceImpl(queryParam).wrapper(AnalysisReportDataRebuildService.class).wrapperCast(AnalysisReportDataDimensionSumService.class).addSumDimension(system.getMainDimensionByDimType(DimensionType.ORG).getId()).wrapperCast(AnalysisReportDataDimensionCleanService.class).addSumDimension(system.getMainDimensionByDimType(DimensionType.CURRENCY).getId()).addSumDimension(system.getMainDimensionByDimType(DimensionType.ORG).getId()).addSumDimension(system.getMainDimensionByDimType(DimensionType.PERIOD).getId()).wrapper(MetricValueMapFillReportDataBuildService.class);
                break;
            }
        }
        FpmAssertUtil.isNotNull(service, (String)"analyse service is null");
        return service;
    }
}

