/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.service.impl;

import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.AnalysisReportType;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.InternalOffsetStateType;
import kd.tmc.fpm.business.domain.enums.MemberType;
import kd.tmc.fpm.business.domain.enums.PeriodType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.ReportPeriodType;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.OrgMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.index.DimensionIndexTree;
import kd.tmc.fpm.business.domain.model.index.node.TreeNode;
import kd.tmc.fpm.business.domain.model.report.AnalysisHeader;
import kd.tmc.fpm.business.domain.model.report.AnalysisReport;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.sumplan.EvalDimensionCombination;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.domain.service.AnalysisReportDataBuildService;
import kd.tmc.fpm.business.domain.service.AnalysisReportDataService;
import kd.tmc.fpm.business.utils.CommonUtils;
import kd.tmc.fpm.common.enums.AmountUnitEnum;
import kd.tmc.fpm.common.helper.FpmGlobalConfigHelper;
import kd.tmc.fpm.common.utils.AmountUtil;
import kd.tmc.fpm.common.utils.NumberUtils;
import org.apache.commons.collections.CollectionUtils;

public abstract class AbstractAnalysisReportDataBuildService
implements AnalysisReportDataBuildService {
    protected static final Log logger = LogFactory.getLog(AbstractAnalysisReportDataBuildService.class);
    protected AnalysisHeader header;
    protected FundPlanSystem system;
    protected ReportTemplate analysisTemplate;
    protected AnalysisReport analysisReport;
    protected Map<Long, Long> subject2SubjectFlowMap;
    protected Long reportCurrency;
    protected Long reportCurrencyVirtualMemberId;
    protected Set<Long> queryAllDimensionIds;
    protected AbstractAnalysisReportDataBuildService abstractAnalysisReportDataBuildService;
    protected List<Dimension> summaryDimIdList;

    public AbstractAnalysisReportDataBuildService(AnalysisHeader header, FundPlanSystem system) {
        if (Objects.isNull(system)) {
            throw new KDBizException("system is null");
        }
        if (Objects.isNull(header)) {
            throw new KDBizException("AnalysisHeader is null");
        }
        this.header = header;
        this.system = system;
        this.subject2SubjectFlowMap = new HashMap<Long, Long>(64);
        this.queryAllDimensionIds = new HashSet<Long>(8);
        this.summaryDimIdList = new ArrayList<Dimension>(8);
    }

    public AbstractAnalysisReportDataBuildService(AbstractAnalysisReportDataBuildService abstractAnalysisReportDataBuildService) {
        this.abstractAnalysisReportDataBuildService = abstractAnalysisReportDataBuildService;
        this.header = abstractAnalysisReportDataBuildService.header;
        this.system = abstractAnalysisReportDataBuildService.system;
        this.subject2SubjectFlowMap = abstractAnalysisReportDataBuildService.subject2SubjectFlowMap;
        this.reportCurrency = abstractAnalysisReportDataBuildService.reportCurrency;
        this.reportCurrencyVirtualMemberId = abstractAnalysisReportDataBuildService.reportCurrencyVirtualMemberId;
        this.queryAllDimensionIds = abstractAnalysisReportDataBuildService.queryAllDimensionIds;
        this.summaryDimIdList = abstractAnalysisReportDataBuildService.summaryDimIdList;
    }

    protected AbstractAnalysisReportDataBuildService fillBack(AbstractAnalysisReportDataBuildService analysisReportDataBuildService) {
        this.analysisReport = analysisReportDataBuildService.analysisReport;
        this.analysisTemplate = analysisReportDataBuildService.analysisTemplate;
        this.reportCurrency = analysisReportDataBuildService.reportCurrency;
        this.reportCurrencyVirtualMemberId = analysisReportDataBuildService.reportCurrencyVirtualMemberId;
        return this;
    }

    @Override
    public AnalysisReport getAnalysisReport() {
        logger.info("headerInfo:{}", (Object)this.header);
        logger.info("\u6784\u5efa\u4f53\u7cfb");
        this.buildSystem();
        logger.info("\u6784\u5efa\u6a21\u677f");
        this.buildTemplate();
        logger.info("\u751f\u6210\u62a5\u8868");
        this.buildAnalysisReport();
        logger.info("\u91cd\u6784\u6570\u636e");
        this.rebuildData();
        this.afterReBuild();
        logger.info("\u5206\u6790\u8868\u67e5\u8be2\u5230\u7684\u6570\u636e\u96c6\u5927\u5c0f\uff1a{}", (Object)this.analysisReport.getReportDataList().size());
        return this.analysisReport;
    }

    protected void afterReBuild() {
        if (Objects.nonNull(this.abstractAnalysisReportDataBuildService)) {
            this.abstractAnalysisReportDataBuildService.afterReBuild();
        }
    }

    protected void buildSystem() {
        if (Objects.nonNull(this.abstractAnalysisReportDataBuildService)) {
            this.abstractAnalysisReportDataBuildService.buildSystem();
        }
    }

    protected void buildTemplate() {
        if (Objects.nonNull(this.abstractAnalysisReportDataBuildService)) {
            this.abstractAnalysisReportDataBuildService.buildTemplate();
            this.fillBack(this.abstractAnalysisReportDataBuildService);
        }
    }

    protected void buildAnalysisReport() {
        if (Objects.nonNull(this.abstractAnalysisReportDataBuildService)) {
            this.abstractAnalysisReportDataBuildService.buildAnalysisReport();
            this.fillBack(this.abstractAnalysisReportDataBuildService);
        }
        if (Objects.nonNull(this.analysisReport)) {
            return;
        }
        this.analysisReport = this.getAnalysisReportInstance();
        this.init();
    }

    protected void rebuildData() {
        if (Objects.nonNull(this.abstractAnalysisReportDataBuildService)) {
            this.abstractAnalysisReportDataBuildService.rebuildData();
            return;
        }
        if (this.needRemoveNotMaxVersionData()) {
            this.retainMaxVersionData();
        }
        this.doRebuildData(true);
    }

    protected void doRebuildData(boolean convertUnit) {
        logger.info("{}\u91cd\u6784\u6570\u636e\uff0c\u5e01\u79cd\u8f6c\u6362\uff1a{}", (Object)this.getClass().getName(), (Object)convertUnit);
        DimensionIndexTree indexTree = this.analysisReport.getIndexTree(this.system);
        List<TreeNode> leafList = indexTree.getLeafList();
        BiFunction<BigDecimal, String, BigDecimal> convertUnitFunction = this.getConvertUnitFunction(this.analysisTemplate.getAmountUnit().getNumber(), convertUnit);
        ArrayList<ReportData> reBuildReportData = new ArrayList<ReportData>(leafList.size());
        for (TreeNode treeNode : leafList) {
            List<Object> dataList = treeNode.getDataList();
            if (EmptyUtil.isEmpty(dataList)) continue;
            ReportData originalReportData = (ReportData)dataList.get(0);
            ReportData reportData = new ReportData(originalReportData);
            reportData.setId(originalReportData.getId());
            reportData.clearAmt();
            Consumer<ReportData> amtAddConsumer = this.getAmtAddConsumer(reportData, convertUnitFunction);
            dataList.stream().map(ReportData.class::cast).forEach(amtAddConsumer::accept);
            dataList.clear();
            dataList.add(reportData);
            reBuildReportData.add(reportData);
        }
        logger.info("{}\u91cd\u6784\u540e\u7684\u6570\u636e\u5927\u5c0f\uff1a{}", (Object)this.getClass().getName(), (Object)reBuildReportData.size());
        this.analysisReport.setReportDataList(reBuildReportData);
    }

    protected boolean needRemoveNotMaxVersionData() {
        return true;
    }

    protected Consumer<ReportData> getAmtAddConsumer(ReportData reportData, BiFunction<BigDecimal, String, BigDecimal> convertUnitFunction) {
        return data -> {
            String reportDataAmountUnit = data.getAmountUnit().getNumber();
            reportData.addPlanAmt((BigDecimal)convertUnitFunction.apply(data.getPlanAmt(), reportDataAmountUnit));
            if (InternalOffsetStateType.checkOffset(this.header.getInternalOffsetState())) {
                BigDecimal offsetAmt = CommonUtils.getValueIfNull(reportData.getOffsetAmt()).negate();
                reportData.addPlanAmt(offsetAmt);
                reportData.addOriginalPlanAmt(offsetAmt);
            }
            reportData.addActAmt((BigDecimal)convertUnitFunction.apply(data.getActAmt(), reportDataAmountUnit));
            reportData.addReportPlanAmt((BigDecimal)convertUnitFunction.apply(data.getReportPlanAmt(), reportDataAmountUnit));
            reportData.addOriginalPlanAmt((BigDecimal)convertUnitFunction.apply(data.getOriginalPlanAmt(), reportDataAmountUnit));
            reportData.addLockAmt((BigDecimal)convertUnitFunction.apply(data.getLockAmt(), reportDataAmountUnit));
            reportData.addPlanReferenceAmt((BigDecimal)convertUnitFunction.apply(data.getPlanReferenceAmt(), reportDataAmountUnit));
            reportData.getSourceIdList().add(data.getId());
        };
    }

    protected BiFunction<BigDecimal, String, BigDecimal> getConvertUnitFunction(String targetAmountUnit, boolean needConvert) {
        if (!needConvert) {
            return (originalAmt, sourceAmountUnit) -> originalAmt;
        }
        return (originalAmt, sourceAmountUnit) -> AmountUtil.convert((AmountUnitEnum)AmountUnitEnum.get((String)sourceAmountUnit), (AmountUnitEnum)AmountUnitEnum.get((String)targetAmountUnit), (BigDecimal)originalAmt);
    }

    protected void retainMaxVersionData() {
        logger.info("\u6eda\u52a8\u671f\u95f4\u53ef\u80fd\u5b58\u5728\u591a\u4e2a\u6570\u636e\u7248\u672c\uff0c\u5bf9\u6eda\u52a8\u671f\u95f4\u6570\u636e\u8fdb\u884c\u91cd\u6784\uff0c\u4fdd\u7559\u6700\u5927\u7248\u672c\u7684\u6eda\u52a8\u671f\u95f4\u6570\u636e start\uff0c\u6570\u636e\u603b\u5927\u5c0f\uff1a{}", (Object)this.analysisReport.getReportDataList().size());
        List<ReportData> reportDataList = this.analysisReport.getReportDataList();
        Set reportPeriodIds = reportDataList.stream().map(ReportData::getReportPeriodId).filter(i -> !NumberUtils.equalsZero((Long)i)).collect(Collectors.toSet());
        Dimension periodDimension = this.system.getMainDimensionByDimType(DimensionType.PERIOD);
        Map periodMemberMap = periodDimension.getAllDimMemberList().stream().filter(dimMember -> reportPeriodIds.contains(dimMember.getId())).map(PeriodMember.class::cast).collect(Collectors.toMap(DimMember::getId, Function.identity(), (a, b) -> a));
        Comparator comparator = (o1, o2) -> {
            Long reportPeriodIdFirst = o1.getReportPeriodId();
            Long reportPeriodIdSecond = o2.getReportPeriodId();
            PeriodMember periodMemberFirst = (PeriodMember)periodMemberMap.get(reportPeriodIdFirst);
            PeriodMember periodMemberSecond = (PeriodMember)periodMemberMap.get(reportPeriodIdSecond);
            if (periodMemberFirst.getStartDate().compareTo(periodMemberSecond.getStartDate()) >= 0) {
                return -1;
            }
            return 1;
        };
        Map<EvalDimensionCombination, List<ReportData>> combinationListMap = this.analysisReport.getAnalysisReportType() == AnalysisReportType.SYNTHESIS && this.analysisTemplate.getTemplateType().isDetail() ? reportDataList.stream().collect(Collectors.groupingBy(rd -> EvalDimensionCombination.getEvalDimensionCombinationWithDetailDim(rd, td -> true))) : reportDataList.stream().collect(Collectors.groupingBy(rd -> EvalDimensionCombination.getEvalDimensionCombinationByReportData(rd, td -> true)));
        for (Map.Entry<EvalDimensionCombination, List<ReportData>> entry : combinationListMap.entrySet()) {
            List<ReportData> dataList = entry.getValue();
            if (dataList.size() <= 1) continue;
            dataList.sort(comparator);
            ReportData rollData = new ReportData(dataList.get(0));
            rollData.clearAmt();
            for (ReportData reportData : dataList) {
                if (!Objects.equals(rollData.getReportPeriodId(), reportData.getReportPeriodId())) break;
                rollData.addPlanAmt(reportData.getPlanAmt());
                rollData.addReportPlanAmt(reportData.getReportPlanAmt());
                rollData.addOriginalPlanAmt(reportData.getOriginalPlanAmt());
                rollData.addPlanReferenceAmt(reportData.getPlanReferenceAmt());
                rollData.addLockAmt(reportData.getLockAmt());
                rollData.addActAmt(reportData.getActAmt());
            }
            dataList.clear();
            dataList.add(rollData);
        }
        this.analysisReport.setReportDataList(combinationListMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList()));
        logger.info("\u6eda\u52a8\u671f\u95f4\u6570\u636e\u7248\u672c\u91cd\u6784end\uff0c\u91cd\u6784\u540e\u7684\u6570\u636e\u5927\u5c0f\uff1a{}", (Object)this.analysisReport.getReportDataList().size());
    }

    protected AnalysisReport getAnalysisReportInstance() {
        return new AnalysisReport();
    }

    protected void init() {
        logger.info("\u521d\u59cb\u5316\u5206\u6790\u8868");
        Long reportPeriodId = this.header.getReportTypeId();
        ReportPeriodType reportPeriodType = this.system.getPeriodTypeByPeriodTypeId(reportPeriodId);
        this.analysisReport.setAnalysisReportType(this.header.getAnalysisReportType());
        this.analysisReport.setSystemId(this.system.getId());
        this.analysisReport.setTemplate(this.analysisTemplate);
        this.analysisReport.setReportPeriodType(reportPeriodType);
        this.analysisReport.setPeriodMemberList(this.getPeriodMemberList());
        this.analysisReport.setCompanyMemberList(this.getOrgMemberList());
        this.analysisReport.setName(this.analysisTemplate.getName());
        this.analysisReport.setInitFlag(false);
        this.analysisReport.setReportDataList(new ArrayList<ReportData>(128));
        this.analysisReport.setFlow(this.header.getFlow());
        this.analysisReport.setSubjectMapSubjectFlowDimMap(this.subject2SubjectFlowMap);
        if (!this.header.isContainDetailReportType()) {
            reportPeriodType.setDetailPeriodType(null);
        }
        AnalysisReportDataService analysisReportDataService = this.getAnalysisReportDataService();
        List<ReportData> reportDataList = analysisReportDataService.getReportDataList();
        this.analysisReport.setReportDataList(reportDataList);
        if (EmptyUtil.isNoEmpty((String)this.header.getDimType())) {
            Optional<Dimension> first = this.system.getMainDimList().stream().filter(dimension -> Objects.equals(dimension.getNumber(), this.header.getDimType())).findFirst();
            first.ifPresent(dimension -> this.analysisReport.setStatisticsDim(dimension.getId()));
        }
        logger.info("\u521d\u59cb\u5316\u6c47\u7387");
        this.initExchangeRate();
    }

    protected List<OrgMember> getOrgMemberList() {
        Dimension orgDim = this.system.getMainDimensionByDimType(DimensionType.ORG);
        List<OrgMember> orgMemberList = orgDim.getMemberList(OrgMember.class);
        ArrayList<OrgMember> reportOrgMemberList = new ArrayList<OrgMember>(10);
        reportOrgMemberList.addAll(orgMemberList);
        for (OrgMember orgMember : orgMemberList) {
            List<DimMember> allChildMember = orgMember.getAllChildMember();
            List allOrgChildMember = allChildMember.stream().map(item -> (OrgMember)item).collect(Collectors.toList());
            reportOrgMemberList.addAll(allOrgChildMember);
        }
        return reportOrgMemberList;
    }

    protected List<PeriodMember> getPeriodMemberList() {
        Long reportPeriodId = this.header.getReportTypeId();
        ReportPeriodType reportPeriodType = this.system.getPeriodTypeByPeriodTypeId(reportPeriodId);
        if (reportPeriodType == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e2d\u672a\u67e5\u8be2\u5230\u7f16\u62a5\u7c7b\u578b", (String)"AbstractAnalysisReportDataBuildService_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        PeriodType periodType = reportPeriodType.getPeriodType();
        Dimension periodDim = this.system.getMainDimensionByDimType(DimensionType.PERIOD);
        List<PeriodMember> periodList = periodDim.getMemberList(PeriodMember.class);
        ArrayList<PeriodMember> reportPeriodMemList = new ArrayList<PeriodMember>();
        for (PeriodMember periodMember : periodList) {
            reportPeriodMemList.addAll(periodMember.getChildMemberByPeriodTypeAndPeriodId(periodType, reportPeriodType.getReportPeriodId()));
            if (PeriodType.MONTH_WEEK != periodType) continue;
            reportPeriodMemList.addAll(periodMember.getChildMemberByPeriodTypeAndPeriodId(PeriodType.YEAR_WEEK, reportPeriodType.getReportPeriodId()));
        }
        List<Long> periodId = this.header.getPeriodId();
        return reportPeriodMemList.stream().filter(p -> periodId.contains(p.getId())).collect(Collectors.toList());
    }

    protected void initExchangeRate() {
        this.initExchangeTableInfo();
        Long exchangeRateTableId = this.analysisReport.getExchangeRateTableId();
        Long reportCurrency = this.header.getReportCurrency();
        if (EmptyUtil.isEmpty((Long)exchangeRateTableId) || Objects.isNull(reportCurrency)) {
            return;
        }
        this.analysisReport.setReportCurrency(reportCurrency);
        if (Objects.isNull(this.analysisReport.getExchangeRateDate())) {
            this.analysisReport.setExchangeRateDate(DateUtils.getCurrentDate());
        }
        String currencySelectFields = String.join((CharSequence)",", "id", "sourceid", "name", "number");
        DynamicObject targetCurrency = QueryServiceHelper.queryOne((String)"fpm_member", (String)currencySelectFields, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)reportCurrency)});
        StringBuilder reportCurrencyInfo = new StringBuilder();
        reportCurrencyInfo.append(targetCurrency.getString("name")).append("\u3010").append(targetCurrency.getString("number")).append("\u3011");
        QFilter currencyFilter = new QFilter("bodysystem", "=", (Object)this.system.getId()).and("dimtype", "=", (Object)DimensionType.CURRENCY.getNumber());
        if (!CollectionUtils.isEmpty(this.header.getCurrency())) {
            currencyFilter.and("id", "in", this.header.getCurrency());
        }
        DynamicObjectCollection currencyRanges = QueryServiceHelper.query((String)"fpm_member", (String)currencySelectFields, (QFilter[])new QFilter[]{currencyFilter});
        StringBuilder errorCurrencyInfo = new StringBuilder();
        for (DynamicObject currencyRange : currencyRanges) {
            Long sourceCurrencyId = currencyRange.getLong("id");
            if (Objects.equals(sourceCurrencyId, this.analysisReport.getReportCurrency())) {
                this.analysisReport.addExchangeRate(sourceCurrencyId, BigDecimal.ONE);
                continue;
            }
            sourceCurrencyId = currencyRange.getLong("sourceid");
            BigDecimal exchangeValue = BaseDataServiceHelper.getExchangeRate((Long)exchangeRateTableId, (Long)sourceCurrencyId, (Long)targetCurrency.getLong("sourceid"), (Date)this.analysisReport.getExchangeRateDate());
            if (Objects.isNull(exchangeValue)) {
                errorCurrencyInfo.append(currencyRange.getString("name")).append("\u3010").append(currencyRange.getString("number")).append("\u3011").append("\u3001");
                continue;
            }
            this.analysisReport.addExchangeRate(sourceCurrencyId, exchangeValue);
        }
    }

    protected void initExchangeTableInfo() {
        QFilter exQFilter = new QFilter("bodysys", "=", (Object)this.system.getId()).and(String.join((CharSequence)".", "reportperiod", "id"), "in", this.header.getPeriodId()).and(String.join((CharSequence)".", "maindimentry", "maintable"), "=", (Object)"1").and(String.join((CharSequence)".", "maindimentry", "effectflag"), "=", (Object)"1");
        DynamicObject exchangeRate = QueryServiceHelper.queryOne((String)"fpm_report", (String)"id,exratetable.id,exchangeratedate,maindimentry.version", (QFilter[])new QFilter[]{exQFilter});
        if (Objects.isNull(exchangeRate)) {
            QFilter qFilter = new QFilter("bodysys", "=", (Object)this.system.getId());
            qFilter.and(String.join((CharSequence)".", "maindimentry", "periodmem", "id"), "in", this.header.getPeriodId());
            qFilter.and(String.join((CharSequence)".", "maindimentry", "maintable"), "=", (Object)"1");
            qFilter.and(String.join((CharSequence)".", "maindimentry", "effectflag"), "=", (Object)"1");
            DynamicObjectCollection exchangeRateCollection = QueryServiceHelper.query((String)"fpm_report", (String)"id,exratetable.id,exchangeratedate,maindimentry.version", (QFilter[])new QFilter[]{qFilter}, (String)"maindimentry.version desc");
            if (!CollectionUtils.isEmpty((Collection)exchangeRateCollection)) {
                exchangeRate = (DynamicObject)exchangeRateCollection.get(0);
            }
        }
        if (Objects.isNull(exchangeRate)) {
            logger.warn("\u67e5\u8be2\u4e0d\u5230\u6c47\u7387\uff0c\u53ef\u80fd\u65e0\u5df2\u751f\u6548\u7684\u6570\u636e");
            return;
        }
        this.analysisReport.setExchangeRateTableId(exchangeRate.getLong("exratetable.id"));
        this.analysisReport.setExchangeRateDate(exchangeRate.getDate("exchangeratedate"));
    }

    protected void rebuildMemberLevel(List<DimMember> memberList, int level) {
        if (CollectionUtils.isEmpty(memberList)) {
            return;
        }
        for (DimMember dimMember : memberList) {
            List<DimMember> children = dimMember.getChildren();
            dimMember.setLevel(level);
            this.rebuildMemberLevel(children, level + 1);
        }
    }

    protected void createReportCurrency() {
        logger.info("\u521b\u5efa\u62a5\u544a\u5e01\u6210\u5458start");
        List<Dimension> dimList = this.system.getDimList();
        Optional<Dimension> currencyDim = dimList.stream().filter(item -> item.getDimType() == DimensionType.CURRENCY).findFirst();
        if (!currencyDim.isPresent()) {
            return;
        }
        Optional<DimMember> reportCurrencyMem = currencyDim.get().getAllDimMemberList().stream().filter(item -> Objects.equals(this.header.getReportCurrency(), item.getId())).findFirst();
        if (!reportCurrencyMem.isPresent()) {
            return;
        }
        DimMember reportCurrencyDimMember = reportCurrencyMem.get();
        long memberId = DB.genGlobalLongId();
        DimMember inDimMember = new DimMember();
        inDimMember.setId(memberId);
        inDimMember.setNumber(reportCurrencyDimMember.getNumber());
        inDimMember.setLongNumber(reportCurrencyDimMember.getLongNumber());
        inDimMember.setSortCode("0000");
        inDimMember.setName(String.format(ResManager.loadKDString((String)"%1$s\uff08\u62a5\u544a\u5e01\uff09", (String)"AbstractAnalysisReportDataBuildService_2", (String)"tmc-fpm-business", (Object[])new Object[0]), reportCurrencyDimMember.getName()));
        inDimMember.setMemberType(MemberType.DIM_MEMBER);
        inDimMember.setSourceId(reportCurrencyDimMember.getSourceId());
        List<DimMember> tMemberList = currencyDim.get().getMemberList();
        inDimMember.setDimensionId(currencyDim.get().getId());
        inDimMember.setEnable(true);
        tMemberList.add(inDimMember);
        currencyDim.get().setMemberList(tMemberList);
        this.reportCurrencyVirtualMemberId = memberId;
        this.reportCurrency = this.header.getReportCurrency();
        logger.info("\u521b\u5efa\u62a5\u544a\u5e01\u6210\u5458end,\u521b\u5efa\u51fa\u7684\u62a5\u544a\u5e01\u6210\u5458\uff1a{}\uff0c\u5bf9\u5e94\u7684\u771f\u5b9e\u6210\u5458id\uff1a{}", (Object)this.reportCurrencyVirtualMemberId, (Object)this.reportCurrency);
    }

    protected boolean isStatisticsDim(Dimension dimension) {
        DimensionType dimType = dimension.getDimType();
        if (Objects.equals(dimType.getNumber(), this.header.getDimType())) {
            return true;
        }
        if (!this.header.getCustomDimension().containsKey(this.header.getDimType())) {
            return Objects.equals(dimension.getNumber(), this.header.getDimType());
        }
        return dimension.getDimType().isCustomDim();
    }

    protected void addAllMemberIfNeed(TemplateDim templateDim) {
        if (EmptyUtil.isNoEmpty(templateDim.getMemberScope())) {
            if (templateDim.getDimType().isCurrencyDim() && this.reportCurrencyVirtualMemberId != null) {
                templateDim.getMemberScope().add(this.reportCurrencyVirtualMemberId);
            }
            return;
        }
        Dimension dimension = this.system.getMainDimensionByDimensionId(templateDim.getDimensionId());
        templateDim.setMemberScope(dimension.getAllDimMemberList().stream().filter(DimMember::isEnable).map(DimMember::getId).collect(Collectors.toList()));
        this.queryAllDimensionIds.add(templateDim.getDimensionId());
        logger.info("\u7ef4\u5ea6\uff1a{}\uff0c\u6ca1\u6709\u4f20\u5165\u6210\u5458\u8303\u56f4\uff0c\u6dfb\u52a0\u6240\u6709\u6210\u5458", (Object)dimension.getName());
    }

    protected DimMember getCurrOrgParent(DimMember accountMember, List<DimMember> flowAccountMemList) {
        DimMember parent = accountMember.getParent();
        if (parent != null && !flowAccountMemList.contains(parent)) {
            return this.getCurrOrgParent(parent, flowAccountMemList);
        }
        return parent;
    }

    protected boolean isFromMultiDim() {
        return FpmGlobalConfigHelper.getBooleanConfigByKey((String)"startmutilquery");
    }

    AnalysisReportDataService getAnalysisReportDataService() {
        if (Objects.nonNull(this.abstractAnalysisReportDataBuildService)) {
            return this.abstractAnalysisReportDataBuildService.getAnalysisReportDataService();
        }
        return Collections::emptyList;
    }

    public AbstractAnalysisReportDataBuildService wrapper(Class<? extends AbstractAnalysisReportDataBuildService> clazz) {
        try {
            Constructor<? extends AbstractAnalysisReportDataBuildService> declaredConstructor = clazz.getDeclaredConstructor(AbstractAnalysisReportDataBuildService.class);
            return declaredConstructor.newInstance(this);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return this;
        }
    }

    public <T> T wrapperCast(Class<T> clazz) {
        return (T)this.wrapper(clazz);
    }
}

