/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.tmc.fpm.business.domain.enums.DimLocation;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.FlowType;
import kd.tmc.fpm.business.domain.enums.MemberType;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.enums.TemplateUseType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.AccountMember;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.report.AnalysisHeader;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.domain.model.template.TemplateLayout;
import kd.tmc.fpm.business.domain.service.impl.AbstractAnalysisReportDataBuildService;
import kd.tmc.fpm.business.utils.CommonUtils;
import kd.tmc.fpm.common.enums.FlowEnum;

public class AbstractVirtualTemplateAnalysisReportDataBuildService
extends AbstractAnalysisReportDataBuildService {
    public AbstractVirtualTemplateAnalysisReportDataBuildService(AnalysisHeader header, FundPlanSystem system) {
        super(header, system);
    }

    @Override
    protected void buildTemplate() {
        super.buildTemplate();
        if (Objects.nonNull(this.analysisTemplate)) {
            return;
        }
        logger.info("\u521b\u5efa\u865a\u62df\u6a21\u677f");
        this.analysisTemplate = new ReportTemplate();
        this.analysisTemplate.setTemplateUse(TemplateUseType.STATISTIC);
        this.analysisTemplate.setTemplateType(TemplateType.FIXED);
        this.analysisTemplate.setAmountUnit(this.header.getAmountUnit());
        TemplateLayout templateLayout = new TemplateLayout();
        templateLayout.setDimLayoutInfoList(new ArrayList<TemplateLayout.LayoutInfo>(16));
        templateLayout.setTemplateType(this.analysisTemplate.getTemplateType());
        this.analysisTemplate.setDimLayout(templateLayout);
        this.analysisTemplate.setPageDimList(new ArrayList<TemplateDim>(4));
        this.analysisTemplate.setColDimList(new ArrayList<TemplateDim>(4));
        this.analysisTemplate.setRowDimList(new ArrayList<TemplateDim>(4));
    }

    protected void createViAccountDim() {
        logger.info("\u521b\u5efa\u79d1\u76ee\u7c7b\u578b\u865a\u62df\u7ef4\u5ea6");
        Dimension viSubjectDim = this.createSubjectFlowDim();
        List<Dimension> dimList = this.system.getDimList();
        Optional<Dimension> subjectOptional = dimList.stream().filter(item -> item.getDimType().isSubjectDim()).findFirst();
        if (!subjectOptional.isPresent()) {
            return;
        }
        List<DimMember> memberList = viSubjectDim.getMemberList();
        Map virtualSubjectFlowMemberMap = memberList.stream().collect(Collectors.toMap(DimMember::getNumber, Function.identity(), (a, b) -> a));
        Dimension subject = subjectOptional.get();
        List subjectMemberList = subject.getAllDimMemberList().stream().map(AccountMember.class::cast).collect(Collectors.toList());
        for (AccountMember subjectMember : subjectMemberList) {
            FlowType flowType = subjectMember.getFlowType();
            DimMember virtualSubjectFlowMember = (DimMember)virtualSubjectFlowMemberMap.get(flowType.getNumber());
            if (Objects.isNull(virtualSubjectFlowMember)) continue;
            this.subject2SubjectFlowMap.putIfAbsent(subjectMember.getId(), virtualSubjectFlowMember.getId());
        }
        dimList.add(viSubjectDim);
        logger.info("\u521b\u5efa\u51fa\u7684\u7c7b\u578b\u6d41\u5411\u865a\u62df\u7ef4\u5ea6id:{}\uff0c\u5bf9\u5e94\u7684\u6210\u5458\u8303\u56f4\uff1a{}", (Object)viSubjectDim.getId(), memberList);
    }

    private Dimension createSubjectFlowDim() {
        logger.info("\u521b\u5efa\u79d1\u76ee\u6d41\u5411\u865a\u62df\u7ef4\u5ea6");
        long dimId = DB.genGlobalLongId();
        Dimension viSubjectDim = new Dimension();
        viSubjectDim.setId(dimId);
        viSubjectDim.setDimType(DimensionType.ACCOUNTTYPE);
        viSubjectDim.setName(ResManager.loadKDString((String)"\u79d1\u76ee\u6d41\u5411", (String)"AbstractVirtualTemplateAnalysisReportDataBuildService_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
        viSubjectDim.setVisible(true);
        viSubjectDim.setNumber(DimensionType.ACCOUNTTYPE.getNumber());
        viSubjectDim.setShrekKey(viSubjectDim.getNumber());
        this.fillMember(viSubjectDim);
        logger.info("\u521b\u5efa\u51fa\u7684\u79d1\u76ee\u6d41\u5411\u7ef4\u5ea6id\uff1a{}\uff0c\u6210\u5458\u8303\u56f4\uff1a{}", (Object)viSubjectDim.getId(), viSubjectDim.getMemberList());
        return viSubjectDim;
    }

    private void fillMember(Dimension viSubjectDim) {
        FlowEnum[] values = FlowEnum.values();
        ArrayList<DimMember> memberList = new ArrayList<DimMember>(values.length);
        Deque<Long> deque = CommonUtils.batchGenerateIds(values.length);
        for (FlowEnum flowEnum : values) {
            DimMember inDimMember = new DimMember();
            inDimMember.setId(deque.poll());
            inDimMember.setNumber(flowEnum.getValue());
            inDimMember.setLongNumber(flowEnum.getValue());
            inDimMember.setSortCode(flowEnum.getValue());
            inDimMember.setName(flowEnum.getName());
            inDimMember.setMemberType(MemberType.DIM_MEMBER);
            inDimMember.setShrekKey(flowEnum.getValue());
            inDimMember.setDimensionId(viSubjectDim.getId());
            memberList.add(inDimMember);
        }
        viSubjectDim.setMemberList(memberList);
    }

    protected void addTemplateDim2TemplateInfo(Dimension dimension, TemplateDim templateDim) {
        TemplateLayout.LayoutInfo layoutInfo = new TemplateLayout.LayoutInfo();
        layoutInfo.setDimensionId(dimension.getId());
        this.fillLayoutInfo(templateDim, layoutInfo);
        this.analysisTemplate.getDimLayout().getDimLayoutInfoList().add(layoutInfo);
        if (Objects.isNull((Object)templateDim.getLocation())) {
            return;
        }
        switch (templateDim.getLocation()) {
            case ROW: {
                this.analysisTemplate.getRowDimList().add(templateDim);
                break;
            }
            case PAGE: {
                this.analysisTemplate.getPageDimList().add(templateDim);
                break;
            }
            case COL: {
                this.analysisTemplate.getColDimList().add(templateDim);
            }
        }
    }

    protected void fillLayoutInfo(TemplateDim templateDim, TemplateLayout.LayoutInfo layoutInfo) {
        layoutInfo.setLevel(templateDim.getLevel());
        layoutInfo.setDimLocation(templateDim.getLocation());
        layoutInfo.setVisible(templateDim.isVisible());
    }

    protected void fillVirtualSubjectFlowMemberScope(Dimension dimension, TemplateDim templateDim, Predicate<DimMember> filter) {
        List<DimMember> memberList = dimension.getMemberList();
        if (!FlowType.isNonLimit(this.header.getFlow())) {
            List<Long> memberScope = memberList.stream().filter(item -> Objects.equals(item.getNumber(), this.header.getFlow())).map(DimMember::getId).collect(Collectors.toList());
            templateDim.setMemberScope(memberScope);
            return;
        }
        List<Long> memberScope = memberList.stream().filter(filter::test).map(DimMember::getId).collect(Collectors.toList());
        templateDim.setMemberScope(memberScope);
    }

    protected void setStatisticsDimOrPage(Dimension dimension, TemplateDim templateDim) {
        DimensionType dimType = dimension.getDimType();
        templateDim.setLocation(DimLocation.ROW);
        templateDim.setLevel(1);
        switch (dimType) {
            case COMPANY: {
                templateDim.setMemberScope(this.header.getCompany());
                break;
            }
            case SETTLEMENT_TYPE: {
                templateDim.setMemberScope(this.header.getSettlementMethod());
                break;
            }
            case CUSTOM: {
                List<Long> memberScope = this.header.getCustomDimension().getOrDefault(dimension.getNumber(), Collections.emptyList());
                templateDim.setMemberScope(memberScope);
                break;
            }
        }
        if (!this.isStatisticsDim(dimension)) {
            templateDim.setLevel(1);
            templateDim.setLocation(DimLocation.PAGE);
        }
    }
}

