/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.service.impl;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.report.AnalysisReport;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.domain.service.IVirtualDimMemberProcessService;

public class AccountTypeDimProcessServiceImpl
implements IVirtualDimMemberProcessService {
    private AnalysisReport analysisReport;
    private ReportTemplate reportTemplate;

    public AccountTypeDimProcessServiceImpl(AnalysisReport analysisReport) {
        this.analysisReport = analysisReport;
        this.reportTemplate = analysisReport.getTemplate();
    }

    @Override
    public void processVirtualDimMember(List<ReportData> reportDataList) {
        for (ReportData reportData : reportDataList) {
            Set pageDimIds = this.reportTemplate.getPageDimList().stream().map(TemplateDim::getDimensionId).collect(Collectors.toSet());
            Optional<TemplateDim> first = this.reportTemplate.getAllTemplateDim().stream().filter(td -> !pageDimIds.contains(td.getDimensionId())).filter(td -> td.getDimType() == DimensionType.ACCOUNTTYPE).findFirst();
            if (!first.isPresent()) continue;
            TemplateDim templateDim = first.get();
            List<TemplateDim> dimList = reportData.getDimList();
            List<Object> dataDimValList = reportData.getDimValList();
            Object subjectId = reportData.getDimValByDimType(DimensionType.SUBJECTS, null);
            Long subjectFlowId = this.analysisReport.getSubjectMapSubjectFlowDimMap().get(subjectId);
            if (EmptyUtil.isEmpty((Long)subjectFlowId)) continue;
            dimList.add(templateDim);
            dataDimValList.add(subjectFlowId);
        }
    }
}

