/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.tmc.fpm.business.domain.enums.PeriodType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.ReportPeriodType;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.report.AnalysisReport;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.domain.service.IDimensionMemberStrategy;

public class AnalysisPeriodMemberStrategy
implements IDimensionMemberStrategy {
    private AnalysisReport analysisReport;

    public AnalysisPeriodMemberStrategy(AnalysisReport analysisReport) {
        this.analysisReport = analysisReport;
    }

    @Override
    public List<?> getMemberScope(Dimension dimension, TemplateDim periodDim) {
        if (!dimension.getDimType().isPeriodDim()) {
            return null;
        }
        ReportPeriodType reportPeriodType = this.analysisReport.getReportPeriodType();
        PeriodType periodType = reportPeriodType.getPeriodType();
        ArrayList<PeriodMember> reportPeriodMemList = new ArrayList<PeriodMember>();
        List<PeriodMember> periodList = dimension.getMemberList(PeriodMember.class);
        for (PeriodMember periodMember : periodList) {
            reportPeriodMemList.addAll(periodMember.getChildMemberByPeriodTypeAndPeriodId(periodType, reportPeriodType.getReportPeriodId()));
            if (PeriodType.MONTH_WEEK != periodType) continue;
            reportPeriodMemList.addAll(periodMember.getChildMemberByPeriodTypeAndPeriodId(PeriodType.YEAR_WEEK, reportPeriodType.getReportPeriodId()));
        }
        List periodMemberList = reportPeriodMemList.stream().filter(item -> periodDim.getMemberScope().contains(item.getId())).collect(Collectors.toList());
        if (!this.analysisReport.isContainDetailReportType()) {
            return periodMemberList.stream().map(DimMember::getId).collect(Collectors.toList());
        }
        return periodMemberList.stream().map(DimMember::getAllChildMember).flatMap(Collection::stream).map(DimMember::getId).collect(Collectors.toList());
    }
}

