/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.service.impl;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.index.DimensionIndexTree;
import kd.tmc.fpm.business.domain.model.index.node.TreeNode;
import kd.tmc.fpm.business.domain.service.impl.AbstractAnalysisReportDataBuildService;
import kd.tmc.fpm.business.domain.service.impl.AnalysisReportDataDimensionSumService;
import kd.tmc.fpm.common.bean.DimensionInfoBean;

public class AnalysisReportDataDimensionCleanService
extends AnalysisReportDataDimensionSumService {
    public AnalysisReportDataDimensionCleanService(AbstractAnalysisReportDataBuildService abstractAnalysisReportDataBuildService) {
        super(abstractAnalysisReportDataBuildService);
    }

    @Override
    protected void rebuildData() {
        super.rebuildData();
        if (!this.analysisReport.needClean()) {
            return;
        }
        this.analysisReport.setNeedSum(true);
        this.analysisReport.rebuildTree(this.system);
        this.doRebuildData(false);
    }

    @Override
    public Consumer<TreeNode> getSumAction(Dimension orgDimension, Map<Long, DimMember> dimMemberMap) {
        Long orgDimensionId = orgDimension.getId();
        if (!this.analysisReport.needClean() || !this.analysisReport.getSumDimensionIds().contains(orgDimensionId)) {
            return t -> {};
        }
        DimensionIndexTree indexTree = this.analysisReport.getIndexTree(this.system);
        Map parentChildrenMap = dimMemberMap.values().stream().filter(dimMember -> EmptyUtil.isNoEmpty((Long)dimMember.getParentId())).collect(Collectors.groupingBy(DimMember::getParentId, Collectors.mapping(DimMember::getId, Collectors.toSet())));
        return treeNode -> {
            DimensionInfoBean dimInfoBean = treeNode.getDimInfoBean();
            Object memberId = dimInfoBean.getMemberByDimensionId(orgDimensionId);
            if (EmptyUtil.isEmpty((Object)memberId)) {
                return;
            }
            DimMember dimMember = (DimMember)dimMemberMap.get(memberId);
            if (Objects.isNull(dimMember)) {
                return;
            }
            if (!parentChildrenMap.containsKey(memberId)) {
                return;
            }
            List<Object> currentNodeDataList = treeNode.getDataList();
            if (EmptyUtil.isEmpty(currentNodeDataList)) {
                return;
            }
            this.clearData(orgDimensionId, indexTree, parentChildrenMap, (TreeNode)treeNode, dimInfoBean, memberId);
        };
    }

    private void clearData(Long orgDimensionId, DimensionIndexTree indexTree, Map<Long, Set<Long>> parentChildrenMap, TreeNode treeNode, DimensionInfoBean dimInfoBean, Object memberId) {
        Set<Long> childrenId = parentChildrenMap.get(memberId);
        if (EmptyUtil.isEmpty(childrenId)) {
            return;
        }
        DimensionInfoBean copy = dimInfoBean.copy();
        for (Long childId : childrenId) {
            List<Object> dataList;
            copy.replaceValueIfContains(orgDimensionId, (Object)childId);
            TreeNode orgLeafNode = indexTree.find(copy);
            this.clearData(orgDimensionId, indexTree, parentChildrenMap, orgLeafNode, dimInfoBean, childId);
            if (Objects.isNull(orgLeafNode) || EmptyUtil.isEmpty(dataList = orgLeafNode.getDataList())) continue;
            dataList.clear();
        }
    }
}

