/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.service.impl;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.member.MetricMember;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.service.impl.AbstractAnalysisReportDataBuildService;
import kd.tmc.fpm.business.utils.CommonUtils;
import kd.tmc.fpm.business.utils.MetricValueUtils;

public class MetricValueMapFillReportDataBuildService
extends AbstractAnalysisReportDataBuildService {
    public MetricValueMapFillReportDataBuildService(AbstractAnalysisReportDataBuildService abstractAnalysisReportDataBuildService) {
        super(abstractAnalysisReportDataBuildService);
    }

    @Override
    protected void rebuildData() {
        super.rebuildData();
        List<ReportData> reportDataList = this.analysisReport.getReportDataList();
        Dimension metricDimension = this.system.getMainDimensionByDimType(DimensionType.METRIC);
        List metricMemberList = metricDimension.getAllDimMemberList().stream().map(MetricMember.class::cast).filter(metricMember -> EmptyUtil.isNoEmpty((String)metricMember.getValStr())).collect(Collectors.toList());
        for (ReportData reportData : reportDataList) {
            MetricValueUtils.fillMetricValMap(reportData, this.analysisReport);
            if (EmptyUtil.isEmpty(metricMemberList)) continue;
            for (MetricMember metricMember2 : metricMemberList) {
                BigDecimal evalMetricValue = CommonUtils.getBigDecimalValue(MetricValueUtils.evalMetricValue(metricMember2.getValStr(), reportData));
                evalMetricValue = MetricValueUtils.transferScaleIfPercent(metricMember2.getDataType().isPercent(), evalMetricValue);
                reportData.putMetricVal(metricMember2.getId(), evalMetricValue);
            }
        }
    }
}

