/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimLocation;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.PeriodType;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.enums.TemplateUseType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.ReportPeriodType;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.report.AnalysisHeader;
import kd.tmc.fpm.business.domain.model.report.AnalysisReport;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.domain.model.template.TemplateLayout;
import kd.tmc.fpm.business.domain.service.AnalysisReportDataService;
import kd.tmc.fpm.business.domain.service.InnerCancelProcessServiceImpl;
import kd.tmc.fpm.business.domain.service.impl.AbstractVirtualTemplateAnalysisReportDataBuildService;
import kd.tmc.fpm.business.domain.service.impl.AccountTypeDimProcessServiceImpl;
import kd.tmc.fpm.business.domain.service.impl.AnalysisOrgMemberStrategy;
import kd.tmc.fpm.business.domain.service.impl.AnalysisPeriodMemberStrategy;
import kd.tmc.fpm.business.domain.service.impl.CommonDimMemberStrategy;
import kd.tmc.fpm.business.domain.service.impl.MultiAnalysisSubjectMemberStrategy;
import kd.tmc.fpm.business.domain.service.impl.RelationShrekAnalysisReportDataServiceAdapter;
import kd.tmc.fpm.common.enums.FlowEnum;
import org.apache.commons.collections.CollectionUtils;

public class MultiAnalysisReportDataBuildServiceImpl
extends AbstractVirtualTemplateAnalysisReportDataBuildService {
    public MultiAnalysisReportDataBuildServiceImpl(AnalysisHeader header, FundPlanSystem system) {
        super(header, system);
    }

    @Override
    public void buildSystem() {
        this.rebuildReportOrg();
        this.createReportCurrency();
        this.createViAccountDim();
    }

    private void rebuildReportOrg() {
        logger.info("\u91cd\u6784\u7f16\u62a5\u4e3b\u4f53");
        Dimension orgDim = this.system.getMainDimensionByDimType(DimensionType.ORG);
        List<DimMember> dimMemberList = orgDim.getAllDimMemberList();
        List<Long> orgList = this.header.getOrg();
        if (CollectionUtils.isNotEmpty(orgList)) {
            dimMemberList = dimMemberList.stream().filter(item -> orgList.contains(item.getId())).collect(Collectors.toList());
        }
        for (DimMember dimMember : dimMemberList) {
            DimMember currentTopOrg = this.getCurrOrgParent(dimMember, dimMemberList);
            dimMember.setParent(currentTopOrg);
            dimMember.setParentId(currentTopOrg == null ? null : currentTopOrg.getId());
        }
        List<DimMember> needRebuildLevelList = dimMemberList.stream().filter(item -> item.getParent() == null).collect(Collectors.toList());
        this.rebuildMemberLevel(needRebuildLevelList, 1);
        orgDim.setMemberList(dimMemberList.stream().filter(item -> item.getLevel() == 1).collect(Collectors.toList()));
    }

    @Override
    protected void buildTemplate() {
        super.buildTemplate();
        this.fillVirtualTemplateInfo();
        this.fillTemplateInfo();
    }

    @Override
    protected void buildAnalysisReport() {
        super.buildAnalysisReport();
    }

    private void fillTemplateInfo() {
        List<Dimension> mainDimList = this.system.getMainDimList();
        for (int i = 0; i < mainDimList.size(); ++i) {
            Dimension dimension = mainDimList.get(i);
            if (dimension.getDimType().isMetric() || EmptyUtil.isEmpty(dimension.getAllDimMemberList())) continue;
            if (dimension.getDimType().isPeriodDim()) {
                ReportPeriodType reportPeriodType = this.system.getPeriodTypeByPeriodTypeId(this.header.getReportTypeId());
                this.cleanDetailMemberIfNeed(this.header, reportPeriodType, dimension);
            }
            this.doFillTemplateInfo(dimension, i);
        }
    }

    private void cleanDetailMemberIfNeed(AnalysisHeader header, ReportPeriodType reportPeriodType, Dimension periodDimension) {
        if (header.isContainDetailReportType()) {
            return;
        }
        PeriodType detailPeriodType = reportPeriodType.getDetailPeriodType();
        if (Objects.isNull((Object)detailPeriodType)) {
            return;
        }
        List periodMemberList = periodDimension.getMemberList().stream().map(PeriodMember.class::cast).filter(periodMem -> Objects.equals(header.getReportTypeId(), periodMem.getPeriodTypeId())).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(periodMemberList)) {
            return;
        }
        for (PeriodMember periodMember : periodMemberList) {
            List<DimMember> allChildMemberList = periodMember.getAllChildMember();
            allChildMemberList.stream().map(PeriodMember.class::cast).filter(p -> p.getPeriodType() == detailPeriodType).map(DimMember::getParent).forEach(p -> p.setChildren(Collections.emptyList()));
        }
    }

    private void doFillTemplateInfo(Dimension dimension, int index) {
        TemplateDim templateDim = new TemplateDim();
        templateDim.setDimensionId(dimension.getId());
        templateDim.setSequence(index + 1);
        templateDim.setDimensionName(dimension.getName());
        DimensionType dimType = dimension.getDimType();
        templateDim.setDimType(dimType);
        if (dimType.isSystemDim()) {
            templateDim.setVisible(true);
        }
        switch (dimType) {
            case CURRENCY: {
                templateDim.setLocation(DimLocation.COL);
                templateDim.setLevel(1);
                templateDim.setMemberScope(this.header.getCurrency());
                break;
            }
            case ACCOUNTTYPE: {
                templateDim.setLocation(DimLocation.COL);
                templateDim.setLevel(2);
                HashSet<String> set = new HashSet<String>(8);
                set.add(FlowEnum.OUTFLOW.getValue());
                set.add(FlowEnum.INFLOW.getValue());
                set.add(FlowEnum.NETINFLOW.getValue());
                this.fillVirtualSubjectFlowMemberScope(dimension, templateDim, dm -> set.contains(dm.getNumber()));
                break;
            }
            case SUBJECTS: {
                templateDim.setLevel(2);
                templateDim.setLocation(this.analysisTemplate.isDistSubject() ? DimLocation.COL : DimLocation.PAGE);
                templateDim.setMemberScope(this.header.getSubjects());
                break;
            }
            case PERIOD: {
                templateDim.setLocation(DimLocation.COL);
                templateDim.setLevel(3);
                templateDim.setMemberScope(this.header.getPeriodId());
                templateDim.setIncludeSubSum(true);
                break;
            }
            case ORG: {
                templateDim.setLocation(DimLocation.ROW);
                templateDim.setLevel(2);
                templateDim.setMemberScope(this.header.getOrg());
                templateDim.setIncludeSum(!dimType.getNumber().equals(this.header.getDimType()));
                break;
            }
            default: {
                this.setStatisticsDimOrPage(dimension, templateDim);
            }
        }
        this.addAllMemberIfNeed(templateDim);
        this.addTemplateDim2TemplateInfo(dimension, templateDim);
    }

    private void fillVirtualTemplateInfo() {
        this.analysisTemplate.setTemplateUse(TemplateUseType.STATISTIC);
        this.analysisTemplate.setDistSubject(false);
        this.analysisTemplate.setTemplateType(TemplateType.FIXED);
        this.analysisTemplate.setPageDimList(new ArrayList<TemplateDim>(4));
        this.analysisTemplate.setRowDimList(new ArrayList<TemplateDim>(4));
        this.analysisTemplate.setColDimList(new ArrayList<TemplateDim>(4));
        TemplateLayout templateLayout = new TemplateLayout();
        templateLayout.setTemplateType(this.analysisTemplate.getTemplateType());
        templateLayout.setDimLayoutInfoList(new ArrayList<TemplateLayout.LayoutInfo>(16));
        this.analysisTemplate.setDimLayout(templateLayout);
    }

    @Override
    public AnalysisReportDataService getAnalysisReportDataService() {
        return new RelationShrekAnalysisReportDataServiceAdapter(this.system, this.analysisReport, this.queryAllDimensionIds).dynamicCalculate().addDimensionMemberStrategy(new AnalysisOrgMemberStrategy(this.header.getOrg())).addDimensionMemberStrategy(new AnalysisPeriodMemberStrategy(this.analysisReport)).addDimensionMemberStrategy(new MultiAnalysisSubjectMemberStrategy(this.analysisReport)).addDimensionMemberStrategy(new CommonDimMemberStrategy()).addVirtualDimMemberProcessService(new AccountTypeDimProcessServiceImpl(this.analysisReport)).addVirtualDimMemberProcessService(new InnerCancelProcessServiceImpl(this.header, this.analysisReport, this.system));
    }

    @Override
    protected AnalysisReport getAnalysisReportInstance() {
        return super.getAnalysisReportInstance().addSumDimensionId(this.system.getMainDimensionByDimType(DimensionType.SUBJECTS).getId());
    }
}

