/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.FlowType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.member.AccountMember;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.report.AnalysisReport;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.domain.service.IDimensionMemberStrategy;
import kd.tmc.fpm.business.helper.AnalysisInfoHelper;

public class MultiAnalysisSubjectMemberStrategy
implements IDimensionMemberStrategy {
    private AnalysisReport analysisReport;

    public MultiAnalysisSubjectMemberStrategy(AnalysisReport analysisReport) {
        this.analysisReport = analysisReport;
    }

    @Override
    public List<?> getMemberScope(Dimension dimension, TemplateDim templateDim) {
        if (!dimension.getDimType().isSubjectDim()) {
            return null;
        }
        ArrayList<Long> memberScope = new ArrayList<Long>(templateDim.getMemberScope());
        if (EmptyUtil.isEmpty(memberScope)) {
            List tAccountMemberList = dimension.getAllDimMemberList().stream().map(v -> (AccountMember)v).collect(Collectors.toList());
            Predicate<AccountMember> subjectFilterByFlow = AnalysisInfoHelper.getSubjectFilterByFlow(this.analysisReport.getFlow());
            return tAccountMemberList.stream().filter(subjectFilterByFlow::test).map(DimMember::getId).collect(Collectors.toList());
        }
        Set allChildIds = dimension.getAllDimMemberList().stream().map(AccountMember.class::cast).filter(accountMember -> accountMember.getFlowType() != FlowType.BALANCE).filter(dimMember -> memberScope.contains(dimMember.getId())).map(DimMember::getAllChildMember).filter(Objects::nonNull).flatMap(Collection::stream).map(DimMember::getId).collect(Collectors.toSet());
        memberScope.removeAll(allChildIds);
        return memberScope;
    }
}

