/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.BillStatus;
import kd.tmc.fpm.business.domain.enums.DimLocation;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.FlowType;
import kd.tmc.fpm.business.domain.enums.MemberType;
import kd.tmc.fpm.business.domain.enums.PeriodType;
import kd.tmc.fpm.business.domain.enums.ReportInputType;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.AccountMember;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.index.DimensionIndexTree;
import kd.tmc.fpm.business.domain.model.index.generate.bean.QueryIndexInfo;
import kd.tmc.fpm.business.domain.model.index.generate.bean.WarpBean;
import kd.tmc.fpm.business.domain.model.index.node.TreeNode;
import kd.tmc.fpm.business.domain.model.report.AdjustAmtInfo;
import kd.tmc.fpm.business.domain.model.report.PlanChangeHeader;
import kd.tmc.fpm.business.domain.model.report.PlanChangeRecord;
import kd.tmc.fpm.business.domain.model.report.PlanChangeReport;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportChangeData;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.report.ReportDataSource;
import kd.tmc.fpm.business.domain.model.template.AuxiliaryField;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateAccountSetting;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.domain.model.template.TemplateLayout;
import kd.tmc.fpm.business.domain.model.template.TemplateMetric;
import kd.tmc.fpm.business.domain.service.IPlanChangeService;
import kd.tmc.fpm.business.domain.service.IReportService;
import kd.tmc.fpm.business.domain.service.impl.ReportService;
import kd.tmc.fpm.business.helper.TemplateInfoHelper;
import kd.tmc.fpm.business.mvc.converter.utils.ConverterUtils;
import kd.tmc.fpm.business.mvc.enums.PlanChangeReferIndex;
import kd.tmc.fpm.business.mvc.service.impl.PlanChangeManageServiceImpl;
import kd.tmc.fpm.business.utils.DimensionInfoHelper;
import kd.tmc.fpm.common.bean.DimensionInfoBean;
import kd.tmc.fpm.common.enums.AuxiliaryFieldTypeEnum;
import kd.tmc.fpm.common.property.AuxiliaryFieldsProp;
import kd.tmc.fpm.common.trace.IFpmTraceSpan;
import kd.tmc.fpm.common.trace.IFpmTracer;
import kd.tmc.fpm.common.utils.NumberUtils;
import org.apache.commons.collections.CollectionUtils;

public class PlanChangeService
implements IPlanChangeService {
    private static Log logger = LogFactory.getLog(PlanChangeManageServiceImpl.class);
    private IReportService iReportService = new ReportService();

    @Override
    public void transfer(Report report, PlanChangeReport changeReport, FundPlanSystem system, PlanChangeHeader changeHeader) {
        try (IFpmTraceSpan span = IFpmTracer.getInstance().createSpan(PlanChangeService.class.getSimpleName());){
            HashMap<String, DimMember> virtMembers = new HashMap<String, DimMember>(16);
            span.addTag("Adjustment sheet loading-Create report template");
            ReportTemplate template = this.createTemplate(changeReport.getTemplate(), changeHeader, virtMembers, system);
            changeReport.setTemplate(template);
            this.fillOriginalMainReportNewData(changeReport, report);
            span.addTag("Adjustment sheet report data merge if main table");
            this.mergeDetailInputReportDataAmtIfAdjustMainTable(system, changeReport, report);
            if (changeReport.getRecordBillStatus() != BillStatus.AUDITED) {
                span.addTag("Adjustment sheet loading-Report data transfer");
                this.changeDataBuildByRD(changeReport, report);
            } else {
                span.addTag("Adjustment sheet loading-Non-adjustment account removal");
                this.removeUnChangeAccount(template, changeReport);
            }
            span.addTag("Adjustment sheet loading-Detail-Report template adding subject flow virtual col");
            TemplateInfoHelper.addSubjectFlowColIfDetailTemplateNeed(template, system);
            changeReport.getTemplate().getColDimList().forEach(templateDim -> templateDim.setTotalRow(false));
            changeReport.setSourceReportTotalRowSize(report);
            span.addTag("Adjustment sheet loading-Report template splitting");
            this.changeDataBuildByTpl(changeReport, template, changeHeader, virtMembers);
        }
    }

    @Override
    public void beforeSave(PlanChangeRecord changeData, FundPlanSystem fundPlanSystem, List<Report> originalReports) {
        this.filterReportData(changeData, true, false);
        this.fillOriginalMainReportOldDataFullDim(changeData, originalReports, fundPlanSystem);
        this.fillOriginalMainReportNewData(changeData, originalReports);
        this.summaryChildToMain(changeData, fundPlanSystem, originalReports);
        this.filterReportData(changeData, false, true);
        this.fillSummaryAndFormulaChangeData(changeData.getChangeReportList(), fundPlanSystem, originalReports);
        this.fillAdjustAmtInfoList(changeData, fundPlanSystem);
    }

    private void filterReportData(PlanChangeRecord changeRecord, boolean notFilterMain, boolean filterZero) {
        List<PlanChangeReport> changeReportList = changeRecord.getChangeReportList();
        for (PlanChangeReport changeReport : changeReportList) {
            if (notFilterMain && Objects.equals(changeReport.getReportId(), changeRecord.getMainReportId())) continue;
            List<ReportData> reportDataList = changeReport.getReportDataList().stream().filter(ReportChangeData.class::isInstance).map(reportData -> (ReportChangeData)reportData).filter(reportChangeData -> {
                if (filterZero) {
                    boolean nonZeroAmountReportData = Objects.nonNull(reportChangeData.getCurrentAdjustAmt()) && reportChangeData.getCurrentAdjustAmt().compareTo(BigDecimal.ZERO) != 0;
                    boolean nonEmptyRemarkReportData = EmptyUtil.isNoEmpty((String)reportChangeData.getRemark()) || reportChangeData.isAuxiliaryInfo();
                    return nonZeroAmountReportData || nonEmptyRemarkReportData || reportChangeData.isDirty() != null && reportChangeData.isDirty() != false;
                }
                return true;
            }).collect(Collectors.toList());
            changeReport.setReportDataList(reportDataList);
        }
    }

    private ReportTemplate createTemplate(ReportTemplate baseTemplate, PlanChangeHeader changeHeader, Map<String, DimMember> virtMembers, FundPlanSystem system) {
        List<TemplateDim> colDimList = baseTemplate.getColDimList();
        List<TemplateMetric> metrics = baseTemplate.getMetrics();
        if (CollectionUtils.isNotEmpty(metrics)) {
            metrics.clear();
        }
        TemplateLayout dimLayout = baseTemplate.getDimLayout();
        baseTemplate.setTotalSumVisible(false);
        baseTemplate.setSubSumVisible(false);
        Long systemId = baseTemplate.getSystemId();
        QFilter qFilter = new QFilter("bodysys", "=", (Object)systemId);
        qFilter.and("type", "=", (Object)AuxiliaryFieldTypeEnum.ADJUST_REASON.getValue());
        DynamicObject load = QueryServiceHelper.queryOne((String)"fpm_auxiliaryfields", (String)AuxiliaryFieldsProp.CONVERT_FIELDS, (QFilter[])new QFilter[]{qFilter});
        if (Objects.isNull(load) || baseTemplate.getTemplateType() == TemplateType.DETAIL) {
            baseTemplate.setRemarkVisible(false);
        } else {
            AuxiliaryField adjustReason = ConverterUtils.convert(AuxiliaryField.class, load);
            baseTemplate.getRemarkEntityList().clear();
            baseTemplate.getRemarkEntityList().add(adjustReason);
            baseTemplate.setRemarkName(ResManager.loadKDString((String)"\u8c03\u6574\u539f\u56e0", (String)"PlanChangeService_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
            baseTemplate.setRemarkVisible(true);
        }
        baseTemplate.setMetricTplDim(null);
        List<TemplateLayout.LayoutInfo> dimLayoutInfoList = dimLayout.getDimLayoutInfoList();
        for (TemplateLayout.LayoutInfo layoutInfo : dimLayoutInfoList) {
            layoutInfo.setIncludeSum(false);
        }
        List<TemplateDim> allTemplateDim = baseTemplate.getAllTemplateDim();
        for (TemplateDim templateDim : allTemplateDim) {
            templateDim.setIncludeSubSum(false);
            templateDim.setIncludeSum(false);
        }
        List<Long> list = changeHeader.getDetailPeriods();
        Optional<TemplateDim> periodOp = colDimList.stream().filter(o -> o.getDimType() == DimensionType.PERIOD).findFirst();
        if (periodOp.isPresent() && EmptyUtil.isNoEmpty(list)) {
            TemplateDim templateDim = periodOp.get();
            templateDim.setMemberScope(list);
        }
        List<PlanChangeReferIndex> referIndexS = changeHeader.getReferIndexS();
        if (EmptyUtil.isEmpty(referIndexS = referIndexS.stream().sorted(Comparator.comparingInt(PlanChangeReferIndex::getSortNo)).collect(Collectors.toList()))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u8003\u4fe1\u606f\u4e3a\u7a7a\u3002", (String)"PlanChangeService_1", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        virtMembers.clear();
        long[] memberIds = DB.genLongIds((String)"fpm_member", (int)referIndexS.size());
        ArrayList<DimMember> virtualMembers = new ArrayList<DimMember>(referIndexS.size());
        ArrayList<Long> virtualMemberIds = new ArrayList<Long>(referIndexS.size());
        for (int index = 0; index < referIndexS.size(); ++index) {
            PlanChangeReferIndex referIndex = referIndexS.get(index);
            DimMember virtMember = new DimMember();
            virtMember.setId(memberIds[index]);
            virtualMemberIds.add(memberIds[index]);
            virtMember.setName(referIndex.getName());
            virtMember.setNumber(String.format("%s", referIndex.getValue()));
            virtMember.setLongNumber(String.format("%s_%s", referIndex.getSortNo(), referIndex.getValue()));
            virtMember.setSortCode(virtMember.getLongNumber());
            virtMember.setMemberType(MemberType.DIM_MEMBER);
            virtualMembers.add(virtMember);
            virtMembers.put(virtMember.getNumber(), virtMember);
        }
        Dimension virtDim = new Dimension();
        virtDim.setId(DB.genLongId((String)"fpm_dimension"));
        virtDim.setDimType(DimensionType.ADJUSTDATATYPE);
        virtDim.setName("Adjust-Virtual-Dimenssion");
        virtDim.setVisible(true);
        virtDim.setNumber(DimensionType.ADJUSTDATATYPE.getNumber());
        virtDim.setMemberList(virtualMembers);
        system.getDimList().add(virtDim);
        TemplateLayout.LayoutInfo virtLayout = new TemplateLayout.LayoutInfo();
        Optional<TemplateDim> max = colDimList.stream().max(Comparator.comparingInt(TemplateDim::getLevel));
        int maxLevel = max.get().getLevel();
        virtLayout.setLevel(maxLevel);
        virtLayout.setDimensionId(virtDim.getId());
        virtLayout.setVisible(true);
        virtLayout.setDimLocation(DimLocation.COL);
        TemplateDim virtTempDim = new TemplateDim();
        virtTempDim.setDimensionId(virtDim.getId());
        virtTempDim.setSequence(baseTemplate.getAllTemplateDim().size() + 1);
        virtTempDim.setDimensionName(virtDim.getName());
        virtTempDim.setMemberScope(virtualMemberIds);
        virtTempDim.setVisible(true);
        DimensionType dimType = virtDim.getDimType();
        virtTempDim.setDimType(dimType);
        virtTempDim.setLocation(virtLayout.getDimLocation());
        virtTempDim.setLevel(virtLayout.getLevel());
        colDimList.add(virtTempDim);
        baseTemplate.setColDimList(colDimList);
        return baseTemplate;
    }

    @Override
    public void changeDataBuildByRD(PlanChangeReport changeReport, Report report) {
        List<ReportData> targetPlanDataList = changeReport.getReportDataList();
        List<ReportData> sourceReportDataList = report.getReportDataList();
        Map reportDataMap = targetPlanDataList.stream().filter(ReportChangeData.class::isInstance).map(reportData -> (ReportChangeData)reportData).filter(rd -> !rd.isAuxiliaryInfo()).collect(Collectors.toMap(rd -> EmptyUtil.isNoEmpty((Long)rd.getOriginalReportDataId()) ? rd.getOriginalReportDataId() : rd.getId(), Function.identity(), (a, b) -> a));
        Set<Long> memberIds = changeReport.getAllPeriodMemberIds();
        changeReport.calNewDataStartRowIfDetailTemplate(sourceReportDataList, memberIds);
        if (CollectionUtils.isEmpty(sourceReportDataList) || sourceReportDataList.stream().noneMatch(item -> !item.isAuxiliaryInfo())) {
            return;
        }
        List sourceReportValidDataList = sourceReportDataList.stream().filter(item -> !item.isAuxiliaryInfo()).collect(Collectors.toList());
        for (ReportData reportData2 : sourceReportValidDataList) {
            Long memberId = (Long)reportData2.getDimValByDimType(DimensionType.PERIOD);
            if (!memberIds.contains(memberId)) continue;
            Long id = reportData2.getId();
            if (EmptyUtil.isNoEmpty((String)reportData2.getRemark())) {
                reportData2.setRemark(null);
            }
            if (!reportDataMap.containsKey(id)) {
                targetPlanDataList.add(reportData2);
                continue;
            }
            ReportData reportChangeData = (ReportData)reportDataMap.get(id);
            reportChangeData.setLockAmt(reportData2.getLockAmt());
            reportChangeData.setActAmt(reportData2.getActAmt());
        }
    }

    private void changeDataBuildByTpl(PlanChangeReport planChangeReport, ReportTemplate template, PlanChangeHeader changeHeader, Map<String, DimMember> virtMembers) {
        try (IFpmTraceSpan span = IFpmTracer.getInstance().createSpan("changeDataBuildByTpl");){
            HashSet<ReportData> planDataList = new HashSet<ReportData>(planChangeReport.getReportDataList());
            Optional<TemplateDim> virtTempDimOp = template.getColDimList().stream().filter(Objects::nonNull).filter(o -> o.getDimType() == DimensionType.ADJUSTDATATYPE).findAny();
            if (!virtTempDimOp.isPresent()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u521b\u5efa\u5bf9\u5e94\u7684\u8c03\u6574\u5355\u865a\u62df\u7ef4\u5ea6\uff08\u6ca1\u6709\u9009\u62e9\u5bf9\u5e94\u7684\u53c2\u8003\u6307\u6807\uff09", (String)"PlanChangeService_2", (String)"tmc-fpm-business", (Object[])new Object[0]));
            }
            List<PlanChangeReferIndex> refers = changeHeader.getReferIndexS();
            HashSet<ReportData> oldReportDatas = new HashSet<ReportData>(planDataList.size());
            Map<Integer, List<ReportData>> reportMaps = planDataList.stream().filter(Objects::nonNull).collect(Collectors.groupingBy(o -> o.getRow()));
            Set<Map.Entry<Integer, List<ReportData>>> entries = reportMaps.entrySet();
            span.addTag("init create cells.");
            boolean auditedDetailTemplate = planChangeReport.getRecordBillStatus() == BillStatus.AUDITED && template.getTemplateType() == TemplateType.DETAIL;
            for (Map.Entry<Integer, List<ReportData>> entry : entries) {
                List reportDatas = entry.getValue().stream().filter(Objects::nonNull).sorted(Comparator.comparingInt(ReportData::getCol)).collect(Collectors.toList());
                if (EmptyUtil.isEmpty(reportDatas)) continue;
                int offset = ((ReportData)reportDatas.get(0)).getCol();
                long referSize = refers.stream().filter(item -> item != PlanChangeReferIndex.ADJUSTAMT).count();
                int count = reportDatas.size() * (int)referSize;
                LinkedList<Long> idQueue = new LinkedList<Long>();
                if (count > 0) {
                    long[] idArr;
                    for (long id : idArr = DB.genGlobalLongIds((int)count)) {
                        idQueue.offer(id);
                    }
                }
                for (ReportData reportData : reportDatas) {
                    if (reportData.isAuxiliaryInfo()) continue;
                    oldReportDatas.add(reportData);
                    List<TemplateDim> dimList = reportData.getDimList();
                    List<Object> dimValList = reportData.getDimValList();
                    for (PlanChangeReferIndex refer : refers) {
                        ReportData virtData = null;
                        if (reportData instanceof ReportChangeData) {
                            virtData = new ReportChangeData();
                            Long originalReportDataId = ((ReportChangeData)reportData).getOriginalReportDataId();
                            if (originalReportDataId != null && !originalReportDataId.equals(0L)) {
                                virtData.setEditable(false);
                            } else if (auditedDetailTemplate) {
                                virtData.setEditable(false);
                            } else {
                                virtData.setEditable(true);
                            }
                        } else {
                            virtData = new ReportData();
                        }
                        Long reportDataId = refer == PlanChangeReferIndex.ADJUSTAMT ? reportData.getId() : (Long)idQueue.poll();
                        virtData.setId(reportDataId);
                        virtData.setVersion(reportData.getVersion());
                        virtData.setReportPeriodId(reportData.getReportPeriodId());
                        virtData.setAmountUnit(reportData.getAmountUnit());
                        virtData.setActAmt(BigDecimal.ZERO);
                        virtData.setPlanAmt(BigDecimal.ZERO);
                        virtData.setLockAmt(BigDecimal.ZERO);
                        virtData.setAuxiliaryValMap(reportData.getAuxiliaryValMap());
                        ArrayList<TemplateDim> virtTempDims = new ArrayList<TemplateDim>(dimList);
                        virtTempDims.add(virtTempDimOp.get());
                        virtData.setDimList(virtTempDims);
                        ArrayList<Object> virtDimVals = new ArrayList<Object>(dimValList);
                        virtDimVals.add(virtMembers.get(refer.getValue()).getId());
                        virtData.setDimValList(virtDimVals);
                        BigDecimal referAmt = this.calcReferAmtValue(refer, reportData);
                        virtData.setPlanAmt(referAmt);
                        virtData.setBigDecimalValueOrDefault(referAmt);
                        if (template.getTemplateType() == TemplateType.DETAIL) {
                            if (!(reportData instanceof ReportChangeData)) {
                                virtData.setRow(reportData.getRow() + 1);
                            } else {
                                virtData.setRow(reportData.getRow());
                            }
                            virtData.setCol(offset++);
                        }
                        planDataList.add(virtData);
                    }
                }
            }
            span.addTag("remove old cells.");
            planDataList.removeAll(oldReportDatas);
            planChangeReport.setReportDataList(new ArrayList<ReportData>(planDataList));
        }
    }

    private BigDecimal calcReferAmtValue(PlanChangeReferIndex refer, ReportData reportData) {
        BigDecimal referAmt = BigDecimal.ZERO;
        if (PlanChangeReferIndex.CURRENTPLANAMT == refer) {
            referAmt = reportData.getPlanAmt();
        } else if (PlanChangeReferIndex.ADJUSTAMT == refer) {
            if (reportData instanceof ReportChangeData) {
                referAmt = ((ReportChangeData)reportData).getCurrentAdjustAmt();
            }
        } else if (PlanChangeReferIndex.AFTERADJUSTAMT == refer) {
            if (reportData instanceof ReportChangeData) {
                referAmt = ((ReportChangeData)reportData).getAdjustedPlanAmt();
            }
        } else if (PlanChangeReferIndex.PLANAMT == refer) {
            referAmt = reportData.getOriginalPlanAmt();
        } else if (PlanChangeReferIndex.LOCKAMT == refer) {
            referAmt = reportData.getLockAmt();
        } else if (PlanChangeReferIndex.REALAMT == refer) {
            referAmt = reportData.getActAmt();
        } else if (PlanChangeReferIndex.AVAILABLEAMT == refer) {
            BigDecimal beforeAdjustAmt = reportData.getPlanAmt();
            referAmt = beforeAdjustAmt.subtract(reportData.getLockAmt()).subtract(reportData.getActAmt());
        } else if (PlanChangeReferIndex.ADJUSTEDAVAILABLEAMT == refer) {
            BigDecimal afterAdjustAmt = reportData.getPlanAmt();
            if (reportData instanceof ReportChangeData) {
                afterAdjustAmt = ((ReportChangeData)reportData).getAdjustedPlanAmt();
            }
            referAmt = afterAdjustAmt.subtract(reportData.getLockAmt()).subtract(reportData.getActAmt());
        }
        return referAmt;
    }

    private void summaryChildToMain(PlanChangeRecord changeData, FundPlanSystem fundPlanSystem, List<Report> originalReports) {
        List<PlanChangeReport> changeReportList = changeData.getChangeReportList();
        Optional<PlanChangeReport> first = changeReportList.stream().filter(planChangeReport -> planChangeReport.getTemplate().isMainTable()).findFirst();
        if (!first.isPresent()) {
            return;
        }
        PlanChangeReport mainReport = first.get();
        Optional<Report> originalMainReportOpt = originalReports.stream().filter(report -> Objects.equals(report.getId(), mainReport.getReportId())).findAny();
        if (!originalMainReportOpt.isPresent()) {
            return;
        }
        Report originalMainReport = originalMainReportOpt.get();
        HashSet<Long> originalReportIds = new HashSet<Long>(changeData.getOriginalReportIdList());
        for (PlanChangeReport planChangeReport2 : changeReportList) {
            Long reportId;
            if (mainReport == planChangeReport2 || !originalReportIds.contains(reportId = planChangeReport2.getReportId())) continue;
            this.sumSubData(mainReport, planChangeReport2, fundPlanSystem, originalMainReport);
        }
    }

    private void sumSubData(PlanChangeReport parentReport, PlanChangeReport subReport, FundPlanSystem fundPlanSystem, Report originalParentReport) {
        ReportTemplate parentTemplate = parentReport.getTemplate();
        ReportTemplate subTemplate = subReport.getTemplate();
        logger.info("\u5b50\u8868\u6a21\u677f[{}]\u5411\u4e3b\u8868\u6a21\u677f[{}]\u6c47\u603b\u6570\u636e", (Object)subTemplate.getId(), (Object)parentTemplate.getId());
        Set<Long> needSummarySubjectIdSet = TemplateInfoHelper.loadNeedSummaryToMainReportAllSubjectIds(parentTemplate, subTemplate);
        if (CollectionUtils.isEmpty(needSummarySubjectIdSet)) {
            return;
        }
        this.clearParentNodeData(needSummarySubjectIdSet, parentReport, fundPlanSystem);
        Dimension subjectDim = fundPlanSystem.getMainDimensionByDimType(DimensionType.SUBJECTS);
        Dimension periodDim = fundPlanSystem.getMainDimensionByDimType(DimensionType.PERIOD);
        Set<Long> reportLeafPeriodIdSet = this.getReportLeafPeriodSet(subReport);
        QueryIndexInfo<Object, ReportData> originalParentQueryIndex = originalParentReport.getQueryIndexInfo(fundPlanSystem, true);
        Map<Long, ReportChangeData> reportDataId2ChangeDataMap = parentReport.getReportDataList().stream().filter(ReportChangeData.class::isInstance).map(o -> (ReportChangeData)o).collect(Collectors.toMap(rd -> EmptyUtil.isNoEmpty((Long)rd.getOriginalReportDataId()) ? rd.getOriginalReportDataId() : rd.getId(), Function.identity(), (a, b) -> a));
        HashMap<ReportData, Boolean> handleMap = new HashMap<ReportData, Boolean>(16);
        HashSet<Long> firstSumOriginalParentRDIdSet = new HashSet<Long>(16);
        for (ReportData subReportData : subReport.getReportDataList()) {
            ReportChangeData parentReportChangeData;
            boolean isFirstSum;
            DimensionInfoBean parentDimensionInfoBean;
            List<ReportData> originalParentRDList;
            Long periodId;
            Long subjectId;
            if (!(subReportData instanceof ReportChangeData)) continue;
            ReportChangeData subReportChangeData = (ReportChangeData)subReportData;
            if (subReportData.isAuxiliaryInfo() || !needSummarySubjectIdSet.contains(subjectId = (Long)subReportChangeData.getDimValByDimensionId(subjectDim.getId())) || !reportLeafPeriodIdSet.contains(periodId = (Long)subReportChangeData.getDimValByDimensionId(periodDim.getId()))) continue;
            DimensionInfoBean subDimensionInfoBean = DimensionInfoHelper.getDimensionInfoBean(subReportChangeData);
            ReportData originalParentRD = originalParentQueryIndex.findOne(subDimensionInfoBean);
            if (EmptyUtil.isEmpty((Object)originalParentRD) && CollectionUtils.isNotEmpty(originalParentRDList = originalParentQueryIndex.findList(parentDimensionInfoBean = DimensionInfoHelper.getDimensionInfoBean(subReportChangeData, parentTemplate))) && originalParentRDList.size() == 1 && DimensionInfoHelper.getDimensionInfoBean(originalParentRDList.get(0)).getDimensionIdList().size() < subDimensionInfoBean.getDimensionIdList().size()) {
                originalParentRD = originalParentRDList.get(0);
                this.fillMainDim(subReportChangeData.getDimList(), subReportChangeData.getDimValList(), originalParentRD.getDimList(), originalParentRD.getDimValList());
                originalParentQueryIndex.updateIndex(new WarpBean<Long, ReportData>(originalParentRD.getId(), subDimensionInfoBean, originalParentRD));
            }
            if (isFirstSum = EmptyUtil.isEmpty((Object)originalParentRD)) {
                originalParentRD = this.createNewReportDataIfNeed(originalParentRD, subReportChangeData, originalParentReport);
                originalParentQueryIndex.updateIndex(new WarpBean<Long, ReportData>(originalParentRD.getId(), DimensionInfoHelper.getDimensionInfoBean(originalParentRD), originalParentRD));
                firstSumOriginalParentRDIdSet.add(originalParentRD.getId());
            }
            if (EmptyUtil.isEmpty((Object)(parentReportChangeData = (ReportChangeData)reportDataId2ChangeDataMap.get(originalParentRD.getId())))) {
                parentReportChangeData = this.createNewReportChangeDataIfNeed(originalParentRD, parentReport, reportDataId2ChangeDataMap);
            }
            if (EmptyUtil.isEmpty((Object)parentReportChangeData)) continue;
            DimensionInfoBean parentDimensionInfoBean2 = DimensionInfoHelper.getDimensionInfoBean(parentReportChangeData);
            if (parentDimensionInfoBean2.getDimensionIdList().size() < subDimensionInfoBean.getDimensionIdList().size()) {
                this.fillMainDim(originalParentRD.getDimList(), originalParentRD.getDimValList(), parentReportChangeData.getDimList(), parentReportChangeData.getDimValList());
            }
            this.summaryToMainReportChangeData(parentReportChangeData, subReportChangeData, handleMap, true);
        }
        firstSumOriginalParentRDIdSet.stream().filter(reportDataId2ChangeDataMap::containsKey).map(reportDataId2ChangeDataMap::get).forEach(reportChangeData -> reportChangeData.setOriginalReportDataId(0L));
    }

    private void clearParentNodeData(Set<Long> needSummarySubjectIds, ReportDataSource parentReport, FundPlanSystem fundPlanSystem) {
        PlanChangeReport planChangeReport = (PlanChangeReport)parentReport;
        Set<Long> reportLeafPeriodIdSet = this.getReportLeafPeriodSet(planChangeReport);
        Dimension subjectDim = fundPlanSystem.getMainDimensionByDimType(DimensionType.SUBJECTS);
        Dimension periodDim = fundPlanSystem.getMainDimensionByDimType(DimensionType.PERIOD);
        for (ReportData reportData : parentReport.getReportDataList()) {
            Long periodId;
            Object subjectId;
            ReportChangeData changeData;
            if (!(reportData instanceof ReportChangeData) || (changeData = (ReportChangeData)reportData).isAuxiliaryInfo() || !needSummarySubjectIds.contains(subjectId = changeData.getDimValByDimensionId(subjectDim.getId())) || !reportLeafPeriodIdSet.contains(periodId = (Long)changeData.getDimValByDimensionId(periodDim.getId()))) continue;
            changeData.setCurrentAdjustAmt(BigDecimal.ZERO);
            changeData.setAdjustedPlanAmt(changeData.getPlanAmt());
            changeData.setDirty(true);
        }
    }

    private void summaryToMainReportChangeData(ReportChangeData parentReportChangeData, ReportChangeData subReportChangeData, HashMap<ReportData, Boolean> handleMap, boolean isAdd) {
        BigDecimal currentAdjustAmt = parentReportChangeData.getCurrentAdjustAmt();
        if (!handleMap.getOrDefault(parentReportChangeData, Boolean.FALSE).booleanValue()) {
            currentAdjustAmt = BigDecimal.ZERO;
        }
        currentAdjustAmt = currentAdjustAmt == null ? BigDecimal.ZERO : currentAdjustAmt;
        BigDecimal subActAmount = subReportChangeData.getCurrentAdjustAmt();
        currentAdjustAmt = isAdd ? currentAdjustAmt.add(subActAmount) : BigDecimal.ZERO;
        parentReportChangeData.setCurrentAdjustAmt(currentAdjustAmt);
        BigDecimal planAmt = parentReportChangeData.getPlanAmt() == null ? BigDecimal.ZERO : parentReportChangeData.getPlanAmt();
        parentReportChangeData.setAdjustedPlanAmt(planAmt.add(currentAdjustAmt));
        parentReportChangeData.setDirty(true);
        handleMap.put(parentReportChangeData, true);
    }

    private ReportChangeData createNewReportChangeDataIfNeed(ReportData parentRD, PlanChangeReport planChangeReport, Map<Long, ReportChangeData> parentReportChangeDataMap) {
        if (parentRD instanceof ReportChangeData) {
            return (ReportChangeData)parentRD;
        }
        ReportChangeData reportChangeData = new ReportChangeData();
        ReportTemplate template = planChangeReport.getTemplate();
        reportChangeData.setVersion(1);
        reportChangeData.setLinkedReportId(planChangeReport.getReportId());
        reportChangeData.setDimList(parentRD.getDimList());
        reportChangeData.setDimValList(parentRD.getDimValList());
        reportChangeData.setReportPeriodId(planChangeReport.getReportPeriodId());
        reportChangeData.setMainTable(template.isMainTable());
        reportChangeData.setAmountUnit(template.getAmountUnit());
        reportChangeData.setOriginalReportId(parentRD.getReportId());
        reportChangeData.setOriginalReportDataId(parentRD.getId());
        reportChangeData.setPlanAmt(parentRD.getPlanAmt());
        reportChangeData.setLockAmt(parentRD.getLockAmt());
        reportChangeData.setActAmt(parentRD.getActAmt());
        reportChangeData.setOriginalPlanAmt(parentRD.getOriginalPlanAmt());
        planChangeReport.getReportDataList().add(reportChangeData);
        parentReportChangeDataMap.put(reportChangeData.getOriginalReportDataId(), reportChangeData);
        return reportChangeData;
    }

    public void fillAdjustAmtInfoList(PlanChangeRecord planChangeRecord, FundPlanSystem fundPlanSystem) {
        List<PlanChangeReport> changeReportList = planChangeRecord.getChangeReportList();
        Optional<PlanChangeReport> first = changeReportList.stream().filter(planChangeReport -> planChangeReport.getTemplate().isMainTable()).findFirst();
        if (!first.isPresent()) {
            return;
        }
        PlanChangeReport planChangeReport2 = first.get();
        Map<Long, AccountMember> subjectMemberMap = fundPlanSystem.getMainDimensionByDimType(DimensionType.SUBJECTS).getAllDimMemberList(AccountMember.class).stream().collect(Collectors.toMap(DimMember::getId, Function.identity(), (a, b) -> a));
        List<AdjustAmtInfo> adjustAmtInfoList = this.generateAdjustAmtInfoList(planChangeReport2, subjectMemberMap, planChangeRecord);
        Map<AdjustAmtInfo.CombinationKey, List<AdjustAmtInfo>> combinationKeyListMap = adjustAmtInfoList.stream().collect(Collectors.groupingBy(AdjustAmtInfo::getCombinationKey));
        ArrayList<AdjustAmtInfo> adjustAmtInfos = new ArrayList<AdjustAmtInfo>(combinationKeyListMap.size());
        for (Map.Entry<AdjustAmtInfo.CombinationKey, List<AdjustAmtInfo>> entry : combinationKeyListMap.entrySet()) {
            List<AdjustAmtInfo> amtInfos = entry.getValue();
            if (CollectionUtils.isEmpty(amtInfos)) continue;
            AdjustAmtInfo amtInfo = new AdjustAmtInfo(entry.getKey(), amtInfos.get(0).getAmountUnit());
            for (AdjustAmtInfo adjustAmtInfo : amtInfos) {
                amtInfo.addAdjustAmtInfo(adjustAmtInfo);
            }
            adjustAmtInfos.add(amtInfo);
        }
        planChangeRecord.setAdjustAmtInfoList(adjustAmtInfos);
    }

    public List<AdjustAmtInfo> generateAdjustAmtInfoList(PlanChangeReport planChangeReport, Map<Long, AccountMember> subjectMemberMap, PlanChangeRecord planChangeRecord) {
        ReportTemplate template = planChangeReport.getTemplate();
        List<ReportData> reportDataList = planChangeReport.getReportDataList();
        if (CollectionUtils.isEmpty(reportDataList)) {
            return Collections.emptyList();
        }
        if (Objects.isNull(subjectMemberMap) || subjectMemberMap.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Long> pageList = new ArrayList<Long>(2);
        List<TemplateDim> pageDimList = template.getPageDimList();
        Set<Long> pageDimIds = pageDimList.stream().map(TemplateDim::getDimensionId).collect(Collectors.toSet());
        Set formulaAndSummarySubjectIdSet = template.getAccountSettings().stream().filter(item -> item.getInputType() == ReportInputType.FORMULA || item.getInputType() == ReportInputType.SUMMARY).map(TemplateAccountSetting::getAccountMemId).collect(Collectors.toSet());
        List<PeriodMember> currentAllPeriodMembers = planChangeReport.loadCurrentAllPeriodMembers();
        ArrayList<AdjustAmtInfo> adjustAmtInfoList = new ArrayList<AdjustAmtInfo>(reportDataList.size());
        for (ReportData reportData : reportDataList) {
            ReportChangeData reportChangeData;
            BigDecimal currentAdjustAmt;
            if (reportData.isAuxiliaryInfo() || EmptyUtil.isEmpty((BigDecimal)(currentAdjustAmt = (reportChangeData = (ReportChangeData)reportData).getCurrentAdjustAmt()))) continue;
            List<TemplateDim> dimList = reportChangeData.getDimList();
            Long currencyId = (Long)reportChangeData.getDimValByDimType(DimensionType.CURRENCY, null);
            Long subjectId = (Long)reportChangeData.getDimValByDimType(DimensionType.SUBJECTS, null);
            if (formulaAndSummarySubjectIdSet.contains(subjectId)) continue;
            AccountMember subjectMember = subjectMemberMap.get(subjectId);
            if (subjectMember.isPeriodAccount() && subjectMember.getFlowType() == FlowType.BALANCE) {
                Long periodMemberId = (Long)reportChangeData.getDimValByDimType(DimensionType.PERIOD);
                if (subjectMember.getPeriodDirection().isBeginning() && !Objects.equals(periodMemberId, currentAllPeriodMembers.get(0).getId()) || subjectMember.getPeriodDirection().isEnding() && !Objects.equals(periodMemberId, currentAllPeriodMembers.get(currentAllPeriodMembers.size() - 1).getId())) continue;
            }
            FlowType flowType = subjectMemberMap.get(subjectId).getFlowType();
            AdjustAmtInfo adjustAmtInfoSum = new AdjustAmtInfo(new AdjustAmtInfo.CombinationKey(currencyId, 0L, 0L), reportChangeData.getAmountUnit());
            PlanChangeService.setAmtByFlowType(flowType, adjustAmtInfoSum, currentAdjustAmt);
            adjustAmtInfoList.add(adjustAmtInfoSum);
            pageList.clear();
            for (int i = 0; i < dimList.size(); ++i) {
                TemplateDim templateDim = dimList.get(i);
                if (!this.candidate(templateDim, pageDimIds)) continue;
                if (pageList.isEmpty() && StringUtils.isBlank((CharSequence)planChangeRecord.getPageDimensionType1())) {
                    planChangeRecord.setPageDimensionType1(templateDim.getDimType().getNumber());
                }
                if (!pageList.isEmpty() && StringUtils.isBlank((CharSequence)planChangeRecord.getPageDimensionType2())) {
                    planChangeRecord.setPageDimensionType2(templateDim.getDimType().getNumber());
                }
                pageList.add((Long)reportChangeData.getDimValByDimType(templateDim.getDimType(), null));
            }
            this.generateAdjustAmtInfoForPageList(adjustAmtInfoList, reportChangeData, pageList, currencyId, flowType);
        }
        return adjustAmtInfoList;
    }

    private void generateAdjustAmtInfoForPageList(List<AdjustAmtInfo> adjustAmtInfoList, ReportChangeData reportChangeData, List<Long> pageList, Long currencyId, FlowType flowType) {
        if (pageList.isEmpty()) {
            return;
        }
        if (pageList.size() == 1) {
            AdjustAmtInfo adjustAmtInfo = new AdjustAmtInfo(new AdjustAmtInfo.CombinationKey(currencyId, pageList.get(0)), reportChangeData.getAmountUnit());
            PlanChangeService.setAmtByFlowType(flowType, adjustAmtInfo, reportChangeData.getCurrentAdjustAmt());
            adjustAmtInfoList.add(adjustAmtInfo);
            return;
        }
        if (pageList.size() == 2) {
            AdjustAmtInfo adjustAmtInfo = new AdjustAmtInfo(new AdjustAmtInfo.CombinationKey(currencyId, pageList.get(0), pageList.get(1)), reportChangeData.getAmountUnit());
            PlanChangeService.setAmtByFlowType(flowType, adjustAmtInfo, reportChangeData.getCurrentAdjustAmt());
            adjustAmtInfoList.add(adjustAmtInfo);
        }
    }

    private static void setAmtByFlowType(FlowType flowType, AdjustAmtInfo adjustAmtInfo, BigDecimal currentAdjustAmt) {
        switch (flowType) {
            case IN: {
                adjustAmtInfo.setAdjustSumAmtIn(currentAdjustAmt);
                break;
            }
            case OUT: {
                adjustAmtInfo.setAdjustSumAmtOut(currentAdjustAmt);
                break;
            }
            case BALANCE: {
                adjustAmtInfo.setAdjustSumAmtBal(currentAdjustAmt);
            }
        }
    }

    private boolean candidate(TemplateDim templateDim, Set<Long> pageDimIdSet) {
        Long dimensionId = templateDim.getDimensionId();
        if (!pageDimIdSet.contains(dimensionId)) {
            return false;
        }
        switch (templateDim.getDimType()) {
            case SETTLEMENT_TYPE: 
            case PERIOD: 
            case COMPANY: {
                return true;
            }
        }
        return false;
    }

    private void removeUnChangeAccount(ReportTemplate template, PlanChangeReport changeReport) {
        List<ReportData> reportDataList = changeReport.getReportDataList();
        Set subjectIdSet = reportDataList.stream().filter(item -> !item.isAuxiliaryInfo()).map(item -> item.getDimValByDimType(DimensionType.SUBJECTS, null)).collect(Collectors.toSet());
        TemplateDim templateDim = template.getAllTemplateDim().stream().filter(item -> item.getDimType() == DimensionType.SUBJECTS).findFirst().get();
        List<Long> finalMemberScope = templateDim.getMemberScope().stream().filter(item -> subjectIdSet.contains(item)).collect(Collectors.toList());
        templateDim.setMemberScope(finalMemberScope);
    }

    private void mergeDetailInputReportDataAmtIfAdjustMainTable(FundPlanSystem system, PlanChangeReport planChangeReport, Report report) {
        if (!report.getTemplate().isMainTable() || CollectionUtils.isEmpty(report.getReportDataList()) || report.getReportDataList().stream().noneMatch(item -> !item.isAuxiliaryInfo())) {
            return;
        }
        List<TemplateAccountSetting> accountSettings = report.getTemplate().getAccountSettings();
        Set detailInputSubjects = accountSettings.stream().filter(item -> ReportInputType.DETAIL_INPUT == item.getInputType()).map(TemplateAccountSetting::getAccountMemId).collect(Collectors.toSet());
        if (detailInputSubjects.isEmpty()) {
            return;
        }
        Dimension subjectDim = system.getMainDimensionByDimType(DimensionType.SUBJECTS);
        List detailInputRdList = report.getReportDataList().stream().filter(item -> !item.isAuxiliaryInfo()).filter(item -> {
            Object subjectMemId = item.getDimValByDimensionId(subjectDim.getId());
            return detailInputSubjects.contains((Long)subjectMemId);
        }).collect(Collectors.toList());
        Set dimBeanList = detailInputRdList.stream().map(rd -> DimensionInfoHelper.getDimensionInfoBean(rd, report.getTemplate())).collect(Collectors.toSet());
        HashSet waitRemoveReportDataIds = new HashSet(8);
        Map reportDataId2ChangeDataMap = planChangeReport.getReportDataList().stream().filter(ReportChangeData.class::isInstance).map(reportData -> (ReportChangeData)reportData).filter(rd -> !rd.isAuxiliaryInfo()).collect(Collectors.toMap(rd -> EmptyUtil.isNoEmpty((Long)rd.getOriginalReportDataId()) ? rd.getOriginalReportDataId() : rd.getId(), Function.identity(), (a, b) -> a));
        boolean changeReportAudited = planChangeReport.getRecordBillStatus() == BillStatus.AUDITED;
        DimensionIndexTree indexTree = report.getIndexTree(system);
        for (DimensionInfoBean dimensionInfoBean : dimBeanList) {
            TreeNode treeNode = indexTree.find(dimensionInfoBean);
            if (Objects.isNull(treeNode) || CollectionUtils.isEmpty(treeNode.getDataList())) continue;
            List dataList = treeNode.getDataList().stream().map(rd -> (ReportData)rd).filter(rd -> !rd.isAuxiliaryInfo()).collect(Collectors.toList());
            Optional<ReportData> adjustedOriginalReportDataOpt = dataList.stream().map(o -> (ReportData)o).filter(reportData -> reportDataId2ChangeDataMap.containsKey(reportData.getId())).findAny();
            ReportData sumReportData = adjustedOriginalReportDataOpt.isPresent() ? adjustedOriginalReportDataOpt.get() : (ReportData)dataList.get(0);
            sumReportData.setDirty(false);
            BigDecimal currPlanAmtBeforeSum = BigDecimal.ZERO;
            if (adjustedOriginalReportDataOpt.isPresent()) {
                currPlanAmtBeforeSum = dataList.stream().map(o -> (ReportData)o).filter(reportData -> reportDataId2ChangeDataMap.containsKey(reportData.getId())).map(ReportData::getPlanAmt).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            }
            dataList.stream().map(reportData -> (ReportData)reportData).filter(reportData -> !Objects.equals(reportData.getId(), sumReportData.getId())).forEach(reportData -> {
                sumReportData.addPlanAmt(reportData.getPlanAmt());
                sumReportData.addActAmt(reportData.getActAmt());
                sumReportData.addLockAmt(reportData.getLockAmt());
                sumReportData.addPlanReferenceAmt(reportData.getPlanReferenceAmt());
                sumReportData.addReportPlanAmt(reportData.getReportPlanAmt());
                sumReportData.addOriginalPlanAmt(reportData.getOriginalPlanAmt());
                waitRemoveReportDataIds.add(reportData.getId());
            });
            if (!adjustedOriginalReportDataOpt.isPresent()) continue;
            List changeDataList = dataList.stream().map(o -> (ReportData)o).map(ReportData::getId).filter(reportDataId2ChangeDataMap::containsKey).map(reportDataId2ChangeDataMap::get).collect(Collectors.toList());
            ReportChangeData currChangeData = (ReportChangeData)reportDataId2ChangeDataMap.get(sumReportData.getId());
            BigDecimal planAmtBeforeAdjust = changeDataList.stream().map(ReportData::getPlanAmt).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            BigDecimal currDisplayPlanAmt = changeReportAudited ? sumReportData.getPlanAmt().subtract(currPlanAmtBeforeSum).add(planAmtBeforeAdjust) : sumReportData.getPlanAmt();
            currChangeData.setPlanAmt(currDisplayPlanAmt);
            BigDecimal currAdjustPlanAmt = changeDataList.stream().map(ReportChangeData::getCurrentAdjustAmt).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            currChangeData.setCurrentAdjustAmt(currAdjustPlanAmt);
            BigDecimal adjustedPlanAmt = currChangeData.getPlanAmt().add(currAdjustPlanAmt);
            currChangeData.setAdjustedPlanAmt(adjustedPlanAmt);
            currChangeData.setActAmt(sumReportData.getActAmt());
            currChangeData.setLockAmt(sumReportData.getLockAmt());
            currChangeData.setPlanReferenceAmt(sumReportData.getPlanReferenceAmt());
            currChangeData.setReportPlanAmt(sumReportData.getReportPlanAmt());
            currChangeData.setOriginalPlanAmt(sumReportData.getOriginalPlanAmt());
        }
        report.getReportDataList().removeIf(reportData -> waitRemoveReportDataIds.contains(reportData.getId()));
        Predicate<ReportData> removeReportDataFilter = reportData -> {
            if (reportData instanceof ReportChangeData) {
                ReportChangeData changeData = (ReportChangeData)reportData;
                Long waitRemoveReportDataId = EmptyUtil.isEmpty((Long)changeData.getOriginalReportDataId()) ? changeData.getId() : changeData.getOriginalReportDataId();
                return waitRemoveReportDataIds.contains(waitRemoveReportDataId);
            }
            return false;
        };
        planChangeReport.getReportDataList().removeIf(removeReportDataFilter);
        report.clearIndexTree();
    }

    private void fillSummaryAndFormulaChangeData(List<PlanChangeReport> changeReportList, FundPlanSystem fundPlanSystem, List<Report> originalReports) {
        Map originalReportMap = originalReports.stream().collect(Collectors.toMap(Report::getId, Function.identity(), (a, b) -> a));
        for (PlanChangeReport planChangeReport : changeReportList) {
            if (!planChangeReport.getTemplate().isMainTable()) continue;
            Report mainReport = (Report)originalReportMap.get(planChangeReport.getReportId());
            Set leafSubjectIdSet = mainReport.getTemplate().getAccountSettings().stream().filter(item -> item.getInputType() == ReportInputType.MANUAL_INPUT || item.getInputType() == ReportInputType.DETAIL_INPUT).map(TemplateAccountSetting::getAccountMemId).collect(Collectors.toSet());
            Dimension subjectDim = fundPlanSystem.getMainDimensionByDimType(DimensionType.SUBJECTS);
            Report mainReportCopy = mainReport.copyReportData();
            Map reportChangeDataMap = planChangeReport.getReportDataList().stream().filter(ReportChangeData.class::isInstance).map(o -> (ReportChangeData)o).filter(o -> !o.isAuxiliaryInfo()).collect(Collectors.toMap(rd -> EmptyUtil.isNoEmpty((Long)rd.getOriginalReportDataId()) ? rd.getOriginalReportDataId() : rd.getId(), Function.identity(), (a, b) -> a));
            List<ReportData> manualInputReportDataListAfterAdjust = mainReport.getReportDataList().stream().filter(item -> reportChangeDataMap.containsKey(item.getId())).filter(rd -> leafSubjectIdSet.contains(rd.getDimValByDimensionId(subjectDim.getId()))).collect(Collectors.toList());
            manualInputReportDataListAfterAdjust.forEach(item -> item.setPlanAmt(item.getPlanAmt().add(((ReportChangeData)reportChangeDataMap.get(item.getId())).getCurrentAdjustAmt())));
            List<ReportData> summaryAndFormulaReportDataListAfterAdjust = this.iReportService.calculateReportScope(mainReport, fundPlanSystem, manualInputReportDataListAfterAdjust);
            if (EmptyUtil.isEmpty(summaryAndFormulaReportDataListAfterAdjust)) continue;
            Map summaryAndFormulaReportDataMapAfterAdjust = summaryAndFormulaReportDataListAfterAdjust.stream().collect(Collectors.toMap(ReportData::getId, Function.identity(), (a, b) -> a));
            reportChangeDataMap.values().stream().filter(reportChangeData -> summaryAndFormulaReportDataMapAfterAdjust.containsKey(reportChangeData.getOriginalReportDataId())).forEach(reportChangeData -> {
                ReportData reportDataAfterAdjust = (ReportData)summaryAndFormulaReportDataMapAfterAdjust.get(reportChangeData.getOriginalReportDataId());
                BigDecimal currentAdjustAmt = reportDataAfterAdjust.getPlanAmt().subtract(reportChangeData.getPlanAmt());
                if (NumberUtils.notEquals((BigDecimal)currentAdjustAmt, (BigDecimal)reportChangeData.getCurrentAdjustAmt())) {
                    reportChangeData.setCurrentAdjustAmt(currentAdjustAmt);
                    reportChangeData.setAdjustedPlanAmt(reportDataAfterAdjust.getPlanAmt());
                    reportChangeData.setDirty(Boolean.TRUE);
                }
            });
            Map originalReportDataMap = mainReportCopy.getReportDataList().stream().collect(Collectors.toMap(ReportData::getId, Function.identity(), (a, b) -> a));
            List formulaAndSummaryNewReportChangeDataList = summaryAndFormulaReportDataListAfterAdjust.stream().filter(reportData -> !reportChangeDataMap.containsKey(reportData.getId())).map(reportData -> {
                ReportChangeData reportChangeData = new ReportChangeData((ReportData)reportData);
                ReportData originalReportData = (ReportData)originalReportDataMap.get(reportData.getId());
                reportChangeData.setAdjustedPlanAmt(reportChangeData.getPlanAmt());
                reportChangeData.setCurrentAdjustAmt(reportChangeData.getPlanAmt().subtract(originalReportData.getPlanAmt()));
                reportChangeData.setPlanAmt(originalReportData.getPlanAmt());
                reportChangeData.setDirty(Boolean.TRUE);
                return reportChangeData;
            }).collect(Collectors.toList());
            planChangeReport.getReportDataList().addAll(formulaAndSummaryNewReportChangeDataList);
        }
    }

    private Set<Long> getReportLeafPeriodSet(PlanChangeReport planChangeReport) {
        Set<Long> allPeriodMemberIds = planChangeReport.getAllPeriodMemberIds();
        PeriodType detailPeriodType = planChangeReport.getReportPeriodType().getDetailPeriodType();
        if (detailPeriodType != null) {
            PeriodMember currPeriodMember = planChangeReport.getCurrentReportPeriod();
            allPeriodMemberIds.removeIf(periodId -> Objects.equals(periodId, currPeriodMember.getId()));
        }
        if (planChangeReport.isRollContainsDetail()) {
            List<PeriodMember> periodMembers = planChangeReport.getPeriodMemberList();
            Set periodIds = periodMembers.stream().map(DimMember::getId).collect(Collectors.toSet());
            allPeriodMemberIds.removeIf(period -> periodIds.contains(period));
        }
        return allPeriodMemberIds;
    }

    private ReportData createNewReportDataIfNeed(ReportData mainReportData, ReportData subReportData, Report mainReport) {
        if (EmptyUtil.isNoEmpty((Object)mainReportData)) {
            return mainReportData;
        }
        mainReportData = new ReportData(subReportData);
        mainReportData.setReportId(mainReport.getId());
        mainReportData.setMainTable(true);
        mainReportData.setId(DB.genGlobalLongId());
        return mainReportData;
    }

    private void fillMainDim(List<TemplateDim> currDimList, List<Object> currDimValList, List<TemplateDim> currMainDimList, List<Object> currMainDimValList) {
        currMainDimList.clear();
        currMainDimValList.clear();
        for (int i = 0; i < currDimList.size() && i < currDimValList.size(); ++i) {
            TemplateDim templateDim = currDimList.get(i);
            if (!templateDim.getDimType().isMainDimensionType()) continue;
            currMainDimList.add(templateDim);
            currMainDimValList.add(currDimValList.get(i));
        }
    }

    private void fillOriginalMainReportOldDataFullDim(PlanChangeRecord planChangeRecord, List<Report> originalReports, FundPlanSystem fundPlanSystem) {
        Optional<PlanChangeReport> mainReportOpt = planChangeRecord.getChangeReportList().stream().filter(report -> report.getTemplate().isMainTable()).findAny();
        if (!mainReportOpt.isPresent()) {
            return;
        }
        PlanChangeReport mainReport = mainReportOpt.get();
        Report originalMainReport = originalReports.stream().filter(report -> Objects.equals(report.getId(), mainReport.getReportId())).findAny().get();
        this.fillOriginalMainReportOldDataFullDim(mainReport, originalMainReport, fundPlanSystem);
    }

    private void fillOriginalMainReportOldDataFullDim(PlanChangeReport planChangeReport, Report originalReport, FundPlanSystem fundPlanSystem) {
        if (planChangeReport.getRecordBillStatus() == BillStatus.AUDITED || !originalReport.getTemplate().isMainTable() || CollectionUtils.isEmpty(originalReport.getReportDataList()) || originalReport.getReportDataList().stream().noneMatch(item -> !item.isAuxiliaryInfo())) {
            return;
        }
        List<TemplateAccountSetting> accountSettings = originalReport.getTemplate().getAccountSettings();
        Set detailInputSubjects = accountSettings.stream().filter(item -> ReportInputType.DETAIL_INPUT == item.getInputType()).map(TemplateAccountSetting::getAccountMemId).collect(Collectors.toSet());
        if (detailInputSubjects.isEmpty()) {
            return;
        }
        Dimension subjectDim = fundPlanSystem.getMainDimensionByDimType(DimensionType.SUBJECTS);
        List detailInputChangeRDList = planChangeReport.getReportDataList().stream().filter(ReportChangeData.class::isInstance).map(rd -> (ReportChangeData)rd).filter(rd -> !rd.isAuxiliaryInfo()).filter(rd -> EmptyUtil.isNoEmpty((Long)rd.getOriginalReportDataId())).filter(rd -> {
            Object subjectMemId = rd.getDimValByDimensionId(subjectDim.getId());
            if (subjectMemId == null) {
                return false;
            }
            return detailInputSubjects.contains((Long)subjectMemId);
        }).collect(Collectors.toList());
        Map reportDataMap = originalReport.getReportDataList().stream().collect(Collectors.toMap(ReportData::getId, Function.identity(), (a, b) -> a));
        for (ReportChangeData changeData : detailInputChangeRDList) {
            ReportData reportData = (ReportData)reportDataMap.get(changeData.getOriginalReportDataId());
            DimensionInfoBean changeDataDimInfoBean = DimensionInfoHelper.getDimensionInfoBean(changeData);
            DimensionInfoBean reportDataDimInfoBean = DimensionInfoHelper.getDimensionInfoBean(reportData);
            if (changeDataDimInfoBean.getDimensionIdList().size() <= reportDataDimInfoBean.getDimensionIdList().size()) continue;
            this.fillMainDim(changeData.getDimList(), changeData.getDimValList(), reportData.getDimList(), reportData.getDimValList());
        }
    }

    private void fillOriginalMainReportNewData(PlanChangeRecord planChangeRecord, List<Report> originalReports) {
        Optional<PlanChangeReport> mainReportOpt = planChangeRecord.getChangeReportList().stream().filter(report -> report.getTemplate().isMainTable()).findAny();
        if (!mainReportOpt.isPresent()) {
            return;
        }
        PlanChangeReport mainReport = mainReportOpt.get();
        Report originalMainReport = originalReports.stream().filter(report -> Objects.equals(report.getId(), mainReport.getReportId())).findAny().get();
        this.fillOriginalMainReportNewData(mainReport, originalMainReport);
    }

    private void fillOriginalMainReportNewData(PlanChangeReport planChangeReport, Report originalReport) {
        if (!planChangeReport.getTemplate().isMainTable() || planChangeReport.getRecordBillStatus() == BillStatus.AUDITED) {
            return;
        }
        List noneExistOriginalReportNewDataList = planChangeReport.getReportDataList().stream().filter(ReportChangeData.class::isInstance).map(rd -> (ReportChangeData)rd).filter(rd -> EmptyUtil.isEmpty((Long)rd.getOriginalReportDataId())).map(rd -> {
            ReportData newRD = new ReportData((ReportData)rd);
            newRD.setId(rd.getId());
            return newRD;
        }).collect(Collectors.toCollection(LinkedList::new));
        List<Object> reportDataList = originalReport.getReportDataList() == null ? new ArrayList(noneExistOriginalReportNewDataList.size()) : originalReport.getReportDataList();
        reportDataList.addAll(noneExistOriginalReportNewDataList);
    }
}

