/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimLocation;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.FlowType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.AccountMember;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.report.AnalysisHeader;
import kd.tmc.fpm.business.domain.model.report.AnalysisReport;
import kd.tmc.fpm.business.domain.model.report.PositionAnalysisReport;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.domain.service.AnalysisReportDataService;
import kd.tmc.fpm.business.domain.service.InnerCancelProcessServiceImpl;
import kd.tmc.fpm.business.domain.service.impl.AbstractVirtualTemplateAnalysisReportDataBuildService;
import kd.tmc.fpm.business.domain.service.impl.AccountTypeDimProcessServiceImpl;
import kd.tmc.fpm.business.domain.service.impl.AnalysisMemberOnlyTopStrategy;
import kd.tmc.fpm.business.domain.service.impl.AnalysisOrgMemberStrategy;
import kd.tmc.fpm.business.domain.service.impl.AnalysisPeriodMemberStrategy;
import kd.tmc.fpm.business.domain.service.impl.CommonDimMemberStrategy;
import kd.tmc.fpm.business.domain.service.impl.RelationShrekAnalysisReportDataServiceAdapter;
import kd.tmc.fpm.business.domain.service.result.PeriodStartBalance;
import kd.tmc.fpm.business.utils.CommonUtils;
import kd.tmc.fpm.business.utils.DataSetUtil;
import kd.tmc.fpm.common.enums.AmountUnitEnum;
import kd.tmc.fpm.common.enums.FlowEnum;
import kd.tmc.fpm.common.helper.ModelHelper;
import kd.tmc.fpm.common.utils.AmountUtil;
import org.apache.commons.collections.CollectionUtils;

public class PositionAnalysisReportDataBuildServiceImpl
extends AbstractVirtualTemplateAnalysisReportDataBuildService {
    public PositionAnalysisReportDataBuildServiceImpl(AnalysisHeader header, FundPlanSystem system) {
        super(header, system);
    }

    @Override
    public void buildSystem() {
        Dimension accountDim = this.system.getMainDimensionByDimType(DimensionType.SUBJECTS);
        List<DimMember> dimMemberList = accountDim.getAllDimMemberList();
        List<Long> subjects = this.header.getSubjects();
        Map<FlowType, List<AccountMember>> accountMap = dimMemberList.stream().filter(item -> CollectionUtils.isEmpty((Collection)subjects) || subjects.contains(item.getId())).map(AccountMember.class::cast).collect(Collectors.groupingBy(AccountMember::getFlowType));
        for (Map.Entry<FlowType, List<AccountMember>> flowTypeListEntry : accountMap.entrySet()) {
            List<AccountMember> flowAccountMemList = flowTypeListEntry.getValue();
            ArrayList<DimMember> rebuildLevel = new ArrayList<DimMember>(8);
            FlowType flowType = flowTypeListEntry.getKey();
            for (AccountMember accountMember : flowAccountMemList) {
                List<DimMember> allChildMember = accountMember.getAllChildMember();
                allChildMember.stream().map(AccountMember.class::cast).filter(item -> flowType != item.getFlowType()).filter(item -> Objects.nonNull(item.getParent())).filter(item -> ((AccountMember)item.getParent()).getFlowType() != item.getFlowType()).forEach(item -> {
                    item.getParent().getChildren().remove(item);
                    item.setParent(null);
                    item.setParentId(null);
                    rebuildLevel.add((DimMember)item);
                });
            }
            this.rebuildMemberLevel(rebuildLevel, 1);
        }
        accountDim.setMemberList(dimMemberList.stream().filter(item -> item.getLevel() == 1).collect(Collectors.toList()));
        this.handleHeader();
    }

    @Override
    AnalysisReportDataService getAnalysisReportDataService() {
        return new RelationShrekAnalysisReportDataServiceAdapter(this.system, this.analysisReport, this.queryAllDimensionIds).dynamicCalculate().addDimensionMemberStrategy(new AnalysisPeriodMemberStrategy(this.analysisReport)).addDimensionMemberStrategy(this.isFromMultiDim() ? new AnalysisMemberOnlyTopStrategy().addDimensionId(this.system.getMainDimensionByDimType(DimensionType.ORG).getId()) : new AnalysisOrgMemberStrategy(this.header.getOrg(), true)).addDimensionMemberStrategy(new CommonDimMemberStrategy()).addVirtualDimMemberProcessService(new AccountTypeDimProcessServiceImpl(this.analysisReport)).addVirtualDimMemberProcessService(new InnerCancelProcessServiceImpl(this.header, this.analysisReport, this.system));
    }

    @Override
    public void buildTemplate() {
        super.buildTemplate();
        this.createReportCurrency();
        this.createViAccountDim();
        this.fillTemplateInfo();
    }

    private void fillTemplateInfo() {
        List<Dimension> mainDimList = this.system.getMainDimList();
        for (int i = 0; i < mainDimList.size(); ++i) {
            Dimension dimension = mainDimList.get(i);
            if (dimension.getDimType().isMetric() || EmptyUtil.isEmpty(dimension.getAllDimMemberList())) continue;
            this.doFillTemplateInfo(dimension, i);
        }
    }

    private void doFillTemplateInfo(Dimension dimension, int index) {
        TemplateDim templateDim = new TemplateDim();
        templateDim.setDimensionId(dimension.getId());
        templateDim.setSequence(index + 1);
        templateDim.setDimensionName(dimension.getName());
        DimensionType dimType = dimension.getDimType();
        templateDim.setDimType(dimType);
        if (dimType.isSystemDim()) {
            templateDim.setVisible(true);
        }
        switch (dimType) {
            case CURRENCY: {
                templateDim.setLocation(DimLocation.COL);
                templateDim.setLevel(1);
                templateDim.setMemberScope(this.header.getCurrency());
                break;
            }
            case ACCOUNTTYPE: {
                templateDim.setLocation(DimLocation.ROW);
                templateDim.setLevel(1);
                if (EmptyUtil.isEmpty((String)this.header.getFlow())) {
                    this.header.setFlow(FlowEnum.NONLIMIT.getValue());
                }
                HashSet<String> set = new HashSet<String>(8);
                set.add(FlowEnum.OUTFLOW.getValue());
                set.add(FlowEnum.INFLOW.getValue());
                this.fillVirtualSubjectFlowMemberScope(dimension, templateDim, dm -> set.contains(dm.getNumber()));
                break;
            }
            case SUBJECTS: {
                templateDim.setLocation(DimLocation.ROW);
                templateDim.setLevel(2);
                List<Long> subjects = this.header.getSubjects();
                if (EmptyUtil.isEmpty(subjects)) {
                    subjects = dimension.getAllDimMemberList().stream().map(AccountMember.class::cast).filter(accountMember -> accountMember.getFlowType() == FlowType.IN || accountMember.getFlowType() == FlowType.OUT).map(DimMember::getId).collect(Collectors.toList());
                }
                templateDim.setMemberScope(subjects);
                templateDim.setIncludeSum(true);
                break;
            }
            case PERIOD: {
                templateDim.setLocation(DimLocation.COL);
                templateDim.setLevel(2);
                templateDim.setMemberScope(this.header.getPeriodId());
                templateDim.setIncludeSum(true);
                templateDim.setIncludeSubSum(true);
                break;
            }
            case ORG: {
                templateDim.setLocation(DimLocation.PAGE);
                List<Long> orgList = this.header.getOrg();
                if (EmptyUtil.isEmpty(orgList)) break;
                templateDim.setMemberScope(orgList);
                break;
            }
            default: {
                this.setStatisticsDimOrPage(dimension, templateDim);
            }
        }
        this.addAllMemberIfNeed(templateDim);
        this.addTemplateDim2TemplateInfo(dimension, templateDim);
    }

    @Override
    protected AnalysisReport getAnalysisReportInstance() {
        return new PositionAnalysisReport().addSumDimensionId(this.system.getMainDimensionByDimType(DimensionType.ORG).getId());
    }

    @Override
    protected void init() {
        super.init();
        TemplateDim templateDim = this.analysisTemplate.getAllTemplateDim().stream().filter(o -> o.getDimType().isPeriodDim()).findFirst().get();
        List<Long> memberScope = templateDim.getMemberScope();
        Dimension periodDim = this.system.getMainDimensionByDimType(DimensionType.PERIOD);
        List<DimMember> allPeriodMemberList = periodDim.getAllDimMemberList();
        PeriodMember periodMember = allPeriodMemberList.stream().filter(item -> memberScope.contains(item.getId())).map(item -> (PeriodMember)item).sorted(Comparator.comparing(PeriodMember::getStartDate)).findFirst().get();
        Date lastDay = DateUtils.getLastDay((Date)periodMember.getStartDate(), (int)1);
        TemplateDim currencyTemDim = this.analysisTemplate.getAllTemplateDim().stream().filter(td -> td.getDimType().isCurrencyDim()).findFirst().get();
        HashSet<Long> currencyMemberScope = new HashSet<Long>(currencyTemDim.getMemberScope());
        Set currencySourceIds = this.system.getMainDimensionByDimensionId(currencyTemDim.getDimensionId()).getAllDimMemberList().stream().filter(dimMember -> currencyMemberScope.contains(dimMember.getId())).map(DimMember::getSourceId).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("accountbank.id", "in", this.header.getFundPositionAcctIds()).and("bizdate", "<=", (Object)lastDay).and("currency.id", "in", currencySourceIds);
        String selectFields = "id,amount,accountbank.id,bizdate,currency.id";
        DataSet accountBalanceDataSet = QueryServiceHelper.queryDataSet((String)"QueryAccountBank", (String)"bei_bankbalance", (String)selectFields, (QFilter[])new QFilter[]{qFilter}, null);
        DataSet finish = accountBalanceDataSet.copy().groupBy(new String[]{"accountbank.id", "currency.id"}).max("bizdate").finish();
        DataSet filter = accountBalanceDataSet.join(finish).on("accountbank.id", "accountbank.id").on("bizdate", "bizdate").on("currency.id", "currency.id").select(DataSetUtil.getSelectFields(accountBalanceDataSet, new String[0]).split(",")).finish();
        PeriodStartBalance periodStartBalance = new PeriodStartBalance();
        while (filter.hasNext()) {
            Row row = filter.next();
            BigDecimal amount = this.convertUnit(CommonUtils.getBigDecimalValue(row.getBigDecimal("amount")));
            Long currencyId = row.getLong("currency.id");
            periodStartBalance.addAmount(currencyId, amount);
            BigDecimal rate = this.analysisReport.getExchangeRate(currencyId);
            periodStartBalance.addAmount(amount.multiply(rate));
        }
        PositionAnalysisReport positionAnalysisReport = (PositionAnalysisReport)this.analysisReport;
        positionAnalysisReport.setPeriodStartBalance(periodStartBalance);
        DataSetUtil.closeDataSet(accountBalanceDataSet, finish, filter);
    }

    private BigDecimal convertUnit(BigDecimal amount) {
        return AmountUtil.convert((AmountUnitEnum)AmountUnitEnum.ONE, (AmountUnitEnum)((AmountUnitEnum)AmountUnitEnum.valueOf(AmountUnitEnum.class, (String)this.analysisTemplate.getAmountUnit().name())), (BigDecimal)amount);
    }

    private void handleHeader() {
        if (EmptyUtil.isEmpty(this.header.getOrg())) {
            List<Long> memberScope;
            List authOrgIds = ModelHelper.getOrgAuthScopeWithCheckManager((String)"fpm", (String)"fpm_fundpositiontable");
            Dimension orgDimension = this.system.getMainDimensionByDimType(DimensionType.ORG);
            if (EmptyUtil.isEmpty((Collection)authOrgIds)) {
                memberScope = orgDimension.getAllDimMemberList().stream().map(DimMember::getId).collect(Collectors.toList());
            } else {
                HashSet orgSet = new HashSet(authOrgIds);
                memberScope = orgDimension.getAllDimMemberList().stream().map(DimMember::getId).filter(orgSet::contains).collect(Collectors.toList());
            }
            this.header.setOrg(memberScope);
        }
    }
}

