/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.service.impl;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryObject;
import kd.tmc.fpm.business.domain.enums.ReportStatus;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.service.QueryConditionProcessor;

public class RelationQueryConditionLogProcessorImpl
implements QueryConditionProcessor<ReportDataQueryObject> {
    private static final Log logger = LogFactory.getLog(RelationQueryConditionLogProcessorImpl.class);

    @Override
    public void beforeSearch(ReportDataQueryObject reportDataQueryObject) {
        StringBuilder sb = new StringBuilder();
        List<Dimension> dimIdList = reportDataQueryObject.getDimIdList();
        List<List<Object>> dimValList = reportDataQueryObject.getDimValList();
        if (EmptyUtil.isNoEmpty(dimIdList)) {
            for (int i = 0; i < dimIdList.size(); ++i) {
                Dimension dimension = dimIdList.get(i);
                sb.append(dimension.getNumber()).append(":").append(dimValList.get(i)).append(",");
            }
        }
        if (EmptyUtil.isNoEmpty((Object)((Object)reportDataQueryObject.getReportStatus()))) {
            sb.append("ReportStatus:").append(reportDataQueryObject.getReportStatus().getName()).append(",");
        }
        if (EmptyUtil.isNoEmpty((Object)reportDataQueryObject.getEffectFlag())) {
            sb.append("EffectFlag:").append(reportDataQueryObject.getEffectFlag()).append(",");
        }
        if (EmptyUtil.isNoEmpty(reportDataQueryObject.getReportStatuss())) {
            sb.append("ReportStatus:").append(reportDataQueryObject.getReportStatuss().stream().map(ReportStatus::getName).collect(Collectors.joining("\u3001"))).append(",");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        logger.info("\u67e5\u8be2\u6761\u4ef6\uff1a{}", (Object)sb.toString());
    }

    @Override
    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

