/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.service.impl;

import java.util.List;
import java.util.Set;
import kd.tmc.fpm.business.dataproc.query.IReportDataQueryService;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryResult;
import kd.tmc.fpm.business.dataproc.query.ShrekReportDataQueryDTO;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.report.AnalysisReport;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.service.impl.AbstractAnalysisReportDataService;
import kd.tmc.fpm.business.domain.service.impl.ShrekQueryConditionLogProcessorImpl;
import kd.tmc.fpm.business.mvc.converter.ReportPoConverter;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;

public class ShrekAnalysisReportDataService
extends AbstractAnalysisReportDataService {
    private IReportDataQueryService reportDataQueryService = FpmServiceFactory.getBizService(IReportDataQueryService.class);

    public ShrekAnalysisReportDataService(FundPlanSystem fundPlanSystem, AnalysisReport analysisReport, Set<Long> queryAllDimensionIds) {
        super(fundPlanSystem, analysisReport, queryAllDimensionIds);
        this.addQueryConditionProcessor(new ShrekQueryConditionLogProcessorImpl());
    }

    @Override
    protected List<ReportData> queryReportDataList() {
        ShrekReportDataQueryDTO queryDTO = new ShrekReportDataQueryDTO();
        queryDTO.setDimIdList(this.dimensionList);
        queryDTO.setDimValIdList(this.dimValList);
        queryDTO.setMainTable(true);
        queryDTO.setEffectFlag(Boolean.TRUE);
        queryDTO.setSystem(this.fundPlanSystem);
        queryDTO.setQueryAllDimensionIds(this.queryAllDimensionIds);
        queryDTO.setDynamicCalculate(this.dynamicCalculate);
        this.beforeSearch(queryDTO);
        List<ReportDataQueryResult> resultList = this.reportDataQueryService.queryReportDataByShrek(queryDTO);
        List<ReportData> reportDataList = this.analysisReport.getReportDataList();
        reportDataList.addAll(ReportPoConverter.convertReportData(resultList, this.analysisReport.getTemplate().getAllTemplateDim()));
        return reportDataList;
    }
}

