/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.query.IReportDataQueryService;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryObject;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryResult;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.report.AnalysisReport;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.service.impl.AbstractAnalysisReportDataService;
import kd.tmc.fpm.business.domain.service.impl.RelationQueryConditionLogProcessorImpl;
import kd.tmc.fpm.business.helper.ReportHelper;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;

public class SynthesisRelationAnalysisReportDataService
extends AbstractAnalysisReportDataService {
    private final IReportDataQueryService reportDataQueryService = FpmServiceFactory.getBizService(IReportDataQueryService.class);

    public SynthesisRelationAnalysisReportDataService(FundPlanSystem fundPlanSystem, AnalysisReport analysisReport, Set<Long> queryAllDimensionIds) {
        super(fundPlanSystem, analysisReport, queryAllDimensionIds);
        this.addQueryConditionProcessor(new RelationQueryConditionLogProcessorImpl());
    }

    @Override
    protected List<ReportData> queryReportDataList(Long reportTypeId, Long orgId, List<Dimension> dimensionList, List<List<Object>> dimValList) {
        if (EmptyUtil.isNoEmpty((Object)this.queryAllDimensionIds)) {
            for (int i = 0; i < dimensionList.size(); ++i) {
                Dimension dimension = dimensionList.get(i);
                if (dimension.getDimType().isSystemDim() || !this.queryAllDimensionIds.contains(dimension.getId())) continue;
                dimValList.get(i).add(0L);
            }
        }
        ReportDataQueryObject queryDTO = new ReportDataQueryObject();
        queryDTO.setDimIdList(dimensionList);
        queryDTO.setDimValList(dimValList);
        queryDTO.setReportTypeId(reportTypeId);
        queryDTO.setReportOrgId(orgId);
        queryDTO.setMainTable(true);
        this.beforeSearch(queryDTO);
        if (!queryDTO.isNeedSearch()) {
            return new ArrayList<ReportData>();
        }
        logger.info("\u67e5\u8be2\u7ef4\u5ea6:{}\uff0c\u67e5\u8be2\u7ef4\u5ea6\u7684\u6210\u5458\uff1a{}", dimensionList.stream().map(Dimension::getName).collect(Collectors.toList()), dimValList);
        List<ReportDataQueryResult> reportDataQueryResults = this.reportDataQueryService.queryReportData(queryDTO);
        return ReportHelper.convert(reportDataQueryResults);
    }

    @Override
    protected List<ReportData> queryAllDimReportDataList(Long reportTypeId, Long orgId, List<Dimension> dimensionList, List<List<Object>> dimValList) {
        return this.queryReportDataList(reportTypeId, orgId, dimensionList, dimValList);
    }
}

