/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryObject;
import kd.tmc.fpm.business.domain.enums.BillState;
import kd.tmc.fpm.business.domain.enums.ReportStatus;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.model.report.AnalysisHeader;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.service.QueryConditionProcessor;
import kd.tmc.fpm.common.property.ReportProp;
import org.apache.commons.collections4.CollectionUtils;

public class SynthesisRelationQueryConditionProcessor
implements QueryConditionProcessor<ReportDataQueryObject> {
    private AnalysisHeader header;
    public ReportTemplate template;

    public SynthesisRelationQueryConditionProcessor(AnalysisHeader header, ReportTemplate template) {
        this.template = template;
        this.header = header;
    }

    @Override
    public void beforeSearch(ReportDataQueryObject reportDataQueryObject) {
        reportDataQueryObject.setReportStatuss(this.header.getReportStatusList());
        reportDataQueryObject.setBillStateList(this.header.getBillStateList());
        reportDataQueryObject.setEffectFlag(null);
        if (this.template.getTemplateType().isDetail()) {
            reportDataQueryObject.setMainTable(false);
            reportDataQueryObject.setTemplateType(TemplateType.DETAIL);
            return;
        }
        QFilter qFilter = new QFilter("billstatus", "in", this.header.getBillStateList().stream().map(BillState::getNumber).collect(Collectors.toSet()));
        qFilter.and(new QFilter("planstatus", "in", this.header.getReportStatusList().stream().map(ReportStatus::getVal).collect(Collectors.toSet())));
        qFilter.and(new QFilter("reportperiod.reporttype", "=", (Object)reportDataQueryObject.getReportTypeId()));
        qFilter.and(new QFilter("bodysys", "=", (Object)this.header.getBodySystemId()));
        qFilter.and(new QFilter("template.ismaintable", "=", (Object)"1"));
        qFilter.and(new QFilter("reportorg", "=", (Object)reportDataQueryObject.getReportOrgId()));
        DynamicObject[] needQueryReports = BusinessDataServiceHelper.load((String)"fpm_report", (String)String.join((CharSequence)",", ReportProp.getBillHeadProp()), (QFilter[])new QFilter[]{qFilter});
        if (needQueryReports == null || needQueryReports.length == 0) {
            reportDataQueryObject.setNeedSearch(false);
            return;
        }
        ArrayList<DynamicObject> filterReportDOList = new ArrayList<DynamicObject>(needQueryReports.length);
        for (DynamicObject needQueryReport : needQueryReports) {
            if ("sumplan".equals(needQueryReport.getString("reportplantype")) && !ReportStatus.ENABLE.getVal().equals(needQueryReport.getString("planstatus"))) continue;
            filterReportDOList.add(needQueryReport);
        }
        if (CollectionUtils.isEmpty(filterReportDOList)) {
            reportDataQueryObject.setNeedSearch(false);
            return;
        }
        List<Long> reportIds = filterReportDOList.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
        reportDataQueryObject.setReportIdS(reportIds);
    }
}

