/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.service.provider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.service.IServiceDataProvider;
import kd.tmc.fpm.business.domain.service.provider.ReportDataVersionParam;

public class ReportDataVersionProvider
implements IServiceDataProvider<ReportDataVersionParam, Map<Long, Integer>> {
    @Override
    public Map<Long, Integer> getData(ReportDataVersionParam dataParam) {
        Report report = dataParam.getReport();
        List<PeriodMember> periodMemberList = report.getPeriodMemberList();
        HashMap<Long, Integer> versionMap = new HashMap<Long, Integer>();
        for (PeriodMember periodMember : periodMemberList) {
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(4);
            qFilterList.add(new QFilter("templatebak.templateid", "=", (Object)report.getTemplate().getCopyId()));
            qFilterList.add(new QFilter("reportorg.id", "=", (Object)report.getCompanyMemberList().get(0).getId()));
            qFilterList.add(new QFilter("periodlist.fbasedataid", "=", (Object)periodMember.getId()));
            qFilterList.add(new QFilter("reportperiod.startdate", "<", (Object)periodMemberList.get(0).getStartDate()));
            int count = TmcDataServiceHelper.count((String)"fpm_report", (QFilter[])qFilterList.toArray(new QFilter[0]));
            List periodIdList = periodMember.getAllChildMember().stream().map(DimMember::getId).collect(Collectors.toList());
            periodIdList.add(periodMember.getId());
            for (Long periodId : periodIdList) {
                versionMap.put(periodId, count + 1);
            }
        }
        return versionMap;
    }
}

