/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.service.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryObject;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryResult;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryService;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.index.node.TreeNode;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.service.IServiceDataProvider;
import kd.tmc.fpm.business.domain.service.provider.ReportSumTPDataParam;
import kd.tmc.fpm.business.helper.ReportHelper;
import kd.tmc.fpm.common.bean.DimensionInfoBean;
import org.apache.commons.collections.CollectionUtils;

public class ReportSumToPProvider
implements IServiceDataProvider<ReportSumTPDataParam, List<ReportData>> {
    private static final Log LOGGER = LogFactory.getLog(ReportSumToPProvider.class);

    @Override
    public List<ReportData> getData(ReportSumTPDataParam dataParam) {
        List<TreeNode> effectDataList = dataParam.getEffectDataList();
        Report parentReport = dataParam.getParentReport();
        Map<Long, Dimension> dimMap = dataParam.getDimMap();
        ReportDataQueryService queryService = new ReportDataQueryService();
        ReportDataQueryObject queryObject = new ReportDataQueryObject();
        if (Objects.isNull(parentReport)) {
            queryObject.setReportIdS(Collections.singletonList(dataParam.getReportId()));
        } else {
            queryObject.setReportIdS(Collections.singletonList(parentReport.getId()));
        }
        HashSet tplDimSet = new HashSet();
        HashMap<Long, Set> dimIdAndValListMap = new HashMap<Long, Set>();
        for (int i = 0; i < effectDataList.size(); ++i) {
            TreeNode treeNode = effectDataList.get(i);
            DimensionInfoBean dimInfoBean = treeNode.getDimInfoBean();
            List dimensionIdList = dimInfoBean.getDimensionIdList();
            if (i == 0) {
                tplDimSet.addAll(dimensionIdList);
            }
            for (int j = 0; j < dimensionIdList.size(); ++j) {
                Long dimId = (Long)dimensionIdList.get(j);
                Set targetValList = dimIdAndValListMap.computeIfAbsent(dimId, k -> new HashSet());
                targetValList.add(dimInfoBean.getMemberIdList().get(j));
            }
        }
        ArrayList<Dimension> tplDimIdList = new ArrayList<Dimension>(tplDimSet.size());
        ArrayList<List<Object>> dimValList = new ArrayList<List<Object>>(tplDimSet.size());
        for (Long templateDim : tplDimSet) {
            tplDimIdList.add(dimMap.get(templateDim));
            dimValList.add(new ArrayList((Collection)dimIdAndValListMap.get(templateDim)));
        }
        queryObject.setDimIdList(tplDimIdList);
        queryObject.setDimValList(dimValList);
        if (CollectionUtils.isEmpty(tplDimIdList)) {
            return null;
        }
        List<ReportDataQueryResult> reportDataQueryResults = queryService.queryReportData(queryObject);
        List<ReportData> dbRDList = ReportHelper.convert(reportDataQueryResults);
        return dbRDList;
    }
}

