/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.helper;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.context.ControlBotpUpperHolder;
import kd.tmc.fpm.business.domain.model.control.ControlBOTPInfo;

public class ControlBOTPHelper {
    public static List<ControlBOTPInfo> findUpBill(String entityType, Long id) {
        Map sourceBills = BFTrackerServiceHelper.findSourceBills((String)entityType, (Long[])new Long[]{id});
        Set entries = sourceBills.entrySet();
        ArrayList<ControlBOTPInfo> controlBOTPInfos = new ArrayList<ControlBOTPInfo>(entries.size());
        ControlBOTPHelper.fillUpperIfNeed(sourceBills, controlBOTPInfos, id);
        int level = controlBOTPInfos.size();
        for (Map.Entry entry : entries) {
            String billSign = (String)entry.getKey();
            for (Long billId : (HashSet)entry.getValue()) {
                ControlBOTPInfo controlBOTPInfo = new ControlBOTPInfo();
                controlBOTPInfo.setId(billId);
                controlBOTPInfo.setEntityType(billSign);
                controlBOTPInfo.setLevel(level);
                controlBOTPInfos.add(controlBOTPInfo);
            }
            ++level;
        }
        return controlBOTPInfos;
    }

    public static List<ControlBOTPInfo> findDownBill(String entityType, Long id) {
        Map targetBills = BFTrackerServiceHelper.findTargetBills((String)entityType, (Long[])new Long[]{id});
        Set entries = targetBills.entrySet();
        ArrayList<ControlBOTPInfo> controlBOTPInfos = new ArrayList<ControlBOTPInfo>(entries.size());
        int level = 0;
        for (Map.Entry entry : entries) {
            String billSign = (String)entry.getKey();
            for (Long billId : (HashSet)entry.getValue()) {
                ControlBOTPInfo controlBOTPInfo = new ControlBOTPInfo();
                controlBOTPInfo.setId(billId);
                controlBOTPInfo.setEntityType(billSign);
                controlBOTPInfo.setLevel(level);
                controlBOTPInfos.add(controlBOTPInfo);
            }
            ++level;
        }
        return controlBOTPInfos;
    }

    private static void fillUpperIfNeed(Map<String, HashSet<Long>> sourceBills, List<ControlBOTPInfo> controlBOTPInfos, Long id) {
        List<ControlBOTPInfo> controlBOTPInfosList = ControlBotpUpperHolder.get(id);
        if (EmptyUtil.isEmpty(controlBOTPInfosList)) {
            return;
        }
        List botpInfos = controlBOTPInfosList.stream().filter(c -> !sourceBills.containsKey(c.getEntityType())).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(botpInfos)) {
            return;
        }
        for (int i = 0; i < botpInfos.size(); ++i) {
            ControlBOTPInfo controlBOTPInfo = (ControlBOTPInfo)botpInfos.get(0);
            controlBOTPInfo.setLevel(i);
            controlBOTPInfos.add(controlBOTPInfo);
        }
    }
}

