/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.helper;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.control.ControlAmountCache;
import kd.tmc.fpm.business.domain.model.control.ControlStrategy;
import kd.tmc.fpm.business.domain.model.control.ControlStrategyDetail;
import kd.tmc.fpm.business.domain.model.index.generate.bean.QueryIndexInfo;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.mvc.service.impl.ControlStrategyDelegate;
import kd.tmc.fpm.business.utils.DimensionInfoHelper;
import kd.tmc.fpm.common.bean.DimensionInfoBean;

public class ControlHelper {
    public static BiConsumer<ReportData, BigDecimal> getUpperSubjectOccupyAmtConsumer(ControlAmountCache copy, ControlStrategy controlStrategy, QueryIndexInfo<Long, ReportData> dataQueryIndexInfo, ControlStrategyDelegate controlStrategyDelegate) {
        Map controlStrategyDetailMap = controlStrategy.getControlStrategyDetails().stream().collect(Collectors.toMap(ControlStrategyDetail::getSubjectId, Function.identity(), (a, b) -> a));
        return (matchedReportData, waitReleaseAmt) -> {
            ControlStrategyDetail parentControlStrategyDetail;
            Object subjectId = matchedReportData.getDimValByDimType(DimensionType.SUBJECTS, null);
            ControlStrategyDetail controlStrategyDetail = (ControlStrategyDetail)controlStrategyDetailMap.get(subjectId);
            if (Objects.isNull(controlStrategyDetail)) {
                return;
            }
            Report report = controlStrategyDelegate.getReportById(matchedReportData.getReportId());
            DimensionInfoBean dimensionInfoBean = DimensionInfoHelper.getDimensionInfoBean(matchedReportData, report.getTemplate());
            List memberIdList = dimensionInfoBean.getMemberIdList();
            int subjectIndex = memberIdList.indexOf(subjectId);
            if (subjectIndex == -1) {
                return;
            }
            Long parentId = controlStrategyDetail.getParentId();
            while (Objects.nonNull(parentControlStrategyDetail = (ControlStrategyDetail)controlStrategyDetailMap.get(parentId))) {
                DimensionInfoBean copyInfo = dimensionInfoBean.copy();
                copyInfo.getMemberIdList().set(subjectIndex, parentId);
                List<ReportData> relateUpperReportDataList = dataQueryIndexInfo.findList(copyInfo);
                relateUpperReportDataList = relateUpperReportDataList.stream().filter(rd -> Objects.equals(matchedReportData.getReportId(), rd.getReportId())).collect(Collectors.toList());
                copy.init(relateUpperReportDataList, controlStrategy.getSystemId());
                relateUpperReportDataList.forEach(rd -> copy.updateLockAmount(rd.getId(), rd.getReportActAmount((BigDecimal)waitReleaseAmt)));
                parentId = parentControlStrategyDetail.getParentId();
            }
        };
    }
}

