/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.helper;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.TemplateMetricType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.MetricMember;
import kd.tmc.fpm.business.utils.MetricValueUtils;

public class ControlMetricCalculateHelper {
    private static ThreadLocal<Map<Long, Map<TemplateMetricType, MetricMember>>> systemMetricTypeThreadLocal = ThreadLocal.withInitial(() -> null);

    public static MetricMember getMetricMember(FundPlanSystem system, TemplateMetricType templateMetricType) {
        Map<Long, Map<TemplateMetricType, MetricMember>> systemMetricMap = systemMetricTypeThreadLocal.get();
        if (systemMetricMap == null) {
            return MetricValueUtils.getMetricMember(system, templateMetricType);
        }
        Map metricTypeMetricMemberMap = systemMetricMap.computeIfAbsent(system.getId(), k -> new HashMap(8));
        MetricMember metricMemberCache = (MetricMember)metricTypeMetricMemberMap.get(templateMetricType);
        if (EmptyUtil.isNoEmpty((Object)metricMemberCache)) {
            return metricMemberCache;
        }
        Dimension metricDim = system.getMainDimensionByDimType(DimensionType.METRIC);
        if (EmptyUtil.isEmpty((Object)metricDim)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4f53\u7cfb\u3010%1$s\u3011\uff0c\u6ca1\u6709\u521d\u59cb\u5316\u5ea6\u91cf\u503c\u7ef4\u5ea6\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"ControlMetricCalculateHelper_0", (String)"tmc-fpm-business", (Object[])new Object[0]), system.getName()));
        }
        Optional<MetricMember> first = metricDim.getAllDimMemberList().stream().map(MetricMember.class::cast).filter(metricMember -> metricMember.getTemplateMetricType() == templateMetricType).findFirst();
        if (!first.isPresent()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4f53\u7cfb\u3010%1$s\u3011\uff0c\u627e\u4e0d\u5230\u5ea6\u91cf\u503c\u7c7b\u578b\u3010%2$s\u3011\u7684\u5ea6\u91cf\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"ControlMetricCalculateHelper_1", (String)"tmc-fpm-business", (Object[])new Object[0]), system.getName(), templateMetricType.getName()));
        }
        MetricMember metricMember2 = first.get();
        metricTypeMetricMemberMap.put(templateMetricType, metricMember2);
        return metricMember2;
    }

    public static void remove() {
        systemMetricTypeThreadLocal.remove();
    }

    public static void set() {
        systemMetricTypeThreadLocal.set(new HashMap(8));
    }
}

