/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.PeriodControlStrategyType;
import kd.tmc.fpm.business.domain.model.control.ControlStrategy;
import kd.tmc.fpm.business.domain.model.control.ControlStrategyDetail;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.ReportPeriodType;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.index.generate.bean.QueryIndexInfo;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.mvc.service.context.ControlContext;
import kd.tmc.fpm.business.utils.DimensionInfoHelper;
import kd.tmc.fpm.common.bean.DimensionInfoBean;

public class ControlRelationReportDataFindHelper {
    private static final Log logger = LogFactory.getLog(ControlRelationReportDataFindHelper.class);
    private ControlContext controlContext;

    public static ControlRelationReportDataFindHelper getInstance(ControlContext controlContext) {
        return new ControlRelationReportDataFindHelper(controlContext);
    }

    private ControlRelationReportDataFindHelper(ControlContext controlContext) {
        this.controlContext = controlContext;
    }

    public List<ReportData> getControlReportDataList(QueryIndexInfo<Long, ReportData> relateReportDataQueryIndex, ControlStrategyDetail controlStrategyDetail, ReportData reportData, ControlStrategy controlStrategy, PeriodMember currPeriodMember) {
        if (EmptyUtil.isEmpty(relateReportDataQueryIndex)) {
            return new ArrayList<ReportData>(2);
        }
        List<ControlStrategyDetail.DetailControlBasis> detailControlBasisList = controlStrategyDetail.getDetailControlBasisList();
        DimensionInfoBean dimensionInfoBean = DimensionInfoHelper.getDimensionInfoBeanByFilter(reportData, templateDim -> DimensionType.getSystemDimensionTypeList().contains((Object)templateDim.getDimType()));
        Long systemId = controlStrategy.getSystemId();
        FundPlanSystem system = this.controlContext.getSystem(systemId);
        Dimension subjectDim = system.getMainDimensionByDimType(DimensionType.SUBJECTS);
        List<ReportPeriodType> reportTypeList = system.getReportTypeList();
        ReportPeriodType reportPeriodType = reportTypeList.stream().filter(rt -> Objects.equals(rt.getReportPeriodId(), currPeriodMember.getPeriodTypeId())).findFirst().get();
        logger.info("\u7f16\u5236\u6570\u636e\uff1a{}\uff0c\u539f\u59cb\u7ef4\u5ea6\u4fe1\u606f:{}", (Object)reportData.getId(), (Object)dimensionInfoBean);
        if (Objects.nonNull((Object)reportPeriodType.getDetailPeriodType()) && controlStrategy.getPeriodControlStrategyType() == PeriodControlStrategyType.CURRENT_CONTROL) {
            logger.info("\u63a7\u5236\u7b56\u7565\uff1a{}\u4e3a\u6309\u5f53\u671f\u63a7\u5236", (Object)controlStrategy.getName());
            dimensionInfoBean.replaceValueIfContains(currPeriodMember.getDimensionId(), (Object)(Objects.equals(reportData.getReportPeriodId(), currPeriodMember.getId()) ? currPeriodMember.getId() : currPeriodMember.getParentId()));
        }
        dimensionInfoBean.replaceValueIfContains(subjectDim.getId(), (Object)controlStrategyDetail.getSubjectId());
        logger.info("\u7f16\u5236\u6570\u636e\uff1a{}\u5904\u7406\u63a7\u5236\u65b9\u5f0f\u662f\u6309\u660e\u7ec6\u9879\u63a7\u8fd8\u662f\u6309\u5f53\u671f\u63a7\u540e\u7684\u7ef4\u5ea6\u4fe1\u606f\uff1a{}", (Object)reportData.getId(), (Object)dimensionInfoBean);
        if (EmptyUtil.isEmpty(detailControlBasisList)) {
            return relateReportDataQueryIndex.findList(dimensionInfoBean);
        }
        detailControlBasisList.stream().filter(detailControlBasis -> detailControlBasis.getDimensionType() != DimensionType.DETAILDIM).forEach(detailControlBasis -> dimensionInfoBean.addDimensionInfo(detailControlBasis.getDimensionId(), reportData.getDimValByDimensionId(detailControlBasis.getDimensionId())));
        logger.info("\u7f16\u5236\u6570\u636e\uff1a{}\uff0c\u5bf9\u5e94\u7684\u63a7\u5236\u7b56\u7565\uff1a{}\uff0c\u660e\u7ec6\u63a7\u5236\u9879\uff1a{}\u5b58\u5728\u6309\u660e\u7ec6\u9879\u63a7\uff0c\u5904\u7406\u53ef\u9009\u53ef\u9009\u7ef4\u5ea6\u540e\u7684\u7ef4\u5ea6\u4fe1\u606f\uff1a{}", new Object[]{reportData.getId(), controlStrategy.getName(), controlStrategyDetail.getSubjectName(), dimensionInfoBean});
        List<ReportData> reportDataList = relateReportDataQueryIndex.findList(dimensionInfoBean);
        if (EmptyUtil.isEmpty(reportDataList)) {
            return reportDataList;
        }
        Set<Long> detailControlBaseDimensionIds = detailControlBasisList.stream().filter(detailControlBasis -> detailControlBasis.getDimensionType() == DimensionType.DETAILDIM).map(ControlStrategyDetail.DetailControlBasis::getDimensionId).collect(Collectors.toSet());
        logger.info("\u7f16\u5236\u6570\u636e\uff1a{}\uff0c\u5bf9\u5e94\u7684\u63a7\u5236\u7b56\u7565\uff1a{}\uff0c\u660e\u7ec6\u63a7\u5236\u9879\uff1a{}\u5b58\u5728\u6309\u660e\u7ec6\u5b57\u6bb5\u63a7\uff1a{}", new Object[]{reportData.getId(), controlStrategy.getName(), controlStrategyDetail.getSubjectName(), detailControlBaseDimensionIds});
        if (EmptyUtil.isEmpty(detailControlBaseDimensionIds)) {
            return reportDataList;
        }
        Map<Long, Object> detailDimValueMap = DimensionInfoHelper.getDetailDimValueMap(reportData, detailControlBaseDimensionIds);
        logger.info("\u7f16\u5236\u6570\u636e:{}\u5bf9\u5e94\u7684\u660e\u7ec6\u5b57\u6bb5\u503c\u4fe1\u606f\uff1a{}", (Object)reportData.getId(), detailDimValueMap);
        Predicate<ReportData> predicate = DimensionInfoHelper.getDetailFieldMatchFilter(detailDimValueMap);
        return reportDataList.stream().filter(predicate::test).collect(Collectors.toList());
    }
}

