/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.helper;

import java.util.Objects;
import java.util.function.Supplier;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.mvc.controller.impl.AbstractFpmFormOperate;
import kd.tmc.fpm.business.mvc.view.IViewPageCache;
import kd.tmc.fpm.common.helper.LoggerPrintHelper;
import kd.tmc.fpm.common.utils.FpmSerializeUtil;

public class FormOperateHelper {
    private static final Log logger = LogFactory.getLog(FormOperateHelper.class);

    public static <T> void doFormOperate(AbstractFpmFormOperate<T> formOperate) {
        FpmOperateResult result = formOperate.doOperate();
        if (result.isSuccess()) {
            logger.info(String.format("\u3010%s\u3011\u64cd\u4f5c\u6267\u884c\u6210\u529f\u3002", formOperate.getOperateName()));
            formOperate.onOperateSuccess(result);
        } else {
            logger.info(String.format("\u3010%s\u3011\u64cd\u4f5c\u6267\u884c\u5931\u8d25\u3002\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a\n %s", formOperate.getOperateName(), LoggerPrintHelper.printCollectionLogger(result.getMessageList())));
            formOperate.onOperateError(result);
        }
        formOperate.afterDoThings(result);
        logger.info(String.format("\u3010%s\u3011\u64cd\u4f5c\u6267\u884c\u7ed3\u675f\u3002", formOperate.getOperateName()));
    }

    public static <T> T getObjectByCache(IViewPageCache viewPageCache, Class<T> clazz) {
        return FormOperateHelper.getObjectByCache(viewPageCache, clazz, null);
    }

    public static <T> T getObjectByCache(IViewPageCache viewPageCache, Class<T> clazz, Supplier<String> message) {
        return FormOperateHelper.getObjectByCache(viewPageCache, clazz, viewPageCache.getClass().getName(), message);
    }

    public static <T> T getObjectByCache(IViewPageCache viewPageCache, Class<T> clazz, String cacheKey, Supplier<String> message) {
        String managerJson = viewPageCache.getPageCache().get(cacheKey);
        logger.info(Objects.isNull(message) ? "" : message.get() + "\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6\u5bf9\u8c61\u3010%s\u3011\uff0c\u7f13\u5b58key\u3010%s\u3011\uff0c\u5bf9\u8c61\u5e8f\u5217\u5316\u503c\u3010%s\u3011", new Object[]{clazz.getName(), cacheKey, managerJson});
        return (T)FpmSerializeUtil.deserialize((String)managerJson, clazz);
    }

    public static void cache(IViewPageCache viewPageCache, Object cacheObject) {
        FormOperateHelper.cache(viewPageCache, cacheObject, null);
    }

    public static void cache(IViewPageCache viewPageCache, Object cacheObject, Supplier<String> supplier) {
        FormOperateHelper.cache(viewPageCache, cacheObject, viewPageCache.getClass().getName(), supplier);
    }

    public static void cache(IViewPageCache viewPageCache, Object cacheObject, String cacheKey, Supplier<String> supplier) {
        String serialJson = cacheObject instanceof String ? (String)cacheObject : FpmSerializeUtil.serialize((Object)cacheObject);
        logger.info(Objects.isNull(supplier) ? "" : supplier.get() + "\u5c06\u3010%s\u3011\u653e\u5165\u7f13\u5b58\uff0c\u7f13\u5b58key\u3010%s\u3011\uff0c\u5bf9\u8c61\u5e8f\u5217\u5316\u503c\u3010%s\u3011", new Object[]{cacheObject.getClass().getName(), cacheKey, serialJson});
        viewPageCache.getPageCache().put(cacheKey, serialJson);
    }
}

