/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.FlowType;
import kd.tmc.fpm.business.domain.enums.ReportInputType;
import kd.tmc.fpm.business.domain.enums.TemplateMetricType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.AccountMember;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.index.generate.bean.QueryIndexInfo;
import kd.tmc.fpm.business.domain.model.report.PlanChangeRecord;
import kd.tmc.fpm.business.domain.model.report.PlanChangeReport;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportChangeData;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.template.TemplateAccountSetting;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.domain.service.impl.ReportService;
import kd.tmc.fpm.business.mvc.repository.IDimensionRepository;
import kd.tmc.fpm.business.mvc.repository.IPlanChangeRepository;
import kd.tmc.fpm.business.mvc.repository.IReportRepository;
import kd.tmc.fpm.business.mvc.repository.impl.DimensionRepository;
import kd.tmc.fpm.business.mvc.repository.impl.PlanChangeRepository;
import kd.tmc.fpm.business.mvc.repository.impl.ReportRepository;
import kd.tmc.fpm.business.utils.DimensionInfoHelper;
import kd.tmc.fpm.business.validate.report.ReportChangeSubmitValidator;
import kd.tmc.fpm.common.bean.DimensionInfoBean;
import kd.tmc.fpm.common.bean.FpmContext;
import kd.tmc.fpm.common.trace.IFpmTraceSpan;
import kd.tmc.fpm.common.trace.IFpmTracer;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ReportChangeCheckHelper {
    public static ReportService reportService = new ReportService();
    private static IPlanChangeRepository repository = new PlanChangeRepository();
    private static IReportRepository reportRepository = new ReportRepository();
    private static IDimensionRepository dimensionRepository = new DimensionRepository();
    private static final int CHECK_ADJUSTED_AVAILABLE_AMT_PER_BATCH_SIZE = 5;
    private static final Set<DimensionType> NOTIFY_DIMENSION_TYPE_SET;

    public static FpmOperateResult<Void> checkAdjustedAvailableAmt(PlanChangeRecord planChangeRecord, PlanChangeReport planChangeReport, Report report, FundPlanSystem fundPlanSystem) {
        try (IFpmTraceSpan span = IFpmTracer.getInstance().createSpan("checkAdjustedAvailableAmt_method");){
            FpmContext.get().put("dimMetric", EnumSet.of(TemplateMetricType.PLANAMT));
            List<ReportChangeData> waitCheckChangeDataList = ReportChangeCheckHelper.filterWaitCheckAdjustedAvailableAmtData(planChangeReport, fundPlanSystem);
            List<ReportChangeData> waitCheckCombinedChangeDataList = ReportChangeCheckHelper.combineAdjustDataByTemplate(waitCheckChangeDataList, report, fundPlanSystem);
            for (ReportChangeData changeData : waitCheckCombinedChangeDataList) {
                if (changeData.getPlanAmt().add(changeData.getCurrentAdjustAmt()).subtract(changeData.getLockAmt()).subtract(changeData.getActAmt()).compareTo(BigDecimal.ZERO) >= 0) continue;
                String errorMessage = ReportChangeCheckHelper.getErrorMessage(planChangeRecord, fundPlanSystem, changeData);
                FpmOperateResult<Void> fpmOperateResult = FpmOperateResult.error(errorMessage);
                return fpmOperateResult;
            }
            FpmOperateResult fpmOperateResult = FpmOperateResult.success();
            return fpmOperateResult;
        }
    }

    private static String getErrorMessage(PlanChangeRecord planChangeRecord, FundPlanSystem fundPlanSystem, ReportData reportData) {
        List<TemplateDim> dimList = reportData.getDimList();
        List templateDimList = dimList.stream().filter(templateDim -> NOTIFY_DIMENSION_TYPE_SET.contains((Object)templateDim.getDimType())).sorted(Comparator.comparing(ReportChangeSubmitValidator::getScore)).collect(Collectors.toList());
        StringBuilder sb = new StringBuilder();
        for (TemplateDim templateDim2 : templateDimList) {
            Long memberId = (Long)reportData.getDimValByDimType(templateDim2.getDimType(), templateDim2.getDetailDimType());
            Dimension dimension = fundPlanSystem.getMainDimensionByDimType(templateDim2.getDimType());
            List<DimMember> allDimMemberList = dimension.getAllDimMemberList();
            DimMember member = allDimMemberList.stream().filter(dimMember -> Objects.equals(dimMember.getId(), memberId)).findFirst().get();
            if (sb.length() == 0) {
                sb.append(member.getName());
                continue;
            }
            sb.append("/").append(member.getName());
        }
        String errorMessage = String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u8c03\u6574\u5355\u3010%1$s\u3011\u672c\u6b21\u8c03\u6574\u7684\u7ef4\u5ea6\u7ec4\u5408\u3010%2$s\u3011\u7684\u8c03\u6574\u540e\u53ef\u7528\u4f59\u989d\u5c0f\u4e8e0\uff0c\u6709\u53ef\u80fd\u4f1a\u5bfc\u81f4\u8ba1\u5212\u6267\u884c\u8d85\u989d\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u63d0\u4ea4\u3002", (String)"ReportChangeCheckHelper_1", (String)"tmc-fpm-business", (Object[])new Object[0]), planChangeRecord.getNumber(), sb);
        return errorMessage;
    }

    public static Pair<Boolean, String> checkAdjustedAvailableAmt(List<DynamicObject> dataList) {
        Set<Long> idSet = dataList.stream().map(item -> item.getLong("id")).map(id -> id).collect(Collectors.toSet());
        return ReportChangeCheckHelper.checkAdjustedAvailableAmt(idSet);
    }

    public static Pair<Boolean, String> checkAdjustedAvailableAmt(Collection<Long> planChangeRecordIds) {
        HashMap systemMap = Maps.newHashMapWithExpectedSize((int)8);
        LinkedList<Object> hitInfoList = new LinkedList<Object>();
        ArrayList<Long> planChangeRecordIdList = new ArrayList<Long>(planChangeRecordIds);
        List batchCheckList = Lists.partition(planChangeRecordIdList, (int)5);
        for (List batch : batchCheckList) {
            List<PlanChangeRecord> planChangeRecords = repository.load(batch, true);
            Map changeRecordMap = planChangeRecords.stream().collect(Collectors.toMap(PlanChangeRecord::getId, Function.identity(), (a, b) -> a));
            Set<Long> mainReportIdSet = planChangeRecords.stream().map(PlanChangeRecord::getChangeReportList).flatMap(Collection::stream).filter(report -> report.getTemplate().isMainTable()).map(PlanChangeReport::getReportId).collect(Collectors.toSet());
            List<Report> mainReports = reportRepository.loadReport(mainReportIdSet);
            Map<Long, Report> reportMap = mainReports.stream().collect(Collectors.toMap(Report::getId, Function.identity(), (a, b) -> a));
            for (Long billPkId : batch) {
                Pair<Boolean, String> validatorResult;
                PlanChangeRecord planChangeRecord = (PlanChangeRecord)changeRecordMap.get(billPkId);
                if (Objects.isNull(planChangeRecord) || ((Boolean)(validatorResult = ReportChangeCheckHelper.checkAdjustedAvailableAmt(planChangeRecord, reportMap, systemMap)).getLeft()).booleanValue()) continue;
                hitInfoList.add(validatorResult.getValue());
            }
        }
        if (CollectionUtils.isNotEmpty(hitInfoList)) {
            return Pair.of((Object)false, (Object)String.join((CharSequence)";", hitInfoList));
        }
        return Pair.of((Object)true, (Object)"");
    }

    private static Pair<Boolean, String> checkAdjustedAvailableAmt(PlanChangeRecord planChangeRecord, Map<Long, Report> reportMap, Map<Long, FundPlanSystem> systemMap) {
        FundPlanSystem fundPlanSystem;
        Report report2;
        List<PlanChangeReport> changeReportList = planChangeRecord.getChangeReportList();
        PlanChangeReport planChangeReport = changeReportList.stream().filter(report -> report.getTemplate().isMainTable()).findFirst().get();
        FpmOperateResult<Void> result = ReportChangeCheckHelper.checkAdjustedAvailableAmt(planChangeRecord, planChangeReport, report2 = reportMap.get(planChangeReport.getReportId()), fundPlanSystem = systemMap.computeIfAbsent(report2.getSystemId(), key -> dimensionRepository.loadSystem(report2.getSystemId())));
        if (result.isSuccess()) {
            return Pair.of((Object)true, (Object)"");
        }
        return Pair.of((Object)false, (Object)result.getMessageList().stream().collect(Collectors.joining(";")));
    }

    private static List<ReportChangeData> filterWaitCheckAdjustedAvailableAmtData(PlanChangeReport planChangeReport, FundPlanSystem fundPlanSystem) {
        Dimension subjectDim = fundPlanSystem.getMainDimensionByDimType(DimensionType.SUBJECTS);
        Set balanceSubjects = subjectDim.getAllDimMemberList(AccountMember.class).stream().filter(item -> item.getFlowType() == FlowType.BALANCE).map(DimMember::getId).collect(Collectors.toSet());
        Set leafAcctMemberIds = planChangeReport.getTemplate().getAccountSettings().stream().filter(o -> EmptyUtil.isEmpty(o.getChildren())).map(TemplateAccountSetting::getAccountMemId).collect(Collectors.toSet());
        Set formulaAndSummarySubjectIdSet = planChangeReport.getTemplate().getAccountSettings().stream().filter(item -> item.getInputType() == ReportInputType.FORMULA || item.getInputType() == ReportInputType.SUMMARY).map(TemplateAccountSetting::getAccountMemId).collect(Collectors.toSet());
        Set currReportPeriodIdSet = planChangeReport.getCurrentReportPeriodDetailIfHasDetail().stream().map(DimMember::getId).collect(Collectors.toSet());
        currReportPeriodIdSet.add(planChangeReport.getCurrentReportPeriod().getId());
        Long periodDimId = fundPlanSystem.getMainDimensionByDimType(DimensionType.PERIOD).getId();
        LinkedList<ReportChangeData> waitCheckDataList = new LinkedList<ReportChangeData>();
        List<ReportData> reportDataList = planChangeReport.getReportDataList();
        for (ReportData reportData : reportDataList) {
            Object value;
            Object periodId;
            ReportChangeData reportChangeData = (ReportChangeData)reportData;
            if (reportChangeData.isAuxiliaryInfo() || !currReportPeriodIdSet.contains(periodId = reportChangeData.getDimValByDimensionId(periodDimId)) || balanceSubjects.contains(value = reportChangeData.getDimValByDimensionId(subjectDim.getId())) || !leafAcctMemberIds.contains(value) || formulaAndSummarySubjectIdSet.contains(value) || BigDecimal.ZERO.compareTo(reportChangeData.getCurrentAdjustAmt()) == 0) continue;
            waitCheckDataList.add(reportChangeData);
        }
        return waitCheckDataList;
    }

    private static List<ReportChangeData> combineAdjustDataByTemplate(List<ReportChangeData> reportChangeDataList, Report report, FundPlanSystem fundPlanSystem) {
        if (CollectionUtils.isEmpty(reportChangeDataList)) {
            return new ArrayList<ReportChangeData>(0);
        }
        Map orgReportDataMap = report.getReportDataList().stream().collect(Collectors.toMap(ReportData::getId, Function.identity()));
        reportChangeDataList.forEach(item -> {
            ReportData reportData;
            Long originalReportDataId = item.getOriginalReportDataId();
            if (EmptyUtil.isNoEmpty((Long)originalReportDataId) && Objects.nonNull(reportData = (ReportData)orgReportDataMap.get(originalReportDataId))) {
                item.setLockAmt(reportData.getLockAmt());
                item.setActAmt(reportData.getActAmt());
            }
        });
        Map<DimensionInfoBean, List<ReportChangeData>> dimInfo2ChangeDataMap = reportChangeDataList.stream().collect(Collectors.groupingBy(changeData -> DimensionInfoHelper.getDimensionInfoBeanByFilter(changeData, td -> td.isVisible() && td.getDimType().isMainDimensionType())));
        QueryIndexInfo<Object, ReportData> queryIndexInfo = report.getQueryIndexInfo(fundPlanSystem);
        LinkedList<ReportChangeData> combineAdjustDataList = new LinkedList<ReportChangeData>();
        dimInfo2ChangeDataMap.forEach((dimensionInfoBean, changeDataList) -> {
            List sourceReportDataList = queryIndexInfo.findList((DimensionInfoBean)dimensionInfoBean);
            ReportChangeData combineChangeData = new ReportChangeData((ReportData)changeDataList.get(0));
            changeDataList.stream().filter(changeData -> !Objects.equals(combineChangeData.getId(), changeData.getId())).forEach(changeData -> {
                combineChangeData.addPlanAmt(changeData.getPlanAmt());
                combineChangeData.setCurrentAdjustAmt(combineChangeData.getCurrentAdjustAmt().add(changeData.getCurrentAdjustAmt()));
                combineChangeData.setAdjustedPlanAmt(combineChangeData.getAdjustedPlanAmt().add(changeData.getAdjustedPlanAmt()));
                combineChangeData.addLockAmt(changeData.getLockAmt());
                combineChangeData.addActAmt(changeData.getActAmt());
                combineChangeData.addOriginalPlanAmt(changeData.getOriginalPlanAmt());
            });
            Set adjustedSourceReportDataIdSet = changeDataList.stream().map(ReportChangeData::getOriginalReportDataId).filter(EmptyUtil::isNoEmpty).collect(Collectors.toSet());
            sourceReportDataList.stream().filter(reportData -> !adjustedSourceReportDataIdSet.contains(reportData.getId())).forEach(reportData -> {
                combineChangeData.addPlanAmt(reportData.getPlanAmt());
                combineChangeData.setAdjustedPlanAmt(combineChangeData.getAdjustedPlanAmt().add(reportData.getPlanAmt()));
                combineChangeData.addLockAmt(reportData.getLockAmt());
                combineChangeData.addActAmt(reportData.getActAmt());
                combineChangeData.addOriginalPlanAmt(reportData.getOriginalPlanAmt());
            });
            combineAdjustDataList.add(combineChangeData);
        });
        return combineAdjustDataList;
    }

    static {
        HashSet<DimensionType> dimensionTypeSet = new HashSet<DimensionType>(8);
        dimensionTypeSet.add(DimensionType.SUBJECTS);
        dimensionTypeSet.add(DimensionType.CURRENCY);
        dimensionTypeSet.add(DimensionType.COMPANY);
        dimensionTypeSet.add(DimensionType.PERIOD);
        dimensionTypeSet.add(DimensionType.SETTLEMENT_TYPE);
        NOTIFY_DIMENSION_TYPE_SET = Collections.unmodifiableSet(dimensionTypeSet);
    }
}

