/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.cache.data.CacheCellMeta;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryResult;
import kd.tmc.fpm.business.domain.enums.DetailDimType;
import kd.tmc.fpm.business.domain.enums.DimLocation;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.MemberType;
import kd.tmc.fpm.business.domain.enums.TemplateMetricType;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.ReportPeriodType;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.index.DimensionIndexTree;
import kd.tmc.fpm.business.domain.model.index.generate.QueryIndexInfoMapGenerator;
import kd.tmc.fpm.business.domain.model.index.generate.bean.QueryIndexInfo;
import kd.tmc.fpm.business.domain.model.index.node.TreeNode;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportCalcVal;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportCalcTree;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportCalcValTreeNode;
import kd.tmc.fpm.common.bean.DimensionInfoBean;
import kd.tmc.fpm.common.enums.CellDimTypeEnum;
import kd.tmc.fpm.common.utils.CollectionBuildUtil;
import kd.tmc.fpm.common.utils.NumberUtils;
import kd.tmc.fpm.spread.utils.ExcelUtils;
import kd.tmc.fpm.spread.widget.CellTypeEnum;
import kd.tmc.fpm.spread.widget.SpreadSelector;
import kd.tmc.fpm.spread.widget.core.Book;
import kd.tmc.fpm.spread.widget.core.Cell;
import kd.tmc.fpm.spread.widget.core.Sheet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ReportHelper {
    private static BigDecimal MAX_AMT_ROUND = BigDecimal.valueOf(10000000000000L);
    private static BigDecimal MIN_AMT_ROUND = BigDecimal.valueOf(-10000000000000L);
    public static final Map<String, String> MAINDIM_ENTRY_MAPPING_MAP = new HashMap<String, String>(){
        {
            this.put(DimensionType.ORG.getNumber(), "orgmem");
            this.put(DimensionType.CURRENCY.getNumber(), "currencymem");
            this.put(DimensionType.PERIOD.getNumber(), "periodmem");
            this.put(DimensionType.SUBJECTS.getNumber(), "subjectmem");
            this.put(DimensionType.COMPANY.getNumber(), "companymem");
            this.put(DimensionType.SETTLEMENT_TYPE.getNumber(), "settletypemem");
        }
    };
    public static final Map<String, String> DETAILDIM_ENTRY_MAPPING_MAP = new HashMap<String, String>(){
        {
            this.put(DetailDimType.CONNTERPARTY_TYPE.getNumber(), "opusertype");
            this.put(DetailDimType.COUNTERPARTY_NAME.getNumber(), "opusername");
            this.put(DetailDimType.BANK_CATE.getNumber(), "bankcate");
            this.put(DetailDimType.CONTRACT_NO.getNumber(), "contractno");
            this.put(DetailDimType.CONTRACT_NAME.getNumber(), "contractname");
            this.put(DetailDimType.PLAN_DATE.getNumber(), "plandate");
            this.put(DetailDimType.BANK_ACCOUNT.getNumber(), "bankaccount");
            this.put(DetailDimType.EXTRA_1.getNumber(), "detailext1");
            this.put(DetailDimType.EXTRA_2.getNumber(), "detailext2");
            this.put(DetailDimType.EXTRA_3.getNumber(), "detailext3");
            this.put(DetailDimType.EXTRA_4.getNumber(), "detailext4");
            this.put(DetailDimType.EXTRA_5.getNumber(), "detailext5");
            this.put(DetailDimType.EXTRA_6.getNumber(), "detailext6");
        }
    };
    public static final Map<String, String> TYPE_MAPPING_MAP = new HashMap<String, String>(){
        {
            this.putAll(MAINDIM_ENTRY_MAPPING_MAP);
            this.putAll(DETAILDIM_ENTRY_MAPPING_MAP);
        }
    };

    public static List<ReportData> convert(List<ReportDataQueryResult> dataQueryResultList) {
        ArrayList<ReportData> result = new ArrayList<ReportData>(dataQueryResultList.size());
        for (ReportDataQueryResult reportDataQueryResult : dataQueryResultList) {
            List<TemplateDim> currTemplateDim = reportDataQueryResult.getDimList();
            ReportData reportData = new ReportData();
            reportData.setActAmt(reportDataQueryResult.getActAmt());
            reportData.setPlanAmt(reportDataQueryResult.getPlanAmt());
            reportData.setLockAmt(reportDataQueryResult.getLockAmt());
            reportData.setHoldLockAmt(reportDataQueryResult.getHoldLockAmt());
            reportData.setHoldActAmt(reportDataQueryResult.getHoldActAmt());
            reportData.setVersion(reportDataQueryResult.getVersion() + 1);
            reportData.setDimValList(reportDataQueryResult.getDimValList());
            reportData.setAmountUnit(reportDataQueryResult.getAmountUnit());
            reportData.setDimList(currTemplateDim);
            reportData.setId(reportDataQueryResult.getId());
            reportData.setReportId(reportDataQueryResult.getReportId());
            reportData.setReportPeriodId(reportDataQueryResult.getReportPeriodId());
            reportData.setMainTable(reportDataQueryResult.isMainTable());
            reportData.setCol(reportDataQueryResult.getCol());
            reportData.setRow(reportDataQueryResult.getRow());
            reportData.setReportPlanAmt(reportDataQueryResult.getReportPlanAmt());
            reportData.setOriginalPlanAmt(reportDataQueryResult.getOriginalPlanAmt());
            reportData.setOffsetAmt(reportDataQueryResult.getOffsetAmt());
            reportData.setPlanReferenceAmt(reportDataQueryResult.getPlanReferenceAmt());
            reportData.setAuxiliaryValMap(reportDataQueryResult.getAuxiliaryValMap());
            reportData.setAuxiliaryInfo(reportDataQueryResult.isAuxiliaryInfo());
            reportData.setValue(reportDataQueryResult.getValue());
            reportData.putAllMetricVal(reportDataQueryResult.getMetricValMap());
            reportData.setSourceIdList(reportDataQueryResult.getSourceIdList());
            reportData.setSystemId(reportDataQueryResult.getSystemId());
            reportData.setSmartGelFlag(reportDataQueryResult.getSmartGelFlag());
            result.add(reportData);
        }
        return result;
    }

    public static List<DimensionInfoBean> completionDimension(ReportTemplate template, DimensionInfoBean dimensionInfo) {
        ArrayList<DimensionInfoBean> dimensionInfoBeanList = new ArrayList<DimensionInfoBean>(template.getColDimList().size());
        List templateDim = template.getAllTemplateDim().stream().filter(item -> !dimensionInfo.getDimensionIdList().contains(item.getDimensionId())).collect(Collectors.toList());
        ArrayList listDim = new ArrayList(16);
        ArrayList dimensionIdList = new ArrayList(16);
        templateDim.stream().forEach(item -> {
            if (!dimensionInfo.getDimensionIdList().contains(item.getDimensionId())) {
                dimensionIdList.add(item.getDimensionId());
                listDim.add(item.getMemberScope());
            }
        });
        List descartes = CollectionBuildUtil.descartes(listDim);
        ArrayList dimIdList = new ArrayList(dimensionInfo.getDimensionIdList());
        dimIdList.addAll(dimensionIdList);
        descartes.stream().forEach(item1 -> {
            ArrayList memberIdList = new ArrayList(dimensionInfo.getMemberIdList());
            memberIdList.addAll(item1);
            DimensionInfoBean dimensionInfoBean = new DimensionInfoBean(dimIdList, memberIdList);
            dimensionInfoBeanList.add(dimensionInfoBean);
        });
        return dimensionInfoBeanList;
    }

    public static void mountReportData(DimensionIndexTree indexTree, List<ReportData> mountReportDataList) {
        for (ReportData reportData : mountReportDataList) {
            ArrayList<Long> dimIdList = new ArrayList<Long>(reportData.getDimList().size());
            ArrayList<Object> dimMemIdList = new ArrayList<Object>(reportData.getDimList().size());
            List<Object> prepareDatas = reportData.getDimValList();
            for (int inx = 0; inx < reportData.getDimList().size(); ++inx) {
                TemplateDim templateDim = reportData.getDimList().get(inx);
                if (templateDim.getDimType() == DimensionType.DETAILDIM) continue;
                dimIdList.add(templateDim.getDimensionId());
                dimMemIdList.add(prepareDatas.get(inx));
            }
            DimensionInfoBean dimensionInfoBean = new DimensionInfoBean();
            dimensionInfoBean.setDimensionIdList(dimIdList);
            dimensionInfoBean.setMemberIdList(dimMemIdList);
            TreeNode node = indexTree.find(dimensionInfoBean);
            if (node == null) continue;
            node.addData(reportData);
        }
    }

    public static void checkReport(Report report, FundPlanSystem system) {
        ReportHelper.checkReportData(report, system);
    }

    public static void checkReportData(Report report, FundPlanSystem system) {
        List<ReportData> reportDataList = report.getReportDataList();
        if (CollectionUtils.isEmpty(reportDataList)) {
            return;
        }
        ReportHelper.checkDetailReportData(system, report, reportDataList);
    }

    public static void checkDetailReportData(FundPlanSystem system, Report report, List<ReportData> reportDataList) {
        if (!report.getTemplate().getTemplateType().isDetail()) {
            return;
        }
        if (!CollectionUtils.isEmpty(report.getCurrentReportPeriodDetail())) {
            PeriodMember currentReportPeriod = report.getCurrentReportPeriod();
            reportDataList = reportDataList.stream().filter(item -> !currentReportPeriod.getId().equals(item.getDimValByDimType(DimensionType.PERIOD))).collect(Collectors.toList());
        }
        if (report.isRollContainsDetail()) {
            Set periodIds = report.getPeriodMemberList().stream().map(DimMember::getId).collect(Collectors.toSet());
            reportDataList = reportDataList.stream().filter(item -> !periodIds.contains((Long)item.getDimValByDimType(DimensionType.PERIOD))).collect(Collectors.toList());
        }
        List<Dimension> dimensions = system.getDimList();
        Map systemDimMap = dimensions.stream().collect(Collectors.toMap(Dimension::getId, Function.identity()));
        Map<Integer, List<ReportData>> rowRDList = reportDataList.stream().filter(item -> !item.isAuxiliaryInfo()).collect(Collectors.groupingBy(ReportData::getRow));
        String errorMsg = ResManager.loadKDString((String)"\u7b2c%1$s\u884c%2$s\u5fc5\u5f55\uff0c\u8bf7\u5148\u5f55\u5165\u6570\u636e\u518d\u63d0\u4ea4\u3002", (String)"ReportHelper_0", (String)"tmc-fpm-business", (Object[])new Object[0]);
        for (Map.Entry<Integer, List<ReportData>> next : rowRDList.entrySet()) {
            for (ReportData reportData : next.getValue()) {
                List<TemplateDim> dimList = reportData.getDimList();
                List<Object> dimValList = reportData.getDimValList();
                List colDimList = dimList.stream().filter(item -> DimLocation.COL == item.getLocation() && !item.isExpand()).sorted(Comparator.comparingInt(TemplateDim::getSequence)).collect(Collectors.toList());
                ArrayList<Object> colDimValList = new ArrayList<Object>(colDimList.size());
                for (TemplateDim templateDim : colDimList) {
                    int index = dimList.indexOf(templateDim);
                    colDimValList.add(dimValList.get(index));
                }
                for (int i = 0; i < colDimList.size(); ++i) {
                    TemplateDim templateDim;
                    templateDim = (TemplateDim)colDimList.get(i);
                    Dimension dimension = (Dimension)systemDimMap.get(templateDim.getDimensionId());
                    if (!dimension.isMustInput() || !templateDim.isVisible()) continue;
                    Object val = colDimValList.get(i);
                    if (dimension.getMemberType() == MemberType.AMOUNT ? val == null : val == null || val.equals(0L)) {
                        throw new KDBizException(String.format(errorMsg, reportData.getRow() + 1, dimension.getName()));
                    }
                    if (!(val instanceof String) || !StringUtils.isEmpty((CharSequence)val.toString())) continue;
                    throw new KDBizException(String.format(errorMsg, reportData.getRow() + 1, dimension.getName()));
                }
            }
        }
    }

    public static void checkReportDataAmt(Report report) throws KDBizException {
        ReportHelper.checkReportDataAmt(report.getReportDataList());
    }

    public static void checkReportDataAmt(List<ReportData> reportDataList) throws KDBizException {
        if (CollectionUtils.isEmpty(reportDataList)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (ReportData data : reportDataList) {
            if (!ReportHelper.checkAmtRound(data.getPlanAmt())) {
                sb.append(ReportHelper.checkReportDataAmtErrorMsgSuppler(TemplateMetricType.PLANAMT, data).get());
            }
            if (!ReportHelper.checkAmtRound(data.getOriginalPlanAmt())) {
                sb.append(ReportHelper.checkReportDataAmtErrorMsgSuppler(TemplateMetricType.ORIGINALPLANAMT, data).get());
            }
            if (!ReportHelper.checkAmtRound(data.getPlanReferenceAmt())) {
                sb.append(ReportHelper.checkReportDataAmtErrorMsgSuppler(TemplateMetricType.PLANREFERENCEAMT, data).get());
            }
            if (!ReportHelper.checkAmtRound(data.getReportPlanAmt())) {
                sb.append(ReportHelper.checkReportDataAmtErrorMsgSuppler(TemplateMetricType.REPORTPLANAMT, data).get());
            }
            if (!ReportHelper.checkAmtRound(data.getLockAmt())) {
                sb.append(ReportHelper.checkReportDataAmtErrorMsgSuppler(TemplateMetricType.LOCKAMT, data).get());
            }
            if (ReportHelper.checkAmtRound(data.getActAmt())) continue;
            sb.append(ReportHelper.checkReportDataAmtErrorMsgSuppler(TemplateMetricType.ACTMAT, data).get());
        }
        if (sb.length() > 0) {
            throw new KDBizException(sb.toString());
        }
    }

    public static boolean checkAmtRound(BigDecimal amt) {
        if (Objects.isNull(amt)) {
            return true;
        }
        return amt.compareTo(MAX_AMT_ROUND) < 0 && amt.compareTo(MIN_AMT_ROUND) > 0;
    }

    private static Supplier<String> checkReportDataAmtErrorMsgSuppler(TemplateMetricType metricType, ReportData reportData) {
        return () -> {
            String errorMsg = ResManager.loadKDString((String)"\u3010%1$s\u3011\u5355\u5143\u683c\u586b\u62a5\u7684\u3010%2$s\u3011\u8d85\u51fa\u6700\u5927\u6570\u503c\u8303\u56f4\uff0c\u8bf7\u786e\u8ba4\u3002\n", (String)"ReportHelper_1", (String)"tmc-fpm-business", (Object[])new Object[0]);
            return String.format(errorMsg, ExcelUtils.xy2Pos((int)reportData.getCol(), (int)reportData.getRow()), metricType.getName());
        };
    }

    public static List<ReportData> getFixReportSelectedDimCombinationData(CacheCellMeta cellMeta, DynamicObject dataEntity, SpreadSelector spreadSelector, List<String> pageDimFields) {
        int selectedCellSize = (spreadSelector.getEndRow() - spreadSelector.getStartRow() + 1) * (spreadSelector.getEndCol() - spreadSelector.getStartCol() + 1);
        ArrayList<ReportData> reportDataList = new ArrayList<ReportData>(selectedCellSize);
        for (int i = spreadSelector.getStartRow(); i <= spreadSelector.getEndRow(); ++i) {
            for (int j = spreadSelector.getStartCol(); j <= spreadSelector.getEndCol(); ++j) {
                ReportData reportData2 = new ReportData();
                reportData2.setRow(i);
                reportData2.setCol(j);
                reportData2.setDimList(new LinkedList<TemplateDim>());
                reportData2.setDimValList(new LinkedList<Object>());
                reportDataList.add(reportData2);
            }
        }
        String dimensionIdProp = String.join((CharSequence)".", "dimension", "id");
        int level = 1;
        for (String pageDimField : pageDimFields) {
            DynamicObject dy = dataEntity.getDynamicObject(pageDimField);
            if (Objects.isNull(dy)) continue;
            TemplateDim currTemplateDim = new TemplateDim();
            currTemplateDim.setDimensionId(dy.getLong(dimensionIdProp));
            currTemplateDim.setLevel(level++);
            currTemplateDim.setLocation(DimLocation.PAGE);
            reportDataList.forEach(reportData -> {
                reportData.getDimList().add(currTemplateDim);
                reportData.getDimValList().add(dy.getLong("id"));
            });
        }
        ReportHelper.setSelectedRowOrColDimCombination(reportDataList, DimLocation.ROW, cellMeta);
        ReportHelper.setSelectedRowOrColDimCombination(reportDataList, DimLocation.COL, cellMeta);
        return reportDataList;
    }

    private static void setSelectedRowOrColDimCombination(List<ReportData> reportDataList, DimLocation dimLocation, CacheCellMeta cellMeta) {
        HashMap templateDimMap = new HashMap(8, 1.0f);
        LinkedList<ReportCalcValTreeNode> queue = new LinkedList<ReportCalcValTreeNode>();
        int b1 = dimLocation == DimLocation.ROW ? reportDataList.stream().mapToInt(ReportData::getRow).min().getAsInt() : reportDataList.stream().mapToInt(ReportData::getCol).min().getAsInt();
        int b2 = dimLocation == DimLocation.ROW ? reportDataList.stream().mapToInt(ReportData::getRow).max().getAsInt() : reportDataList.stream().mapToInt(ReportData::getCol).max().getAsInt();
        queue.addAll(dimLocation == DimLocation.ROW ? cellMeta.getRowDimTree().getRoot().getChildren() : cellMeta.getColDimTree().getRoot().getChildren());
        while (!queue.isEmpty()) {
            int size = queue.size();
            for (int i = 0; i < size; ++i) {
                int a2;
                ReportCalcValTreeNode curr = (ReportCalcValTreeNode)queue.poll();
                int a1 = dimLocation == DimLocation.ROW ? curr.getCalcVal().getStartRow() : curr.getCalcVal().getStartCol();
                int n = a2 = dimLocation == DimLocation.ROW ? curr.getCalcVal().getEndRow() : curr.getCalcVal().getEndCol();
                if (b2 < a1 || b1 > a2 || curr.getCalcVal().isReferenceCell() || curr.getCalcVal().isSummary() || curr.getCalcVal().isRemarkCell() || curr.getCalcVal().isMetric()) continue;
                if (CollectionUtils.isNotEmpty(curr.getChildren())) {
                    queue.addAll(curr.getChildren());
                }
                if (!Objects.nonNull(curr.getCalcVal().getValue())) continue;
                Long dimensionId = curr.getCalcVal().getDimensionId();
                Supplier<TemplateDim> templateDimSupplier = () -> templateDimMap.computeIfAbsent(dimensionId, key -> {
                    TemplateDim templateDim = new TemplateDim();
                    templateDim.setDimensionId((Long)key);
                    templateDim.setLocation(dimLocation);
                    return templateDim;
                });
                reportDataList.stream().filter(reportData -> {
                    int idx = dimLocation == DimLocation.ROW ? reportData.getRow() : reportData.getCol();
                    return idx >= a1 && idx <= a2;
                }).forEach(reportData -> {
                    List<TemplateDim> dimList = reportData.getDimList();
                    List<Object> dimValList = reportData.getDimValList();
                    OptionalInt currTemplateDimIdxOpt = IntStream.range(0, dimList.size()).filter(idx -> ((TemplateDim)dimList.get(idx)).getDimensionId().equals(dimensionId)).findAny();
                    if (currTemplateDimIdxOpt.isPresent()) {
                        dimValList.set(currTemplateDimIdxOpt.getAsInt(), curr.getCalcVal().getValue());
                    } else {
                        TemplateDim templateDim = (TemplateDim)templateDimSupplier.get();
                        dimList.add(templateDim);
                        dimValList.add(curr.getCalcVal().getValue());
                    }
                });
            }
        }
    }

    /*
     * Exception decompiling
     */
    public static IntPredicate getSummaryColPredicate(List<ReportCalcValTreeNode> allColDimTreeNode) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static IntPredicate getSummaryRowPredicate(List<ReportCalcValTreeNode> allRowDimTreeNode) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static IntPredicate getRemarkColPredicate(List<ReportCalcValTreeNode> allColDimTreeNode) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Set<Long> getAllPeriodMemberIds(Report report) {
        return ReportHelper.getAllPeriodMember(report).stream().map(DimMember::getId).collect(Collectors.toSet());
    }

    public static List<PeriodMember> getAllPeriodMember(Report report) {
        return ReportHelper.getAllPeriodMember(report, false);
    }

    public static List<PeriodMember> getAllPeriodMember(Report report, boolean needReference) {
        ArrayList periodMembers = Lists.newArrayList(report.getPeriodMemberList());
        if (needReference && Objects.nonNull(report.getReferencePeriodMember())) {
            periodMembers.add(report.getReferencePeriodMember());
        }
        if (periodMembers.size() == 1) {
            periodMembers.addAll(report.getCurrentReportPeriodDetail());
            return periodMembers;
        }
        ReportPeriodType reportPeriodType = report.getReportPeriodType();
        if (Objects.isNull((Object)reportPeriodType.getDetailPeriodType())) {
            return periodMembers;
        }
        if (report.isRollContainsDetail()) {
            periodMembers.addAll(report.getPeriodMemberList().stream().map(DimMember::getAllChildMember).flatMap(Collection::stream).map(PeriodMember.class::cast).collect(Collectors.toList()));
            return periodMembers;
        }
        periodMembers.addAll(report.getCurrentReportPeriodDetail());
        return periodMembers;
    }

    public static PeriodMember getFirstPeriod(Report report) {
        List<PeriodMember> currentReportPeriodDetail = report.getCurrentReportPeriodDetail();
        if (EmptyUtil.isEmpty(currentReportPeriodDetail)) {
            return report.getCurrentReportPeriod();
        }
        return currentReportPeriodDetail.stream().min(Comparator.comparing(PeriodMember::getStartDate)).orElse(null);
    }

    public static List<PeriodMember> getReportPeriod(Report report) {
        List<PeriodMember> currentReportPeriodDetail = report.getCurrentReportPeriodDetail();
        if (EmptyUtil.isEmpty(currentReportPeriodDetail)) {
            return Collections.singletonList(report.getCurrentReportPeriod());
        }
        return currentReportPeriodDetail;
    }

    public static List<PeriodMember> getReportPeriodAndRollPeriod(Report report) {
        List<PeriodMember> currentReportPeriod = ReportHelper.getReportPeriod(report);
        ReportPeriodType reportPeriodType = report.getReportPeriodType();
        if (Objects.isNull((Object)reportPeriodType.getDetailPeriodType())) {
            return currentReportPeriod;
        }
        if (!report.isRollContainsDetail()) {
            return currentReportPeriod;
        }
        return report.getPeriodMemberList().stream().map(DimMember::getAllChildMember).flatMap(Collection::stream).map(PeriodMember.class::cast).collect(Collectors.toList());
    }

    public static boolean isAuxiliaryInfo(List<TemplateDim> dataDimList, List<TemplateDim> allTemplateDim) {
        long templateMainDimSize = allTemplateDim.stream().filter(Objects::nonNull).filter(item -> Objects.nonNull((Object)item.getDimType())).filter(item -> item.getDimType().isMainDimensionType()).count();
        long dataMainDimSize = dataDimList.stream().filter(Objects::nonNull).filter(item -> Objects.nonNull((Object)item.getDimType())).filter(item -> item.getDimType().isMainDimensionType()).count();
        return dataMainDimSize < templateMainDimSize;
    }

    public static Pair<List<Long>, Map<String, Integer>> getDetailReportPageDimListAndDataMaxRowMap(Report report, ReportTemplate template, FundPlanSystem fundPlanSystem) {
        if (template.getTemplateType() != TemplateType.DETAIL) {
            return Pair.of(new ArrayList(0), (Object)Maps.newHashMapWithExpectedSize((int)0));
        }
        Pair<List<Long>, List<List<Long>>> pageDimAndValGroup = template.buildPageDimAndValGroup();
        QueryIndexInfo<Object, ReportData> queryIndexInfo = report.getQueryIndexInfo(fundPlanSystem);
        HashMap pageDataMaxRowMap = Maps.newHashMapWithExpectedSize((int)8);
        List pageDimIdList = (List)pageDimAndValGroup.getLeft();
        List right = (List)pageDimAndValGroup.getRight();
        for (List pageDimValList : right) {
            List collect = pageDimValList.stream().map(item -> item).collect(Collectors.toList());
            DimensionInfoBean dimensionInfoBean = DimensionInfoBean.of((List)pageDimIdList, collect);
            Optional<Integer> singlePageMaxRowOpt = queryIndexInfo.findList(dimensionInfoBean).stream().map(ReportData::getRow).max(Integer::compareTo);
            int currMaxRow = singlePageMaxRowOpt.orElseGet(() -> {
                boolean hasDetailPeriod = report.getReportPeriodType().getDetailPeriodType() != null;
                int pageDataStartRow = report.getTemplate().getTotalRow() + report.getTemplate().getDataStartRow(hasDetailPeriod);
                return pageDataStartRow - 1;
            });
            String pageDimValStr = String.join((CharSequence)"#", pageDimValList.stream().map(Object::toString).collect(Collectors.toList()));
            pageDataMaxRowMap.put(pageDimValStr, currMaxRow);
        }
        return Pair.of((Object)pageDimIdList, (Object)pageDataMaxRowMap);
    }

    public static Optional<Long> getSubjectDimIdIfNeedUpdateSubjectFlow(ReportTemplate reportTemplate) {
        TemplateDim subjectColTempDim = null;
        TemplateDim subjectFlowColTempDim = null;
        List<TemplateDim> templateColDimList = reportTemplate.getColDimList();
        for (TemplateDim templateDim : templateColDimList) {
            if (templateDim.getDimType() == DimensionType.SUBJECTS) {
                subjectColTempDim = templateDim;
            }
            if (templateDim.getDimType() != DimensionType.ACCOUNTTYPE) continue;
            subjectFlowColTempDim = templateDim;
        }
        if (subjectColTempDim == null || subjectFlowColTempDim == null) {
            return Optional.empty();
        }
        Long dimensionId = subjectColTempDim.getDimensionId();
        return dimensionId == null ? Optional.empty() : Optional.of(dimensionId);
    }

    public static int getSubjectColIfNeedUpdateSubjectFlow(ReportTemplate reportTemplate, ReportCalcTree colDimTree) {
        Optional<Long> subjectDimIdOpt = ReportHelper.getSubjectDimIdIfNeedUpdateSubjectFlow(reportTemplate);
        if (!subjectDimIdOpt.isPresent()) {
            return -1;
        }
        Long subjectDimId = subjectDimIdOpt.get();
        Optional<ReportCalcVal> subjectCalcValOpt = colDimTree.getLeafList().stream().map(calcValTreeNode -> calcValTreeNode.getCalcVal()).filter(reportCalcVal -> Objects.equals(subjectDimId, reportCalcVal.getDimensionId())).findAny();
        if (subjectCalcValOpt.isPresent()) {
            return subjectCalcValOpt.get().getCol();
        }
        return -1;
    }

    public static void sortDetailReportDataRowByDim(ReportTemplate reportTemplate, List<ReportData> reportDataList, FundPlanSystem system) {
        ReportHelper.sortDetailReportDataRowByDim(reportTemplate, reportDataList, system, null);
    }

    public static void sortDetailReportDataRowByDim(ReportTemplate reportTemplate, List<ReportData> reportDataList, FundPlanSystem system, QueryIndexInfo<Object, ReportData> queryIndexInfo) {
        if (!reportTemplate.getTemplateType().isDetail() || CollectionUtils.isEmpty(reportDataList) || reportDataList.stream().allMatch(ReportData::isAuxiliaryInfo)) {
            return;
        }
        queryIndexInfo = queryIndexInfo != null ? queryIndexInfo : QueryIndexInfoMapGenerator.buildReportDataIndex(reportDataList, system, rd -> !rd.isAuxiliaryInfo());
        LinkedHashMap sortDimId2IdxMap = new LinkedHashMap(4, 1.0f);
        List<DimensionType> sortDimTypeList = Arrays.asList(DimensionType.ORG, DimensionType.PERIOD, DimensionType.SUBJECTS, DimensionType.CURRENCY);
        sortDimTypeList.forEach(dimensionType -> sortDimId2IdxMap.put(system.getMainDimensionByDimType((DimensionType)((Object)dimensionType)).getId(), -1));
        Optional<ReportData> reportDataOpt = reportDataList.stream().filter(rd -> !rd.isAuxiliaryInfo()).findAny();
        if (!reportDataOpt.isPresent()) {
            return;
        }
        List<TemplateDim> tplDimList = reportDataOpt.get().getDimList();
        IntStream.range(0, tplDimList.size()).filter(i -> sortDimId2IdxMap.containsKey(((TemplateDim)tplDimList.get(i)).getDimensionId())).forEach(i -> sortDimId2IdxMap.put(((TemplateDim)tplDimList.get(i)).getDimensionId(), i));
        Map memberId2DimMemberMap = system.getDimList().stream().filter(dim -> sortDimId2IdxMap.containsKey(dim.getId())).map(Dimension::getAllDimMemberList).flatMap(Collection::stream).collect(Collectors.toMap(DimMember::getId, Function.identity(), (a, b) -> a));
        Pair<List<Long>, List<List<Long>>> pageDimAndValGroup = reportTemplate.buildPageDimAndValGroup();
        List pageDimIdList = (List)pageDimAndValGroup.getLeft();
        HashSet pageDimIdSet = new HashSet(pageDimIdList);
        List pageDimValGroupList = (List)pageDimAndValGroup.getRight();
        for (List pageDimValList : pageDimValGroupList) {
            List pageDimValObjList = pageDimValList.stream().map(item -> item).collect(Collectors.toList());
            DimensionInfoBean pageDimInfoBean = DimensionInfoBean.of((List)pageDimIdList, pageDimValObjList);
            List<ReportData> pageReportDataList = queryIndexInfo.findList(pageDimInfoBean);
            if (CollectionUtils.isEmpty(pageReportDataList)) continue;
            List sortReportDataList = pageReportDataList.stream().sorted((rd1, rd2) -> {
                for (Map.Entry entry : sortDimId2IdxMap.entrySet()) {
                    Long dimId = (Long)entry.getKey();
                    if (pageDimIdSet.contains(dimId)) continue;
                    int idx = (Integer)entry.getValue();
                    Long rd1CurrDimVal = (Long)rd1.getDimValList().get(idx);
                    Long rd2CurrDimVal = (Long)rd2.getDimValList().get(idx);
                    DimMember dimMember1 = (DimMember)memberId2DimMemberMap.get(rd1CurrDimVal);
                    DimMember dimMember2 = (DimMember)memberId2DimMemberMap.get(rd2CurrDimVal);
                    int compareVal = dimMember1.getSortCode().compareTo(dimMember2.getSortCode());
                    if (NumberUtils.equalsZero((Integer)compareVal)) continue;
                    return compareVal;
                }
                return 0;
            }).collect(Collectors.toList());
            int minRow = sortReportDataList.stream().mapToInt(ReportData::getRow).min().orElse(0);
            int preReportDataOldRow = -1;
            int offset = -1;
            for (ReportData reportData : sortReportDataList) {
                if (preReportDataOldRow != reportData.getRow()) {
                    ++offset;
                }
                preReportDataOldRow = reportData.getRow();
                reportData.setRow(minRow + offset);
                reportData.setDirty(Boolean.TRUE);
            }
        }
    }

    public static void resetDetailReportRowWithoutDirtyFlag(Report report, FundPlanSystem system) {
        ReportHelper.resetDetailReportRow(report, system);
        if (report != null && CollectionUtils.isNotEmpty(report.getReportDataList())) {
            report.getReportDataList().forEach(data -> data.setDirty(Boolean.FALSE));
        }
    }

    public static void resetDetailReportRow(Report report, FundPlanSystem system) {
        ReportHelper.resetDetailReportRow(report, system, null);
    }

    public static void resetDetailReportRow(Report report, FundPlanSystem system, QueryIndexInfo<Object, ReportData> queryIndexInfo) {
        if (report == null || CollectionUtils.isEmpty(report.getReportDataList()) || report.getTemplate() == null || report.getTemplate().getTemplateType() == null || !report.getTemplate().getTemplateType().isDetail() || system == null || report.getReportPeriodType() == null) {
            return;
        }
        queryIndexInfo = queryIndexInfo != null ? queryIndexInfo : QueryIndexInfoMapGenerator.buildReportDataIndex(report.getReportDataList(), system, rd -> true);
        Pair<List<Long>, List<List<Long>>> pageDimAndValGroup = report.getTemplate().buildPageDimAndValGroup();
        List pageDimIdList = (List)pageDimAndValGroup.getLeft();
        List pageDimValGroupList = (List)pageDimAndValGroup.getRight();
        boolean hasDetailPeriod = report.getReportPeriodType().getDetailPeriodType() != null;
        int pageDataStartRow = report.getTemplate().getTotalRow() + report.getTemplate().getDataStartRow(hasDetailPeriod);
        for (List pageDimValList : pageDimValGroupList) {
            List pageDimValObjList = pageDimValList.stream().map(item -> item).collect(Collectors.toList());
            DimensionInfoBean pageDimInfoBean = DimensionInfoBean.of((List)pageDimIdList, pageDimValObjList);
            List<ReportData> pageReportDataList = queryIndexInfo.findList(pageDimInfoBean);
            if (CollectionUtils.isEmpty(pageReportDataList)) continue;
            Map sortedRowMap = pageReportDataList.stream().filter(item -> item.getRow() > 0).collect(Collectors.groupingBy(ReportData::getRow, TreeMap::new, Collectors.toCollection(LinkedList::new)));
            int line = pageDataStartRow;
            for (Map.Entry entry : sortedRowMap.entrySet()) {
                List dataList = (List)entry.getValue();
                for (ReportData data : dataList) {
                    data.setRow(line);
                    data.setDirty(Boolean.TRUE);
                }
                ++line;
            }
        }
    }

    public static Map<Integer, List<Long>> createDetailReportPerRowMainDimValMap(Book book) {
        Sheet sheet = book.getSheet();
        HashMap<Integer, List<Long>> perRowMainDimValMap = new HashMap<Integer, List<Long>>(sheet.getTwoDimCoord().length);
        Predicate<Cell> mainDimValCellPredicate = cell -> EmptyUtil.isNoEmpty((Object)cell) && CellDimTypeEnum.DATADIMS == cell.getCellDimType() && cell.getValue() instanceof Long && CellTypeEnum.F7WIDGET == cell.getCellType() && Objects.equals("fpm_member", cell.getWidgetValue());
        Cell[][] cellArray = sheet.getTwoDimCoord();
        int n = cellArray.length;
        for (int i = 0; i < n; ++i) {
            Cell[] colArray;
            for (Cell col : colArray = cellArray[i]) {
                if (!mainDimValCellPredicate.test(col)) continue;
                List mainDimValList = perRowMainDimValMap.computeIfAbsent(col.getRow(), val -> new ArrayList(7));
                mainDimValList.add((Long)col.getValue());
            }
        }
        return perRowMainDimValMap;
    }

    private static /* synthetic */ boolean lambda$getRemarkColPredicate$25(List remarkColInterval, int col) {
        return remarkColInterval.stream().anyMatch(interval -> interval[0] <= col && col <= interval[1]);
    }

    private static /* synthetic */ boolean lambda$getSummaryRowPredicate$21(List summaryColInterval, int row) {
        return summaryColInterval.stream().anyMatch(interval -> interval[0] <= row && row <= interval[1]);
    }

    private static /* synthetic */ boolean lambda$getSummaryColPredicate$17(List summaryColInterval, int col) {
        return summaryColInterval.stream().anyMatch(interval -> interval[0] <= col && col <= interval[1]);
    }
}

