/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.helper;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimLocation;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.FlowType;
import kd.tmc.fpm.business.domain.enums.ITypeEnum;
import kd.tmc.fpm.business.domain.enums.ReportInputType;
import kd.tmc.fpm.business.domain.enums.TemplateMetricType;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.AccountMember;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateAccountSetting;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.domain.model.template.TemplateLayout;
import kd.tmc.fpm.business.utils.DimensionInfoHelper;
import kd.tmc.fpm.business.utils.MetricValueUtils;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.common.enums.MetricMemberTypeEnum;
import kd.tmc.fpm.common.utils.NumberUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

public class TemplateInfoHelper {
    public static Pair<Boolean, DynamicObject> uniqueValidator(DynamicObject srcObj, List<DynamicObject> targetObj) {
        if (srcObj.getBoolean("ismaintable") && targetObj.size() > 0) {
            List currCurrencyMemberIdList = srcObj.getDynamicObjectCollection("currencymember").stream().map(e -> e.get("fbasedataid.id")).collect(Collectors.toList());
            List currReportIdList = srcObj.getDynamicObjectCollection("reporttype").stream().map(e -> e.get("fbasedataid.id")).collect(Collectors.toList());
            List currSubjectMemberIdList = srcObj.getDynamicObjectCollection("subjectmember").stream().map(e -> e.get("fbasedataid.id")).collect(Collectors.toList());
            List currUserIdList = srcObj.getDynamicObjectCollection("user").stream().map(e -> e.get("fbasedataid.id")).collect(Collectors.toList());
            Map<String, Long> dimensionMap = TemplateInfoHelper.getDimByDimType(srcObj.getDynamicObject("model").getPkValue());
            HashMap dimensionIdsMap = new HashMap(dimensionMap.size());
            dimensionMap.forEach((s, l) -> {
                List ids = srcObj.getDynamicObjectCollection("dimsettingentry").stream().filter(v -> l.longValue() == v.getLong("dim")).map(v -> v.getDynamicObjectCollection("plantemplatemember")).map(v -> v.stream().map(t -> t.get("fbasedataid.id"))).flatMap(v -> v).collect(Collectors.toList());
                dimensionIdsMap.put(s, ids);
            });
            for (DynamicObject template : targetObj) {
                Map.Entry entry;
                List currencyMemberIdList = template.getDynamicObjectCollection("currencymember").stream().map(e -> e.get("fbasedataid.id")).collect(Collectors.toList());
                List reportIdList = template.getDynamicObjectCollection("reporttype").stream().map(e -> e.get("fbasedataid.id")).collect(Collectors.toList());
                List subjectMemberIdList = template.getDynamicObjectCollection("subjectmember").stream().map(e -> e.get("fbasedataid.id")).collect(Collectors.toList());
                List userIdList = template.getDynamicObjectCollection("user").stream().map(e -> e.get("fbasedataid.id")).collect(Collectors.toList());
                HashMap dimensionFromDBIdsMap = new HashMap(dimensionMap.size());
                dimensionMap.forEach((s, l) -> {
                    List templateFromDBDimSettingEntryIds = template.getDynamicObjectCollection("dimsettingentry").stream().filter(v -> l.longValue() == v.getLong("dim")).map(v -> v.getDynamicObjectCollection("plantemplatemember")).map(v -> v.stream().map(t -> t.get("fbasedataid.id"))).flatMap(v -> v).collect(Collectors.toList());
                    dimensionFromDBIdsMap.put(s, templateFromDBDimSettingEntryIds);
                });
                if (CollectionUtils.retainAll(currReportIdList, reportIdList).size() <= 0 || CollectionUtils.retainAll(currCurrencyMemberIdList, currencyMemberIdList).size() <= 0 || CollectionUtils.retainAll(currSubjectMemberIdList, subjectMemberIdList).size() <= 0 || CollectionUtils.retainAll(currUserIdList, userIdList).size() <= 0) continue;
                boolean isLegal = true;
                Iterator iterator = dimensionIdsMap.entrySet().iterator();
                while (iterator.hasNext() && (isLegal = CollectionUtils.retainAll((Collection)((Collection)(entry = iterator.next()).getValue()), (Collection)((Collection)dimensionFromDBIdsMap.get(entry.getKey()))).size() > 0)) {
                }
                if (!isLegal) continue;
                return Pair.of((Object)Boolean.FALSE, (Object)template);
            }
        }
        return Pair.of((Object)Boolean.TRUE, null);
    }

    private static Map<String, Long> getDimByDimType(Object pkValue) {
        HashMap<String, Long> dimensionMap = new HashMap<String, Long>(0);
        DynamicObjectCollection dimensions = QueryServiceHelper.query((String)"fpm_dimension", (String)"id,basedata", (QFilter[])new QFilter[]{new QFilter("bodysystem", "=", pkValue).and("basedata", "in", Arrays.asList(DimsionEnums.SETLTMENT.getNumber(), DimsionEnums.COMPANY.getNumber()))});
        if (dimensions != null && dimensions.size() > 0) {
            dimensions.stream().forEach(v -> dimensionMap.put(v.getString("basedata"), v.getLong("id")));
        }
        return dimensionMap;
    }

    public static void checkTemplateDimEntry(ReportTemplate reportTemplate) {
        List<TemplateDim> allTemplateDim = reportTemplate.getAllTemplateDim();
        List allMembers = allTemplateDim.stream().map(TemplateDim::getMemberScope).flatMap(Collection::stream).collect(Collectors.toList());
        DynamicObjectCollection load = QueryServiceHelper.query((String)"fpm_member", (String)"id,name,enable", (QFilter[])new QFilter[]{new QFilter("id", "in", allMembers)});
        if (load == null || load.size() == 0) {
            return;
        }
        List disableMember = load.stream().filter(item -> !item.getBoolean("enable")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(disableMember)) {
            return;
        }
        String name = disableMember.stream().map(item -> item.getString("name")).collect(Collectors.joining(","));
        String msg = String.format(ResManager.loadKDString((String)"\u6a21\u677f\u4e2d\u5f15\u7528\u7684\u7ef4\u5ea6\u6210\u5458\u201c%1$s\u201d\u5df2\u88ab\u7981\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TemplateInfoHelper_0", (String)"tmc-fpm-business", (Object[])new Object[0]), name);
        throw new KDBizException(msg);
    }

    public static boolean hasEnableCombine(ReportTemplate reportTemplate) {
        return reportTemplate.getTotalRow() > 0;
    }

    public static boolean hasEnableSubjectFlowCombine(ReportTemplate reportTemplate) {
        return reportTemplate.getAllTemplateDim().stream().anyMatch(TemplateDim::isSubjectFlowTotal);
    }

    public static boolean hasEnableNetInFlowTotalRow(ReportTemplate reportTemplate, Dimension subjectDim) {
        Optional<TemplateDim> subjectTplDimOpt = reportTemplate.getColDimList().stream().filter(item -> item.getDimType() == DimensionType.SUBJECTS).findAny();
        if (!subjectTplDimOpt.isPresent()) {
            return false;
        }
        HashSet<Long> tplSubjectMemberScopeSet = new HashSet<Long>(subjectTplDimOpt.get().getMemberScope());
        Set<String> tplAllFlowTypeSet = subjectDim.getAllDimMemberList().stream().filter(member -> tplSubjectMemberScopeSet.contains(member.getId())).map(AccountMember.class::cast).map(AccountMember::getFlowType).map(FlowType::getNumber).collect(Collectors.toSet());
        return TemplateInfoHelper.hasEnableNetInFlowTotalRow(reportTemplate, tplAllFlowTypeSet);
    }

    public static boolean hasEnableNetInFlowTotalRow(ReportTemplate reportTemplate, Set<String> tplAllFlowTypeSet) {
        if (TemplateInfoHelper.hasEnableSubjectFlow(reportTemplate)) {
            Optional<TemplateDim> subjectTplDimOpt = reportTemplate.getColDimList().stream().filter(item -> item.getDimType() == DimensionType.SUBJECTS).findAny();
            if (!subjectTplDimOpt.isPresent()) {
                return false;
            }
            if (!tplAllFlowTypeSet.contains(FlowType.IN.getNumber()) || !tplAllFlowTypeSet.contains(FlowType.OUT.getNumber())) {
                return false;
            }
            Optional<TemplateDim> currencyTplDimOpt = reportTemplate.getColDimList().stream().filter(item -> item.getDimType() == DimensionType.CURRENCY).findAny();
            return !currencyTplDimOpt.isPresent() || currencyTplDimOpt.get().isExpand() || currencyTplDimOpt.get().getMemberScope().size() <= 2;
        }
        return false;
    }

    public static boolean hasEnableSubjectFlow(ReportTemplate reportTemplate) {
        if (reportTemplate.getTemplateType().isDetail()) {
            Optional<TemplateDim> subjectTplDimOpt = reportTemplate.getColDimList().stream().filter(item -> item.getDimType() == DimensionType.SUBJECTS).findAny();
            return subjectTplDimOpt.isPresent() && !subjectTplDimOpt.get().isExpand() && TemplateInfoHelper.hasEnableSubjectFlowCombine(reportTemplate);
        }
        return false;
    }

    public static boolean nonSubjectFlowVirtualDim(ReportTemplate reportTemplate, DimensionType dimensionType) {
        return !TemplateInfoHelper.isSubjectFlowVirtualDim(reportTemplate, dimensionType);
    }

    public static boolean isSubjectFlowVirtualDim(ReportTemplate reportTemplate, DimensionType dimensionType) {
        if (!TemplateInfoHelper.hasEnableSubjectFlow(reportTemplate)) {
            return false;
        }
        return dimensionType.isVirtualDim() && dimensionType == DimensionType.ACCOUNTTYPE;
    }

    public static void addSubjectFlowColIfDetailTemplateNeed(ReportTemplate reportTemplate, FundPlanSystem fundPlanSystem) {
        if (!TemplateInfoHelper.hasEnableSubjectFlow(reportTemplate)) {
            return;
        }
        List<TemplateDim> colTemplateDimList = reportTemplate.getColDimList();
        OptionalInt subjectTempDimIdx = IntStream.range(0, colTemplateDimList.size()).filter(i -> ((TemplateDim)colTemplateDimList.get(i)).getDimType() == DimensionType.SUBJECTS).findAny();
        if (!subjectTempDimIdx.isPresent()) {
            return;
        }
        Map<Long, Long> subject2SubjectFlowMap = DimensionInfoHelper.createViAccountDim(fundPlanSystem);
        List<Dimension> dimList = fundPlanSystem.getDimList();
        Optional<Dimension> accountTypeDimOpt = dimList.stream().filter(dim -> dim.getDimType() == DimensionType.ACCOUNTTYPE).findAny();
        if (!accountTypeDimOpt.isPresent()) {
            return;
        }
        Dimension accountTypeDim = accountTypeDimOpt.get();
        TemplateLayout.LayoutInfo layoutInfo = new TemplateLayout.LayoutInfo();
        layoutInfo.setDimensionId(accountTypeDim.getId());
        layoutInfo.setDimLocation(DimLocation.COL);
        layoutInfo.setLevel(colTemplateDimList.get(subjectTempDimIdx.getAsInt()).getLevel());
        layoutInfo.setVisible(true);
        Dimension subjectDim = fundPlanSystem.getMainDimensionByDimType(DimensionType.SUBJECTS);
        List<TemplateLayout.LayoutInfo> dimLayoutInfoList = reportTemplate.getDimLayout().getDimLayoutInfoList();
        OptionalInt subjectLayoutIdxOpt = IntStream.range(0, dimLayoutInfoList.size()).filter(i -> Objects.equals(((TemplateLayout.LayoutInfo)dimLayoutInfoList.get(i)).getDimensionId(), subjectDim.getId())).findAny();
        dimLayoutInfoList.add(subjectLayoutIdxOpt.getAsInt() + 1, layoutInfo);
        TemplateDim templateDim = new TemplateDim();
        templateDim.setId(DB.genGlobalLongId());
        templateDim.setDimensionId(accountTypeDim.getId());
        templateDim.setSequence(subjectTempDimIdx.getAsInt() + 1);
        templateDim.setDimensionName(accountTypeDim.getName());
        templateDim.setIncludeSum(false);
        templateDim.setDimType(accountTypeDim.getDimType());
        templateDim.setLocation(layoutInfo.getDimLocation());
        templateDim.setLevel(layoutInfo.getLevel());
        templateDim.setVisible(true);
        List<Long> memberScopeList = colTemplateDimList.get(subjectTempDimIdx.getAsInt()).getMemberScope().stream().map(subject2SubjectFlowMap::get).collect(Collectors.toList());
        templateDim.setMemberScope(memberScopeList);
        IntStream.range(subjectTempDimIdx.getAsInt() + 1, colTemplateDimList.size()).forEach(i -> {
            int oldSequence = ((TemplateDim)colTemplateDimList.get(i)).getSequence();
            ((TemplateDim)colTemplateDimList.get(i)).setSequence(oldSequence + 1);
        });
        colTemplateDimList.add(subjectTempDimIdx.getAsInt() + 1, templateDim);
    }

    public static boolean isDetail(ReportTemplate reportTemplate) {
        return reportTemplate.getTemplateType().isDetail();
    }

    public static boolean isFix(ReportTemplate reportTemplate) {
        return reportTemplate.getTemplateType().isFixed();
    }

    public static boolean enableSum(ReportTemplate reportTemplate) {
        List<TemplateDim> allTemplateDim = reportTemplate.getAllTemplateDim();
        boolean expand = allTemplateDim.stream().filter(i -> i.getDimType().isPeriodDim()).anyMatch(TemplateDim::isExpand);
        boolean includeSum = allTemplateDim.stream().anyMatch(TemplateDim::isIncludeSum);
        return expand || includeSum;
    }

    public static Set<Long> buildAllBySetting(List<TemplateAccountSetting> accountSettings) {
        if (CollectionUtils.isEmpty(accountSettings)) {
            return Sets.newHashSetWithExpectedSize((int)0);
        }
        HashSet result = Sets.newHashSetWithExpectedSize((int)accountSettings.size());
        for (TemplateAccountSetting accountSetting : accountSettings) {
            Long accountMemId = accountSetting.getAccountMemId();
            result.add(accountMemId);
            TemplateInfoHelper.getChildSetting(accountSetting, result);
        }
        return result;
    }

    private static void getChildSetting(TemplateAccountSetting setting, Set<Long> memberSet) {
        if (setting != null) {
            memberSet.add(setting.getAccountMemId());
        }
        if (setting == null || CollectionUtils.isEmpty(setting.getChildren())) {
            return;
        }
        for (TemplateAccountSetting child : setting.getChildren()) {
            TemplateInfoHelper.getChildSetting(child, memberSet);
        }
    }

    public static Set<Long> buildAllChildTemplateIdByAccount(Collection<Long> memberIds, List<TemplateAccountSetting> accountSettings) {
        if (CollectionUtils.isEmpty(accountSettings)) {
            return Sets.newHashSetWithExpectedSize((int)0);
        }
        HashSet result = Sets.newHashSetWithExpectedSize((int)accountSettings.size());
        for (TemplateAccountSetting accountSetting : accountSettings) {
            Long childTemplateId = accountSetting.getChildTemplateId();
            if (memberIds.contains(accountSetting.getAccountMemId())) {
                result.add(childTemplateId);
            }
            TemplateInfoHelper.buildChildTemplateId(memberIds, accountSetting, result);
        }
        return result.stream().filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private static void buildChildTemplateId(Collection<Long> memberIds, TemplateAccountSetting setting, Set<Long> memberSet) {
        if (setting != null && memberIds.contains(setting.getAccountMemId())) {
            memberSet.add(setting.getChildTemplateId());
        }
        if (setting == null || CollectionUtils.isEmpty(setting.getChildren())) {
            return;
        }
        for (TemplateAccountSetting child : setting.getChildren()) {
            TemplateInfoHelper.buildChildTemplateId(memberIds, child, memberSet);
        }
    }

    public static boolean nonExistBaseMetricTypeIfAnalyseMetricNeed(Collection<Long> metricMemberIds) {
        DynamicObjectCollection metricMemberDyColl = QueryServiceHelper.query((String)"fpm_member", (String)String.join((CharSequence)",", "id", "metrictype", "metricpresettype", "computeformulavalue_tag"), (QFilter[])new QFilter[]{new QFilter("id", "in", metricMemberIds)});
        Set baseMetricTypeEnumSet = metricMemberDyColl.stream().filter(memberDy -> {
            MetricMemberTypeEnum metricType = MetricMemberTypeEnum.getEnumByCode((String)memberDy.getString("metrictype"));
            return metricType == MetricMemberTypeEnum.BASE;
        }).map(memberDy -> ITypeEnum.getByNumber(memberDy.getString("metricpresettype"), TemplateMetricType.class)).collect(Collectors.toSet());
        return metricMemberDyColl.stream().filter(memberDy -> {
            MetricMemberTypeEnum metricType = MetricMemberTypeEnum.getEnumByCode((String)memberDy.getString("metrictype"));
            return metricType == MetricMemberTypeEnum.ANALYSE;
        }).map(memberDy -> memberDy.getString("computeformulavalue_tag")).filter(StringUtils::isNotEmpty).map(MetricValueUtils::splitFormulaBaseMetricType).flatMap(Collection::stream).map(MetricValueUtils::switchType).anyMatch(needBaseMetricType -> baseMetricTypeEnumSet.isEmpty() || !baseMetricTypeEnumSet.contains(needBaseMetricType));
    }

    public static Set<Long> loadNeedSummaryToMainReportAllSubjectIds(ReportTemplate mainTemplate, ReportTemplate childTemplate) {
        if (mainTemplate == null || !mainTemplate.isMainTable() || childTemplate == null || childTemplate.isMainTable()) {
            return Sets.newHashSetWithExpectedSize((int)0);
        }
        return TemplateInfoHelper.getChildReportUnderAllSubjectOfMainReport(mainTemplate, childTemplate).values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public static Map<Long, Set<Long>> getChildReportUnderAllSubjectOfMainReport(ReportTemplate mainTemplate, ReportTemplate childTemplate) {
        List<TemplateAccountSetting> mainSubjectSettingList = mainTemplate.getAccountSettings();
        long childTemplateId = childTemplate.getId();
        HashMap<Long, Set<Long>> detailSubjectDownLevelSubjectIdMap = new HashMap<Long, Set<Long>>(8);
        for (TemplateAccountSetting mainSubjectSetting : mainSubjectSettingList) {
            Long detailTemplateId;
            ReportInputType inputType = mainSubjectSetting.getInputType();
            if (inputType != ReportInputType.DETAIL_INPUT || !Objects.equals(detailTemplateId = mainSubjectSetting.getChildTemplateId(), childTemplateId)) continue;
            Set detailInputSubjectIds = detailSubjectDownLevelSubjectIdMap.computeIfAbsent(mainSubjectSetting.getAccountMemId(), k -> new HashSet(16));
            detailInputSubjectIds.add(mainSubjectSetting.getAccountMemId());
        }
        TemplateType templateType = childTemplate.getTemplateType();
        if (templateType == TemplateType.DETAIL) {
            return detailSubjectDownLevelSubjectIdMap;
        }
        List<TemplateAccountSetting> accountSettings = childTemplate.getAccountSettings();
        for (TemplateAccountSetting accountSetting : accountSettings) {
            Long subjectMemberId = accountSetting.getAccountMemId();
            if (!detailSubjectDownLevelSubjectIdMap.containsKey(subjectMemberId)) continue;
            Set detailInputSubjectIds = (Set)detailSubjectDownLevelSubjectIdMap.get(subjectMemberId);
            TemplateInfoHelper.addDownLevelChildSubjectIds(detailInputSubjectIds, accountSetting);
        }
        return detailSubjectDownLevelSubjectIdMap;
    }

    private static void addDownLevelChildSubjectIds(Set<Long> detailInputSubjectIds, TemplateAccountSetting accountSetting) {
        if (EmptyUtil.isEmpty((Object)accountSetting)) {
            return;
        }
        List<TemplateAccountSetting> children = accountSetting.getChildren();
        if (Objects.isNull(children)) {
            return;
        }
        for (TemplateAccountSetting child : children) {
            detailInputSubjectIds.add(child.getAccountMemId());
            TemplateInfoHelper.addDownLevelChildSubjectIds(detailInputSubjectIds, child);
        }
    }

    public static DimLocation getLocationByTemplate(ReportTemplate template, Long dimId) {
        if (template == null || dimId == null) {
            return null;
        }
        List<TemplateDim> allTemplateDim = template.getAllTemplateDim();
        List templateDimList = allTemplateDim.stream().filter(i -> NumberUtils.equals((Long)i.getDimensionId(), (Long)dimId)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(templateDimList)) {
            return null;
        }
        TemplateDim templateDim = (TemplateDim)templateDimList.get(0);
        return templateDim.getLocation();
    }
}

